define(['@microsoft/load-themed-styles', 'vue'], function (loadThemedStyles, Vue) {

  Vue = Vue && Vue.hasOwnProperty('default') ? Vue['default'] : Vue;

  function normalizeComponent(template, style, script, scopeId, isFunctionalTemplate, moduleIdentifier
  /* server only */
  , shadowMode, createInjector, createInjectorSSR, createInjectorShadow) {
    if (typeof shadowMode !== 'boolean') {
      createInjectorSSR = createInjector;
      createInjector = shadowMode;
      shadowMode = false;
    } // Vue.extend constructor export interop.


    var options = typeof script === 'function' ? script.options : script; // render functions

    if (template && template.render) {
      options.render = template.render;
      options.staticRenderFns = template.staticRenderFns;
      options._compiled = true; // functional template

      if (isFunctionalTemplate) {
        options.functional = true;
      }
    } // scopedId


    if (scopeId) {
      options._scopeId = scopeId;
    }

    var hook;

    if (moduleIdentifier) {
      // server build
      hook = function hook(context) {
        // 2.3 injection
        context = context || // cached call
        this.$vnode && this.$vnode.ssrContext || // stateful
        this.parent && this.parent.$vnode && this.parent.$vnode.ssrContext; // functional
        // 2.2 with runInNewContext: true

        if (!context && typeof __VUE_SSR_CONTEXT__ !== 'undefined') {
          context = __VUE_SSR_CONTEXT__;
        } // inject component styles


        if (style) {
          style.call(this, createInjectorSSR(context));
        } // register component module identifier for async chunk inference


        if (context && context._registeredComponents) {
          context._registeredComponents.add(moduleIdentifier);
        }
      }; // used by ssr in case component is cached and beforeCreate
      // never gets called


      options._ssrRegister = hook;
    } else if (style) {
      hook = shadowMode ? function (context) {
        style.call(this, createInjectorShadow(context, this.$root.$options.shadowRoot));
      } : function (context) {
        style.call(this, createInjector(context));
      };
    }

    if (hook) {
      if (options.functional) {
        // register for functional component in vue file
        var originalRender = options.render;

        options.render = function renderWithStyleInjection(h, context) {
          hook.call(context);
          return originalRender(h, context);
        };
      } else {
        // inject component registration as beforeCreate hook
        var existing = options.beforeCreate;
        options.beforeCreate = existing ? [].concat(existing, hook) : [hook];
      }
    }

    return script;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function type () {
    for (var _len = arguments.length, types = new Array(_len), _key = 0; _key < _len; _key++) {
      types[_key] = arguments[_key];
    }

    types.push('');
    return {
      props: {
        type: {
          type: String,
          default: '',
          validator: function validator(value) {
            return types.indexOf(value) !== -1;
          }
        }
      }
    };
  }

  var disabled = {
    props: {
      disabled: {
        type: Boolean,
        default: false
      }
    }
  };

  var icon = {
    props: {
      icon: String
    },
    computed: {
      iconClass: function iconClass() {
        return _defineProperty({}, "ms-Icon--".concat(this.icon), !!this.icon);
      }
    }
  };

  var script = {
    name: 'ou-button',
    mixins: [type('primary', 'hero', 'compound', 'small', 'default'), disabled, icon],
    props: {
      description: String
    },
    computed: {
      buttonClass: function buttonClass() {
        var _ref;

        return _ref = {}, _defineProperty(_ref, "ms-Button--".concat(this.type), !!this.type), _defineProperty(_ref, 'is-disabled', this.disabled), _ref;
      }
    },
    methods: {
      clickEvent: function clickEvent() {
        if (!this.disabled) {
          this.$emit('click');
        }
      }
    }
  };

  /* script */
  const __vue_script__ = script;

  /* template */
  var __vue_render__ = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('button',{staticClass:"ms-Button",class:_vm.buttonClass,on:{"click":_vm.clickEvent}},[(_vm.icon && _vm.type == 'hero')?_c('span',{staticClass:"ms-Button-icon"},[_c('i',{staticClass:"ms-Icon",class:_vm.iconClass})]):_vm._e(),_vm._v(" "),_c('span',{staticClass:"ms-Button-label"},[_vm._t("default")],2),_vm._v(" "),(_vm.description && _vm.type == 'compound')?_c('span',{staticClass:"ms-Button-description"},[_vm._v("\n    "+_vm._s(_vm.description)+"\n  ")]):_vm._e()])};
  var __vue_staticRenderFns__ = [];

    /* style */
    const __vue_inject_styles__ = undefined;
    /* scoped */
    const __vue_scope_id__ = undefined;
    /* module identifier */
    const __vue_module_identifier__ = undefined;
    /* functional template */
    const __vue_is_functional_template__ = false;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var button = normalizeComponent(
      { render: __vue_render__, staticRenderFns: __vue_staticRenderFns__ },
      __vue_inject_styles__,
      __vue_script__,
      __vue_scope_id__,
      __vue_is_functional_template__,
      __vue_module_identifier__,
      false,
      undefined,
      undefined,
      undefined
    );

  var script$1 = {
    loadStyles: loadThemedStyles.loadStyles,
    extends: button
  };

  /* script */
  const __vue_script__$1 = script$1;

  /* template */

    /* style */
    const __vue_inject_styles__$1 = function (inject) {
      if (!inject) return
      inject("data-v-3e4e6252_0", { source: ".ms-Button[data-v-3e4e6252]{box-sizing:border-box;margin:0;padding:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;color:\"[theme:neutralPrimary, default: #333333]\";font-size:14px;font-weight:400;background-color:\"[theme:neutralLighter, default: #f4f4f4]\";border:1px solid \"[theme:neutralLighter, default: #f4f4f4]\";cursor:pointer;display:inline-block;height:32px;min-width:80px;padding:4px 20px 6px}.ms-Button.is-hidden[data-v-3e4e6252]{display:none}.ms-Button[data-v-3e4e6252]:hover{background-color:\"[theme:neutralLight, default: #eaeaea]\";border-color:\"[theme:neutralLight, default: #eaeaea]\"}.ms-Button:hover .ms-Button-label[data-v-3e4e6252]{color:\"[theme:black, default: #000000]\"}@media screen and (-ms-high-contrast:active){.ms-Button[data-v-3e4e6252]:hover{color:#1aebff;border-color:#1aebff}}@media screen and (-ms-high-contrast:black-on-white){.ms-Button[data-v-3e4e6252]:hover{color:#37006e;border-color:#37006e}}.ms-Button[data-v-3e4e6252]:focus{background-color:\"[theme:neutralLight, default: #eaeaea]\";border-color:\"[theme:themePrimary, default: #0078d7]\";outline:1px solid transparent}.ms-Button:focus .ms-Button-label[data-v-3e4e6252]{color:\"[theme:black, default: #000000]\"}.ms-Button[data-v-3e4e6252]:active{background-color:\"[theme:themePrimary, default: #0078d7]\";border-color:\"[theme:themePrimary, default: #0078d7]\"}.ms-Button:active .ms-Button-label[data-v-3e4e6252]{color:\"[theme:white, default: #ffffff]\"}.ms-Button.is-disabled[data-v-3e4e6252],.ms-Button[data-v-3e4e6252]:disabled{background-color:\"[theme:neutralLighter, default: #f4f4f4]\";border-color:\"[theme:neutralLighter, default: #f4f4f4]\";cursor:default}.ms-Button.is-disabled .ms-Button-label[data-v-3e4e6252],.ms-Button:disabled .ms-Button-label[data-v-3e4e6252]{color:\"[theme:neutralTertiary, default: #a6a6a6]\"}.ms-Button.is-disabled[data-v-3e4e6252]:focus,.ms-Button.is-disabled[data-v-3e4e6252]:hover,.ms-Button[data-v-3e4e6252]:disabled:focus,.ms-Button[data-v-3e4e6252]:disabled:hover{outline:0}.ms-Button-label[data-v-3e4e6252]{color:\"[theme:neutralPrimary, default: #333333]\";font-weight:600;font-size:14px}.ms-Button-description[data-v-3e4e6252],.ms-Button-icon[data-v-3e4e6252]{display:none}.ms-Button.ms-Button--primary[data-v-3e4e6252]{background-color:\"[theme:themePrimary, default: #0078d7]\";border-color:\"[theme:themePrimary, default: #0078d7]\"}.ms-Button.ms-Button--primary .ms-Button-label[data-v-3e4e6252]{color:\"[theme:white, default: #ffffff]\"}.ms-Button.ms-Button--primary[data-v-3e4e6252]:hover{background-color:\"[theme:themeDark, default: #005a9e]\";border-color:\"[theme:themeDark, default: #005a9e]\"}.ms-Button.ms-Button--primary[data-v-3e4e6252]:focus{background-color:\"[theme:themeDark, default: #005a9e]\";border-color:\"[theme:themeDarker, default: #004578]\"}.ms-Button.ms-Button--primary[data-v-3e4e6252]:active{background-color:\"[theme:themePrimary, default: #0078d7]\";border-color:\"[theme:themePrimary, default: #0078d7]\"}.ms-Button.ms-Button--primary.is-disabled[data-v-3e4e6252],.ms-Button.ms-Button--primary[data-v-3e4e6252]:disabled{background-color:\"[theme:neutralLighter, default: #f4f4f4]\";border-color:\"[theme:neutralLighter, default: #f4f4f4]\"}.ms-Button.ms-Button--primary.is-disabled .ms-Button-label[data-v-3e4e6252],.ms-Button.ms-Button--primary:disabled .ms-Button-label[data-v-3e4e6252]{color:\"[theme:neutralTertiary, default: #a6a6a6]\"}.ms-Button.ms-Button--small[data-v-3e4e6252]{min-width:60px;min-height:24px;height:auto;padding-top:0;padding-bottom:4px}.ms-Button.ms-Button--small .ms-Button-label[data-v-3e4e6252]{font-weight:400;font-size:12px}.ms-Button.ms-Button--hero[data-v-3e4e6252]{align-items:center;background-color:transparent;border:0;padding:0;position:relative}.ms-Button.ms-Button--hero .ms-Button-icon[data-v-3e4e6252]{color:\"[theme:themePrimary, default: #0078d7]\";display:inline-block;font-size:12px;margin-right:4px;padding-top:5px;text-align:center}.ms-Button.ms-Button--hero .ms-Button-icon .ms-Icon[data-v-3e4e6252]{border-radius:18px;border:1px solid \"[theme:themePrimary, default: #0078d7]\";font-size:12px;height:18px;line-height:18px;width:18px}.ms-Button.ms-Button--hero .ms-Button-label[data-v-3e4e6252]{color:\"[theme:themePrimary, default: #0078d7]\";font-size:21px;font-weight:100;position:relative;text-decoration:none;vertical-align:top}.ms-Button.ms-Button--hero:focus .ms-Button-icon[data-v-3e4e6252],.ms-Button.ms-Button--hero:hover .ms-Button-icon[data-v-3e4e6252]{color:\"[theme:themeDark, default: #005a9e]\"}.ms-Button.ms-Button--hero:focus .ms-Button-icon .ms-Icon[data-v-3e4e6252],.ms-Button.ms-Button--hero:hover .ms-Button-icon .ms-Icon[data-v-3e4e6252]{border:1px solid \"[theme:themeDark, default: #005a9e]\"}.ms-Button.ms-Button--hero:focus .ms-Button-label[data-v-3e4e6252],.ms-Button.ms-Button--hero:hover .ms-Button-label[data-v-3e4e6252]{color:\"[theme:themeDarker, default: #004578]\"}.ms-Button.ms-Button--hero:active .ms-Button-icon[data-v-3e4e6252]{color:\"[theme:themePrimary, default: #0078d7]\"}.ms-Button.ms-Button--hero:active .ms-Button-icon .ms-Icon[data-v-3e4e6252]{border:1px solid \"[theme:themePrimary, default: #0078d7]\"}.ms-Button.ms-Button--hero:active .ms-Button-label[data-v-3e4e6252]{color:\"[theme:themePrimary, default: #0078d7]\"}.ms-Button.ms-Button--hero.is-disabled .ms-Button-icon[data-v-3e4e6252],.ms-Button.ms-Button--hero:disabled .ms-Button-icon[data-v-3e4e6252]{color:\"[theme:neutralTertiaryAlt, default: #c8c8c8]\"}.ms-Button.ms-Button--hero.is-disabled .ms-Button-icon .ms-Icon[data-v-3e4e6252],.ms-Button.ms-Button--hero:disabled .ms-Button-icon .ms-Icon[data-v-3e4e6252]{border:1px solid \"[theme:neutralTertiaryAlt, default: #c8c8c8]\"}.ms-Button.ms-Button--hero.is-disabled .ms-Button-label[data-v-3e4e6252],.ms-Button.ms-Button--hero:disabled .ms-Button-label[data-v-3e4e6252]{color:\"[theme:neutralTertiary, default: #a6a6a6]\"}.ms-Button.ms-Button--compound[data-v-3e4e6252]{display:block;height:auto;max-width:280px;min-height:72px;padding:20px}.ms-Button.ms-Button--compound .ms-Button-label[data-v-3e4e6252]{display:block;font-weight:600;position:relative;text-align:left;margin-top:-5px}.ms-Button.ms-Button--compound .ms-Button-description[data-v-3e4e6252]{color:\"[theme:neutralSecondary, default: #666666]\";display:block;font-weight:400;font-size:12px;position:relative;text-align:left;top:3px}.ms-Button.ms-Button--compound:hover .ms-Button-description[data-v-3e4e6252]{color:\"[theme:neutralDark, default: #212121]\"}.ms-Button.ms-Button--compound[data-v-3e4e6252]:focus{border-color:\"[theme:themePrimary, default: #0078d7]\";background-color:\"[theme:neutralLighter, default: #f4f4f4]\"}.ms-Button.ms-Button--compound:focus .ms-Button-label[data-v-3e4e6252]{color:\"[theme:neutralPrimary, default: #333333]\"}.ms-Button.ms-Button--compound:focus .ms-Button-description[data-v-3e4e6252]{color:\"[theme:neutralSecondary, default: #666666]\"}.ms-Button.ms-Button--compound[data-v-3e4e6252]:active{background-color:\"[theme:themePrimary, default: #0078d7]\"}.ms-Button.ms-Button--compound:active .ms-Button-description[data-v-3e4e6252],.ms-Button.ms-Button--compound:active .ms-Button-label[data-v-3e4e6252]{color:\"[theme:white, default: #ffffff]\"}.ms-Button.ms-Button--compound.is-disabled .ms-Button-description[data-v-3e4e6252],.ms-Button.ms-Button--compound.is-disabled .ms-Button-label[data-v-3e4e6252],.ms-Button.ms-Button--compound:disabled .ms-Button-description[data-v-3e4e6252],.ms-Button.ms-Button--compound:disabled .ms-Button-label[data-v-3e4e6252]{color:\"[theme:neutralTertiary, default: #a6a6a6]\"}.ms-Button.ms-Button--compound.is-disabled[data-v-3e4e6252]:active,.ms-Button.ms-Button--compound.is-disabled[data-v-3e4e6252]:focus,.ms-Button.ms-Button--compound[data-v-3e4e6252]:disabled:active,.ms-Button.ms-Button--compound[data-v-3e4e6252]:disabled:focus{border-color:\"[theme:neutralLighter, default: #f4f4f4]\";background-color:\"[theme:neutralLighter, default: #f4f4f4]\"}.ms-Button.ms-Button--compound.is-disabled:active .ms-Button-description[data-v-3e4e6252],.ms-Button.ms-Button--compound.is-disabled:active .ms-Button-label[data-v-3e4e6252],.ms-Button.ms-Button--compound.is-disabled:focus .ms-Button-description[data-v-3e4e6252],.ms-Button.ms-Button--compound.is-disabled:focus .ms-Button-label[data-v-3e4e6252],.ms-Button.ms-Button--compound:disabled:active .ms-Button-description[data-v-3e4e6252],.ms-Button.ms-Button--compound:disabled:active .ms-Button-label[data-v-3e4e6252],.ms-Button.ms-Button--compound:disabled:focus .ms-Button-description[data-v-3e4e6252],.ms-Button.ms-Button--compound:disabled:focus .ms-Button-label[data-v-3e4e6252]{color:\"[theme:neutralTertiary, default: #a6a6a6]\"}", map: undefined, media: undefined });

    };
    /* scoped */
    const __vue_scope_id__$1 = "data-v-3e4e6252";
    /* module identifier */
    const __vue_module_identifier__$1 = undefined;
    /* functional template */
    const __vue_is_functional_template__$1 = undefined;
    /* style inject */
    const __vue_create_injector__ = function(context){ 
                  return function(scopeId, data)
                  {
                      if(window['wizstyle-'+scopeId])
                          return;
                      if(__vue_script__$1.loadStyles)
                          __vue_script__$1.loadStyles(data.source);
                      window['wizstyle-'+scopeId]=true;
                  }
              };
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var uiButton = normalizeComponent(
      {},
      __vue_inject_styles__$1,
      __vue_script__$1,
      __vue_scope_id__$1,
      __vue_is_functional_template__$1,
      __vue_module_identifier__$1,
      false,
      __vue_create_injector__,
      undefined,
      undefined
    );

  var script$2 = {
    name: 'ou-callout',
    mixins: [type('actionText', 'OOBE', 'peek')],
    props: {
      position: {
        type: String,
        default: 'right',
        validator: function validator(value) {
          return ['right', 'left', 'top', 'bottom'].indexOf(value) !== -1;
        }
      },
      showClose: {
        type: Boolean,
        default: false
      },
      title: String,
      content: String
    },
    data: function data() {
      return {
        calloutInstance: null
      };
    },
    computed: {
      calloutClass: function calloutClass() {
        var _ref;

        return _ref = {}, _defineProperty(_ref, "ms-Callout--".concat(this.type), !!this.type), _defineProperty(_ref, 'ms-Callout--close', this.showClose), _ref;
      }
    },
    mounted: function mounted() {
      this.calloutInstance = new this.$fabric.Callout(this.$refs.callout, this.$refs.calloutTrigger, this.position);
    }
  };

  /* script */
  const __vue_script__$2 = script$2;

  /* template */
  var __vue_render__$1 = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',[_c('div',{ref:"callout",staticClass:"ms-Callout is-hidden",class:_vm.calloutClass},[_c('div',{staticClass:"ms-Callout-main"},[(_vm.showClose)?_c('button',{staticClass:"ms-Callout-close"},[_c('i',{staticClass:"ms-Icon ms-Icon--Clear"})]):_vm._e(),_vm._v(" "),_c('div',{staticClass:"ms-Callout-header"},[_c('p',{staticClass:"ms-Callout-title"},[_vm._v(_vm._s(_vm.title))])]),_vm._v(" "),_c('div',{staticClass:"ms-Callout-inner"},[_c('div',{staticClass:"ms-Callout-content"},[(_vm.content)?_c('p',{staticClass:"ms-Callout-subText"},[_vm._v(_vm._s(_vm.content))]):_vm._t("content")],2),_vm._v(" "),_c('div',{staticClass:"ms-Callout-actions"},[_vm._t("actions")],2)])])]),_vm._v(" "),_c('span',{ref:"calloutTrigger"},[_vm._t("default")],2)])};
  var __vue_staticRenderFns__$1 = [];

    /* style */
    const __vue_inject_styles__$2 = undefined;
    /* scoped */
    const __vue_scope_id__$2 = undefined;
    /* module identifier */
    const __vue_module_identifier__$2 = undefined;
    /* functional template */
    const __vue_is_functional_template__$2 = false;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var callout = normalizeComponent(
      { render: __vue_render__$1, staticRenderFns: __vue_staticRenderFns__$1 },
      __vue_inject_styles__$2,
      __vue_script__$2,
      __vue_scope_id__$2,
      __vue_is_functional_template__$2,
      __vue_module_identifier__$2,
      false,
      undefined,
      undefined,
      undefined
    );

  var CONTEXT_STATE_CLASS = "is-open";
  var MODAL_STATE_POSITIONED = "is-positioned";
  var CONTEXT_HOST_MAIN_CLASS = "ms-ContextualHost-main";
  var CONTEXT_HOST_BEAK_CLASS = "ms-ContextualHost-beak";
  var ARROW_LEFT_CLASS = "ms-ContextualHost--arrowLeft";
  var ARROW_TOP_CLASS = "ms-ContextualHost--arrowTop";
  var ARROW_BOTTOM_CLASS = "ms-ContextualHost--arrowBottom";
  var ARROW_RIGHT_CLASS = "ms-ContextualHost--arrowRight";
  var MODIFIER_BASE = "ms-ContextualHost--";
  var ARROW_SIZE = 28;
  var ARROW_OFFSET = 8;

  var ContextualHost = function () {
    function ContextualHost(content, direction, targetElement, hasArrow, modifiers, matchTargetWidth, disposalCallback) {
      if (hasArrow === void 0) {
        hasArrow = true;
      }

      this._resizeAction = this._resizeAction.bind(this);
      this._dismissAction = this._dismissAction.bind(this);
      this._handleKeyUpDismiss = this._handleKeyUpDismiss.bind(this);
      this._matchTargetWidth = matchTargetWidth || false;
      this._direction = direction;
      this._container = this.createContainer();
      this._contextualHost = this._container;
      this._contextualHostMain = this._contextualHost.getElementsByClassName(CONTEXT_HOST_MAIN_CLASS)[0];

      this._contextualHostMain.appendChild(content);

      this._hasArrow = hasArrow;
      this._arrow = this._container.getElementsByClassName(CONTEXT_HOST_BEAK_CLASS)[0];
      this._targetElement = targetElement;

      this._openModal();

      this._setResizeDisposal();

      if (disposalCallback) {
        this._disposalCallback = disposalCallback;
      }

      if (modifiers) {
        for (var i = 0; i < modifiers.length; i++) {
          this._container.classList.add(MODIFIER_BASE + modifiers[i]);
        }
      }

      if (!ContextualHost.hosts) {
        ContextualHost.hosts = [];
      }

      ContextualHost.hosts.push(this);
    }

    ContextualHost.prototype.disposeModal = function () {
      if (ContextualHost.hosts.length > 0) {
        window.removeEventListener("resize", this._resizeAction, false);
        document.removeEventListener("click", this._dismissAction, true);
        document.removeEventListener("keyup", this._handleKeyUpDismiss, true);

        this._container.parentNode.removeChild(this._container);

        if (this._disposalCallback) {
          this._disposalCallback();
        }

        var index = ContextualHost.hosts.indexOf(this);
        ContextualHost.hosts.splice(index, 1);
        var i = ContextualHost.hosts.length;

        while (i--) {
          ContextualHost.hosts[i].disposeModal();
          ContextualHost.hosts.splice(i, 1);
        }
      }
    };

    ContextualHost.prototype.setChildren = function (value) {
      if (!this._children) {
        this._children = [];
      }

      this._children.push(value);
    };

    ContextualHost.prototype.contains = function (value) {
      return this._container.contains(value);
    };

    ContextualHost.prototype.createContainer = function () {
      var ContextualHost0 = document.createElement("div");
      ContextualHost0.setAttribute("class", "ms-ContextualHost");
      ContextualHost0.innerHTML += " ";
      var ContextualHost0c1 = document.createElement("div");
      ContextualHost0c1.setAttribute("class", CONTEXT_HOST_MAIN_CLASS);
      ContextualHost0c1.innerHTML += " ";
      ContextualHost0.appendChild(ContextualHost0c1);
      ContextualHost0.innerHTML += " ";
      var ContextualHost0c3 = document.createElement("div");
      ContextualHost0c3.setAttribute("class", CONTEXT_HOST_BEAK_CLASS);
      ContextualHost0.appendChild(ContextualHost0c3);
      ContextualHost0.innerHTML += "";
      return ContextualHost0;
    };

    ContextualHost.prototype._openModal = function () {
      var _this = this;

      this._copyModalToBody();

      this._saveModalSize();

      this._findAvailablePosition();

      this._showModal();

      setTimeout(function () {
        _this._setDismissClick();
      }, 100);
    };

    ContextualHost.prototype._findAvailablePosition = function () {
      var _posOk;

      switch (this._direction) {
        case "left":
          _posOk = this._positionOk(this._tryPosModalLeft.bind(this), this._tryPosModalRight.bind(this), this._tryPosModalBottom.bind(this), this._tryPosModalTop.bind(this));

          this._setPosition(_posOk);

          break;

        case "right":
          _posOk = this._positionOk(this._tryPosModalRight.bind(this), this._tryPosModalLeft.bind(this), this._tryPosModalBottom.bind(this), this._tryPosModalTop.bind(this));

          this._setPosition(_posOk);

          break;

        case "top":
          _posOk = this._positionOk(this._tryPosModalTop.bind(this), this._tryPosModalBottom.bind(this));

          this._setPosition(_posOk);

          break;

        case "bottom":
          _posOk = this._positionOk(this._tryPosModalBottom.bind(this), this._tryPosModalTop.bind(this));

          this._setPosition(_posOk);

          break;

        default:
          this._setPosition();

      }
    };

    ContextualHost.prototype._showModal = function () {
      this._container.classList.add(CONTEXT_STATE_CLASS);
    };

    ContextualHost.prototype._positionOk = function (pos1, pos2, pos3, pos4) {
      var _posOk;

      _posOk = pos1();

      if (!_posOk) {
        _posOk = pos2();

        if (!_posOk && pos3) {
          _posOk = pos3();

          if (!_posOk && pos4) {
            _posOk = pos4();
          }
        }
      }

      return _posOk;
    };

    ContextualHost.prototype._calcLeft = function (mWidth, teWidth, teLeft) {
      var mHalfWidth = mWidth / 2;
      var teHalf = teWidth / 2;
      var mHLeft = teLeft + teHalf - mHalfWidth;
      mHLeft = mHLeft < mHalfWidth ? teLeft : mHLeft;
      return mHLeft;
    };

    ContextualHost.prototype._calcTop = function (mHeight, teHeight, teTop) {
      var mHalfWidth = mHeight / 2;
      var teHalf = teHeight / 2;
      var mHLeft = teTop + teHalf - mHalfWidth;
      mHLeft = mHLeft < mHalfWidth ? teTop : mHLeft;
      return mHLeft;
    };

    ContextualHost.prototype._setPosition = function (curDirection) {
      var teBR = this._targetElement.getBoundingClientRect();

      var teLeft = teBR.left;
      var teRight = teBR.right;
      var teTop = teBR.top;
      var teWidth = teBR.width;
      var teHeight = teBR.height;
      var mHLeft;
      var mHTop;
      var mWidth = "";
      var arrowTop;
      var arrowLeft;
      var windowX = window.scrollX ? window.scrollX : 0;
      var windowY = window.scrollY ? window.scrollY : 0;
      var arrowSpace = this._hasArrow ? ARROW_SIZE : 0;

      if (this._matchTargetWidth) {
        mWidth = "width: " + this._modalWidth + "px;";
      }

      switch (curDirection) {
        case "left":
          mHLeft = teLeft - this._modalWidth - arrowSpace;
          mHTop = this._calcTop(this._modalHeight, teHeight, teTop);
          mHTop += window.scrollY ? window.scrollY : 0;

          this._container.setAttribute("style", "top: " + mHTop + "px; left: " + mHLeft + "px;" + mWidth);

          this._container.classList.add(MODAL_STATE_POSITIONED);

          if (this._hasArrow) {
            this._container.classList.add(ARROW_RIGHT_CLASS);

            arrowTop = teTop + windowY - mHTop + ARROW_OFFSET;

            this._arrow.setAttribute("style", "top: " + arrowTop + "px;");
          }

          break;

        case "right":
          mHTop = this._calcTop(this._modalHeight, teHeight, teTop);
          mHTop += windowY;
          mHLeft = teRight + arrowSpace;

          this._container.setAttribute("style", "top: " + mHTop + "px; left: " + mHLeft + "px;" + mWidth);

          this._container.classList.add(MODAL_STATE_POSITIONED);

          if (this._hasArrow) {
            arrowTop = windowY + teTop - mHTop + ARROW_OFFSET;

            this._arrow.setAttribute("style", "top: " + arrowTop + "px;");

            this._container.classList.add(ARROW_LEFT_CLASS);
          }

          break;

        case "top":
          mHLeft = this._calcLeft(this._modalWidth, this._teWidth, teLeft);
          mHTop = teTop - this._modalHeight - arrowSpace;
          mHTop += windowY;

          this._container.setAttribute("style", "top: " + mHTop + "px; left: " + mHLeft + "px;" + mWidth);

          this._container.classList.add(MODAL_STATE_POSITIONED);

          if (this._hasArrow) {
            arrowTop = this._modalHeight - arrowSpace / 2;
            arrowLeft = Math.max(windowX + teLeft - mHLeft + (teWidth - arrowSpace) / 2, ARROW_OFFSET);

            this._arrow.setAttribute("style", "top: " + arrowTop + "px; left: " + arrowLeft + "px;");

            this._container.classList.add(ARROW_BOTTOM_CLASS);
          }

          break;

        case "bottom":
          mHLeft = mHLeft = this._calcLeft(this._modalWidth, this._teWidth, teLeft);
          mHTop = teTop + teHeight + arrowSpace;
          mHTop += window.scrollY ? window.scrollY : 0;

          this._container.setAttribute("style", "top: " + mHTop + "px; left: " + mHLeft + "px;" + mWidth);

          this._container.classList.add(MODAL_STATE_POSITIONED);

          if (this._hasArrow) {
            arrowLeft = Math.max(windowX + teLeft - mHLeft + (teWidth - arrowSpace) / 2, ARROW_OFFSET);

            this._arrow.setAttribute("style", "left: " + arrowLeft + "px;");

            this._container.classList.add(ARROW_TOP_CLASS);
          }

          break;

        default:
          this._container.setAttribute("style", "top: 50%; left: 50%; transform: translateX(-50%) translateY(-50%);");

      }
    };

    ContextualHost.prototype._tryPosModalLeft = function () {
      var teLeft = this._targetElement.getBoundingClientRect().left;

      if (teLeft < this._modalWidth) {
        return false;
      } else {
        return "left";
      }
    };

    ContextualHost.prototype._tryPosModalRight = function () {
      var teRight = this._targetElement.getBoundingClientRect().right;

      var w = Math.max(document.documentElement.clientWidth, window.innerWidth || 0);

      if (w - teRight < this._modalWidth) {
        return false;
      } else {
        return "right";
      }
    };

    ContextualHost.prototype._tryPosModalBottom = function () {
      var teBottom = window.innerHeight - this._targetElement.getBoundingClientRect().bottom;

      if (teBottom < this._modalHeight) {
        return false;
      } else {
        return "bottom";
      }
    };

    ContextualHost.prototype._tryPosModalTop = function () {
      var teTop = this._targetElement.getBoundingClientRect().top;

      if (teTop < this._modalHeight) {
        return false;
      } else {
        return "top";
      }
    };

    ContextualHost.prototype._copyModalToBody = function () {
      document.body.appendChild(this._container);
    };

    ContextualHost.prototype._saveModalSize = function () {
      var _modalStyles = window.getComputedStyle(this._container);

      this._container.setAttribute("style", "opacity: 0; z-index: -1");

      this._container.classList.add(MODAL_STATE_POSITIONED);

      this._container.classList.add(CONTEXT_STATE_CLASS);

      if (this._matchTargetWidth) {
        var teStyles = window.getComputedStyle(this._targetElement);
        this._modalWidth = this._targetElement.getBoundingClientRect().width + (parseInt(teStyles.marginLeft, 10) + parseInt(teStyles.marginLeft, 10));
      } else {
        this._modalWidth = this._container.getBoundingClientRect().width + (parseInt(_modalStyles.marginLeft, 10) + parseInt(_modalStyles.marginRight, 10));

        this._container.setAttribute("style", "");
      }

      this._modalHeight = this._container.getBoundingClientRect().height + (parseInt(_modalStyles.marginTop, 10) + parseInt(_modalStyles.marginBottom, 10));

      this._container.classList.remove(MODAL_STATE_POSITIONED);

      this._container.classList.remove(CONTEXT_STATE_CLASS);

      this._teWidth = this._targetElement.getBoundingClientRect().width;
      this._teHeight = this._targetElement.getBoundingClientRect().height;
    };

    ContextualHost.prototype._dismissAction = function (e) {
      if (!this._container.contains(e.target) && e.target !== this._container) {
        if (this._children !== undefined) {
          var isChild_1 = false;

          this._children.map(function (child) {
            if (child !== undefined) {
              isChild_1 = child.contains(e.target);
            }
          });

          if (!isChild_1) {
            this.disposeModal();
          }
        } else {
          this.disposeModal();
        }
      }
    };

    ContextualHost.prototype._setDismissClick = function () {
      document.addEventListener("click", this._dismissAction, true);
      document.addEventListener("keyup", this._handleKeyUpDismiss, true);
    };

    ContextualHost.prototype._handleKeyUpDismiss = function (e) {
      if (e.keyCode === 32 || e.keyCode === 27) {
        this._dismissAction(e);
      }
    };

    ContextualHost.prototype._resizeAction = function () {
      this.disposeModal();
    };

    ContextualHost.prototype._setResizeDisposal = function () {
      window.addEventListener("resize", this._resizeAction, false);
    };

    return ContextualHost;
  }();

  var STATE_HIDDEN = "is-hidden";
  var CLOSE_BUTTON_CLASS = ".ms-Callout-close";
  var MODIFIER_OOBE_CLASS = "ms-Callout--OOBE";

  var Callout = function () {
    function Callout(container, addTarget, position) {
      this._container = container;
      this._addTarget = addTarget;
      this._position = position;
      this._closeButton = container.querySelector(CLOSE_BUTTON_CLASS);

      this._setOpener();
    }

    Callout.prototype._setOpener = function () {
      this._addTarget.addEventListener("click", this._clickHandler.bind(this), true);

      this._addTarget.addEventListener("keyup", this._keyupHandler.bind(this), true);
    };

    Callout.prototype._openContextMenu = function () {
      var modifiers = [];

      if (this._hasModifier(MODIFIER_OOBE_CLASS)) {
        modifiers.push("primaryArrow");
      }

      this._container.classList.remove(STATE_HIDDEN);

      this._contextualHost = new ContextualHost(this._container, this._position, this._addTarget, true, modifiers);

      if (this._closeButton) {
        this._closeButton.addEventListener("click", this._closeHandler.bind(this), false);
      }
    };

    Callout.prototype._hasModifier = function (modifierClass) {
      return this._container.classList.contains(modifierClass);
    };

    Callout.prototype._closeHandler = function (e) {
      if (this._contextualHost != null) {
        this._contextualHost.disposeModal();
      }

      this._closeButton.removeEventListener("click", this._closeHandler.bind(this), false);

      this._addTarget.removeEventListener("click", this._clickHandler.bind(this), true);

      this._addTarget.removeEventListener("keyup", this._keyupHandler.bind(this), true);
    };

    Callout.prototype._clickHandler = function (e) {
      this._openContextMenu();
    };

    Callout.prototype._keyupHandler = function (event) {
      if (event.keyCode === 32) {
        event.stopPropagation();
        event.preventDefault();

        this._openContextMenu();
      } else {
        this._closeHandler(event);
      }
    };

    return Callout;
  }();

  var script$3 = {
    loadStyles: loadThemedStyles.loadStyles,
    beforeMount: function beforeMount() {
      this.$fabric = {
        Callout: Callout
      };
    },
    mounted: function mounted() {
      var _this = this;

      this.$refs.calloutTrigger.addEventListener("click", function () {
        var contextualHostElm = _this.$refs.callout.parentElement.parentElement;
        contextualHostElm.setAttribute(_this.$options._scopeId, "");

        for (var i = 0; i < contextualHostElm.children.length; i++) {
          contextualHostElm.children[i].setAttribute(_this.$options._scopeId, "");
        }

        _this.calloutInstance._contextualHost._openModal(); // recalculate position

      });
    },
    extends: callout
  };

  /* script */
  const __vue_script__$3 = script$3;

  /* template */

    /* style */
    const __vue_inject_styles__$3 = function (inject) {
      if (!inject) return
      inject("data-v-081530f0_0", { source: "@charset \"UTF-8\";.ms-Callout[data-v-081530f0]{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;width:288px}.ms-Callout.is-hidden[data-v-081530f0]{display:none}.ms-Callout-header[data-v-081530f0]{z-index:105;padding-top:24px;padding-bottom:12px;padding-left:28px;padding-right:28px}.ms-Callout-title[data-v-081530f0]{margin:0;font-weight:300;font-size:21px}.ms-Callout-subText[data-v-081530f0]{margin:0;font-weight:300;color:\"[theme:neutralPrimary, default: #333333]\";font-size:12px}.ms-Callout-close[data-v-081530f0]{margin:0;border:0;background:0 0;cursor:pointer;position:absolute;top:12px;right:12px;padding:8px;width:32px;height:32px;font-size:14px;color:\"[theme:neutralSecondary, default: #666666]\";z-index:110}.ms-Callout-link[data-v-081530f0]{font-size:14px}.ms-Callout-inner[data-v-081530f0]{height:100%;padding-top:0;padding-bottom:12px;padding-left:28px;padding-right:28px}.ms-Callout-actions[data-v-081530f0]{position:relative;margin-top:20px;width:100%;white-space:nowrap}.ms-Callout-actions .ms-CommandButton.ms-CommandButton--inline[data-v-081530f0]{height:27px;line-height:27px}.ms-Callout-actions .ms-CommandButton.ms-CommandButton--inline .ms-CommandButton-button[data-v-081530f0]{height:27px;line-height:27px}.ms-Callout-actions .ms-CommandButton.ms-CommandButton--inline .ms-CommandButton-label[data-v-081530f0]{line-height:27px}.ms-Callout-actions .ms-CommandButton.ms-CommandButton--inline .ms-CommandButton-icon[data-v-081530f0]{line-height:27px}.ms-Callout-actions .ms-CommandButton.ms-CommandButton--inline:focus .ms-Button[data-v-081530f0],.ms-Callout-actions .ms-CommandButton.ms-CommandButton--inline:hover .ms-Button[data-v-081530f0]{color:\"[theme:themePrimary, default: #0078d7]\"}.ms-Callout-actions .ms-Callout-button[data-v-081530f0]{margin-right:12px}.ms-Callout.ms-Callout--OOBE .ms-Callout-header[data-v-081530f0]{padding:28px 24px;background-color:\"[theme:themePrimary, default: #0078d7]\"}.ms-Callout.ms-Callout--OOBE .ms-Callout-title[data-v-081530f0]{font-weight:100;font-size:28px;color:\"[theme:white, default: #ffffff]\"}.ms-Callout.ms-Callout--OOBE .ms-Callout-inner[data-v-081530f0]{padding-top:20px}.ms-Callout.ms-Callout--OOBE .ms-Callout-subText[data-v-081530f0]{font-size:14px}.ms-Callout.ms-Callout--actionText .ms-Callout-actions[data-v-081530f0]{border-top:1px solid \"[theme:neutralLight, default: #eaeaea]\";padding-top:12px}.ms-Callout.ms-Callout--actionText .ms-Callout-inner[data-v-081530f0]{padding-bottom:12px}.ms-Callout.ms-Callout--peek .ms-Callout-header[data-v-081530f0]{padding-bottom:0}.ms-Callout.ms-Callout--peek .ms-Callout-title[data-v-081530f0]{font-size:14px}.ms-Callout.ms-Callout--peek .ms-Callout-actions[data-v-081530f0]{margin-top:12px;margin-bottom:-4px}.ms-ContextualHost[data-v-081530f0]{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;z-index:10;margin:16px auto;position:relative;min-width:10px;display:none;background-color:\"[theme:white, default: #ffffff]\";box-shadow:0 0 5px 0 rgba(0,0,0,.4)}.ms-ContextualHost.is-positioned[data-v-081530f0]{position:absolute;margin:0}.ms-ContextualHost.is-open[data-v-081530f0]{display:inline-block}.ms-ContextualHost-beak[data-v-081530f0]{box-shadow:0 0 15px -5px \"[theme:neutralPrimaryAlt, default: #3c3c3c]\";position:absolute;width:28px;height:28px;background:\"[theme:white, default: #ffffff]\";border:1px solid \"[theme:neutralLight, default: #eaeaea]\";box-sizing:border-box;top:-6px;display:none;-webkit-transform:rotate(45deg);transform:rotate(45deg);z-index:0;outline:1px solid transparent}.ms-ContextualHost.ms-ContextualHost--arrowLeft .ms-ContextualHost-beak[data-v-081530f0],.ms-ContextualHost.ms-ContextualHost--arrowRight .ms-ContextualHost-beak[data-v-081530f0]{top:40px;display:none}.ms-ContextualHost.ms-ContextualHost--arrowLeft .ms-ContextualHost-beak[data-v-081530f0]{left:-10px}.ms-ContextualHost.ms-ContextualHost--arrowRight .ms-ContextualHost-beak[data-v-081530f0]{right:-10px}.ms-ContextualHost.ms-ContextualHost--arrowTop .ms-ContextualHost-beak[data-v-081530f0]{display:block;top:-10px}.ms-ContextualHost.ms-ContextualHost--arrowBottom .ms-ContextualHost-beak[data-v-081530f0]{display:block;bottom:-10px}.ms-ContextualHost-main[data-v-081530f0]{position:relative;background-color:\"[theme:white, default: #ffffff]\";box-sizing:border-box;outline:1px solid transparent;z-index:5;min-height:10px}.ms-ContextualHost-close[data-v-081530f0]{margin:0;border:0;background:0 0;cursor:pointer;position:absolute;top:12px;right:12px;padding:8px;width:32px;height:32px;font-size:14px;color:\"[theme:neutralSecondary, default: #666666]\";z-index:10}.ms-ContextualHost.ms-ContextualHost--close .ms-ContextualHost-title[data-v-081530f0]{margin-right:20px}.ms-ContextualHost.ms-ContextualHost--primaryArrow .ms-ContextualHost-beak[data-v-081530f0]{background-color:\"[theme:themePrimary, default: #0078d7]\"}@media (min-width:480px){.ms-ContextualHost[data-v-081530f0]{margin:16px}.ms-ContextualHost.is-positioned[data-v-081530f0]{margin:0}.ms-ContextualHost.ms-ContextualHost--arrowLeft .ms-ContextualHost-beak[data-v-081530f0],.ms-ContextualHost.ms-ContextualHost--arrowRight .ms-ContextualHost-beak[data-v-081530f0]{display:block}}@font-face{font-family:FabricMDL2Icons-a13498cf;src:url(https://spoprod-a.akamaihd.net/files/fabric/assets/icons/fabric-icons-a13498cf.woff) format(\"woff\")}.ms-Icon[data-v-081530f0]{display:inline-block;font-style:normal;font-weight:400}.ms-Icon.ms-Icon--Clear[data-v-081530f0]::before{font-family:FabricMDL2Icons-a13498cf;content:\"\"}", map: undefined, media: undefined });

    };
    /* scoped */
    const __vue_scope_id__$3 = "data-v-081530f0";
    /* module identifier */
    const __vue_module_identifier__$3 = undefined;
    /* functional template */
    const __vue_is_functional_template__$3 = undefined;
    /* style inject */
    const __vue_create_injector__$1 = function(context){ 
                  return function(scopeId, data)
                  {
                      if(window['wizstyle-'+scopeId])
                          return;
                      if(__vue_script__$3.loadStyles)
                          __vue_script__$3.loadStyles(data.source);
                      window['wizstyle-'+scopeId]=true;
                  }
              };
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var uiCallout = normalizeComponent(
      {},
      __vue_inject_styles__$3,
      __vue_script__$3,
      __vue_scope_id__$3,
      __vue_is_functional_template__$3,
      __vue_module_identifier__$3,
      false,
      __vue_create_injector__$1,
      undefined,
      undefined
    );

  //
  var script$4 = {
    name: 'ou-checkbox',
    mixins: [disabled],
    props: {
      value: Boolean
    },
    data: function data() {
      return {
        checkboxInstance: null
      };
    },
    watch: {
      value: function value() {
        this.setCheck();
      }
    },
    mounted: function mounted() {
      this.checkboxInstance = new this.$fabric.CheckBox(this.$refs.checkbox);
      this.setCheck();
    },
    methods: {
      toggle: function toggle() {
        this.$emit('input', this.checkboxInstance.getValue());
      },
      setCheck: function setCheck() {
        this.value && !this.disabled ? this.checkboxInstance.check() : this.checkboxInstance.unCheck();
      }
    }
  };

  /* script */
  const __vue_script__$4 = script$4;

  /* template */
  var __vue_render__$2 = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{ref:"checkbox",staticClass:"ms-CheckBox"},[_c('input',{staticClass:"ms-CheckBox-input",attrs:{"tabindex":"-1","type":"checkbox"},on:{"click":_vm.toggle}}),_vm._v(" "),_c('label',{staticClass:"ms-CheckBox-field",class:{ 'is-disabled': _vm.disabled },attrs:{"role":"checkbox","tabindex":"0","aria-checked":"false","name":"checkbox"}},[_c('span',{staticClass:"ms-Label"},[_vm._t("default")],2)])])};
  var __vue_staticRenderFns__$2 = [];

    /* style */
    const __vue_inject_styles__$4 = undefined;
    /* scoped */
    const __vue_scope_id__$4 = undefined;
    /* module identifier */
    const __vue_module_identifier__$4 = undefined;
    /* functional template */
    const __vue_is_functional_template__$4 = false;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var checkbox = normalizeComponent(
      { render: __vue_render__$2, staticRenderFns: __vue_staticRenderFns__$2 },
      __vue_inject_styles__$4,
      __vue_script__$4,
      __vue_scope_id__$4,
      __vue_is_functional_template__$4,
      __vue_module_identifier__$4,
      false,
      undefined,
      undefined,
      undefined
    );

  var CheckBox = function () {
    function CheckBox(container) {
      this._container = container;
      this._choiceField = this._container.querySelector(".ms-CheckBox-field");
      this._choiceInput = this._container.querySelector(".ms-CheckBox-input");

      if (this._choiceInput.checked) {
        this._choiceField.setAttribute("aria-checked", "true");
      }

      if (this._choiceField.getAttribute("aria-checked") === "true") {
        this._choiceField.classList.add("is-checked");
      }

      this._addListeners();
    }

    CheckBox.prototype.getValue = function () {
      return this._choiceField.getAttribute("aria-checked") === "true" ? true : false;
    };

    CheckBox.prototype.toggle = function () {
      if (this.getValue()) {
        this.unCheck();
      } else {
        this.check();
      }

      this._choiceInput.click();
    };

    CheckBox.prototype.check = function () {
      this._choiceField.setAttribute("aria-checked", "true");

      this._choiceField.classList.add("is-checked");
    };

    CheckBox.prototype.unCheck = function () {
      this._choiceField.setAttribute("aria-checked", "false");

      this._choiceField.classList.remove("is-checked");
    };

    CheckBox.prototype.removeListeners = function () {
      this._choiceField.removeEventListener("focus", this._FocusHandler.bind(this));

      this._choiceField.removeEventListener("blur", this._BlurHandler.bind(this));

      this._choiceField.removeEventListener("click", this._ClickHandler.bind(this));

      this._choiceField.removeEventListener("keydown", this._KeydownHandler.bind(this));
    };

    CheckBox.prototype._addListeners = function (events) {
      var ignore = events && events.ignore;

      if (!ignore || !(ignore.indexOf("focus") > -1)) {
        this._choiceField.addEventListener("focus", this._FocusHandler.bind(this), false);
      }

      if (!ignore || !(ignore.indexOf("blur") > -1)) {
        this._choiceField.addEventListener("blur", this._BlurHandler.bind(this), false);
      }

      if (!ignore || !(ignore.indexOf("click") > -1)) {
        this._choiceField.addEventListener("click", this._ClickHandler.bind(this), false);
      }

      if (!ignore || !(ignore.indexOf("keydown") > -1)) {
        this._choiceField.addEventListener("keydown", this._KeydownHandler.bind(this), false);
      }
    };

    CheckBox.prototype._FocusHandler = function () {
      this._choiceField.classList.add("in-focus");
    };

    CheckBox.prototype._BlurHandler = function () {
      this._choiceField.classList.remove("in-focus");
    };

    CheckBox.prototype._ClickHandler = function (event) {
      event.stopPropagation();
      event.preventDefault();

      if (!this._choiceField.classList.contains("is-disabled")) {
        this.toggle();
      }
    };

    CheckBox.prototype._KeydownHandler = function (event) {
      if (event.keyCode === 32) {
        event.stopPropagation();
        event.preventDefault();

        if (!this._choiceField.classList.contains("is-disabled")) {
          this.toggle();
        }
      }
    };

    return CheckBox;
  }();

  var script$5 = {
    loadStyles: loadThemedStyles.loadStyles,
    beforeMount: function beforeMount() {
      this.$fabric = {
        CheckBox: CheckBox
      };
    },
    extends: checkbox,
    mounted: function mounted() {
      if (this.value) {
        this.checkboxInstance.check();
      }
    }
  };

  /* script */
  const __vue_script__$5 = script$5;

  /* template */

    /* style */
    const __vue_inject_styles__$5 = function (inject) {
      if (!inject) return
      inject("data-v-a3afd76a_0", { source: "@charset \"UTF-8\";.ms-CheckBox[data-v-a3afd76a]{box-sizing:border-box;color:\"[theme:neutralPrimary, default: #333333]\";font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;font-size:14px;font-weight:400;min-height:36px;position:relative}.ms-CheckBox .ms-Label[data-v-a3afd76a]{font-size:14px;padding:0 0 0 26px;cursor:pointer;display:inline-block}.ms-CheckBox-input[data-v-a3afd76a]{position:absolute;opacity:0}.ms-CheckBox-field[data-v-a3afd76a]::before{content:\"\";display:inline-block;border:2px solid \"[theme:neutralTertiary, default: #a6a6a6]\";width:20px;height:20px;cursor:pointer;font-weight:400;position:absolute;box-sizing:border-box;transition-property:background,border,border-color;transition-duration:.2s;transition-timing-function:cubic-bezier(.4,0,.23,1)}.ms-CheckBox-field[data-v-a3afd76a]::after{content:\"\";font-family:FabricMDL2Icons;display:none;position:absolute;font-weight:900;background-color:transparent;font-size:13px;top:0;color:\"[theme:white, default: #ffffff]\";line-height:20px;width:20px;text-align:center}@media screen and (-ms-high-contrast:active){.ms-CheckBox-field[data-v-a3afd76a]::after{color:\"[theme:black, default: #000000]\"}}@media screen and (-ms-high-contrast:black-on-white){.ms-CheckBox-field[data-v-a3afd76a]::after{color:\"[theme:white, default: #ffffff]\"}}.ms-CheckBox-field[data-v-a3afd76a]{display:inline-block;cursor:pointer;margin-top:8px;position:relative;outline:0;vertical-align:top}.ms-CheckBox-field[data-v-a3afd76a]:focus::before,.ms-CheckBox-field[data-v-a3afd76a]:hover::before{border-color:\"[theme:neutralSecondaryAlt, default: #767676]\"}.ms-CheckBox-field:focus .ms-Label[data-v-a3afd76a],.ms-CheckBox-field:hover .ms-Label[data-v-a3afd76a]{color:\"[theme:black, default: #000000]\"}.ms-CheckBox-field.is-disabled[data-v-a3afd76a]{cursor:default}.ms-CheckBox-field.is-disabled[data-v-a3afd76a]::before{background-color:\"[theme:neutralTertiaryAlt, default: #c8c8c8]\";border-color:\"[theme:neutralTertiaryAlt, default: #c8c8c8]\";color:\"[theme:neutralTertiaryAlt, default: #c8c8c8]\"}@media screen and (-ms-high-contrast:active){.ms-CheckBox-field.is-disabled[data-v-a3afd76a]::before{border-color:#0f0}}@media screen and (-ms-high-contrast:black-on-white){.ms-CheckBox-field.is-disabled[data-v-a3afd76a]::before{border-color:#600000}}.ms-CheckBox-field.is-disabled .ms-Label[data-v-a3afd76a]{color:\"[theme:neutralTertiary, default: #a6a6a6]\"}@media screen and (-ms-high-contrast:active){.ms-CheckBox-field.is-disabled .ms-Label[data-v-a3afd76a]{color:#0f0}}@media screen and (-ms-high-contrast:black-on-white){.ms-CheckBox-field.is-disabled .ms-Label[data-v-a3afd76a]{color:#600000}}.ms-CheckBox-field.in-focus[data-v-a3afd76a]::before{border-color:\"[theme:neutralSecondaryAlt, default: #767676]\"}.ms-CheckBox-field.in-focus.is-disabled[data-v-a3afd76a]::before{border-color:\"[theme:neutralTertiaryAlt, default: #c8c8c8]\"}.ms-CheckBox-field.in-focus.is-checked[data-v-a3afd76a]::before{border-color:\"[theme:themeDarkAlt, default: #106ebe]\"}.ms-CheckBox-field.is-checked[data-v-a3afd76a]::before{border:10px solid \"[theme:themePrimary, default: #0078d7]\";background-color:\"[theme:themePrimary, default: #0078d7]\"}@media screen and (-ms-high-contrast:active){.ms-CheckBox-field.is-checked[data-v-a3afd76a]::before{border-color:#1aebff}}@media screen and (-ms-high-contrast:black-on-white){.ms-CheckBox-field.is-checked[data-v-a3afd76a]::before{border-color:#37006e}}.ms-CheckBox-field.is-checked[data-v-a3afd76a]::after{display:block}.ms-CheckBox-field.is-checked[data-v-a3afd76a]:focus::before,.ms-CheckBox-field.is-checked[data-v-a3afd76a]:hover::before{border-color:\"[theme:themeDarkAlt, default: #106ebe]\"}@font-face{font-family:FabricMDL2Icons-a13498cf;src:url(https://spoprod-a.akamaihd.net/files/fabric/assets/icons/fabric-icons-a13498cf.woff) format(\"woff\")}.ms-CheckBox-field.is-checked[data-v-a3afd76a]::after{font-family:FabricMDL2Icons-a13498cf!important}.ms-CheckBox-field.is-disabled.is-checked[data-v-a3afd76a]::before{background-color:\"[theme:neutralTertiaryAlt, default:#c8c8c8]\";border-color:\"[theme:neutralTertiaryAlt, default:#c8c8c8]\"}", map: undefined, media: undefined });

    };
    /* scoped */
    const __vue_scope_id__$5 = "data-v-a3afd76a";
    /* module identifier */
    const __vue_module_identifier__$5 = undefined;
    /* functional template */
    const __vue_is_functional_template__$5 = undefined;
    /* style inject */
    const __vue_create_injector__$2 = function(context){ 
                  return function(scopeId, data)
                  {
                      if(window['wizstyle-'+scopeId])
                          return;
                      if(__vue_script__$5.loadStyles)
                          __vue_script__$5.loadStyles(data.source);
                      window['wizstyle-'+scopeId]=true;
                  }
              };
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var uiCheckbox = normalizeComponent(
      {},
      __vue_inject_styles__$5,
      __vue_script__$5,
      __vue_scope_id__$5,
      __vue_is_functional_template__$5,
      __vue_module_identifier__$5,
      false,
      __vue_create_injector__$2,
      undefined,
      undefined
    );

  //
  var script$6 = {
    name: 'ou-choice-field',
    mixins: [disabled],
    inject: ['eventHub'],
    props: {
      value: [String, Number]
    },
    created: function created() {
      this.eventHub.$on('setChoiceField', this.setChoiceField);
    },
    beforeDestroy: function beforeDestroy() {
      this.eventHub.$off('setChoiceField', this.setChoiceField);
    },
    methods: {
      updateParentValue: function updateParentValue() {
        if (!this.disabled) {
          this.eventHub.$emit('updateValue', this.value);
        }
      },
      setChoiceField: function setChoiceField(value) {
        if (this.disabled) {
          return;
        }

        if (this.value == value) {
          this.$refs.radioLabel.classList.add('is-checked');
        } else {
          this.$refs.radioLabel.classList.remove('is-checked');
        }
      }
    }
  };

  /* script */
  const __vue_script__$6 = script$6;

  /* template */
  var __vue_render__$3 = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('li',{staticClass:"ms-RadioButton"},[_c('input',{staticClass:"ms-RadioButton-input",attrs:{"tabindex":"-1","type":"radio"}}),_vm._v(" "),_c('label',{ref:"radioLabel",staticClass:"ms-RadioButton-field",class:{ 'is-disabled': _vm.disabled },attrs:{"role":"radio","tabindex":"0","aria-checked":"false","name":"choicefieldgroup"},on:{"click":_vm.updateParentValue}},[_c('span',{staticClass:"ms-Label"},[_vm._t("default")],2)])])};
  var __vue_staticRenderFns__$3 = [];

    /* style */
    const __vue_inject_styles__$6 = undefined;
    /* scoped */
    const __vue_scope_id__$6 = undefined;
    /* module identifier */
    const __vue_module_identifier__$6 = undefined;
    /* functional template */
    const __vue_is_functional_template__$6 = false;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var ChoiceField = normalizeComponent(
      { render: __vue_render__$3, staticRenderFns: __vue_staticRenderFns__$3 },
      __vue_inject_styles__$6,
      __vue_script__$6,
      __vue_scope_id__$6,
      __vue_is_functional_template__$6,
      __vue_module_identifier__$6,
      false,
      undefined,
      undefined,
      undefined
    );

  var script$7 = {
    extends: ChoiceField,
    created: function created() {
      this.$options._scopeId = this.$parent.$options._scopeId;
    }
  };

  /* script */
  const __vue_script__$7 = script$7;

  /* template */

    /* style */
    const __vue_inject_styles__$7 = undefined;
    /* scoped */
    const __vue_scope_id__$7 = undefined;
    /* module identifier */
    const __vue_module_identifier__$7 = undefined;
    /* functional template */
    const __vue_is_functional_template__$7 = undefined;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var uiChoiceField = normalizeComponent(
      {},
      __vue_inject_styles__$7,
      __vue_script__$7,
      __vue_scope_id__$7,
      __vue_is_functional_template__$7,
      __vue_module_identifier__$7,
      false,
      undefined,
      undefined,
      undefined
    );

  var eventHub = {
    data: function data() {
      return {
        eventHub: new Vue()
      };
    },
    provide: function provide() {
      return {
        eventHub: this.eventHub
      };
    }
  };

  //
  var script$8 = {
    name: 'ou-choice-field-group',
    mixins: [eventHub],
    props: {
      value: [String, Number]
    },
    watch: {
      value: function value() {
        this.setChoiceFields();
      }
    },
    created: function created() {
      this.eventHub.$on('updateValue', this.updateValue);
    },
    beforeDestroy: function beforeDestroy() {
      this.eventHub.$off('updateValue', this.updateValue);
    },
    mounted: function mounted() {
      this.setChoiceFields();
      new this.$fabric.ChoiceFieldGroup(this.$refs.choiceFieldGroup);
    },
    methods: {
      updateValue: function updateValue(value) {
        this.$emit('input', value);
      },
      setChoiceFields: function setChoiceFields() {
        if (typeof this.value != 'undefined') {
          this.eventHub.$emit('setChoiceField', this.value);
        }
      }
    }
  };

  /* script */
  const __vue_script__$8 = script$8;

  /* template */
  var __vue_render__$4 = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{ref:"choiceFieldGroup",staticClass:"ms-ChoiceFieldGroup",attrs:{"id":"choicefieldgroup","role":"radiogroup"}},[_c('div',{staticClass:"ms-ChoiceFieldGroup-title"},[_vm._t("title")],2),_vm._v(" "),_c('ul',{staticClass:"ms-ChoiceFieldGroup-list"},[_vm._t("default")],2)])};
  var __vue_staticRenderFns__$4 = [];

    /* style */
    const __vue_inject_styles__$8 = undefined;
    /* scoped */
    const __vue_scope_id__$8 = undefined;
    /* module identifier */
    const __vue_module_identifier__$8 = undefined;
    /* functional template */
    const __vue_is_functional_template__$8 = false;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var ChoiceFieldGroup = normalizeComponent(
      { render: __vue_render__$4, staticRenderFns: __vue_staticRenderFns__$4 },
      __vue_inject_styles__$8,
      __vue_script__$8,
      __vue_scope_id__$8,
      __vue_is_functional_template__$8,
      __vue_module_identifier__$8,
      false,
      undefined,
      undefined,
      undefined
    );

  var RadioButton = function () {
    function RadioButton(container) {
      this._container = container;
      this._choiceField = this._container.querySelector(".ms-RadioButton-field");
      this._choiceInput = this._container.querySelector(".ms-RadioButton-input");

      if (this._choiceField.getAttribute("aria-checked") === "true") {
        this._choiceField.classList.add("is-checked");
      }

      this._addListeners();
    }

    RadioButton.prototype.getValue = function () {
      return this._choiceField.getAttribute("aria-checked") === "true" ? true : false;
    };

    RadioButton.prototype.toggle = function () {
      if (this.getValue()) {
        this.unCheck();
      } else {
        this.check();
      }
    };

    RadioButton.prototype.check = function () {
      this._choiceField.setAttribute("aria-checked", "true");

      this._choiceField.classList.add("is-checked");

      this._choiceInput.checked = true;
    };

    RadioButton.prototype.unCheck = function () {
      this._choiceField.setAttribute("aria-checked", "false");

      this._choiceField.classList.remove("is-checked");

      this._choiceInput.checked = false;
    };

    RadioButton.prototype.removeListeners = function () {
      this._choiceField.removeEventListener("focus", this._FocusHandler.bind(this));

      this._choiceField.removeEventListener("blur", this._BlurHandler.bind(this));

      this._choiceField.removeEventListener("click", this._RadioClickHandler.bind(this));

      this._choiceField.addEventListener("keydown", this._RadioKeydownHandler.bind(this));
    };

    RadioButton.prototype._addListeners = function () {
      this._choiceField.addEventListener("focus", this._FocusHandler.bind(this), false);

      this._choiceField.addEventListener("blur", this._BlurHandler.bind(this), false);

      this._choiceField.addEventListener("click", this._RadioClickHandler.bind(this), false);

      this._choiceField.addEventListener("keydown", this._RadioKeydownHandler.bind(this), false);
    };

    RadioButton.prototype._RadioClickHandler = function (event) {
      event.stopPropagation();
      event.preventDefault();

      if (!this._choiceField.classList.contains("is-disabled")) {
        this._dispatchSelectEvent();
      }
    };

    RadioButton.prototype._dispatchSelectEvent = function () {
      var objDict = {
        bubbles: true,
        cancelable: true,
        detail: {
          name: this._choiceField.getAttribute("name"),
          item: this
        }
      };

      this._choiceField.dispatchEvent(new CustomEvent("msChoicefield", objDict));
    };

    RadioButton.prototype._RadioKeydownHandler = function (event) {
      if (event.keyCode === 32) {
        event.stopPropagation();
        event.preventDefault();

        if (!this._choiceField.classList.contains("is-disabled")) {
          this._dispatchSelectEvent();
        }
      }
    };

    RadioButton.prototype._FocusHandler = function () {
      this._choiceField.classList.add("in-focus");
    };

    RadioButton.prototype._BlurHandler = function () {
      this._choiceField.classList.remove("in-focus");
    };

    return RadioButton;
  }();

  var ChoiceFieldGroup$1 = function () {
    function ChoiceFieldGroup(container) {
      this._choiceFieldGroup = container;
      this._choiceFieldComponents = [];

      this._initalSetup();

      this._addListeners();
    }

    ChoiceFieldGroup.prototype.removeListeners = function () {
      this._choiceFieldGroup.removeEventListener("msChoicefield", this._ChoiceFieldHandler.bind(this));
    };

    ChoiceFieldGroup.prototype._initalSetup = function () {
      var choiceFieldElements = this._choiceFieldGroup.querySelectorAll(".ms-RadioButton");

      for (var i = 0; i < choiceFieldElements.length; i++) {
        this._choiceFieldComponents[i] = new RadioButton(choiceFieldElements[i]);
      }
    };

    ChoiceFieldGroup.prototype._addListeners = function () {
      document.addEventListener("msChoicefield", this._ChoiceFieldHandler.bind(this), false);
    };

    ChoiceFieldGroup.prototype._ChoiceFieldHandler = function (event) {
      var name = event.detail.name;
      var selectedChoice = event.detail.item;

      if (this._choiceFieldGroup.id === name) {
        for (var i = 0; i < this._choiceFieldComponents.length; i++) {
          this._choiceFieldComponents[i].unCheck();
        }

        selectedChoice.check();
      }
    };

    return ChoiceFieldGroup;
  }();

  var script$9 = {
    loadStyles: loadThemedStyles.loadStyles,
    beforeMount: function beforeMount() {
      this.$fabric = {
        ChoiceFieldGroup: ChoiceFieldGroup$1
      };
    },
    extends: ChoiceFieldGroup
  };

  /* script */
  const __vue_script__$9 = script$9;

  /* template */

    /* style */
    const __vue_inject_styles__$9 = function (inject) {
      if (!inject) return
      inject("data-v-fcb13a6e_0", { source: ".ms-RadioButton[data-v-fcb13a6e]{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;box-sizing:border-box;color:\"[theme:neutralPrimary, default: #333333]\";font-size:14px;font-weight:400;min-height:36px;position:relative}.ms-RadioButton .ms-Label[data-v-fcb13a6e]{font-size:14px;padding:0 0 0 26px;cursor:pointer;display:inline-block}.ms-RadioButton-input[data-v-fcb13a6e]{position:absolute;opacity:0}.ms-RadioButton-field[data-v-fcb13a6e]::before{content:\"\";display:inline-block;border:2px solid \"[theme:neutralTertiary, default: #a6a6a6]\";width:20px;height:20px;cursor:pointer;font-weight:400;position:absolute;box-sizing:border-box;transition-property:border-color;transition-duration:.2s;transition-timing-function:cubic-bezier(.4,0,.23,1);border-radius:50%}.ms-RadioButton-field[data-v-fcb13a6e]::after{content:\"\";width:0;height:0;border-radius:50%;position:absolute;top:8px;left:8px;bottom:0;right:0;transition-property:top,left,width,height;transition-duration:150ms;transition-timing-function:cubic-bezier(.4,0,.23,1);box-sizing:border-box}@media screen and (-ms-high-contrast:active){.ms-RadioButton-field[data-v-fcb13a6e]::after{color:#0f0}}@media screen and (-ms-high-contrast:black-on-white){.ms-RadioButton-field[data-v-fcb13a6e]::after{color:#600000}}.ms-RadioButton-field[data-v-fcb13a6e]{display:inline-block;cursor:pointer;margin-top:8px;position:relative;outline:0;vertical-align:top}.ms-RadioButton-field[data-v-fcb13a6e]:focus::before,.ms-RadioButton-field[data-v-fcb13a6e]:hover::before{border-color:\"[theme:neutralSecondaryAlt, default: #767676]\"}.ms-RadioButton-field:focus .ms-Label[data-v-fcb13a6e],.ms-RadioButton-field:hover .ms-Label[data-v-fcb13a6e]{color:\"[theme:black, default: #000000]\"}.ms-RadioButton-field.is-disabled[data-v-fcb13a6e]{cursor:default}.ms-RadioButton-field.is-disabled[data-v-fcb13a6e]::before{background-color:\"[theme:neutralTertiaryAlt, default: #c8c8c8]\";border-color:\"[theme:neutralTertiaryAlt, default: #c8c8c8]\";color:\"[theme:neutralTertiaryAlt, default: #c8c8c8]\"}@media screen and (-ms-high-contrast:active){.ms-RadioButton-field.is-disabled[data-v-fcb13a6e]::before{border-color:#0f0}}@media screen and (-ms-high-contrast:black-on-white){.ms-RadioButton-field.is-disabled[data-v-fcb13a6e]::before{border-color:#600000}}.ms-RadioButton-field.is-disabled .ms-Label[data-v-fcb13a6e]{color:\"[theme:neutralTertiary, default: #a6a6a6]\"}@media screen and (-ms-high-contrast:active){.ms-RadioButton-field.is-disabled .ms-Label[data-v-fcb13a6e]{color:#0f0}}@media screen and (-ms-high-contrast:black-on-white){.ms-RadioButton-field.is-disabled .ms-Label[data-v-fcb13a6e]{color:#600000}}.ms-RadioButton-field.is-disabled[data-v-fcb13a6e]:focus::before,.ms-RadioButton-field.is-disabled[data-v-fcb13a6e]:hover::before{border-color:\"[theme:neutralTertiaryAlt, default: #c8c8c8]\"}.ms-RadioButton-field.in-focus[data-v-fcb13a6e]::before{border-color:\"[theme:neutralSecondaryAlt, default: #767676]\"}.ms-RadioButton-field.is-checked[data-v-fcb13a6e]::before{border:2px solid \"[theme:themePrimary, default: #0078d7]\";background-color:transparent}@media screen and (-ms-high-contrast:active){.ms-RadioButton-field.is-checked[data-v-fcb13a6e]::before{border-color:#1aebff}}@media screen and (-ms-high-contrast:black-on-white){.ms-RadioButton-field.is-checked[data-v-fcb13a6e]::before{border-color:#37006e}}.ms-RadioButton-field.is-checked[data-v-fcb13a6e]::after{background-color:\"[theme:themePrimary, default: #0078d7]\";top:5px;left:5px;width:10px;height:10px}@media screen and (-ms-high-contrast:active){.ms-RadioButton-field.is-checked[data-v-fcb13a6e]::after{background-color:#1aebff}}@media screen and (-ms-high-contrast:black-on-white){.ms-RadioButton-field.is-checked[data-v-fcb13a6e]::after{background-color:#37006e}}.ms-RadioButton-field.is-checked[data-v-fcb13a6e]:focus::before,.ms-RadioButton-field.is-checked[data-v-fcb13a6e]:hover::before{border-color:\"[theme:themePrimary, default: #0078d7]\"}.ms-RadioButton-field.is-checked.in-focus[data-v-fcb13a6e]::before{border-color:\"[theme:themePrimary, default: #0078d7]\"}.ms-ChoiceFieldGroup[data-v-fcb13a6e]{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;margin-bottom:4px}.ms-ChoiceFieldGroup .ms-ChoiceFieldGroup-list[data-v-fcb13a6e]{padding:0;margin:0;list-style:none}", map: undefined, media: undefined });

    };
    /* scoped */
    const __vue_scope_id__$9 = "data-v-fcb13a6e";
    /* module identifier */
    const __vue_module_identifier__$9 = undefined;
    /* functional template */
    const __vue_is_functional_template__$9 = undefined;
    /* style inject */
    const __vue_create_injector__$3 = function(context){ 
                  return function(scopeId, data)
                  {
                      if(window['wizstyle-'+scopeId])
                          return;
                      if(__vue_script__$9.loadStyles)
                          __vue_script__$9.loadStyles(data.source);
                      window['wizstyle-'+scopeId]=true;
                  }
              };
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var uiChoiceFieldGroup = normalizeComponent(
      {},
      __vue_inject_styles__$9,
      __vue_script__$9,
      __vue_scope_id__$9,
      __vue_is_functional_template__$9,
      __vue_module_identifier__$9,
      false,
      __vue_create_injector__$3,
      undefined,
      undefined
    );

  var script$a = {
    name: 'ou-contextual-menu',
    mixins: [type('multiselect'), eventHub],
    props: {
      value: {
        type: Array,
        default: function _default() {
          return [];
        }
      }
    },
    computed: {
      contextualMenuClass: function contextualMenuClass() {
        return _defineProperty({}, "ms-ContextualMenu--".concat(this.type), !!this.type);
      }
    },
    watch: {
      value: function value() {
        this.setChildrenValue();
      }
    },
    created: function created() {
      this.eventHub.$on('updateValue', this.updateValue);
    },
    data: function data() {
      return {
        contextualMenuInstance: null
      };
    },
    mounted: function mounted() {
      this.setChildrenValue();
      this.contextualMenuInstance = new this.$fabric.ContextualMenu(this.$refs.contextualMenu, this.$refs.contextualMenuTrigger);
    },
    beforeDestroy: function beforeDestroy() {
      this.eventHub.$off('updateValue', this.updateValue);
    },
    methods: {
      setChildrenValue: function setChildrenValue() {
        if (this.type == 'multiselect') {
          this.eventHub.$emit('setSelected', this.value);
        }
      },
      updateValue: function updateValue(value) {
        if (this.type != 'multiselect') {
          return;
        }

        var newValue;

        if (this.value.indexOf(value) !== -1) {
          newValue = this.value.filter(function (item) {
            return item !== value;
          });
        } else {
          newValue = this.value.concat(value);
        }

        this.$emit('input', newValue);
      }
    }
  };

  /* script */
  const __vue_script__$a = script$a;

  /* template */
  var __vue_render__$5 = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"inline-block"},[_c('span',{ref:"contextualMenuTrigger",staticClass:"inline-block"},[_vm._t("default")],2),_vm._v(" "),_c('ul',{ref:"contextualMenu",staticClass:"ms-ContextualMenu is-hidden",class:_vm.contextualMenuClass},[_vm._t("list")],2)])};
  var __vue_staticRenderFns__$5 = [];

    /* style */
    const __vue_inject_styles__$a = function (inject) {
      if (!inject) return
      inject("data-v-3132f7cc_0", { source: ".inline-block[data-v-3132f7cc]{display:inline-block}", map: undefined, media: undefined });

    };
    /* scoped */
    const __vue_scope_id__$a = "data-v-3132f7cc";
    /* module identifier */
    const __vue_module_identifier__$a = undefined;
    /* functional template */
    const __vue_is_functional_template__$a = false;
    /* style inject */
    const __vue_create_injector__$4 = function(context){ 
                  return function(scopeId, data)
                  {
                      if(window['wizstyle-'+scopeId])
                          return;
                      if(__vue_script__$a.loadStyles)
                          __vue_script__$a.loadStyles(data.source);
                      window['wizstyle-'+scopeId]=true;
                  }
              };
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var ContextualMenu = normalizeComponent(
      { render: __vue_render__$5, staticRenderFns: __vue_staticRenderFns__$5 },
      __vue_inject_styles__$a,
      __vue_script__$a,
      __vue_scope_id__$a,
      __vue_is_functional_template__$a,
      __vue_module_identifier__$a,
      false,
      __vue_create_injector__$4,
      undefined,
      undefined
    );

  var MODAL_POSITION = "bottom";
  var SUBMENU_POSITION = "right";

  var ContextualMenu$1 = function () {
    function ContextualMenu(container, hostTarget, position) {
      this._container = container;
      this._hostTarget = hostTarget;
      this._position = position ? position : MODAL_POSITION;
      this._isOpen = false;

      this._setOpener(hostTarget);

      this._init();
    }

    ContextualMenu.prototype.getHost = function () {
      return this._host;
    };

    ContextualMenu.prototype._init = function () {
      this._container.addEventListener("click", this._onContextualMenuClick.bind(this), true);

      document.addEventListener("click", this._onDocumentClick.bind(this), false);
    };

    ContextualMenu.prototype._onDocumentClick = function (event) {
      if (event.target instanceof HTMLElement) {
        var target = event.target;
        var classList = target.classList;

        if (!this._hostTarget.contains(target) && !classList.contains("ms-ContextualMenu-link")) {
          this._isOpen = false;
        }
      }
    };

    ContextualMenu.prototype._onContextualMenuClick = function (event) {
      var target = event.target;
      var classList = target.classList;

      if (classList.contains("ms-ContextualMenu-link") && !classList.contains("is-disabled")) {
        if (this._container.classList.contains("ms-ContextualMenu--multiselect")) {
          this._multiSelect(target);
        } else {
          this._singleSelect(target);

          if (!target.parentElement.classList.contains("ms-ContextualMenu-item--hasMenu")) {
            this._host.disposeModal();

            this._isOpen = false;
          }
        }
      }
    };

    ContextualMenu.prototype._multiSelect = function (target) {
      if (target.classList.contains("is-selected")) {
        target.classList.remove("is-selected");
      } else {
        target.classList.add("is-selected");
      }
    };

    ContextualMenu.prototype._singleSelect = function (target) {
      var selecteds = this._container.querySelectorAll(".is-selected");

      var i = selecteds.length;

      while (i--) {
        selecteds[i].classList.remove("is-selected");
      }

      target.classList.add("is-selected");
    };

    ContextualMenu.prototype._toggleMenu = function (event) {
      !this._isOpen ? this._openContextMenu(event) : this._host.disposeModal();
      this._isOpen = !this._isOpen;
    };

    ContextualMenu.prototype._setOpener = function (hostTarget) {
      var _this = this;

      hostTarget.addEventListener("click", function (event) {
        event.preventDefault();

        _this._toggleMenu(event);
      });
    };

    ContextualMenu.prototype._openContextMenu = function (event) {
      this._createModalHostView(this._container, this._position, this._hostTarget);

      this._checkForSubmenus(this._container);
    };

    ContextualMenu.prototype._checkForSubmenus = function (container) {
      var _this = this;

      var submenus = container.querySelectorAll(".ms-ContextualMenu-item.ms-ContextualMenu-item--hasMenu");
      var i = submenus.length;

      if (submenus.length) {
        var _loop_1 = function _loop_1() {
          var button = submenus[i].querySelector(".ms-ContextualMenu-link");
          var menu = submenus[i].querySelector(".ms-ContextualMenu");

          if (menu) {
            var contextualMenu_1 = new ContextualMenu(menu, button, SUBMENU_POSITION);
            menu.addEventListener("hostAdded", function () {
              _this._host.setChildren(contextualMenu_1.getHost());
            });
          }
        };

        while (i--) {
          _loop_1();
        }
      }
    };

    ContextualMenu.prototype._createModalHostView = function (container, position, hostTarget) {
      container.classList.remove("is-hidden");
      this._host = new ContextualHost(container, position, hostTarget, false);
      var event = document.createEvent("Event");
      event.initEvent("hostAdded", true, true);
      container.dispatchEvent(event);
    };

    return ContextualMenu;
  }();

  var script$b = {
    loadStyles: loadThemedStyles.loadStyles,
    beforeMount: function beforeMount() {
      this.$fabric = {
        ContextualMenu: ContextualMenu$1
      };
    },
    mounted: function mounted() {
      var _this = this;

      this.$refs.contextualMenuTrigger.addEventListener("click", function () {
        var setScopeIdForContextualHost = function setScopeIdForContextualHost(contextualhost) {
          contextualhost.setAttribute(_this.$options._scopeId, "");
          Array.prototype.slice.call(contextualhost.children).map(function (c) {
            return c.setAttribute(_this.$options._scopeId, "");
          }); // Array.from(contextualhost.children).map(c=>c.setAttribute(this.$options._scopeId,""));
          // if contextmenu is out of window to the right - we change left to right orientation.

          if (_this.isOutOfViewport(contextualhost).right) {
            contextualhost.style.left = "auto";
            contextualhost.style.right = "10px";
          }
        }; // set scopeId for contextualhost


        setScopeIdForContextualHost(_this.$refs.contextualMenu.parentElement.parentElement); // scopeId for menuItems

        var menuItems = _this.$refs.contextualMenu.querySelectorAll("[class^='ms-ContextualMenu']");

        Array.prototype.slice.call(menuItems).map(function (menuItem) {
          return menuItem.setAttribute(_this.$options._scopeId, "");
        }); // Array.from(menuItems).map(menuItem=>menuItem.setAttribute(this.$options._scopeId, ""));

        var subItems = _this.contextualMenuInstance._container.querySelectorAll(".ms-ContextualMenu-item.ms-ContextualMenu-item--hasMenu"); // Array.from(subItems).map((subItem)=>{


        Array.prototype.slice.call(menuItems).map(function (subItem) {
          subItem.addEventListener("click", function () {
            var contextualMenuElmInsideHost = document.querySelector(".ms-ContextualHost:not([".concat(_this.$options._scopeId, "]) [").concat(_this.$options._scopeId, "]"));
            if (contextualMenuElmInsideHost && contextualMenuElmInsideHost.parentElement.parentElement) setScopeIdForContextualHost(contextualMenuElmInsideHost.parentElement.parentElement);
            if (ContextualHost.hosts[ContextualHost.hosts.length - 1]) ContextualHost.hosts[ContextualHost.hosts.length - 1]._openModal();
          });
        });
      });
    },
    methods: {
      isOutOfViewport: function isOutOfViewport(elem) {
        // Get element bounding
        var bounding = elem.getBoundingClientRect(); // Check if it is out of the viewport on each side

        var out = {};
        out.top = bounding.top < 0;
        out.left = bounding.left < 0;
        out.bottom = bounding.bottom > (window.innerHeight || document.documentElement.clientHeight);
        out.right = bounding.right > (window.innerWidth || document.documentElement.clientWidth);
        out.any = out.top || out.left || out.bottom || out.right;
        out.all = out.top && out.left && out.bottom && out.right;
        return out;
      }
    },
    extends: ContextualMenu
  };

  /* script */
  const __vue_script__$b = script$b;

  /* template */

    /* style */
    const __vue_inject_styles__$b = function (inject) {
      if (!inject) return
      inject("data-v-e7ea7062_0", { source: "@charset \"UTF-8\";.ms-ContextualMenu[data-v-e7ea7062]{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;box-sizing:border-box;margin:0;padding:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;color:\"[theme:neutralPrimary, default: #333333]\";font-size:14px;font-weight:400;display:block;min-width:180px;max-width:220px;list-style-type:none;position:relative;background-color:\"[theme:white, default: #ffffff]\"}.ms-ContextualMenu.is-hidden[data-v-e7ea7062]{display:none}.ms-ContextualMenu-item[data-v-e7ea7062]{position:relative}.ms-ContextualMenu-link[data-v-e7ea7062]{box-sizing:border-box;text-decoration:none;color:\"[theme:neutralPrimary, default: #333333]\";border:1px solid transparent;cursor:pointer;display:block;height:36px;overflow:hidden;line-height:34px;padding:0 16px 0 25px;position:relative;text-overflow:ellipsis;white-space:nowrap}.ms-ContextualMenu-link[data-v-e7ea7062]:active,.ms-ContextualMenu-link[data-v-e7ea7062]:focus,.ms-ContextualMenu-link[data-v-e7ea7062]:hover{background-color:\"[theme:neutralLighter, default: #f4f4f4]\";color:\"[theme:neutralDark, default: #212121]\"}.ms-ContextualMenu-link:active .ms-ContextualMenu-subMenuIcon[data-v-e7ea7062],.ms-ContextualMenu-link:focus .ms-ContextualMenu-subMenuIcon[data-v-e7ea7062],.ms-ContextualMenu-link:hover .ms-ContextualMenu-subMenuIcon[data-v-e7ea7062]{color:\"[theme:neutralDark, default: #212121]\"}.ms-ContextualMenu-link[data-v-e7ea7062]:focus{outline:transparent;border:1px solid \"[theme:neutralSecondary, default: #666666]\"}.ms-ContextualMenu-link.is-selected[data-v-e7ea7062]{background-color:\"[theme:neutralQuaternaryAlt, default: #dadada]\";color:\"[theme:black, default: #000000]\";font-weight:600}.ms-ContextualMenu-link.is-selected~.ms-ContextualMenu-subMenuIcon[data-v-e7ea7062]{color:\"[theme:black, default: #000000]\"}.ms-ContextualMenu-link.is-selected[data-v-e7ea7062]:hover{background-color:\"[theme:neutralQuaternary, default: #d0d0d0]\"}.ms-ContextualMenu-link.is-disabled[data-v-e7ea7062]{color:\"[theme:neutralTertiary, default: #a6a6a6]\";background-color:\"[theme:white, default: #ffffff]\";pointer-events:none}.ms-ContextualMenu-link.is-disabled[data-v-e7ea7062]:active,.ms-ContextualMenu-link.is-disabled[data-v-e7ea7062]:focus{border-color:\"[theme:white, default: #ffffff]\"}.ms-ContextualMenu-link.is-disabled .ms-Icon[data-v-e7ea7062]{color:\"[theme:neutralTertiary, default: #a6a6a6]\";pointer-events:none;cursor:default}.ms-ContextualMenu-item.ms-ContextualMenu-item--divider[data-v-e7ea7062]{cursor:default;display:block;height:1px;background-color:\"[theme:neutralLight, default: #eaeaea]\";position:relative}.ms-ContextualMenu-item.ms-ContextualMenu-item--header[data-v-e7ea7062]{color:\"[theme:themePrimary, default: #0078d7]\";font-size:12px;text-transform:uppercase;height:36px;line-height:36px;padding:0 18px}.ms-ContextualMenu-item.ms-ContextualMenu-item--hasMenu .ms-ContextualMenu[data-v-e7ea7062]{position:absolute;top:-1px;left:178px}.ms-ContextualMenu-caretRight[data-v-e7ea7062],.ms-ContextualMenu-subMenuIcon[data-v-e7ea7062]{color:\"[theme:neutralPrimary, default: #333333]\";font-size:8px;font-weight:600;width:24px;height:36px;line-height:36px;position:absolute;text-align:center;top:0;right:0;z-index:1;pointer-events:none}.ms-ContextualMenu.ms-ContextualMenu--multiselect .ms-ContextualMenu-item.ms-ContextualMenu-item--header[data-v-e7ea7062]{padding:0 16px 0 26px}.ms-ContextualMenu.ms-ContextualMenu--multiselect .ms-ContextualMenu-link.is-selected[data-v-e7ea7062]{background-color:\"[theme:white, default: #ffffff]\";font-weight:600;color:\"[theme:neutralPrimary, default: #333333]\"}.ms-ContextualMenu.ms-ContextualMenu--multiselect .ms-ContextualMenu-link.is-selected[data-v-e7ea7062]::after{-moz-osx-font-smoothing:grayscale;-webkit-font-smoothing:antialiased;display:inline-block;font-family:FabricMDL2Icons;font-style:normal;font-weight:400;speak:none;color:\"[theme:neutralPrimary, default: #333333]\";content:\"\";font-size:10px;font-weight:800;height:36px;line-height:36px;position:absolute;left:7px}.ms-ContextualMenu.ms-ContextualMenu--multiselect .ms-ContextualMenu-link.is-selected[data-v-e7ea7062]:focus,.ms-ContextualMenu.ms-ContextualMenu--multiselect .ms-ContextualMenu-link.is-selected[data-v-e7ea7062]:hover{color:\"[theme:neutralDark, default: #212121]\";background-color:\"[theme:neutralLighter, default: #f4f4f4]\"}.ms-ContextualMenu.ms-ContextualMenu--multiselect .ms-ContextualMenu-link.is-selected[data-v-e7ea7062]:focus::after,.ms-ContextualMenu.ms-ContextualMenu--multiselect .ms-ContextualMenu-link.is-selected[data-v-e7ea7062]:hover::after{color:\"[theme:neutralDark, default: #212121]\"}.ms-ContextualMenu.ms-ContextualMenu--multiselect .ms-ContextualMenu-link.is-selected[data-v-e7ea7062]:active{color:\"[theme:black, default: #000000]\";background-color:\"[theme:neutralQuaternary, default: #d0d0d0]\"}.ms-ContextualMenu.ms-ContextualMenu--multiselect .ms-ContextualMenu-link.is-selected[data-v-e7ea7062]:active::after{color:\"[theme:black, default: #000000]\"}.ms-ContextualMenu.ms-ContextualMenu--hasChecks .ms-ContextualMenu-link[data-v-e7ea7062],.ms-ContextualMenu.ms-ContextualMenu--hasIcons .ms-ContextualMenu-link[data-v-e7ea7062]{padding-left:40px}.ms-ContextualMenu.ms-ContextualMenu--hasChecks .ms-Icon[data-v-e7ea7062],.ms-ContextualMenu.ms-ContextualMenu--hasIcons .ms-Icon[data-v-e7ea7062]{position:absolute;top:50%;transform:translateY(-50%);width:40px;text-align:center}.ms-ContextualMenu.ms-ContextualMenu--hasIcons[data-v-e7ea7062]{width:220px}.ms-ContextualHost[data-v-e7ea7062]{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;z-index:10;margin:16px auto;position:relative;min-width:10px;display:none;background-color:\"[theme:white, default: #ffffff]\";box-shadow:0 0 5px 0 rgba(0,0,0,.4)}.ms-ContextualHost.is-positioned[data-v-e7ea7062]{position:absolute;margin:0}.ms-ContextualHost.is-open[data-v-e7ea7062]{display:inline-block}.ms-ContextualHost-beak[data-v-e7ea7062]{box-shadow:0 0 15px -5px \"[theme:neutralPrimaryAlt, default: #3c3c3c]\";position:absolute;width:28px;height:28px;background:\"[theme:white, default: #ffffff]\";border:1px solid \"[theme:neutralLight, default: #eaeaea]\";box-sizing:border-box;top:-6px;display:none;-webkit-transform:rotate(45deg);transform:rotate(45deg);z-index:0;outline:1px solid transparent}.ms-ContextualHost.ms-ContextualHost--arrowLeft .ms-ContextualHost-beak[data-v-e7ea7062],.ms-ContextualHost.ms-ContextualHost--arrowRight .ms-ContextualHost-beak[data-v-e7ea7062]{top:40px;display:none}.ms-ContextualHost.ms-ContextualHost--arrowLeft .ms-ContextualHost-beak[data-v-e7ea7062]{left:-10px}.ms-ContextualHost.ms-ContextualHost--arrowRight .ms-ContextualHost-beak[data-v-e7ea7062]{right:-10px}.ms-ContextualHost.ms-ContextualHost--arrowTop .ms-ContextualHost-beak[data-v-e7ea7062]{display:block;top:-10px}.ms-ContextualHost.ms-ContextualHost--arrowBottom .ms-ContextualHost-beak[data-v-e7ea7062]{display:block;bottom:-10px}.ms-ContextualHost-main[data-v-e7ea7062]{position:relative;background-color:\"[theme:white, default: #ffffff]\";box-sizing:border-box;outline:1px solid transparent;z-index:5;min-height:10px}.ms-ContextualHost-close[data-v-e7ea7062]{margin:0;border:0;background:0 0;cursor:pointer;position:absolute;top:12px;right:12px;padding:8px;width:32px;height:32px;font-size:14px;color:\"[theme:neutralSecondary, default: #666666]\";z-index:10}.ms-ContextualHost.ms-ContextualHost--close .ms-ContextualHost-title[data-v-e7ea7062]{margin-right:20px}.ms-ContextualHost.ms-ContextualHost--primaryArrow .ms-ContextualHost-beak[data-v-e7ea7062]{background-color:\"[theme:themePrimary, default: #0078d7]\"}@media (min-width:480px){.ms-ContextualHost[data-v-e7ea7062]{margin:16px}.ms-ContextualHost.is-positioned[data-v-e7ea7062]{margin:0}.ms-ContextualHost.ms-ContextualHost--arrowLeft .ms-ContextualHost-beak[data-v-e7ea7062],.ms-ContextualHost.ms-ContextualHost--arrowRight .ms-ContextualHost-beak[data-v-e7ea7062]{display:block}}@font-face{font-family:FabricMDL2Icons-a13498cf;src:url(https://spoprod-a.akamaihd.net/files/fabric/assets/icons/fabric-icons-a13498cf.woff) format(\"woff\")}.ms-Icon[data-v-e7ea7062]{display:inline-block;font-style:normal;font-weight:400}.ms-Icon.ms-Icon--ChevronRight[data-v-e7ea7062]::before{font-family:FabricMDL2Icons-a13498cf;content:\"\"}.ms-ContextualMenu-link.is-selected[data-v-e7ea7062]::after{display:inline-block;font-style:normal;font-weight:400;font-family:FabricMDL2Icons-a13498cf!important;content:\"\"!important}", map: undefined, media: undefined });

    };
    /* scoped */
    const __vue_scope_id__$b = "data-v-e7ea7062";
    /* module identifier */
    const __vue_module_identifier__$b = undefined;
    /* functional template */
    const __vue_is_functional_template__$b = undefined;
    /* style inject */
    const __vue_create_injector__$5 = function(context){ 
                  return function(scopeId, data)
                  {
                      if(window['wizstyle-'+scopeId])
                          return;
                      if(__vue_script__$b.loadStyles)
                          __vue_script__$b.loadStyles(data.source);
                      window['wizstyle-'+scopeId]=true;
                  }
              };
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var uiContextualMenu = normalizeComponent(
      {},
      __vue_inject_styles__$b,
      __vue_script__$b,
      __vue_scope_id__$b,
      __vue_is_functional_template__$b,
      __vue_module_identifier__$b,
      false,
      __vue_create_injector__$5,
      undefined,
      undefined
    );

  var script$c = {
    name: 'ou-contextual-menu-item',
    mixins: [type('divider', 'header', 'hasMenu'), disabled],
    inject: ['eventHub'],
    data: function data() {
      return {
        selected: false
      };
    },
    props: {
      name: String,
      value: [String, Number]
    },
    computed: {
      hasLink: function hasLink() {
        return this.type == 'hasMenu' || this.type == '';
      },
      hasMenu: function hasMenu() {
        return this.type == 'hasMenu';
      },
      contextualMenuItemClass: function contextualMenuItemClass() {
        return _defineProperty({}, "ms-ContextualMenu-item--".concat(this.type), !!this.type);
      },
      contextualMenuLinkClass: function contextualMenuLinkClass() {
        return {
          'is-disabled': this.disabled,
          'is-selected': this.selected
        };
      }
    },
    created: function created() {
      this.eventHub.$on('setSelected', this.setSelected);
    },
    beforeDestroy: function beforeDestroy() {
      this.eventHub.$off('setSelected', this.setSelected);
    },
    methods: {
      clickEvent: function clickEvent() {
        if (this.value) {
          this.eventHub.$emit('updateValue', this.value);
        } else if (!this.type && !this.disabled) {
          this.$emit('click');
        }
      },
      setSelected: function setSelected(values) {
        if (values.indexOf(this.value) !== -1) {
          this.selected = true;
        } else {
          this.selected = false;
        }
      }
    }
  };

  /* script */
  const __vue_script__$c = script$c;

  /* template */
  var __vue_render__$6 = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('li',{staticClass:"ms-ContextualMenu-item",class:_vm.contextualMenuItemClass},[(_vm.type == 'header')?_c('span',[_vm._v(_vm._s(_vm.name))]):_vm._e(),_vm._v(" "),(_vm.hasLink)?_c('a',{staticClass:"ms-ContextualMenu-link",class:_vm.contextualMenuLinkClass,on:{"click":_vm.clickEvent}},[_vm._v("\n    "+_vm._s(_vm.name)+"\n  ")]):_vm._e(),_vm._v(" "),(_vm.hasMenu)?_c('i',{staticClass:"ms-ContextualMenu-subMenuIcon ms-Icon ms-Icon--ChevronRight"}):_vm._e(),_vm._v(" "),(_vm.hasMenu)?_c('ul',{staticClass:"ms-ContextualMenu is-hidden"},[_vm._t("default")],2):_vm._e()])};
  var __vue_staticRenderFns__$6 = [];

    /* style */
    const __vue_inject_styles__$c = undefined;
    /* scoped */
    const __vue_scope_id__$c = undefined;
    /* module identifier */
    const __vue_module_identifier__$c = undefined;
    /* functional template */
    const __vue_is_functional_template__$c = false;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var ContextualMenuItem = normalizeComponent(
      { render: __vue_render__$6, staticRenderFns: __vue_staticRenderFns__$6 },
      __vue_inject_styles__$c,
      __vue_script__$c,
      __vue_scope_id__$c,
      __vue_is_functional_template__$c,
      __vue_module_identifier__$c,
      false,
      undefined,
      undefined,
      undefined
    );

  var script$d = {
    extends: ContextualMenuItem
  };

  /* script */
  const __vue_script__$d = script$d;

  /* template */

    /* style */
    const __vue_inject_styles__$d = undefined;
    /* scoped */
    const __vue_scope_id__$d = undefined;
    /* module identifier */
    const __vue_module_identifier__$d = undefined;
    /* functional template */
    const __vue_is_functional_template__$d = undefined;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var uiContextualMenuItem = normalizeComponent(
      {},
      __vue_inject_styles__$d,
      __vue_script__$d,
      __vue_scope_id__$d,
      __vue_is_functional_template__$d,
      __vue_module_identifier__$d,
      false,
      undefined,
      undefined,
      undefined
    );

  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  var script$e = {
    name: 'ou-command-bar',
    mounted: function mounted() {
      new this.$fabric.CommandBar(this.$refs.commandBar);
    }
  };

  /* script */
  const __vue_script__$e = script$e;

  /* template */
  var __vue_render__$7 = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{ref:"commandBar",staticClass:"ms-CommandBar"},[_c('div',{staticClass:"ms-CommandBar-sideCommands"},[_vm._t("side")],2),_vm._v(" "),_c('div',{staticClass:"ms-CommandBar-mainArea"},[_vm._t("main"),_vm._v(" "),_vm._m(0)],2)])};
  var __vue_staticRenderFns__$7 = [function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"ms-CommandButton ms-CommandBar-overflowButton ms-CommandButton--noLabel"},[_c('button',{staticClass:"ms-CommandButton-button"},[_c('span',{staticClass:"ms-CommandButton-icon"},[_c('i',{staticClass:"ms-Icon ms-Icon--More"})]),_vm._v(" "),_c('span',{staticClass:"ms-CommandButton-label"})]),_vm._v(" "),_c('ul',{staticClass:"ms-ContextualMenu is-opened ms-ContextualMenu--hasIcons"},[_c('li',{staticClass:"ms-ContextualMenu-item"},[_c('a',{staticClass:"ms-ContextualMenu-link"}),_vm._v(" "),_c('i',{staticClass:"ms-Icon ms-Icon--folder"})])])])}];

    /* style */
    const __vue_inject_styles__$e = undefined;
    /* scoped */
    const __vue_scope_id__$e = undefined;
    /* module identifier */
    const __vue_module_identifier__$e = undefined;
    /* functional template */
    const __vue_is_functional_template__$e = false;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var commandbar = normalizeComponent(
      { render: __vue_render__$7, staticRenderFns: __vue_staticRenderFns__$7 },
      __vue_inject_styles__$e,
      __vue_script__$e,
      __vue_scope_id__$e,
      __vue_is_functional_template__$e,
      __vue_module_identifier__$e,
      false,
      undefined,
      undefined,
      undefined
    );

  var SB_FIELD = ".ms-SearchBox-field";
  var SB_CLEAR_BUTTON = ".ms-SearchBox-clear";
  var SB_EXIT_BUTTON = ".ms-SearchBox-exit";
  var SB_HAS_TEXT = "has-text";
  var SB_IS_ACTIVE = "is-active";
  var SB_IS_ANIMATED = "is-animated";

  var SearchBox = function () {
    function SearchBox(container) {
      var _this = this;

      this._container = container;

      this._saveDOMRefs(this._container);

      this._boundExpandSearchHandler = this._expandSearchHandler.bind(this);
      this._boundEnableClose = this._enableClose.bind(this);
      this._boundCollapseSearchBox = this._collapseSearchBox.bind(this);
      this._boundClearSearchBox = this._clearSearchBox.bind(this);
      this._boundHandleBlur = this._handleBlur.bind(this);
      this._boundExitSearchBox = this._exitSearchBox.bind(this);

      this._setHasText();

      this._setFocusAction(this._container);

      this._setClearButtonAction();

      this._setBlurAction();

      this._clearOnly = false;
      setTimeout(function () {
        _this._checkState();

        _this._addAnimation();
      }, 10);
    }

    SearchBox.prototype.setCollapsedListeners = function () {
      this._disposeListeners();

      this._searchBox.addEventListener("click", this._boundExpandSearchHandler, false);

      this._searchBoxField.addEventListener("focus", this._boundExpandSearchHandler, true);
    };

    SearchBox.prototype.getInputField = function () {
      return this._searchBoxField;
    };

    SearchBox.prototype._saveDOMRefs = function (context) {
      this._searchBox = context;
      this._searchBoxField = this._searchBox.querySelector(SB_FIELD);
      this._searchBoxClearButton = this._searchBox.querySelector(SB_CLEAR_BUTTON);
      this._searchBoxExitButton = this._searchBox.querySelector(SB_EXIT_BUTTON);
    };

    SearchBox.prototype._disposeListeners = function () {
      this._searchBox.removeEventListener("click", this._boundExpandSearchHandler);

      this._searchBoxField.removeEventListener("focus", this._boundExpandSearchHandler);
    };

    SearchBox.prototype._exitSearchBox = function (event) {
      event.stopPropagation();
      event.target.blur();

      this._clearSearchBox();

      this._collapseSearchBox();

      this._searchBox.removeEventListener("keyup", this._boundEnableClose);

      this.setCollapsedListeners();
    };

    SearchBox.prototype._collapseSearchBox = function () {
      this._searchBox.classList.remove("is-active");

      var event = document.createEvent("Event");
      event.initEvent("searchCollapse", true, true);

      this._searchBoxField.dispatchEvent(event);
    };

    SearchBox.prototype._expandSearchHandler = function () {
      this._disposeListeners();

      this._searchBox.classList.add("is-active");

      this._searchBoxField.focus();
    };

    SearchBox.prototype._enableClose = function () {
      this._setHasText();
    };

    SearchBox.prototype._setHasText = function () {
      if (this._searchBoxField.value.length > 0) {
        this._searchBox.classList.add(SB_HAS_TEXT);
      } else {
        this._searchBox.classList.remove(SB_HAS_TEXT);
      }
    };

    SearchBox.prototype._setFocusAction = function (context) {
      var _this = this;

      this._searchBoxField.addEventListener("focus", function () {
        _this._setHasText();

        _this._searchBox.addEventListener("keyup", _this._boundEnableClose, false);

        _this._searchBox.classList.add(SB_IS_ACTIVE);

        _this._searchBox.classList.add(SB_IS_ACTIVE);
      }, true);
    };

    SearchBox.prototype._clearSearchBox = function (event) {
      var _this = this;

      this._clearOnly = true;
      this._searchBoxField.value = "";

      this._setHasText();

      setTimeout(function () {
        _this._clearOnly = false;
      }, 10);
    };

    SearchBox.prototype._setClearButtonAction = function () {
      var _this = this;

      if (this._searchBoxExitButton) {
        this._searchBoxExitButton.addEventListener("click", this._boundExitSearchBox, false);
      }

      this._searchBoxClearButton.addEventListener("mousedown", this._boundClearSearchBox, false);

      this._searchBoxClearButton.addEventListener("keydown", function (e) {
        var keyCode = e.keyCode;

        if (keyCode === 13) {
          _this._clearSearchBox(e);
        }
      }, false);
    };

    SearchBox.prototype._handleBlur = function (event) {
      var _this = this;

      console.log("_handleBlur");
      if (this._searchBox.classList.contains("ignoreBlur")) return;

      if (!this._clearOnly) {
        this._searchBox.removeEventListener("keyup", this._boundEnableClose);

        setTimeout(function () {
          if (!_this._searchBox.contains(document.activeElement)) {
            _this._clearSearchBox();

            _this._collapseSearchBox();

            _this.setCollapsedListeners();
          }
        }, 10);
      } else {
        this._searchBoxField.focus();
      }

      this._clearOnly = false;
    };

    SearchBox.prototype._setBlurAction = function () {
      this._searchBoxField.addEventListener("blur", this._boundHandleBlur, true);

      this._searchBoxClearButton.addEventListener("blur", this._boundHandleBlur, true);
    };

    SearchBox.prototype._checkState = function () {
      if (this._searchBox.classList.contains("is-collapsed")) {
        this.setCollapsedListeners();
      }
    };

    SearchBox.prototype._addAnimation = function () {
      this._container.classList.add(SB_IS_ANIMATED);
    };

    return SearchBox;
  }();

  var CONTEXT_CLASS = ".ms-ContextualMenu";
  var CB_SPLIT_CLASS = ".ms-CommandButton-splitIcon";
  var CB_BUTTON_CLASS = ".ms-CommandButton-button";
  var MODAL_POSITION$1 = "bottom";

  var CommandButton = function () {
    function CommandButton(container, contextMenu) {
      this._container = container;
      this._command = this._container;
      this._commandButton = this._command.querySelector(CB_BUTTON_CLASS);
      this._splitButton = this._command.querySelector(CB_SPLIT_CLASS);

      if (contextMenu) {
        this._contextualMenu = contextMenu;
      } else {
        this._contextualMenu = this._container.querySelector(CONTEXT_CLASS);
      }

      this._checkForMenu();
    }

    CommandButton.prototype._createModalHostView = function () {
      this._modalHostView = new ContextualHost(this._contextualMenu, MODAL_POSITION$1, this._command, false);
    };

    CommandButton.prototype._setClick = function () {
      if (this._splitButton) {
        this._splitButton.addEventListener("click", this._createModalHostView.bind(this), false);
      } else {
        this._commandButton.addEventListener("click", this._createModalHostView.bind(this), false);
      }
    };

    CommandButton.prototype._checkForMenu = function () {
      if (this._contextualMenu) {
        this._setClick();
      }
    };

    return CommandButton;
  }();

  var CONTEXTUAL_MENU = ".ms-ContextualMenu";
  var CONTEXTUAL_MENU_ITEM = ".ms-ContextualMenu-item";
  var CONTEXTUAL_MENU_LINK = ".ms-ContextualMenu-link";
  var CB_SEARCH_BOX = ".ms-SearchBox";
  var CB_MAIN_AREA = ".ms-CommandBar-mainArea";
  var CB_SIDE_COMMAND_AREA = ".ms-CommandBar-sideCommands";
  var CB_ITEM_OVERFLOW = ".ms-CommandBar-overflowButton";
  var CB_NO_LABEL_CLASS = "ms-CommandButton--noLabel";
  var SEARCH_BOX_CLOSE = ".ms-SearchBox-closeField";
  var COMMAND_BUTTON = ".ms-CommandButton";
  var COMMAND_BUTTON_LABEL = ".ms-CommandButton-label";
  var ICON = ".ms-Icon";
  var OVERFLOW_WIDTH = 40;
  var OVERFLOW_LEFT_RIGHT_PADDING = 30;

  var CommandBar = function () {
    function CommandBar(container) {
      this.responsiveSizes = {
        "sm-min": 320,
        "md-min": 480,
        "lg-min": 640,
        "xl-min": 1024,
        "xxl-min": 1366,
        "xxxl-min": 1920
      };
      this.visibleCommands = [];
      this.commandWidths = [];
      this.overflowCommands = [];
      this.itemCollection = [];
      this._sideAreaCollection = [];
      this.breakpoint = "sm";
      this._container = container;
      this.responsiveSizes["sm-max"] = this.responsiveSizes["md-min"] - 1;
      this.responsiveSizes["md-max"] = this.responsiveSizes["lg-min"] - 1;
      this.responsiveSizes["lg-max"] = this.responsiveSizes["xl-min"] - 1;
      this.responsiveSizes["xl-max"] = this.responsiveSizes["xxl-min"] - 1;
      this.responsiveSizes["xxl-max"] = this.responsiveSizes["xxxl-min"] - 1;

      this._setElements();

      this._setBreakpoint();

      if (this._elements.overflowCommand) {
        this._initOverflow();
      }

      this._setUIState();
    }

    CommandBar.prototype._runsSearchBox = function (state) {
      if (state === void 0) {
        state = "add";
      }

      this._changeSearchState("is-collapsed", state);
    };

    CommandBar.prototype._runOverflow = function () {
      if (this._elements.overflowCommand) {
        this._saveCommandWidths();

        this._redrawMenu();

        this._updateCommands();

        this._drawCommands();

        this._checkOverflow();
      }
    };

    CommandBar.prototype._initOverflow = function () {
      this._createContextualRef();

      this._createItemCollection(this.itemCollection, CB_MAIN_AREA);

      this._createItemCollection(this._sideAreaCollection, CB_SIDE_COMMAND_AREA);

      this._saveCommandWidths();

      this._updateCommands();

      this._drawCommands();

      this._setWindowEvent();

      this._checkOverflow();
    };

    CommandBar.prototype._hasClass = function (element, cls) {
      return (" " + element.className + " ").indexOf(" " + cls + " ") > -1;
    };

    CommandBar.prototype._onSearchExpand = function () {
      if (this.breakpoint === "lg") {
        this._container.classList.add("search-expanded");

        this._doResize();
      }
    };

    CommandBar.prototype._onSearchCollapse = function () {
      if (this.breakpoint === "lg") {
        this._container.classList.remove("search-expanded");

        this._doResize();
      }
    };

    CommandBar.prototype._getScreenSize = function () {
      var w = window;
      var wSize = {
        x: 0,
        y: 0
      };
      var d = document,
          e = d.documentElement,
          g = d.getElementsByTagName("body")[0];
      wSize.x = w.innerWidth || e.clientWidth || g.clientWidth;
      wSize.y = w.innerHeight || e.clientHeight || g.clientHeight;
      return wSize;
    };

    CommandBar.prototype._setBreakpoint = function () {
      var screenSize = this._getScreenSize().x;

      switch (true) {
        case screenSize <= this.responsiveSizes["sm-max"]:
          this.breakpoint = "sm";
          break;

        case screenSize >= this.responsiveSizes["md-min"] && screenSize <= this.responsiveSizes["md-max"]:
          this.breakpoint = "md";
          break;

        case screenSize >= this.responsiveSizes["lg-min"] && screenSize <= this.responsiveSizes["lg-max"]:
          this.breakpoint = "lg";
          break;

        case screenSize >= this.responsiveSizes["xl-min"] && screenSize <= this.responsiveSizes["xl-max"]:
          this.breakpoint = "xl";
          break;

        case screenSize >= this.responsiveSizes["xxl-min"] && screenSize <= this.responsiveSizes["xxl-max"]:
          this.breakpoint = "xxl";
          break;

        case screenSize >= this.responsiveSizes["xxxl-min"]:
          this.breakpoint = "xxxl";
          break;
      }
    };

    CommandBar.prototype._createSearchInstance = function () {
      if (this._elements.searchBox) {
        return new SearchBox(this._elements.searchBox);
      } else {
        return false;
      }
    };

    CommandBar.prototype._changeSearchState = function (state, action) {
      if (this._elements.searchBox) {
        switch (action) {
          case "remove":
            this._elements.searchBox.classList.remove(state);

            break;

          case "add":
            this._elements.searchBox.classList.add(state);

            break;
        }
      }
    };

    CommandBar.prototype._setElements = function () {
      var _this = this;

      this._elements = {
        mainArea: this._container.querySelector(CB_MAIN_AREA)
      };

      if (this._container.querySelector(CB_SIDE_COMMAND_AREA)) {
        this._elements.sideCommandArea = this._container.querySelector(CB_SIDE_COMMAND_AREA);
      }

      if (this._container.querySelector(CB_ITEM_OVERFLOW)) {
        this._elements.overflowCommand = this._container.querySelector(CB_ITEM_OVERFLOW);
        this._elements.contextMenu = this._container.querySelector(CB_ITEM_OVERFLOW).querySelector(CONTEXTUAL_MENU);
      }

      if (this._container.querySelector(CB_MAIN_AREA + " " + CB_SEARCH_BOX)) {
        this._elements.searchBox = this._container.querySelector(CB_MAIN_AREA + " " + CB_SEARCH_BOX);
        this._elements.searchBoxClose = this._container.querySelector(SEARCH_BOX_CLOSE);
        this.searchBoxInstance = this._createSearchInstance();
        this.searchBoxInstance.getInputField().addEventListener("focus", function () {
          _this._onSearchExpand();
        }, false);
        this.searchBoxInstance.getInputField().addEventListener("searchCollapse", function () {
          _this._onSearchCollapse();
        }, false);
      }
    };

    CommandBar.prototype._createItemCollection = function (iCollection, areaClass) {
      var item,
          label,
          iconClasses,
          splitClasses,
          items = this._container.querySelectorAll(areaClass + " > " + COMMAND_BUTTON + ":not(" + CB_ITEM_OVERFLOW + ")");

      this._commandButtonInstance = new CommandButton(this._elements.overflowCommand);

      for (var i = 0; i < items.length; i++) {
        item = items[i];
        label = item.querySelector(COMMAND_BUTTON_LABEL).textContent;
        var icon = item.querySelector(ICON);

        if (icon) {
          iconClasses = icon.className;
          splitClasses = iconClasses.split(" ");

          for (var o = 0; o < splitClasses.length; o++) {
            if (splitClasses[o].indexOf(ICON.replace(".", "") + "--") > -1) {
              icon = splitClasses[o];
              break;
            }
          }
        }

        iCollection.push({
          item: item,
          label: label,
          icon: icon,
          isCollapsed: item.classList.contains(CB_NO_LABEL_CLASS) ? true : false,
          commandButtonRef: new CommandButton(item)
        });
      }

      return;
    };

    CommandBar.prototype._createContextualRef = function () {
      this.contextualItemContainerRef = this._elements.contextMenu.querySelector(CONTEXTUAL_MENU_ITEM).cloneNode(true);
      this.contextualItemLink = this._elements.contextMenu.querySelector(CONTEXTUAL_MENU_LINK).cloneNode(false);
      this.contextualItemIcon = this._elements.contextMenu.querySelector(".ms-Icon").cloneNode(false);
      this._elements.contextMenu.innerHTML = "";
    };

    CommandBar.prototype._getElementWidth = function (element) {
      var width, styles;

      if (element.offsetParent === null) {
        element.setAttribute("style", "position: absolute; opacity: 0; display: block;");
      }

      width = element.getBoundingClientRect().width;
      styles = window.getComputedStyle(element);
      width += parseInt(styles.marginLeft, 10) + parseInt(styles.marginRight, 10);
      element.setAttribute("style", "");
      return width;
    };

    CommandBar.prototype._saveCommandWidths = function () {
      for (var i = 0; i < this.itemCollection.length; i++) {
        var item = this.itemCollection[i].item;

        var width = this._getElementWidth(item);

        this.commandWidths[i] = width;
      }
    };

    CommandBar.prototype._updateCommands = function () {
      var searchCommandWidth = 0;

      var mainAreaWidth = this._elements.mainArea.getBoundingClientRect().width;

      if (this._elements.searchBox) {
        searchCommandWidth = this._getElementWidth(this._elements.searchBox);
      }

      var offset = searchCommandWidth + OVERFLOW_WIDTH + OVERFLOW_LEFT_RIGHT_PADDING;
      var totalAreaWidth = mainAreaWidth - offset;
      this.visibleCommands = [];
      this.overflowCommands = [];
      var totalWidths = 0;

      for (var i = 0; i < this.itemCollection.length; i++) {
        totalWidths += this.commandWidths[i];

        if (totalWidths < totalAreaWidth) {
          this.visibleCommands.push(this.itemCollection[i]);
        } else {
          this.overflowCommands.push(this.itemCollection[i]);
        }
      }
    };

    CommandBar.prototype._drawCommands = function () {
      this._elements.contextMenu.innerHTML = "";

      for (var i = 0; i < this.overflowCommands.length; i++) {
        this.overflowCommands[i].item.classList.add("is-hidden");
        var newCItem = this.contextualItemContainerRef.cloneNode(false);
        var newClink = this.contextualItemLink.cloneNode(false);
        var iconClass = this.overflowCommands[i].icon;
        newClink.innerText = this.overflowCommands[i].label;
        newCItem.appendChild(newClink);

        if (iconClass) {
          var newIcon = this.contextualItemIcon.cloneNode(false);
          newIcon.className = ICON.replace(".", "") + " " + iconClass;
          newCItem.appendChild(newIcon);
        }

        this._elements.contextMenu.appendChild(newCItem);
      }

      for (var x = 0; x < this.visibleCommands.length; x++) {
        this.visibleCommands[x].item.classList.remove("is-hidden");
      }
    };

    CommandBar.prototype._setWindowEvent = function () {
      var _this = this;

      window.addEventListener("resize", function () {
        _this._doResize();
      }, false);
    };

    CommandBar.prototype._processCollapsedClasses = function (type) {
      for (var i = 0; i < this.itemCollection.length; i++) {
        var thisItem = this.itemCollection[i];

        if (!thisItem.isCollapsed) {
          if (type === "add") {
            thisItem.item.classList.add(CB_NO_LABEL_CLASS);
          } else {
            thisItem.item.classList.remove(CB_NO_LABEL_CLASS);
          }
        }
      }

      for (var i = 0; i < this._sideAreaCollection.length; i++) {
        var thisItem = this._sideAreaCollection[i];

        if (!thisItem.isCollapsed) {
          if (type === "add") {
            thisItem.item.classList.add(CB_NO_LABEL_CLASS);
          } else {
            thisItem.item.classList.remove(CB_NO_LABEL_CLASS);
          }
        }
      }
    };

    CommandBar.prototype._setUIState = function () {
      switch (this.breakpoint) {
        case "sm":
          this._runsSearchBox();

          this._processCollapsedClasses("add");

          this._runOverflow();

          break;

        case "md":
          this._runsSearchBox();

          this._processCollapsedClasses("add");

          this._runOverflow();

          break;

        case "lg":
          this._runsSearchBox();

          this._processCollapsedClasses("remove");

          this._runOverflow();

          break;

        case "xl":
          this._runsSearchBox("remove");

          this._processCollapsedClasses("remove");

          this._runOverflow();

          break;

        default:
          this._runsSearchBox("remove");

          this._processCollapsedClasses("remove");

          this._runOverflow();

          break;
      }
    };

    CommandBar.prototype._checkOverflow = function () {
      if (this.overflowCommands.length > 0) {
        this._elements.overflowCommand.classList.remove("is-hidden");
      } else {
        this._elements.overflowCommand.classList.add("is-hidden");

        if (this.activeCommand === this._elements.overflowCommand) {
          this._elements.contextMenu.classList.remove("is-open");
        }
      }
    };

    CommandBar.prototype._redrawMenu = function () {
      var left;

      if (this._hasClass(this._elements.contextMenu, "is-open")) {
        left = this.activeCommand.getBoundingClientRect().left;

        this._drawOverflowMenu(left);
      }
    };

    CommandBar.prototype._drawOverflowMenu = function (left) {
      this._elements.contextMenu.setAttribute("style", "left: " + left + "px; transform: translateX(-50%)");
    };

    CommandBar.prototype._doResize = function () {
      this._setBreakpoint();

      this._setUIState();
    };

    return CommandBar;
  }();

  var script$f = {
    loadStyles: loadThemedStyles.loadStyles,
    beforeMount: function beforeMount() {
      this.$fabric = {
        CommandBar: CommandBar
      };
    },
    extends: commandbar
  };

  /* script */
  const __vue_script__$f = script$f;

  /* template */

    /* style */
    const __vue_inject_styles__$f = function (inject) {
      if (!inject) return
      inject("data-v-458a6beb_0", { source: "@charset \"UTF-8\";.ms-CommandBar{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;background-color:\"[theme:neutralLighter, default: #f4f4f4]\";height:40px;white-space:nowrap;padding-left:0;border:0;position:relative}.ms-CommandBar:focus{outline:0}.ms-CommandBar .ms-CommandButton--actionButton{border-right:1px solid \"[theme:neutralLight, default: #eaeaea]\"}.ms-CommandBar .ms-Button{height:100%}.ms-CommandBar .ms-Button.ms-Button--noLabel .ms-Button-icon{padding-right:0}.ms-CommandBar .ms-Button.is-hidden{display:none}.ms-CommandBar .ms-SearchBox,.ms-CommandBar .ms-SearchBox-field,.ms-CommandBar .ms-SearchBox-label{height:100%}.ms-CommandBar .ms-SearchBox{display:inline-block;vertical-align:top;transition:margin-right 267ms}.ms-CommandBar .ms-SearchBox.ms-SearchBox--commandBar.is-collapsed.is-active{width:220px}@media only screen and (max-width:639px){.ms-CommandBar .ms-SearchBox.ms-SearchBox--commandBar.is-collapsed.is-active{width:100%;position:absolute;left:0;right:0;z-index:10}}.ms-CommandBar .ms-CommandBar-overflowButton .ms-CommandButton-button{font-size:18px;padding:0 11px}@media only screen and (min-width:1024px){.ms-CommandBar .ms-SearchBox{margin-right:24px}}@media only screen and (max-width:639px){.ms-CommandBar{height:44px}}@media only screen and (min-width:640px){.ms-CommandBar.search-expanded .ms-SearchBox{margin-right:8px}.ms-CommandBar .ms-SearchBox.ms-SearchBox--commandBar.is-collapsed{transition:none}}.ms-CommandBar-mainArea{overflow-x:hidden;display:block;height:100%;overflow:hidden}.ms-CommandBar-sideCommands{float:right;text-align:right;width:auto;padding-right:4px;height:100%}.ms-CommandBar-sideCommands .ms-Button:last-child{margin-right:0}@media only screen and (min-width:640px){.ms-CommandBar-sideCommands{min-width:128px}}@media only screen and (min-width:1024px){.ms-CommandBar-sideCommands{padding-right:20px}}.ms-CommandButton{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;display:inline-block;position:relative;vertical-align:top}.ms-CommandButton.is-hidden{display:none}.ms-CommandButton.is-disabled .ms-CommandButton-button,.ms-CommandButton:disabled .ms-CommandButton-button{cursor:default}.ms-CommandButton.is-disabled .ms-CommandButton-button:hover,.ms-CommandButton:disabled .ms-CommandButton-button:hover{background-color:\"[theme:themeLighterAlt, default: #eff6fc]\"}.ms-CommandButton.is-disabled .ms-CommandButton-button .ms-CommandButton-label,.ms-CommandButton:disabled .ms-CommandButton-button .ms-CommandButton-label{color:\"[theme:neutralTertiary, default: #a6a6a6]\"}.ms-CommandButton.is-disabled .ms-CommandButton-button .ms-CommandButton-icon,.ms-CommandButton:disabled .ms-CommandButton-button .ms-CommandButton-icon{color:\"[theme:neutralTertiary, default: #a6a6a6]\"}.ms-CommandButton .ms-ContextualMenu{display:none}.ms-CommandButton-button,.ms-CommandButton-splitIcon{box-sizing:border-box;margin:0;padding:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;color:\"[theme:neutralPrimary, default: #333333]\";font-size:14px;font-weight:400;cursor:pointer;display:inline-block;height:40px;line-height:40px;outline:1px solid transparent;padding:0 8px;position:relative;vertical-align:top;background:0 0}.ms-CommandButton-button:hover,.ms-CommandButton-splitIcon:hover{background-color:\"[theme:neutralLight, default: #eaeaea]\"}.ms-CommandButton-button:hover .ms-CommandButton-label,.ms-CommandButton-splitIcon:hover .ms-CommandButton-label{color:\"[theme:neutralDark, default: #212121]\"}.ms-CommandButton-button:active,.ms-CommandButton-splitIcon:active{background-color:\"[theme:neutralLight, default: #eaeaea]\"}.ms-CommandButton-button:focus::before,.ms-CommandButton-splitIcon:focus::before{top:3px;left:3px;right:3px;bottom:3px;border:1px solid \"[theme:neutralPrimary, default: #333333]\";position:absolute;z-index:10;content:\"\";outline:0}.ms-CommandButton-button:focus,.ms-CommandButton-splitIcon:focus{outline:0}@media only screen and (max-width:639px){.ms-CommandButton-button,.ms-CommandButton-splitIcon{height:44px}.ms-CommandButton-button .ms-CommandButton-icon,.ms-CommandButton-splitIcon .ms-CommandButton-icon{font-size:20px}.ms-CommandButton-button .ms-CommandButton-label,.ms-CommandButton-splitIcon .ms-CommandButton-label{line-height:44px}}.ms-CommandButton-button{border:0;margin:0}.ms-CommandButton+.ms-CommandButton{margin-left:8px}@media only screen and (max-width:639px){.ms-CommandButton+.ms-CommandButton{margin-left:4px}}.ms-CommandButton-icon{display:inline-block;margin-right:8px;position:relative;font-size:16px;min-width:16px;height:100%}.ms-CommandButton-icon .ms-Icon{position:absolute;top:50%;left:50%;transform:translate(-50%,-50%)}.ms-CommandButton-label{font-size:14px;font-weight:400;color:\"[theme:neutralPrimary, default: #333333]\";line-height:40px;height:100%;display:inline-block;vertical-align:top}.ms-CommandButton-label:hover{color:\"[theme:neutralDark, default: #212121]\"}.ms-CommandButton-dropdownIcon,.ms-CommandButton-splitIcon{display:inline-block;position:relative;color:\"[theme:neutralPrimary, default: #333333]\";font-size:12px;font-weight:300;min-width:12px;height:100%;vertical-align:top;margin-left:8px}.ms-CommandButton-dropdownIcon .ms-Icon,.ms-CommandButton-splitIcon .ms-Icon{line-height:normal;padding-top:16px}.ms-CommandButton-dropdownIcon:focus::before,.ms-CommandButton-splitIcon:focus::before{top:3px;left:3px;right:3px;bottom:3px;border:1px solid \"[theme:neutralPrimary, default: #333333]\";position:absolute;z-index:10;content:\"\";outline:0}@media only screen and (max-width:639px){.ms-CommandButton-dropdownIcon,.ms-CommandButton-splitIcon{display:none}}.ms-CommandButton-splitIcon{margin-left:-2px;width:27px;border:0}.ms-CommandButton-splitIcon .ms-Icon{margin-left:-1px;position:relative;padding-top:16px}.ms-CommandButton-splitIcon .ms-Icon::after{position:absolute;content:\" \";width:1px;height:16px;top:12px;left:-8px;border-left:1px solid \"[theme:neutralTertiaryAlt, default: #c8c8c8]\"}.ms-CommandButton.ms-CommandButton--noLabel .ms-CommandButton-icon{margin-right:0}.ms-CommandButton.ms-CommandButton--noLabel .ms-CommandButton-label{display:none}.ms-CommandButton.ms-CommandButton--noLabel .ms-CommandButton-button{padding:0 12px}.ms-CommandButton.ms-CommandButton--inline .ms-CommandButton-button{background:0 0}.ms-CommandButton.ms-CommandButton--actionButton .ms-CommandButton-button{width:50px;height:40px}.ms-CommandButton.ms-CommandButton--actionButton .ms-CommandButton-icon{position:absolute;top:50%;left:50%;transform:translate(-50%,-50%);width:16px;height:16px;padding-right:0}.ms-CommandButton.ms-CommandButton--pivot.is-active::before{content:\"\";height:2px;position:absolute;left:0;right:0;background-color:\"[theme:themePrimary, default: #0078d7]\";bottom:0;z-index:5}.ms-CommandButton.ms-CommandButton--pivot:hover::before{content:\"\";height:2px;position:absolute;left:0;right:0;background-color:\"[theme:themePrimary, default: #0078d7]\";bottom:0;z-index:5}.ms-CommandButton.ms-CommandButton--pivot .ms-CommandButton-label,.ms-CommandButton.ms-CommandButton--textOnly .ms-CommandButton-label{display:inline-block}@media only screen and (max-width:479px){.ms-CommandButton.ms-CommandButton--pivot .ms-CommandButton-label,.ms-CommandButton.ms-CommandButton--textOnly .ms-CommandButton-label{font-size:16px}}.ms-ContextualMenu{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;box-sizing:border-box;margin:0;padding:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;color:\"[theme:neutralPrimary, default: #333333]\";font-size:14px;font-weight:400;display:block;min-width:180px;max-width:220px;list-style-type:none;position:relative;background-color:\"[theme:white, default: #ffffff]\"}.ms-ContextualMenu.is-hidden{display:none}.ms-ContextualMenu-item{position:relative}.ms-ContextualMenu-link{box-sizing:border-box;text-decoration:none;color:\"[theme:neutralPrimary, default: #333333]\";border:1px solid transparent;cursor:pointer;display:block;height:36px;overflow:hidden;line-height:34px;padding:0 16px 0 25px;position:relative;text-overflow:ellipsis;white-space:nowrap}.ms-ContextualMenu-link:active,.ms-ContextualMenu-link:focus,.ms-ContextualMenu-link:hover{background-color:\"[theme:neutralLighter, default: #f4f4f4]\";color:\"[theme:neutralDark, default: #212121]\"}.ms-ContextualMenu-link:active .ms-ContextualMenu-subMenuIcon,.ms-ContextualMenu-link:focus .ms-ContextualMenu-subMenuIcon,.ms-ContextualMenu-link:hover .ms-ContextualMenu-subMenuIcon{color:\"[theme:neutralDark, default: #212121]\"}.ms-ContextualMenu-link:focus{outline:transparent;border:1px solid \"[theme:neutralSecondary, default: #666666]\"}.ms-ContextualMenu-link.is-selected{background-color:\"[theme:neutralQuaternaryAlt, default: #dadada]\";color:\"[theme:black, default: #000000]\";font-weight:600}.ms-ContextualMenu-link.is-selected~.ms-ContextualMenu-subMenuIcon{color:\"[theme:black, default: #000000]\"}.ms-ContextualMenu-link.is-selected:hover{background-color:\"[theme:neutralQuaternary, default: #d0d0d0]\"}.ms-ContextualMenu-link.is-disabled{color:\"[theme:neutralTertiary, default: #a6a6a6]\";background-color:\"[theme:white, default: #ffffff]\";pointer-events:none}.ms-ContextualMenu-link.is-disabled:active,.ms-ContextualMenu-link.is-disabled:focus{border-color:\"[theme:white, default: #ffffff]\"}.ms-ContextualMenu-link.is-disabled .ms-Icon{color:\"[theme:neutralTertiary, default: #a6a6a6]\";pointer-events:none;cursor:default}.ms-ContextualMenu-item.ms-ContextualMenu-item--divider{cursor:default;display:block;height:1px;background-color:\"[theme:neutralLight, default: #eaeaea]\";position:relative}.ms-ContextualMenu-item.ms-ContextualMenu-item--header{color:\"[theme:themePrimary, default: #0078d7]\";font-size:12px;text-transform:uppercase;height:36px;line-height:36px;padding:0 18px}.ms-ContextualMenu-item.ms-ContextualMenu-item--hasMenu .ms-ContextualMenu{position:absolute;top:-1px;left:178px}.ms-ContextualMenu-caretRight,.ms-ContextualMenu-subMenuIcon{color:\"[theme:neutralPrimary, default: #333333]\";font-size:8px;font-weight:600;width:24px;height:36px;line-height:36px;position:absolute;text-align:center;top:0;right:0;z-index:1;pointer-events:none}.ms-ContextualMenu.ms-ContextualMenu--multiselect .ms-ContextualMenu-item.ms-ContextualMenu-item--header{padding:0 16px 0 26px}.ms-ContextualMenu.ms-ContextualMenu--multiselect .ms-ContextualMenu-link.is-selected{background-color:\"[theme:white, default: #ffffff]\";font-weight:600;color:\"[theme:neutralPrimary, default: #333333]\"}.ms-ContextualMenu.ms-ContextualMenu--multiselect .ms-ContextualMenu-link.is-selected::after{-moz-osx-font-smoothing:grayscale;-webkit-font-smoothing:antialiased;display:inline-block;font-family:FabricMDL2Icons;font-style:normal;font-weight:400;speak:none;color:\"[theme:neutralPrimary, default: #333333]\";content:\"\";font-size:10px;font-weight:800;height:36px;line-height:36px;position:absolute;left:7px}.ms-ContextualMenu.ms-ContextualMenu--multiselect .ms-ContextualMenu-link.is-selected:focus,.ms-ContextualMenu.ms-ContextualMenu--multiselect .ms-ContextualMenu-link.is-selected:hover{color:\"[theme:neutralDark, default: #212121]\";background-color:\"[theme:neutralLighter, default: #f4f4f4]\"}.ms-ContextualMenu.ms-ContextualMenu--multiselect .ms-ContextualMenu-link.is-selected:focus::after,.ms-ContextualMenu.ms-ContextualMenu--multiselect .ms-ContextualMenu-link.is-selected:hover::after{color:\"[theme:neutralDark, default: #212121]\"}.ms-ContextualMenu.ms-ContextualMenu--multiselect .ms-ContextualMenu-link.is-selected:active{color:\"[theme:black, default: #000000]\";background-color:\"[theme:neutralQuaternary, default: #d0d0d0]\"}.ms-ContextualMenu.ms-ContextualMenu--multiselect .ms-ContextualMenu-link.is-selected:active::after{color:\"[theme:black, default: #000000]\"}.ms-ContextualMenu.ms-ContextualMenu--hasChecks .ms-ContextualMenu-link,.ms-ContextualMenu.ms-ContextualMenu--hasIcons .ms-ContextualMenu-link{padding-left:40px}.ms-ContextualMenu.ms-ContextualMenu--hasChecks .ms-Icon,.ms-ContextualMenu.ms-ContextualMenu--hasIcons .ms-Icon{position:absolute;top:50%;transform:translateY(-50%);width:40px;text-align:center}.ms-ContextualMenu.ms-ContextualMenu--hasIcons{width:220px}.ms-ContextualHost{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;z-index:10;margin:16px auto;position:relative;min-width:10px;display:none;background-color:\"[theme:white, default: #ffffff]\";box-shadow:0 0 5px 0 rgba(0,0,0,.4)}.ms-ContextualHost.is-positioned{position:absolute;margin:0}.ms-ContextualHost.is-open{display:inline-block}.ms-ContextualHost-beak{box-shadow:0 0 15px -5px \"[theme:neutralPrimaryAlt, default: #3c3c3c]\";position:absolute;width:28px;height:28px;background:\"[theme:white, default: #ffffff]\";border:1px solid \"[theme:neutralLight, default: #eaeaea]\";box-sizing:border-box;top:-6px;display:none;-webkit-transform:rotate(45deg);transform:rotate(45deg);z-index:0;outline:1px solid transparent}.ms-ContextualHost.ms-ContextualHost--arrowLeft .ms-ContextualHost-beak,.ms-ContextualHost.ms-ContextualHost--arrowRight .ms-ContextualHost-beak{top:40px;display:none}.ms-ContextualHost.ms-ContextualHost--arrowLeft .ms-ContextualHost-beak{left:-10px}.ms-ContextualHost.ms-ContextualHost--arrowRight .ms-ContextualHost-beak{right:-10px}.ms-ContextualHost.ms-ContextualHost--arrowTop .ms-ContextualHost-beak{display:block;top:-10px}.ms-ContextualHost.ms-ContextualHost--arrowBottom .ms-ContextualHost-beak{display:block;bottom:-10px}.ms-ContextualHost-main{position:relative;background-color:\"[theme:white, default: #ffffff]\";box-sizing:border-box;outline:1px solid transparent;z-index:5;min-height:10px}.ms-ContextualHost-close{margin:0;border:0;background:0 0;cursor:pointer;position:absolute;top:12px;right:12px;padding:8px;width:32px;height:32px;font-size:14px;color:\"[theme:neutralSecondary, default: #666666]\";z-index:10}.ms-ContextualHost.ms-ContextualHost--close .ms-ContextualHost-title{margin-right:20px}.ms-ContextualHost.ms-ContextualHost--primaryArrow .ms-ContextualHost-beak{background-color:\"[theme:themePrimary, default: #0078d7]\"}@media (min-width:480px){.ms-ContextualHost{margin:16px}.ms-ContextualHost.is-positioned{margin:0}.ms-ContextualHost.ms-ContextualHost--arrowLeft .ms-ContextualHost-beak,.ms-ContextualHost.ms-ContextualHost--arrowRight .ms-ContextualHost-beak{display:block}}.inline-block{display:inline-block}@font-face{font-family:FabricMDL2Icons-a13498cf;src:url(https://spoprod-a.akamaihd.net/files/fabric/assets/icons/fabric-icons-a13498cf.woff) format(\"woff\")}.ms-Icon{display:inline-block;font-style:normal;font-weight:400}.ms-Icon.ms-Icon--More::before{font-family:FabricMDL2Icons-a13498cf;content:\"\"}", map: undefined, media: undefined });

    };
    /* scoped */
    const __vue_scope_id__$f = undefined;
    /* module identifier */
    const __vue_module_identifier__$f = undefined;
    /* functional template */
    const __vue_is_functional_template__$f = undefined;
    /* style inject */
    const __vue_create_injector__$6 = function(context){ 
                  return function(scopeId, data)
                  {
                      if(window['wizstyle-'+scopeId])
                          return;
                      if(__vue_script__$f.loadStyles)
                          __vue_script__$f.loadStyles(data.source);
                      window['wizstyle-'+scopeId]=true;
                  }
              };
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var uiCommandBar = normalizeComponent(
      {},
      __vue_inject_styles__$f,
      __vue_script__$f,
      __vue_scope_id__$f,
      __vue_is_functional_template__$f,
      __vue_module_identifier__$f,
      false,
      __vue_create_injector__$6,
      undefined,
      undefined
    );

  var script$g = {
    name: 'ou-command-button',
    mixins: [type('noLabel', 'inline', 'dropdown'), disabled, icon],
    computed: {
      commandButtonClass: function commandButtonClass() {
        var _ref;

        return _ref = {}, _defineProperty(_ref, "ms-CommandButton--".concat(this.type), !!this.type), _defineProperty(_ref, 'is-disabled', this.disabled), _ref;
      }
    },
    methods: {
      clickEvent: function clickEvent() {
        if (!this.disabled) {
          this.$emit('click');
        }
      }
    }
  };

  /* script */
  const __vue_script__$g = script$g;

  /* template */
  var __vue_render__$8 = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"ms-CommandButton",class:_vm.commandButtonClass,on:{"click":_vm.clickEvent}},[_c('button',{staticClass:"ms-CommandButton-button"},[(_vm.icon)?_c('span',{staticClass:"ms-CommandButton-icon ms-fontColor-themePrimary"},[_c('i',{staticClass:"ms-Icon",class:_vm.iconClass})]):_vm._e(),_vm._v(" "),_c('span',{staticClass:"ms-CommandButton-label"},[_vm._t("default")],2),_vm._v(" "),(_vm.type == 'dropdown')?_c('span',{staticClass:"ms-CommandButton-dropdownIcon"},[_c('i',{staticClass:"ms-Icon ms-Icon--ChevronDown"})]):_vm._e()])])};
  var __vue_staticRenderFns__$8 = [];

    /* style */
    const __vue_inject_styles__$g = undefined;
    /* scoped */
    const __vue_scope_id__$g = undefined;
    /* module identifier */
    const __vue_module_identifier__$g = undefined;
    /* functional template */
    const __vue_is_functional_template__$g = false;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var commandbutton = normalizeComponent(
      { render: __vue_render__$8, staticRenderFns: __vue_staticRenderFns__$8 },
      __vue_inject_styles__$g,
      __vue_script__$g,
      __vue_scope_id__$g,
      __vue_is_functional_template__$g,
      __vue_module_identifier__$g,
      false,
      undefined,
      undefined,
      undefined
    );

  //
  var script$h = {
    loadStyles: loadThemedStyles.loadStyles,
    computed: {
      hasIcon: function hasIcon() {
        return !!this.$slots['icon'];
      }
    },
    beforeMount: function beforeMount() {
      this.$fabric = {
        CommandButton: CommandButton
      };
    },
    extends: commandbutton
  };

  /* script */
  const __vue_script__$h = script$h;

  /* template */
  var __vue_render__$9 = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"ms-CommandButton",class:_vm.commandButtonClass,on:{"click":_vm.clickEvent}},[_c('button',{staticClass:"ms-CommandButton-button"},[(_vm.hasIcon)?_c('span',{staticClass:"ms-CommandButton-icon ms-fontColor-themePrimary"},[_vm._t("icon")],2):_vm._e(),_vm._v(" "),_c('span',{staticClass:"ms-CommandButton-label"},[_vm._t("default")],2),_vm._v(" "),(_vm.type == 'dropdown')?_c('span',{staticClass:"ms-CommandButton-dropdownIcon"},[_c('i',{staticClass:"ms-Icon ms-Icon--ChevronDown"})]):_vm._e()])])};
  var __vue_staticRenderFns__$9 = [];

    /* style */
    const __vue_inject_styles__$h = function (inject) {
      if (!inject) return
      inject("data-v-07a7d11a_0", { source: ".ms-CommandButton[data-v-07a7d11a]{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;display:inline-block;position:relative;vertical-align:top}.ms-CommandButton.is-hidden[data-v-07a7d11a]{display:none}.ms-CommandButton.is-disabled .ms-CommandButton-button[data-v-07a7d11a],.ms-CommandButton:disabled .ms-CommandButton-button[data-v-07a7d11a]{cursor:default}.ms-CommandButton.is-disabled .ms-CommandButton-button[data-v-07a7d11a]:hover,.ms-CommandButton:disabled .ms-CommandButton-button[data-v-07a7d11a]:hover{background-color:\"[theme:themeLighterAlt, default: #eff6fc]\"}.ms-CommandButton.is-disabled .ms-CommandButton-button .ms-CommandButton-label[data-v-07a7d11a],.ms-CommandButton:disabled .ms-CommandButton-button .ms-CommandButton-label[data-v-07a7d11a]{color:\"[theme:neutralTertiary, default: #a6a6a6]\"}.ms-CommandButton.is-disabled .ms-CommandButton-button .ms-CommandButton-icon[data-v-07a7d11a],.ms-CommandButton:disabled .ms-CommandButton-button .ms-CommandButton-icon[data-v-07a7d11a]{color:\"[theme:neutralTertiary, default: #a6a6a6]\"}.ms-CommandButton .ms-ContextualMenu[data-v-07a7d11a]{display:none}.ms-CommandButton-button[data-v-07a7d11a],.ms-CommandButton-splitIcon[data-v-07a7d11a]{box-sizing:border-box;margin:0;padding:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;color:\"[theme:neutralPrimary, default: #333333]\";font-size:14px;font-weight:400;cursor:pointer;display:inline-block;height:40px;line-height:40px;outline:1px solid transparent;padding:0 8px;position:relative;vertical-align:top;background:0 0}.ms-CommandButton-button[data-v-07a7d11a]:hover,.ms-CommandButton-splitIcon[data-v-07a7d11a]:hover{background-color:\"[theme:neutralLight, default: #eaeaea]\"}.ms-CommandButton-button:hover .ms-CommandButton-label[data-v-07a7d11a],.ms-CommandButton-splitIcon:hover .ms-CommandButton-label[data-v-07a7d11a]{color:\"[theme:neutralDark, default: #212121]\"}.ms-CommandButton-button[data-v-07a7d11a]:active,.ms-CommandButton-splitIcon[data-v-07a7d11a]:active{background-color:\"[theme:neutralLight, default: #eaeaea]\"}.ms-CommandButton-button[data-v-07a7d11a]:focus::before,.ms-CommandButton-splitIcon[data-v-07a7d11a]:focus::before{top:3px;left:3px;right:3px;bottom:3px;border:1px solid \"[theme:neutralPrimary, default: #333333]\";position:absolute;z-index:10;content:\"\";outline:0}.ms-CommandButton-button[data-v-07a7d11a]:focus,.ms-CommandButton-splitIcon[data-v-07a7d11a]:focus{outline:0}@media only screen and (max-width:639px){.ms-CommandButton-button[data-v-07a7d11a],.ms-CommandButton-splitIcon[data-v-07a7d11a]{height:44px}.ms-CommandButton-button .ms-CommandButton-icon[data-v-07a7d11a],.ms-CommandButton-splitIcon .ms-CommandButton-icon[data-v-07a7d11a]{font-size:20px}.ms-CommandButton-button .ms-CommandButton-label[data-v-07a7d11a],.ms-CommandButton-splitIcon .ms-CommandButton-label[data-v-07a7d11a]{line-height:44px}}.ms-CommandButton-button[data-v-07a7d11a]{border:0;margin:0}.ms-CommandButton+.ms-CommandButton[data-v-07a7d11a]{margin-left:8px}@media only screen and (max-width:639px){.ms-CommandButton+.ms-CommandButton[data-v-07a7d11a]{margin-left:4px}}.ms-CommandButton-icon[data-v-07a7d11a]{display:inline-block;margin-right:8px;position:relative;font-size:16px;min-width:16px;height:100%}.ms-CommandButton-icon .ms-Icon[data-v-07a7d11a]{position:absolute;top:50%;left:50%;transform:translate(-50%,-50%)}.ms-CommandButton-label[data-v-07a7d11a]{font-size:14px;font-weight:400;color:\"[theme:neutralPrimary, default: #333333]\";line-height:40px;height:100%;display:inline-block;vertical-align:top}.ms-CommandButton-label[data-v-07a7d11a]:hover{color:\"[theme:neutralDark, default: #212121]\"}.ms-CommandButton-dropdownIcon[data-v-07a7d11a],.ms-CommandButton-splitIcon[data-v-07a7d11a]{display:inline-block;position:relative;color:\"[theme:neutralPrimary, default: #333333]\";font-size:12px;font-weight:300;min-width:12px;height:100%;vertical-align:top;margin-left:8px}.ms-CommandButton-dropdownIcon .ms-Icon[data-v-07a7d11a],.ms-CommandButton-splitIcon .ms-Icon[data-v-07a7d11a]{line-height:normal;padding-top:16px}.ms-CommandButton-dropdownIcon[data-v-07a7d11a]:focus::before,.ms-CommandButton-splitIcon[data-v-07a7d11a]:focus::before{top:3px;left:3px;right:3px;bottom:3px;border:1px solid \"[theme:neutralPrimary, default: #333333]\";position:absolute;z-index:10;content:\"\";outline:0}@media only screen and (max-width:639px){.ms-CommandButton-dropdownIcon[data-v-07a7d11a],.ms-CommandButton-splitIcon[data-v-07a7d11a]{display:none}}.ms-CommandButton-splitIcon[data-v-07a7d11a]{margin-left:-2px;width:27px;border:0}.ms-CommandButton-splitIcon .ms-Icon[data-v-07a7d11a]{margin-left:-1px;position:relative;padding-top:16px}.ms-CommandButton-splitIcon .ms-Icon[data-v-07a7d11a]::after{position:absolute;content:\" \";width:1px;height:16px;top:12px;left:-8px;border-left:1px solid \"[theme:neutralTertiaryAlt, default: #c8c8c8]\"}.ms-CommandButton.ms-CommandButton--noLabel .ms-CommandButton-icon[data-v-07a7d11a]{margin-right:0}.ms-CommandButton.ms-CommandButton--noLabel .ms-CommandButton-label[data-v-07a7d11a]{display:none}.ms-CommandButton.ms-CommandButton--noLabel .ms-CommandButton-button[data-v-07a7d11a]{padding:0 12px}.ms-CommandButton.ms-CommandButton--inline .ms-CommandButton-button[data-v-07a7d11a]{background:0 0}.ms-CommandButton.ms-CommandButton--actionButton .ms-CommandButton-button[data-v-07a7d11a]{width:50px;height:40px}.ms-CommandButton.ms-CommandButton--actionButton .ms-CommandButton-icon[data-v-07a7d11a]{position:absolute;top:50%;left:50%;transform:translate(-50%,-50%);width:16px;height:16px;padding-right:0}.ms-CommandButton.ms-CommandButton--pivot.is-active[data-v-07a7d11a]::before{content:\"\";height:2px;position:absolute;left:0;right:0;background-color:\"[theme:themePrimary, default: #0078d7]\";bottom:0;z-index:5}.ms-CommandButton.ms-CommandButton--pivot[data-v-07a7d11a]:hover::before{content:\"\";height:2px;position:absolute;left:0;right:0;background-color:\"[theme:themePrimary, default: #0078d7]\";bottom:0;z-index:5}.ms-CommandButton.ms-CommandButton--pivot .ms-CommandButton-label[data-v-07a7d11a],.ms-CommandButton.ms-CommandButton--textOnly .ms-CommandButton-label[data-v-07a7d11a]{display:inline-block}@media only screen and (max-width:479px){.ms-CommandButton.ms-CommandButton--pivot .ms-CommandButton-label[data-v-07a7d11a],.ms-CommandButton.ms-CommandButton--textOnly .ms-CommandButton-label[data-v-07a7d11a]{font-size:16px}}", map: undefined, media: undefined });

    };
    /* scoped */
    const __vue_scope_id__$h = "data-v-07a7d11a";
    /* module identifier */
    const __vue_module_identifier__$h = undefined;
    /* functional template */
    const __vue_is_functional_template__$h = false;
    /* style inject */
    const __vue_create_injector__$7 = function(context){ 
                  return function(scopeId, data)
                  {
                      if(window['wizstyle-'+scopeId])
                          return;
                      if(__vue_script__$h.loadStyles)
                          __vue_script__$h.loadStyles(data.source);
                      window['wizstyle-'+scopeId]=true;
                  }
              };
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var uiCommandButton = normalizeComponent(
      { render: __vue_render__$9, staticRenderFns: __vue_staticRenderFns__$9 },
      __vue_inject_styles__$h,
      __vue_script__$h,
      __vue_scope_id__$h,
      __vue_is_functional_template__$h,
      __vue_module_identifier__$h,
      false,
      __vue_create_injector__$7,
      undefined,
      undefined
    );

  var script$i = {
    name: 'ou-dialog',
    mixins: [type('multiline', 'lgHeader', 'blocking', 'close')],
    props: {
      title: String,
      subText: String,
      value: {
        type: Boolean,
        default: false
      }
    },
    data: function data() {
      return {
        dialogInstance: null
      };
    },
    computed: {
      dialogClass: function dialogClass() {
        return _defineProperty({}, "ms-Dialog--".concat(this.type), !!this.type);
      }
    },
    watch: {
      value: function value(_value) {
        this.setDialogVisibility(_value);
      }
    },
    mounted: function mounted() {
      this.dialogInstance = new this.$fabric.Dialog(this.$refs.dialog);
      this.setDialogVisibility(this.value);
    },
    methods: {
      setDialogVisibility: function setDialogVisibility(value) {
        if (value) {
          this.dialogInstance.open(); // Because the office ui fabric js don't support on_close or on_open event in dialog
          // component, So I have to write some hacking code to change the visible status when
          // click the overlay. Otherwise the visible status can't change, when click the overlay
          // to close the dialog.

          this.bindOverlayCloseEvent();
        } else if (this.isOpen()) {
          // Avoid to destroy overlay element twice, and get errors, so determine if the dialog
          // was opened before close it.
          this.dialogInstance.close();
        }
      },
      bindOverlayCloseEvent: function bindOverlayCloseEvent() {
        var _this = this;

        if (this.dialogInstance._overlay) {
          var overlayElement = this.dialogInstance._overlay.overlayElement;

          var closeOverlay = function closeOverlay() {
            overlayElement.removeEventListener('click', closeOverlay);

            _this.$emit('input', false);
          };

          overlayElement.addEventListener('click', closeOverlay);
        }
      },
      isOpen: function isOpen() {
        // When the dialog is shown, the dialog element add a class name of 'is-open',
        // So use this to determine the dialog if was opened.
        return this.$refs.dialog.classList.contains('is-open');
      },
      closeDialog: function closeDialog(event) {
        this.$emit('input', false); // Because the original close button element have the click event to close the dialog,
        // when I fire the click event, the original click event function will fire behind it,
        // So stop the original click event, when I fire the click event.

        event.stopImmediatePropagation();
      }
    }
  };

  /* script */
  const __vue_script__$i = script$i;

  /* template */
  var __vue_render__$a = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{ref:"dialog",staticClass:"ms-Dialog",class:_vm.dialogClass},[(_vm.type == 'close')?_c('button',{staticClass:"ms-Dialog-button ms-Dialog-buttonClose",on:{"click":_vm.closeDialog}},[_c('i',{staticClass:"ms-Icon ms-Icon--Cancel"})]):_vm._e(),_vm._v(" "),_c('div',{staticClass:"ms-Dialog-title"},[_vm._v(_vm._s(_vm.title))]),_vm._v(" "),_c('div',{staticClass:"ms-Dialog-content"},[_c('p',{staticClass:"ms-Dialog-subText"},[_vm._v(_vm._s(_vm.subText))]),_vm._v(" "),_vm._t("default")],2),_vm._v(" "),_c('div',{staticClass:"ms-Dialog-actions"},[_vm._t("actions")],2)])};
  var __vue_staticRenderFns__$a = [];

    /* style */
    const __vue_inject_styles__$i = undefined;
    /* scoped */
    const __vue_scope_id__$i = undefined;
    /* module identifier */
    const __vue_module_identifier__$i = undefined;
    /* functional template */
    const __vue_is_functional_template__$i = false;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var dialog = normalizeComponent(
      { render: __vue_render__$a, staticRenderFns: __vue_staticRenderFns__$a },
      __vue_inject_styles__$i,
      __vue_script__$i,
      __vue_scope_id__$i,
      __vue_is_functional_template__$i,
      __vue_module_identifier__$i,
      false,
      undefined,
      undefined,
      undefined
    );

  var Overlay = function () {
    function Overlay(overlayElement) {
      if (overlayElement) {
        this.overlayElement = overlayElement;
      } else {
        var overlayContainer = document.createElement("div");
        overlayContainer.setAttribute("class", "ms-Overlay");
        this.overlayElement = overlayContainer;
      }

      this.overlayElement.addEventListener("click", this.hide.bind(this), false);
    }

    Overlay.prototype.remove = function () {
      this.overlayElement.parentElement.removeChild(this.overlayElement);
    };

    Overlay.prototype.show = function () {
      this.overlayElement.classList.add("is-visible");
      document.body.classList.add("ms-u-overflowHidden");
    };

    Overlay.prototype.hide = function () {
      this.overlayElement.classList.remove("is-visible");
      document.body.classList.remove("ms-u-overflowHidden");
    };

    return Overlay;
  }();

  var Dialog = function () {
    function Dialog(dialog) {
      this._dialog = dialog;
      this._closeButtonElement = this._dialog.querySelector(".ms-Dialog-buttonClose");
      this._actionButtonElements = this._dialog.querySelectorAll(".ms-Dialog-action");

      if (this._closeButtonElement) {
        this._closeButtonElement.addEventListener("click", this.close.bind(this), false);
      }

      for (var i = 0; i < this._actionButtonElements.length; i++) {
        this._actionButtonElements[i].addEventListener("click", this.close.bind(this), false);
      }
    }

    Dialog.prototype.close = function () {
      this._overlay.remove();

      this._dialog.classList.remove("is-open");

      document.body.classList.remove("ms-u-overflowHidden");

      this._overlay.overlayElement.removeEventListener("click", this.close.bind(this));
    };

    Dialog.prototype.open = function () {
      this._dialog.classList.add("is-open");

      this._overlay = new Overlay();

      if (!this._dialog.classList.contains("ms-Dialog--blocking")) {
        this._overlay.overlayElement.addEventListener("click", this.close.bind(this), false);

        this._overlay.show();

        document.body.classList.add("ms-u-overflowHidden");
      }

      this._dialog.parentElement.appendChild(this._overlay.overlayElement);
    };

    return Dialog;
  }();

  var script$j = {
    loadStyles: loadThemedStyles.loadStyles,
    beforeMount: function beforeMount() {
      this.$fabric = {
        Dialog: Dialog
      };
    },
    props: {
      useDarkOverlay: Boolean
    },
    methods: {
      ensureScopeIdForChilds: function ensureScopeIdForChilds() {
        if (this.dialogInstance && this.dialogInstance._overlay && this.dialogInstance._overlay.overlayElement) {
          this.dialogInstance._overlay.overlayElement.setAttribute(this.$options._scopeId, "");

          if (this.useDarkOverlay) this.dialogInstance._overlay.overlayElement.className += " ms-Overlay--dark";
        }
      },
      ensureOverlayIsClosed: function ensureOverlayIsClosed() {
        if (this.dialogInstance && this.dialogInstance._overlay && this.dialogInstance._overlay.overlayElement.parentElement) this.dialogInstance._overlay.remove();
      }
    },
    mounted: function mounted() {
      this.$nextTick(function () {
        this.ensureScopeIdForChilds();
      });
    },
    watch: {
      value: function value(newVal) {
        this.ensureScopeIdForChilds();
        if (!newVal) this.ensureOverlayIsClosed();
      }
    },
    beforeDestroy: function beforeDestroy() {
      this.ensureOverlayIsClosed();
    },
    extends: dialog
  };

  /* script */
  const __vue_script__$j = script$j;

  /* template */

    /* style */
    const __vue_inject_styles__$j = function (inject) {
      if (!inject) return
      inject("data-v-78142cce_0", { source: "@charset \"UTF-8\";.ms-Dialog[data-v-78142cce]{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;box-shadow:0 0 5px 0 rgba(0,0,0,.4);background-color:\"[theme:white, default: #ffffff]\";display:none;height:auto;min-width:220px;max-width:340px;padding:28px 24px;z-index:10;position:fixed;transform:translate(-50%,-50%);left:50%;top:50%}.ms-Dialog.is-open[data-v-78142cce]{display:block}.ms-Dialog-title[data-v-78142cce]{font-size:21px;font-weight:100;margin-bottom:24px}.ms-Dialog-content[data-v-78142cce]{position:relative}.ms-Dialog-subText[data-v-78142cce]{color:\"[theme:neutralPrimary, default: #333333]\";font-size:12px;font-weight:300;line-height:1.5}.ms-Dialog-actions[data-v-78142cce]{margin-top:24px;text-align:right}.ms-Dialog--multiline .ms-Dialog-title[data-v-78142cce]{font-size:28px}.ms-Dialog.ms-Dialog--lgHeader .ms-Dialog-title[data-v-78142cce]{background-color:\"[theme:themePrimary, default: #0078d7]\";color:\"[theme:white, default: #ffffff]\";font-size:28px;font-weight:100;padding:28px 24px;margin-top:-28px;margin-left:-24px;margin-right:-24px}.ms-Dialog-buttonClose[data-v-78142cce]{background:0 0;border:0;cursor:pointer;margin:0;padding:4px;position:absolute;right:12px;top:12px;z-index:10}.ms-Dialog-buttonClose .ms-Icon.ms-Icon--Cancel[data-v-78142cce]{color:\"[theme:neutralSecondary, default: #666666]\";font-size:16px}.ms-Button.ms-Button--compound[data-v-78142cce]:not(:last-child){margin-bottom:20px}.ms-Dialog.ms-Dialog--close:not(.ms-Dialog--lgHeader) .ms-Dialog-title[data-v-78142cce]{margin-right:20px}.ms-Dialog.ms-Dialog--close:not(.ms-Dialog--lgHeader) .ms-Dialog-button.ms-Dialog-buttonClose[data-v-78142cce]{display:block}@media (min-width:480px){.ms-Dialog-main[data-v-78142cce]{width:auto;min-width:288px;max-width:340px}}.ms-Overlay[data-v-78142cce]{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;background-color:\"[theme:whiteTranslucent40, default: rgba(255,255,255,.4)]\";position:fixed;bottom:0;left:0;right:0;top:0;z-index:0;display:none}.ms-Overlay.is-visible[data-v-78142cce]{display:block}.ms-Overlay--dark[data-v-78142cce]{background-color:\"[theme:blackTranslucent40, default: rgba(0,0,0,.4)]\"}.ms-u-overflowHidden[data-v-78142cce]{overflow:hidden}@font-face{font-family:FabricMDL2Icons-a13498cf;src:url(https://spoprod-a.akamaihd.net/files/fabric/assets/icons/fabric-icons-a13498cf.woff) format(\"woff\")}.ms-Icon[data-v-78142cce]{display:inline-block;font-style:normal;font-weight:400}.ms-Icon.ms-Icon--Cancel[data-v-78142cce]::before{font-family:FabricMDL2Icons-a13498cf;content:\"\"}", map: undefined, media: undefined });

    };
    /* scoped */
    const __vue_scope_id__$j = "data-v-78142cce";
    /* module identifier */
    const __vue_module_identifier__$j = undefined;
    /* functional template */
    const __vue_is_functional_template__$j = undefined;
    /* style inject */
    const __vue_create_injector__$8 = function(context){ 
                  return function(scopeId, data)
                  {
                      if(window['wizstyle-'+scopeId])
                          return;
                      if(__vue_script__$j.loadStyles)
                          __vue_script__$j.loadStyles(data.source);
                      window['wizstyle-'+scopeId]=true;
                  }
              };
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var uiDialog = normalizeComponent(
      {},
      __vue_inject_styles__$j,
      __vue_script__$j,
      __vue_scope_id__$j,
      __vue_is_functional_template__$j,
      __vue_module_identifier__$j,
      false,
      __vue_create_injector__$8,
      undefined,
      undefined
    );

  //
  var script$k = {
    name: 'ou-dropdown',
    mixins: [disabled, eventHub],
    props: {
      label: String,
      value: [String, Number],
      placeholder: {
        type: String,
        default: 'Please select'
      }
    },
    watch: {
      value: function value() {
        this.setSelectedItem();
      }
    },
    created: function created() {
      this.eventHub.$on('setSelectedStatus', this.setSelectedStatus);
    },
    beforeDestroy: function beforeDestroy() {
      this.eventHub.$off('setSelectedStatus', this.setSelectedStatus);
    },
    mounted: function mounted() {
      new this.$fabric.Dropdown(this.$refs.dropdown);
      this.setDropdownTitle(this.placeholder);
      this.setSelectedItem();
    },
    methods: {
      setDropdownTitle: function setDropdownTitle(title) {
        this.$refs.dropdown.querySelector('.ms-Dropdown-title').textContent = title;
      },
      // Because the office ui js dropdown component don't have selected class to set
      // selected dropdown item, So write some hack code to set dropdown item selected.
      // Maybe next version of office ui js will fix this problem, So this code sould be
      // rewrite.
      setSelectedItem: function setSelectedItem() {
        this.eventHub.$emit('setSelectedItem', this.value);
      },
      setSelectedStatus: function setSelectedStatus(content) {
        var _this = this;

        this.$refs.dropdown.querySelectorAll('.ms-Dropdown-item').forEach(function (item) {
          if (item.textContent.trim() == content.trim()) {
            item.classList.add('is-selected');

            _this.setDropdownTitle(content);
          } else {
            item.classList.remove('is-selected');
          }
        });
      },
      getCurrentSelected: function getCurrentSelected() {
        var dropdownSelect = this.$refs.dropdownSelect;
        this.$emit('input', dropdownSelect.options[dropdownSelect.selectedIndex].value);
      }
    }
  };

  /* script */
  const __vue_script__$k = script$k;

  /* template */
  var __vue_render__$b = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{ref:"dropdown",staticClass:"ms-Dropdown",class:{ 'is-disabled': _vm.disabled }},[(_vm.label)?_c('label',{staticClass:"ms-Label"},[_vm._v(_vm._s(_vm.label))]):_vm._e(),_vm._v(" "),_c('i',{staticClass:"ms-Dropdown-caretDown ms-Icon ms-Icon--ChevronDown"}),_vm._v(" "),_c('select',{ref:"dropdownSelect",staticClass:"ms-Dropdown-select",on:{"change":_vm.getCurrentSelected}},[_vm._t("default")],2)])};
  var __vue_staticRenderFns__$b = [];

    /* style */
    const __vue_inject_styles__$k = undefined;
    /* scoped */
    const __vue_scope_id__$k = undefined;
    /* module identifier */
    const __vue_module_identifier__$k = undefined;
    /* functional template */
    const __vue_is_functional_template__$k = false;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var Dropdown = normalizeComponent(
      { render: __vue_render__$b, staticRenderFns: __vue_staticRenderFns__$b },
      __vue_inject_styles__$k,
      __vue_script__$k,
      __vue_scope_id__$k,
      __vue_is_functional_template__$k,
      __vue_module_identifier__$k,
      false,
      undefined,
      undefined,
      undefined
    );

  var PANEL_HOST_CLASS = "ms-PanelHost";

  var PanelHost = function () {
    function PanelHost(layer, callBack) {
      this._layer = layer;
      this._callBack = callBack;

      this._createElements();

      this._renderElements();
    }

    PanelHost.prototype.dismiss = function () {
      this.overlay.hide();
      document.body.removeChild(this.panelHost);
    };

    PanelHost.prototype.update = function (layer, callBack) {
      this.panelHost.replaceChild(layer, this._layer);

      if (callBack) {
        callBack();
      }
    };

    PanelHost.prototype._renderElements = function () {
      document.body.appendChild(this.panelHost);

      if (this._callBack) {
        this._callBack(this._layer);
      }
    };

    PanelHost.prototype._createElements = function () {
      this.panelHost = document.createElement("div");
      this.panelHost.classList.add(PANEL_HOST_CLASS);
      this.panelHost.appendChild(this._layer);
      this.overlay = new Overlay(this._overlayContainer);
      this.overlay.show();
      this.panelHost.appendChild(this.overlay.overlayElement);
    };

    return PanelHost;
  }();

  var ANIMATE_IN_STATE = "animate-in";
  var ANIMATE_OUT_STATE = "animate-out";
  var ANIMATION_END = 400;

  var Panel = function () {
    function Panel(panel, direction, animateOverlay) {
      this._panel = panel;
      this._direction = direction || "right";
      this._animateOverlay = animateOverlay || true;
      this.panelHost = new PanelHost(this._panel, this._animateInPanel);
      this._closeButton = this._panel.querySelector(".ms-PanelAction-close");
      this._clickHandler = this.dismiss.bind(this, null);

      this._setEvents();

      document.body.setAttribute("style", "height: 100%; overflow: hidden;");
    }

    Panel.prototype.dismiss = function (callBack) {
      var _this = this;

      this._panel.classList.add(ANIMATE_OUT_STATE);

      setTimeout(function () {
        _this._panel.classList.remove(ANIMATE_OUT_STATE);

        _this._panel.classList.remove("is-open");

        _this.panelHost.dismiss();

        if (callBack) {
          callBack();
        }

        document.body.setAttribute("style", "");
      }, ANIMATION_END);

      if (this._closeButton !== null) {
        this._closeButton.removeEventListener("click", this._clickHandler);
      }
    };

    Panel.prototype._setEvents = function () {
      this.panelHost.overlay.overlayElement.addEventListener("click", this._clickHandler);

      if (this._closeButton !== null) {
        this._closeButton.addEventListener("click", this._clickHandler);
      }
    };

    Panel.prototype._animateInPanel = function (layer) {
      layer.classList.add(ANIMATE_IN_STATE);
      layer.classList.add("is-open");
      setTimeout(function () {
        layer.classList.remove(ANIMATE_IN_STATE);
      }, ANIMATION_END);
    };

    return Panel;
  }();

  var DROPDOWN_CLASS = "ms-Dropdown";
  var DROPDOWN_TITLE_CLASS = "ms-Dropdown-title";
  var DROPDOWN_LABEL_HELPER = "ms-Dropdown-truncator";
  var DROPDOWN_ITEMS_CLASS = "ms-Dropdown-items";
  var DROPDOWN_ITEM_CLASS = "ms-Dropdown-item";
  var DROPDOWN_SELECT_CLASS_SELECTOR = ".ms-Dropdown-select";
  var PANEL_CLASS = "ms-Panel";
  var IS_OPEN_CLASS = "is-open";
  var IS_DISABLED_CLASS = "is-disabled";
  var IS_SELECTED_CLASS = "is-selected";
  var ANIMATE_IN_CLASS = "animate-in";
  var SMALL_MAX_WIDTH = 479;

  var Dropdown$1 = function () {
    function Dropdown(container) {
      this._container = container;
      this._dropdownLabelHelper = document.createElement("span");

      this._dropdownLabelHelper.classList.add(DROPDOWN_LABEL_HELPER);

      this._dropdownLabelHelper.classList.add(DROPDOWN_TITLE_CLASS);

      this._newDropdownLabel = document.createElement("span");

      this._newDropdownLabel.classList.add(DROPDOWN_TITLE_CLASS);

      this._newDropdown = document.createElement("ul");

      this._newDropdown.classList.add(DROPDOWN_ITEMS_CLASS);

      this._dropdownItems = [];
      this._originalDropdown = container.querySelector(DROPDOWN_SELECT_CLASS_SELECTOR);

      var _originalOptions = this._originalDropdown.querySelectorAll("option");

      this._onCloseDropdown = this._onCloseDropdown.bind(this);
      this._onItemSelection = this._onItemSelection.bind(this);
      this._onOpenDropdown = this._onOpenDropdown.bind(this);

      for (var i = 0; i < _originalOptions.length; ++i) {
        var option = _originalOptions[i];

        if (option.selected) {
          this._newDropdownLabel.innerHTML = option.text;
        }

        var newItem = document.createElement("li");
        newItem.classList.add(DROPDOWN_ITEM_CLASS);

        if (option.disabled) {
          newItem.classList.add(IS_DISABLED_CLASS);
        }

        if (option.selected) {
          newItem.classList.add(IS_SELECTED_CLASS);
        }

        newItem.innerHTML = option.text;
        newItem.addEventListener("click", this._onItemSelection);

        this._newDropdown.appendChild(newItem);

        this._dropdownItems.push({
          oldOption: option,
          newItem: newItem
        });
      }

      container.appendChild(this._newDropdownLabel);
      container.appendChild(this._newDropdown);
      container.appendChild(this._dropdownLabelHelper);

      this._newDropdownLabel.addEventListener("click", this._onOpenDropdown);

      this._checkTruncation();

      this._setWindowEvent();
    }

    Dropdown.prototype._setWindowEvent = function () {
      var _this = this;

      window.addEventListener("resize", function () {
        _this._doResize();

        _this._checkTruncation();
      }, false);
    };

    Dropdown.prototype._checkTruncation = function () {
      var selected = this._newDropdown.querySelector("." + IS_SELECTED_CLASS);

      var origText = selected ? selected.textContent : this._newDropdown.querySelectorAll("." + DROPDOWN_ITEM_CLASS)[0].textContent;
      this._dropdownLabelHelper.textContent = origText;

      if (this._dropdownLabelHelper.offsetHeight > this._newDropdownLabel.offsetHeight) {
        var i = 0;
        var ellipsis = "...";
        var newText = void 0;

        do {
          i--;
          newText = origText.slice(0, i);
          this._dropdownLabelHelper.textContent = newText + ellipsis;
        } while (this._dropdownLabelHelper.offsetHeight > this._newDropdownLabel.offsetHeight);
      }

      this._newDropdownLabel.textContent = this._dropdownLabelHelper.textContent;
    };

    Dropdown.prototype._getScreenSize = function () {
      var w = window;
      var wSize = {
        x: 0,
        y: 0
      };
      var d = document,
          e = d.documentElement,
          g = d.getElementsByTagName("body")[0];
      wSize.x = w.innerWidth || e.clientWidth || g.clientWidth;
      wSize.y = w.innerHeight || e.clientHeight || g.clientHeight;
      return wSize;
    };

    Dropdown.prototype._doResize = function () {
      var isOpen = this._container.classList.contains(IS_OPEN_CLASS);

      if (!isOpen) {
        return;
      }

      var screenSize = this._getScreenSize().x;

      if (screenSize <= SMALL_MAX_WIDTH) {
        this._openDropdownAsPanel();
      } else {
        this._removeDropdownAsPanel();
      }
    };

    Dropdown.prototype._openDropdownAsPanel = function () {
      if (this._panel === undefined) {
        this._panelContainer = document.createElement("div");

        this._panelContainer.classList.add(PANEL_CLASS);

        this._panelContainer.classList.add(DROPDOWN_CLASS);

        this._panelContainer.classList.add(IS_OPEN_CLASS);

        this._panelContainer.classList.add(ANIMATE_IN_CLASS);

        this._panelContainer.appendChild(this._newDropdown);

        this._panel = new Panel(this._panelContainer);
      }
    };

    Dropdown.prototype._removeDropdownAsPanel = function (evt) {
      var _this = this;

      if (this._panel !== undefined) {
        if (evt && evt.target === this._panel.panelHost.overlay.overlayElement) {
          this._container.appendChild(this._newDropdown);
        } else {
          this._panel.dismiss(function () {
            _this._container.appendChild(_this._newDropdown);
          });
        }

        this._panel = undefined;
      }
    };

    Dropdown.prototype._onOpenDropdown = function (evt) {
      var isDisabled = this._container.classList.contains(IS_DISABLED_CLASS);

      var isOpen = this._container.classList.contains(IS_OPEN_CLASS);

      if (!isDisabled && !isOpen) {
        evt.stopPropagation();

        this._closeOtherDropdowns();

        this._container.classList.add(IS_OPEN_CLASS);

        document.addEventListener("click", this._onCloseDropdown);

        var screenSize = this._getScreenSize().x;

        if (screenSize <= SMALL_MAX_WIDTH) {
          this._openDropdownAsPanel();
        }
      }
    };

    Dropdown.prototype._closeOtherDropdowns = function () {
      var dropdowns = document.querySelectorAll("." + DROPDOWN_CLASS + "." + IS_OPEN_CLASS);

      for (var i = 0; i < dropdowns.length; i++) {
        dropdowns[i].classList.remove(IS_OPEN_CLASS);
      }
    };

    Dropdown.prototype._onCloseDropdown = function (evt) {
      this._removeDropdownAsPanel(evt);

      this._container.classList.remove(IS_OPEN_CLASS);

      document.removeEventListener("click", this._onCloseDropdown);
    };

    Dropdown.prototype._onItemSelection = function (evt) {
      var item = evt.target;

      var isDropdownDisabled = this._container.classList.contains(IS_DISABLED_CLASS);

      var isOptionDisabled = item.classList.contains(IS_DISABLED_CLASS);

      if (!isDropdownDisabled && !isOptionDisabled) {
        for (var i = 0; i < this._dropdownItems.length; ++i) {
          if (this._dropdownItems[i].newItem === item) {
            this._dropdownItems[i].newItem.classList.add(IS_SELECTED_CLASS);

            this._dropdownItems[i].oldOption.selected = true;
          } else {
            this._dropdownItems[i].newItem.classList.remove(IS_SELECTED_CLASS);

            this._dropdownItems[i].oldOption.selected = false;
          }
        }

        this._newDropdownLabel.innerHTML = item.textContent;

        this._checkTruncation();

        var changeEvent = document.createEvent("HTMLEvents");
        changeEvent.initEvent("change", false, true);

        this._originalDropdown.dispatchEvent(changeEvent);
      }
    };

    return Dropdown;
  }();

  var script$l = {
    loadStyles: loadThemedStyles.loadStyles,
    beforeMount: function beforeMount() {
      this.$fabric = {
        Dropdown: Dropdown$1
      };
    },
    methods: {
      setSelectedStatus: function setSelectedStatus(content) {
        var this$1 = this;
        Array.prototype.forEach.call(this.$refs.dropdown.querySelectorAll('.ms-Dropdown-item'), function (item) {
          if (item.textContent.trim() == content.trim()) {
            item.classList.add('is-selected');
            this$1.setDropdownTitle(content);
          } else {
            item.classList.remove('is-selected');
          }
        });
      }
    },
    mounted: function mounted() {
      var _this = this;

      var childs = this.$refs.dropdown.querySelectorAll(":not([" + this.$options._scopeId + "])"); //IE vs. Array.From vs. querySelectorAll = no work >.<
      //Array.prototype.slice, does the trick instead 

      Array.prototype.slice.call(childs).map(function (c) {
        return c.setAttribute(_this.$options._scopeId, "");
      }); // Array.from(childs).map(c=>c.setAttribute(this.$options._scopeId, ""));
    },
    extends: Dropdown
  };

  /* script */
  const __vue_script__$l = script$l;

  /* template */

    /* style */
    const __vue_inject_styles__$l = function (inject) {
      if (!inject) return
      inject("data-v-133f0ced_0", { source: "@charset \"UTF-8\";.ms-Dropdown[data-v-133f0ced]{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;box-sizing:border-box;margin:0;padding:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;color:\"[theme:neutralPrimary, default: #333333]\";font-size:14px;font-weight:400;margin-bottom:10px;position:relative;outline:0}.ms-Dropdown:active .ms-Dropdown-caretDown[data-v-133f0ced],.ms-Dropdown:active .ms-Dropdown-title[data-v-133f0ced],.ms-Dropdown:focus .ms-Dropdown-caretDown[data-v-133f0ced],.ms-Dropdown:focus .ms-Dropdown-title[data-v-133f0ced],.ms-Dropdown:hover .ms-Dropdown-caretDown[data-v-133f0ced],.ms-Dropdown:hover .ms-Dropdown-title[data-v-133f0ced]{color:\"[theme:black, default: #000000]\"}.ms-Dropdown:active .ms-Dropdown-title[data-v-133f0ced],.ms-Dropdown:hover .ms-Dropdown-title[data-v-133f0ced]{border-color:\"[theme:neutralSecondaryAlt, default: #767676]\"}.ms-Dropdown:focus .ms-Dropdown-title[data-v-133f0ced]{border-color:\"[theme:themePrimary, default: #0078d7]\"}.ms-Dropdown .ms-Label[data-v-133f0ced]{display:inline-block;margin-bottom:8px}.ms-Dropdown.is-disabled .ms-Dropdown-title[data-v-133f0ced]{background-color:\"[theme:neutralLighter, default: #f4f4f4]\";border-color:\"[theme:neutralLighter, default: #f4f4f4]\";color:\"[theme:neutralTertiary, default: #a6a6a6]\";cursor:default}@media screen and (-ms-high-contrast:active){.ms-Dropdown.is-disabled .ms-Dropdown-title[data-v-133f0ced]{border-color:#0f0;color:#0f0}}@media screen and (-ms-high-contrast:black-on-white){.ms-Dropdown.is-disabled .ms-Dropdown-title[data-v-133f0ced]{border-color:#600000;color:#600000}}.ms-Dropdown.is-disabled .ms-Dropdown-caretDown[data-v-133f0ced]{color:\"[theme:neutralTertiary, default: #a6a6a6]\"}@media screen and (-ms-high-contrast:active){.ms-Dropdown.is-disabled .ms-Dropdown-caretDown[data-v-133f0ced]{color:#0f0}}@media screen and (-ms-high-contrast:black-on-white){.ms-Dropdown.is-disabled .ms-Dropdown-caretDown[data-v-133f0ced]{color:#600000}}.ms-Dropdown.is-open .ms-Dropdown-items[data-v-133f0ced]{display:block;position:absolute}.ms-Panel .ms-Dropdown-items[data-v-133f0ced]{box-shadow:none;overflow-y:auto;padding-top:4px;max-height:100%}.ms-Panel .ms-Dropdown-items .ms-Dropdown-item[data-v-133f0ced]{padding:7px 16px;overflow:hidden;text-overflow:ellipsis}.ms-Panel .ms-Dropdown-items[data-v-133f0ced]::before{content:none;border:0}.ms-Dropdown-select[data-v-133f0ced]{display:none}.ms-Dropdown-caretDown[data-v-133f0ced]{color:\"[theme:neutralDark, default: #212121]\";font-size:12px;position:absolute;right:13px;bottom:9px;z-index:1;pointer-events:none}.ms-Dropdown-title[data-v-133f0ced]{box-sizing:border-box;margin:0;padding:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;background:\"[theme:white, default: #ffffff]\";border:1px solid \"[theme:neutralTertiaryAlt, default: #c8c8c8]\";cursor:pointer;display:block;height:32px;padding:5px 32px 0 10px;position:relative;overflow:hidden}.ms-Dropdown-title.ms-Dropdown-truncator[data-v-133f0ced]{height:auto;display:block;position:absolute;visibility:hidden}.ms-Dropdown-items[data-v-133f0ced]{box-sizing:border-box;margin:0;padding:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;box-shadow:0 0 5px 0 rgba(0,0,0,.4);background-color:\"[theme:white, default: #ffffff]\";display:none;list-style-type:none;position:absolute;width:100%;max-height:200px;z-index:400;overflow-y:scroll;top:auto;right:auto;bottom:auto;left:auto;max-width:100%}.ms-Dropdown-items[data-v-133f0ced]::before{content:\"\";position:absolute;z-index:-1;top:0;left:0;right:0;bottom:0;border:1px solid \"[theme:neutralLight, default: #eaeaea]\"}@media screen and (-ms-high-contrast:active){.ms-Dropdown-items[data-v-133f0ced]{border:1px solid \"[theme:white, default: #ffffff]\"}}@media screen and (-ms-high-contrast:black-on-white){.ms-Dropdown-items[data-v-133f0ced]{border:1px solid \"[theme:black, default: #000000]\"}}.ms-Dropdown-item[data-v-133f0ced]{box-sizing:border-box;cursor:pointer;display:block;height:36px;padding:7px 10px;position:relative;border:1px solid transparent;white-space:nowrap;overflow:hidden;text-overflow:ellipsis}@media screen and (-ms-high-contrast:active){.ms-Dropdown-item[data-v-133f0ced]{border-color:\"[theme:black, default: #000000]\"}}@media screen and (-ms-high-contrast:black-on-white){.ms-Dropdown-item[data-v-133f0ced]{border-color:\"[theme:white, default: #ffffff]\"}}.ms-Dropdown-item[data-v-133f0ced]:hover{background-color:\"[theme:neutralLight, default: #eaeaea]\";color:\"[theme:black, default: #000000]\"}@media screen and (-ms-high-contrast:active){.ms-Dropdown-item[data-v-133f0ced]:hover{background-color:#1aebff;border-color:#1aebff;color:\"[theme:black, default: #000000]\"}.ms-Dropdown-item[data-v-133f0ced]:hover:focus{border-color:\"[theme:black, default: #000000]\"}}@media screen and (-ms-high-contrast:black-on-white){.ms-Dropdown-item[data-v-133f0ced]:hover{background-color:#37006e;border-color:#37006e;color:\"[theme:white, default: #ffffff]\"}}.ms-Dropdown-item[data-v-133f0ced]:active{background-color:\"[theme:neutralLight, default: #eaeaea]\";border-color:\"[theme:themePrimary, default: #0078d7]\";color:\"[theme:black, default: #000000]\"}.ms-Dropdown-item.is-disabled[data-v-133f0ced]{background:\"[theme:white, default: #ffffff]\";color:\"[theme:neutralTertiary, default: #a6a6a6]\";cursor:default}.ms-Dropdown-item.is-selected[data-v-133f0ced],.ms-Dropdown-item.ms-Dropdown-item--selected[data-v-133f0ced]{background-color:\"[theme:themeLight, default: #c7e0f4]\";color:\"[theme:black, default: #000000]\"}.ms-Dropdown-item.is-selected[data-v-133f0ced]:hover,.ms-Dropdown-item.ms-Dropdown-item--selected[data-v-133f0ced]:hover{background-color:\"[theme:themeLight, default: #c7e0f4]\"}@media screen and (-ms-high-contrast:active){.ms-Dropdown-item.is-selected[data-v-133f0ced],.ms-Dropdown-item.ms-Dropdown-item--selected[data-v-133f0ced]{background-color:#1aebff;border-color:#1aebff;color:\"[theme:black, default: #000000]\"}.ms-Dropdown-item.is-selected[data-v-133f0ced]:focus,.ms-Dropdown-item.ms-Dropdown-item--selected[data-v-133f0ced]:focus{border-color:\"[theme:black, default: #000000]\"}}@media screen and (-ms-high-contrast:black-on-white){.ms-Dropdown-item.is-selected[data-v-133f0ced],.ms-Dropdown-item.ms-Dropdown-item--selected[data-v-133f0ced]{background-color:#37006e;border-color:#37006e;color:\"[theme:white, default: #ffffff]\"}}@font-face{font-family:FabricMDL2Icons-a13498cf;src:url(https://spoprod-a.akamaihd.net/files/fabric/assets/icons/fabric-icons-a13498cf.woff) format(\"woff\")}.ms-Icon[data-v-133f0ced]{display:inline-block;font-style:normal;font-weight:400}.ms-Icon.ms-Icon--ChevronDown[data-v-133f0ced]::before{font-family:FabricMDL2Icons-a13498cf;content:\"\"}.ms-Panel .ms-Dropdown-items[data-v-133f0ced]{max-height:200px;box-shadow:0 0 5px 0 rgba(0,0,0,.4);overflow-y:scroll;padding-top:0}", map: undefined, media: undefined });

    };
    /* scoped */
    const __vue_scope_id__$l = "data-v-133f0ced";
    /* module identifier */
    const __vue_module_identifier__$l = undefined;
    /* functional template */
    const __vue_is_functional_template__$l = undefined;
    /* style inject */
    const __vue_create_injector__$9 = function(context){ 
                  return function(scopeId, data)
                  {
                      if(window['wizstyle-'+scopeId])
                          return;
                      if(__vue_script__$l.loadStyles)
                          __vue_script__$l.loadStyles(data.source);
                      window['wizstyle-'+scopeId]=true;
                  }
              };
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var uiDropdown = normalizeComponent(
      {},
      __vue_inject_styles__$l,
      __vue_script__$l,
      __vue_scope_id__$l,
      __vue_is_functional_template__$l,
      __vue_module_identifier__$l,
      false,
      __vue_create_injector__$9,
      undefined,
      undefined
    );

  //
  //
  //
  var script$m = {
    name: 'ou-dropdown-item',
    inject: ['eventHub'],
    props: {
      value: [String, Number]
    },
    created: function created() {
      this.eventHub.$on('setSelectedItem', this.setSelectedItem);
    },
    beforeDestroy: function beforeDestroy() {
      this.eventHub.$off('setSelectedItem', this.setSelectedItem);
    },
    methods: {
      setSelectedItem: function setSelectedItem(value) {
        if (value === this.value) {
          this.eventHub.$emit('setSelectedStatus', this.$slots.default[0].text);
        }
      }
    }
  };

  /* script */
  const __vue_script__$m = script$m;

  /* template */
  var __vue_render__$c = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('option',{domProps:{"value":_vm.value}},[_vm._t("default")],2)};
  var __vue_staticRenderFns__$c = [];

    /* style */
    const __vue_inject_styles__$m = undefined;
    /* scoped */
    const __vue_scope_id__$m = undefined;
    /* module identifier */
    const __vue_module_identifier__$m = undefined;
    /* functional template */
    const __vue_is_functional_template__$m = false;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var dropdownitem = normalizeComponent(
      { render: __vue_render__$c, staticRenderFns: __vue_staticRenderFns__$c },
      __vue_inject_styles__$m,
      __vue_script__$m,
      __vue_scope_id__$m,
      __vue_is_functional_template__$m,
      __vue_module_identifier__$m,
      false,
      undefined,
      undefined,
      undefined
    );

  var script$n = {
    extends: dropdownitem,
    created: function created() {
      this.$options._scopeId = this.$parent.$options._scopeId;
    }
  };

  /* script */
  const __vue_script__$n = script$n;

  /* template */

    /* style */
    const __vue_inject_styles__$n = undefined;
    /* scoped */
    const __vue_scope_id__$n = undefined;
    /* module identifier */
    const __vue_module_identifier__$n = undefined;
    /* functional template */
    const __vue_is_functional_template__$n = undefined;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var uiDropdownItem = normalizeComponent(
      {},
      __vue_inject_styles__$n,
      __vue_script__$n,
      __vue_scope_id__$n,
      __vue_is_functional_template__$n,
      __vue_module_identifier__$n,
      false,
      undefined,
      undefined,
      undefined
    );

  //
  var script$o = {
    name: 'ou-label',
    mixins: [disabled],
    props: {
      required: {
        type: Boolean,
        default: false
      }
    },
    computed: {
      labelClass: function labelClass() {
        return {
          'is-disabled': this.disabled,
          'is-required': this.required
        };
      }
    }
  };

  /* script */
  const __vue_script__$o = script$o;

  /* template */
  var __vue_render__$d = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('label',{staticClass:"ms-Label",class:_vm.labelClass},[_vm._t("default")],2)};
  var __vue_staticRenderFns__$d = [];

    /* style */
    const __vue_inject_styles__$o = undefined;
    /* scoped */
    const __vue_scope_id__$o = undefined;
    /* module identifier */
    const __vue_module_identifier__$o = undefined;
    /* functional template */
    const __vue_is_functional_template__$o = false;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var label = normalizeComponent(
      { render: __vue_render__$d, staticRenderFns: __vue_staticRenderFns__$d },
      __vue_inject_styles__$o,
      __vue_script__$o,
      __vue_scope_id__$o,
      __vue_is_functional_template__$o,
      __vue_module_identifier__$o,
      false,
      undefined,
      undefined,
      undefined
    );

  var script$p = {
    loadStyles: loadThemedStyles.loadStyles,
    extends: label
  };

  /* script */
  const __vue_script__$p = script$p;

  /* template */

    /* style */
    const __vue_inject_styles__$p = function (inject) {
      if (!inject) return
      inject("data-v-7c3d3d8b_0", { source: ".ms-Label[data-v-7c3d3d8b]{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;box-sizing:border-box;margin:0;padding:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;color:\"[theme:neutralPrimary, default: #333333]\";font-size:12px;font-weight:400;box-sizing:border-box;display:block;padding:5px 0}.ms-Label.is-required[data-v-7c3d3d8b]::after{content:\" *\";color:\"[theme:error, default: #a80000]\"}.ms-Label.is-disabled[data-v-7c3d3d8b]{color:\"[theme:neutralTertiary, default: #a6a6a6]\"}", map: undefined, media: undefined });

    };
    /* scoped */
    const __vue_scope_id__$p = "data-v-7c3d3d8b";
    /* module identifier */
    const __vue_module_identifier__$p = undefined;
    /* functional template */
    const __vue_is_functional_template__$p = undefined;
    /* style inject */
    const __vue_create_injector__$a = function(context){ 
                  return function(scopeId, data)
                  {
                      if(window['wizstyle-'+scopeId])
                          return;
                      if(__vue_script__$p.loadStyles)
                          __vue_script__$p.loadStyles(data.source);
                      window['wizstyle-'+scopeId]=true;
                  }
              };
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var uiLabel = normalizeComponent(
      {},
      __vue_inject_styles__$p,
      __vue_script__$p,
      __vue_scope_id__$p,
      __vue_is_functional_template__$p,
      __vue_module_identifier__$p,
      false,
      __vue_create_injector__$a,
      undefined,
      undefined
    );

  //
  //
  //
  //
  //
  var script$q = {
    name: 'ou-link',
    props: {
      href: String,
      title: String
    },
    methods: {
      clickEvent: function clickEvent() {
        this.$emit('click');
      }
    }
  };

  /* script */
  const __vue_script__$q = script$q;

  /* template */
  var __vue_render__$e = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('a',{staticClass:"ms-Link",attrs:{"href":_vm.href,"title":_vm.title},on:{"click":_vm.clickEvent}},[_vm._t("default")],2)};
  var __vue_staticRenderFns__$e = [];

    /* style */
    const __vue_inject_styles__$q = undefined;
    /* scoped */
    const __vue_scope_id__$q = undefined;
    /* module identifier */
    const __vue_module_identifier__$q = undefined;
    /* functional template */
    const __vue_is_functional_template__$q = false;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var link = normalizeComponent(
      { render: __vue_render__$e, staticRenderFns: __vue_staticRenderFns__$e },
      __vue_inject_styles__$q,
      __vue_script__$q,
      __vue_scope_id__$q,
      __vue_is_functional_template__$q,
      __vue_module_identifier__$q,
      false,
      undefined,
      undefined,
      undefined
    );

  var script$r = {
    loadStyles: loadThemedStyles.loadStyles,
    extends: link
  };

  /* script */
  const __vue_script__$r = script$r;

  /* template */

    /* style */
    const __vue_inject_styles__$r = function (inject) {
      if (!inject) return
      inject("data-v-5f8d8729_0", { source: ".ms-Link[data-v-5f8d8729]{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;font-size:14px;font-weight:400;color:\"[theme:themePrimary, default: #0078d7]\";text-decoration:none;cursor:pointer;outline:0}.ms-Link[data-v-5f8d8729]:focus,.ms-Link[data-v-5f8d8729]:hover{color:\"[theme:themeDarker, default: #004578]\"}.ms-Link[data-v-5f8d8729]:active{color:\"[theme:themePrimary, default: #0078d7]\"}", map: undefined, media: undefined });

    };
    /* scoped */
    const __vue_scope_id__$r = "data-v-5f8d8729";
    /* module identifier */
    const __vue_module_identifier__$r = undefined;
    /* functional template */
    const __vue_is_functional_template__$r = undefined;
    /* style inject */
    const __vue_create_injector__$b = function(context){ 
                  return function(scopeId, data)
                  {
                      if(window['wizstyle-'+scopeId])
                          return;
                      if(__vue_script__$r.loadStyles)
                          __vue_script__$r.loadStyles(data.source);
                      window['wizstyle-'+scopeId]=true;
                  }
              };
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var uiLink = normalizeComponent(
      {},
      __vue_inject_styles__$r,
      __vue_script__$r,
      __vue_scope_id__$r,
      __vue_is_functional_template__$r,
      __vue_module_identifier__$r,
      false,
      __vue_create_injector__$b,
      undefined,
      undefined
    );

  //
  //
  //
  var script$s = {
    name: 'ou-list'
  };

  /* script */
  const __vue_script__$s = script$s;

  /* template */
  var __vue_render__$f = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('ul',{ref:"list",staticClass:"ms-List"},[_vm._t("default")],2)};
  var __vue_staticRenderFns__$f = [];

    /* style */
    const __vue_inject_styles__$s = undefined;
    /* scoped */
    const __vue_scope_id__$s = undefined;
    /* module identifier */
    const __vue_module_identifier__$s = undefined;
    /* functional template */
    const __vue_is_functional_template__$s = false;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var List = normalizeComponent(
      { render: __vue_render__$f, staticRenderFns: __vue_staticRenderFns__$f },
      __vue_inject_styles__$s,
      __vue_script__$s,
      __vue_scope_id__$s,
      __vue_is_functional_template__$s,
      __vue_module_identifier__$s,
      false,
      undefined,
      undefined,
      undefined
    );

  var script$t = {
    loadStyles: loadThemedStyles.loadStyles,
    extends: List
  };

  /* script */
  const __vue_script__$t = script$t;

  /* template */

    /* style */
    const __vue_inject_styles__$t = function (inject) {
      if (!inject) return
      inject("data-v-0dc2df55_0", { source: ".ms-List[data-v-0dc2df55]{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;box-sizing:border-box;margin:0;padding:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;color:\"[theme:neutralPrimary, default: #333333]\";font-size:14px;font-weight:400;list-style-type:none}", map: undefined, media: undefined });

    };
    /* scoped */
    const __vue_scope_id__$t = "data-v-0dc2df55";
    /* module identifier */
    const __vue_module_identifier__$t = undefined;
    /* functional template */
    const __vue_is_functional_template__$t = undefined;
    /* style inject */
    const __vue_create_injector__$c = function(context){ 
                  return function(scopeId, data)
                  {
                      if(window['wizstyle-'+scopeId])
                          return;
                      if(__vue_script__$t.loadStyles)
                          __vue_script__$t.loadStyles(data.source);
                      window['wizstyle-'+scopeId]=true;
                  }
              };
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var uiList = normalizeComponent(
      {},
      __vue_inject_styles__$t,
      __vue_script__$t,
      __vue_scope_id__$t,
      __vue_is_functional_template__$t,
      __vue_module_identifier__$t,
      false,
      __vue_create_injector__$c,
      undefined,
      undefined
    );

  //
  //
  //
  var script$u = {
    name: 'ou-list-actions'
  };

  /* script */
  const __vue_script__$u = script$u;

  /* template */
  var __vue_render__$g = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"ms-ListItem-actions"},[_vm._t("default")],2)};
  var __vue_staticRenderFns__$g = [];

    /* style */
    const __vue_inject_styles__$u = undefined;
    /* scoped */
    const __vue_scope_id__$u = undefined;
    /* module identifier */
    const __vue_module_identifier__$u = undefined;
    /* functional template */
    const __vue_is_functional_template__$u = false;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var ListActions = normalizeComponent(
      { render: __vue_render__$g, staticRenderFns: __vue_staticRenderFns__$g },
      __vue_inject_styles__$u,
      __vue_script__$u,
      __vue_scope_id__$u,
      __vue_is_functional_template__$u,
      __vue_module_identifier__$u,
      false,
      undefined,
      undefined,
      undefined
    );

  var script$v = {
    extends: ListActions,
    created: function created() {
      this.$options._scopeId = this.$parent.$options._scopeId;
    }
  };

  /* script */
  const __vue_script__$v = script$v;

  /* template */

    /* style */
    const __vue_inject_styles__$v = undefined;
    /* scoped */
    const __vue_scope_id__$v = undefined;
    /* module identifier */
    const __vue_module_identifier__$v = undefined;
    /* functional template */
    const __vue_is_functional_template__$v = undefined;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var uiListActions = normalizeComponent(
      {},
      __vue_inject_styles__$v,
      __vue_script__$v,
      __vue_scope_id__$v,
      __vue_is_functional_template__$v,
      __vue_module_identifier__$v,
      false,
      undefined,
      undefined,
      undefined
    );

  //
  var script$w = {
    name: 'ou-list-action-item',
    mixins: [icon],
    methods: {
      clickEvent: function clickEvent() {
        this.$emit('click');
      }
    }
  };

  /* script */
  const __vue_script__$w = script$w;

  /* template */
  var __vue_render__$h = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"ms-ListItem-action",on:{"click":function($event){$event.stopPropagation();return _vm.clickEvent($event)}}},[_c('i',{staticClass:"ms-Icon",class:_vm.iconClass})])};
  var __vue_staticRenderFns__$h = [];

    /* style */
    const __vue_inject_styles__$w = undefined;
    /* scoped */
    const __vue_scope_id__$w = undefined;
    /* module identifier */
    const __vue_module_identifier__$w = undefined;
    /* functional template */
    const __vue_is_functional_template__$w = false;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var ListActionItem = normalizeComponent(
      { render: __vue_render__$h, staticRenderFns: __vue_staticRenderFns__$h },
      __vue_inject_styles__$w,
      __vue_script__$w,
      __vue_scope_id__$w,
      __vue_is_functional_template__$w,
      __vue_module_identifier__$w,
      false,
      undefined,
      undefined,
      undefined
    );

  //
  var script$x = {
    extends: ListActionItem,
    created: function created() {
      this.$options._scopeId = this.$parent.$options._scopeId;
    }
  };

  /* script */
  const __vue_script__$x = script$x;

  /* template */
  var __vue_render__$i = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"ms-ListItem-action",on:{"click":function($event){$event.stopPropagation();return _vm.clickEvent($event)}}},[_vm._t("icon")],2)};
  var __vue_staticRenderFns__$i = [];

    /* style */
    const __vue_inject_styles__$x = undefined;
    /* scoped */
    const __vue_scope_id__$x = undefined;
    /* module identifier */
    const __vue_module_identifier__$x = undefined;
    /* functional template */
    const __vue_is_functional_template__$x = false;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var uiListActionItem = normalizeComponent(
      { render: __vue_render__$i, staticRenderFns: __vue_staticRenderFns__$i },
      __vue_inject_styles__$x,
      __vue_script__$x,
      __vue_scope_id__$x,
      __vue_is_functional_template__$x,
      __vue_module_identifier__$x,
      false,
      undefined,
      undefined,
      undefined
    );

  var script$y = {
    name: 'ou-list-item',
    mixins: [type('image', 'document')],
    props: {
      isUnread: Boolean,
      isSelectable: Boolean,
      isUnseen: Boolean,
      value: Boolean,
      imageSrc: String,
      primaryText: String,
      secondaryText: String,
      tertiaryText: String,
      metaText: String
    },
    computed: {
      listItemClass: function listItemClass() {
        var _ref;

        return _ref = {}, _defineProperty(_ref, "ms-ListItem--".concat(this.type), !!this.type), _defineProperty(_ref, 'is-selectable', this.isSelectable), _defineProperty(_ref, 'is-selected', this.value), _defineProperty(_ref, 'is-unread', this.isUnread), _defineProperty(_ref, 'is-unseen', this.isUnseen), _ref;
      }
    },
    methods: {
      toggle: function toggle() {
        if (this.isSelectable) {
          this.$emit('input', !this.value);
        }
      },
      clickEvent: function clickEvent() {
        this.$emit('click');
      }
    }
  };

  /* script */
  const __vue_script__$y = script$y;

  /* template */
  var __vue_render__$j = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('li',{ref:"listItem",staticClass:"ms-ListItem",class:_vm.listItemClass,on:{"click":_vm.clickEvent}},[(_vm.type == 'image')?_c('img',{staticClass:"ms-ListItem-image",attrs:{"src":_vm.imageSrc}}):_vm._e(),_vm._v(" "),(_vm.primaryText)?_c('span',{staticClass:"ms-ListItem-primaryText"},[_vm._v(_vm._s(_vm.primaryText))]):_vm._e(),_vm._v(" "),(_vm.secondaryText)?_c('span',{staticClass:"ms-ListItem-secondaryText"},[_vm._v(_vm._s(_vm.secondaryText))]):_vm._e(),_vm._v(" "),(_vm.tertiaryText)?_c('span',{staticClass:"ms-ListItem-tertiaryText"},[_vm._v(_vm._s(_vm.tertiaryText))]):_vm._e(),_vm._v(" "),(_vm.metaText)?_c('span',{staticClass:"ms-ListItem-metaText"},[_vm._v(_vm._s(_vm.metaText))]):_vm._e(),_vm._v(" "),(_vm.isSelectable)?_c('div',{staticClass:"ms-ListItem-selectionTarget",on:{"click":function($event){$event.stopPropagation();return _vm.toggle($event)}}}):_vm._e(),_vm._v(" "),_vm._t("default")],2)};
  var __vue_staticRenderFns__$j = [];

    /* style */
    const __vue_inject_styles__$y = undefined;
    /* scoped */
    const __vue_scope_id__$y = undefined;
    /* module identifier */
    const __vue_module_identifier__$y = undefined;
    /* functional template */
    const __vue_is_functional_template__$y = false;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var ListItem = normalizeComponent(
      { render: __vue_render__$j, staticRenderFns: __vue_staticRenderFns__$j },
      __vue_inject_styles__$y,
      __vue_script__$y,
      __vue_scope_id__$y,
      __vue_is_functional_template__$y,
      __vue_module_identifier__$y,
      false,
      undefined,
      undefined,
      undefined
    );

  var script$z = {
    loadStyles: loadThemedStyles.loadStyles,
    extends: ListItem
  };

  /* script */
  const __vue_script__$z = script$z;

  /* template */

    /* style */
    const __vue_inject_styles__$z = function (inject) {
      if (!inject) return
      inject("data-v-29d47ae0_0", { source: "@charset \"UTF-8\";.ms-ListItem[data-v-29d47ae0]{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;box-sizing:border-box;margin:0;padding:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;color:\"[theme:neutralPrimary, default: #333333]\";font-size:14px;font-weight:400;padding:9px 28px 3px;position:relative;display:block}.ms-ListItem[data-v-29d47ae0]::after,.ms-ListItem[data-v-29d47ae0]::before{display:table;content:\"\";line-height:0}.ms-ListItem[data-v-29d47ae0]::after{clear:both}.ms-ListItem-primaryText[data-v-29d47ae0],.ms-ListItem-secondaryText[data-v-29d47ae0],.ms-ListItem-tertiaryText[data-v-29d47ae0]{display:block;overflow:hidden;text-overflow:ellipsis;white-space:nowrap;display:block}.ms-ListItem-primaryText[data-v-29d47ae0]{color:\"[theme:neutralDark, default: #212121]\";font-weight:300;font-size:21px;padding-right:80px;position:relative;top:-4px}.ms-ListItem-secondaryText[data-v-29d47ae0]{color:\"[theme:neutralPrimary, default: #333333]\";font-weight:400;font-size:14px;line-height:25px;position:relative;top:-7px;padding-right:30px}.ms-ListItem-tertiaryText[data-v-29d47ae0]{color:\"[theme:neutralSecondaryAlt, default: #767676]\";font-weight:300;font-size:14px;position:relative;top:-9px;margin-bottom:-4px;padding-right:30px}.ms-ListItem-metaText[data-v-29d47ae0]{color:\"[theme:neutralPrimary, default: #333333]\";font-weight:300;font-size:11px;position:absolute;right:30px;top:39px}.ms-ListItem-image[data-v-29d47ae0]{float:left;height:70px;margin-left:-8px;margin-right:10px;width:70px;background-color:\"[theme:neutralPrimary, default: #333333]\"}.ms-ListItem-selectionTarget[data-v-29d47ae0]{display:none}.ms-ListItem-actions[data-v-29d47ae0]{max-width:80px;position:absolute;right:30px;text-align:right;top:10px}.ms-ListItem-action[data-v-29d47ae0]{color:\"[theme:neutralTertiary, default: #a6a6a6]\";display:inline-block;font-size:15px;position:relative;text-align:center;top:3px;cursor:pointer;height:16px;width:16px}.ms-ListItem-action .ms-Icon[data-v-29d47ae0]{vertical-align:top}.ms-ListItem-action[data-v-29d47ae0]:hover{color:\"[theme:neutralSecondary, default: #666666]\";outline:1px solid transparent}.ms-ListItem.is-unread[data-v-29d47ae0]{border-left:3px solid \"[theme:themePrimary, default: #0078d7]\";padding-left:27px}.ms-ListItem.is-unread .ms-ListItem-metaText[data-v-29d47ae0],.ms-ListItem.is-unread .ms-ListItem-secondaryText[data-v-29d47ae0]{color:\"[theme:themePrimary, default: #0078d7]\";font-weight:600}.ms-ListItem.is-unseen[data-v-29d47ae0]::after{border-right:10px solid transparent;border-top:10px solid \"[theme:themePrimary, default: #0078d7]\";left:0;position:absolute;top:0}.ms-ListItem.is-selectable .ms-ListItem-selectionTarget[data-v-29d47ae0]{display:block;height:20px;left:6px;position:absolute;top:13px;width:20px}.ms-ListItem.is-selectable .ms-ListItem-image[data-v-29d47ae0]{margin-left:0}.ms-ListItem.is-selectable[data-v-29d47ae0]:hover{background-color:\"[theme:neutralLight, default: #eaeaea]\";cursor:pointer;outline:1px solid transparent}.ms-ListItem.is-selectable[data-v-29d47ae0]:hover::before{-moz-osx-font-smoothing:grayscale;-webkit-font-smoothing:antialiased;display:inline-block;font-family:FabricMDL2Icons;font-style:normal;font-weight:400;speak:none;position:absolute;top:14px;left:7px;height:15px;width:15px;border:1px solid \"[theme:neutralSecondaryAlt, default: #767676]\"}.ms-ListItem.is-selected[data-v-29d47ae0]::before{border:1px solid transparent}.ms-ListItem.is-selected[data-v-29d47ae0]::before,.ms-ListItem.is-selected[data-v-29d47ae0]:hover::before{-moz-osx-font-smoothing:grayscale;-webkit-font-smoothing:antialiased;display:inline-block;font-family:FabricMDL2Icons;font-style:normal;font-weight:400;speak:none;content:\"\";font-size:17px;color:\"[theme:neutralSecondaryAlt, default: #767676]\";position:absolute;top:23px;left:7px;border:0}.ms-ListItem.is-selected[data-v-29d47ae0]:hover{background-color:\"[theme:themeLight, default: #c7e0f4]\";outline:1px solid transparent}.ms-ListItem.ms-ListItem--document[data-v-29d47ae0]{padding:0}.ms-ListItem.ms-ListItem--document .ms-ListItem-itemIcon[data-v-29d47ae0]{width:70px;height:70px;float:left;text-align:center}.ms-ListItem.ms-ListItem--document .ms-ListItem-itemIcon .ms-Icon[data-v-29d47ae0]{font-size:38px;line-height:70px;color:\"[theme:neutralSecondary, default: #666666]\"}.ms-ListItem.ms-ListItem--document .ms-ListItem-primaryText[data-v-29d47ae0]{display:block;overflow:hidden;text-overflow:ellipsis;white-space:nowrap;font-size:14px;padding-top:15px;padding-right:0;position:static}.ms-ListItem.ms-ListItem--document .ms-ListItem-secondaryText[data-v-29d47ae0]{display:block;overflow:hidden;text-overflow:ellipsis;white-space:nowrap;color:\"[theme:neutralSecondary, default: #666666]\";font-weight:400;font-size:11px;padding-top:6px}@font-face{font-family:FabricMDL2Icons-a13498cf;src:url(https://spoprod-a.akamaihd.net/files/fabric/assets/icons/fabric-icons-a13498cf.woff) format(\"woff\")}.ms-ListItem.is-selected[data-v-29d47ae0]::before,.ms-ListItem.is-selected[data-v-29d47ae0]:hover::before{display:inline-block;font-style:normal;font-weight:400;font-family:FabricMDL2Icons-a13498cf!important;content:\"\"!important}", map: undefined, media: undefined });

    };
    /* scoped */
    const __vue_scope_id__$z = "data-v-29d47ae0";
    /* module identifier */
    const __vue_module_identifier__$z = undefined;
    /* functional template */
    const __vue_is_functional_template__$z = undefined;
    /* style inject */
    const __vue_create_injector__$d = function(context){ 
                  return function(scopeId, data)
                  {
                      if(window['wizstyle-'+scopeId])
                          return;
                      if(__vue_script__$z.loadStyles)
                          __vue_script__$z.loadStyles(data.source);
                      window['wizstyle-'+scopeId]=true;
                  }
              };
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var uiListItem = normalizeComponent(
      {},
      __vue_inject_styles__$z,
      __vue_script__$z,
      __vue_scope_id__$z,
      __vue_is_functional_template__$z,
      __vue_module_identifier__$z,
      false,
      __vue_create_injector__$d,
      undefined,
      undefined
    );

  var script$A = {
    name: 'ou-message-bar',
    mixins: [type('success', 'error', 'blocked', 'warning', 'severeWarning'), icon],
    computed: {
      messageBarClass: function messageBarClass() {
        return _defineProperty({}, "ms-MessageBar--".concat(this.type), !!this.type);
      }
    }
  };

  /* script */
  const __vue_script__$A = script$A;

  /* template */
  var __vue_render__$k = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"ms-MessageBar",class:_vm.messageBarClass},[_c('div',{staticClass:"ms-MessageBar-content"},[(_vm.icon)?_c('div',{staticClass:"ms-MessageBar-icon"},[_c('i',{staticClass:"ms-Icon",class:_vm.iconClass})]):_vm._e(),_vm._v(" "),_c('div',{staticClass:"ms-MessageBar-text"},[_vm._t("default")],2)])])};
  var __vue_staticRenderFns__$k = [];

    /* style */
    const __vue_inject_styles__$A = undefined;
    /* scoped */
    const __vue_scope_id__$A = undefined;
    /* module identifier */
    const __vue_module_identifier__$A = undefined;
    /* functional template */
    const __vue_is_functional_template__$A = false;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var MessageBar = normalizeComponent(
      { render: __vue_render__$k, staticRenderFns: __vue_staticRenderFns__$k },
      __vue_inject_styles__$A,
      __vue_script__$A,
      __vue_scope_id__$A,
      __vue_is_functional_template__$A,
      __vue_module_identifier__$A,
      false,
      undefined,
      undefined,
      undefined
    );

  //
  var script$B = {
    loadStyles: loadThemedStyles.loadStyles,
    computed: {
      hasIcon: function hasIcon() {
        return !!this.$slots['icon'];
      }
    },
    extends: MessageBar
  };

  /* script */
  const __vue_script__$B = script$B;

  /* template */
  var __vue_render__$l = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"ms-MessageBar",class:_vm.messageBarClass},[_c('div',{staticClass:"ms-MessageBar-content"},[(_vm.hasIcon)?_c('div',{staticClass:"ms-MessageBar-icon"},[_vm._t("icon")],2):_vm._e(),_vm._v(" "),_c('div',{staticClass:"ms-MessageBar-text"},[_vm._t("default")],2)])])};
  var __vue_staticRenderFns__$l = [];

    /* style */
    const __vue_inject_styles__$B = function (inject) {
      if (!inject) return
      inject("data-v-519832b0_0", { source: ".ms-MessageBar[data-v-519832b0]{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;padding:8px;display:table;background-color:\"[theme:infoBackground, default: #f4f4f4]\"}.ms-MessageBar .ms-Link[data-v-519832b0]{font-size:12px}.ms-MessageBar-icon[data-v-519832b0],.ms-MessageBar-text[data-v-519832b0]{display:table-cell;vertical-align:top}.ms-MessageBar-icon[data-v-519832b0]{padding-right:8px;font-size:16px;color:\"[theme:neutralSecondaryAlt, default: #767676]\"}.ms-MessageBar-text[data-v-519832b0]{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;font-size:12px;font-weight:400}.ms-MessageBar.ms-MessageBar--warning[data-v-519832b0]{background-color:\"[theme:warningBackground, default: #fff4ce]\"}.ms-MessageBar.ms-MessageBar--severeWarning[data-v-519832b0]{background-color:\"[theme:severeWarningBackground, default: #fed9cc]\"}.ms-MessageBar.ms-MessageBar--severeWarning .ms-MessageBar-icon[data-v-519832b0]{color:\"[theme:severeWarning, default: #d83b01]\"}.ms-MessageBar.ms-MessageBar--error[data-v-519832b0]{background-color:\"[theme:errorBackground, default: #fde7e9]\"}.ms-MessageBar.ms-MessageBar--error .ms-MessageBar-icon[data-v-519832b0]{color:\"[theme:error, default: #a80000]\"}.ms-MessageBar.ms-MessageBar--blocked[data-v-519832b0]{background-color:\"[theme:errorBackground, default: #fde7e9]\"}.ms-MessageBar.ms-MessageBar--blocked .ms-MessageBar-icon[data-v-519832b0]{color:\"[theme:error, default: #a80000]\"}.ms-MessageBar.ms-MessageBar--success[data-v-519832b0]{background-color:\"[theme:successBackground, default: #dff6dd]\"}.ms-MessageBar.ms-MessageBar--success .ms-MessageBar-icon[data-v-519832b0]{color:\"[theme:green, default: #107c10]\"}", map: undefined, media: undefined });

    };
    /* scoped */
    const __vue_scope_id__$B = "data-v-519832b0";
    /* module identifier */
    const __vue_module_identifier__$B = undefined;
    /* functional template */
    const __vue_is_functional_template__$B = false;
    /* style inject */
    const __vue_create_injector__$e = function(context){ 
                  return function(scopeId, data)
                  {
                      if(window['wizstyle-'+scopeId])
                          return;
                      if(__vue_script__$B.loadStyles)
                          __vue_script__$B.loadStyles(data.source);
                      window['wizstyle-'+scopeId]=true;
                  }
              };
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var uiMessagebar = normalizeComponent(
      { render: __vue_render__$l, staticRenderFns: __vue_staticRenderFns__$l },
      __vue_inject_styles__$B,
      __vue_script__$B,
      __vue_scope_id__$B,
      __vue_is_functional_template__$B,
      __vue_module_identifier__$B,
      false,
      __vue_create_injector__$e,
      undefined,
      undefined
    );

  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  var script$C = {
    name: 'ou-message-banner',
    mounted: function mounted() {
      new this.$fabric.MessageBanner(this.$refs.messageBanner);
    }
  };

  /* script */
  const __vue_script__$C = script$C;

  /* template */
  var __vue_render__$m = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{ref:"messageBanner",staticClass:"ms-MessageBanner"},[_c('div',{staticClass:"ms-MessageBanner-content"},[_c('div',{staticClass:"ms-MessageBanner-text"},[_c('div',{staticClass:"ms-MessageBanner-clipper"},[_vm._t("default")],2)]),_vm._v(" "),_vm._m(0),_vm._v(" "),_c('div',{staticClass:"ms-MessageBanner-action"},[_vm._t("actions")],2)]),_vm._v(" "),_vm._m(1)])};
  var __vue_staticRenderFns__$m = [function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('button',{staticClass:"ms-MessageBanner-expand"},[_c('i',{staticClass:"ms-Icon ms-Icon--ChevronDown"})])},function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('button',{staticClass:"ms-MessageBanner-close"},[_c('i',{staticClass:"ms-Icon ms-Icon--Clear"})])}];

    /* style */
    const __vue_inject_styles__$C = undefined;
    /* scoped */
    const __vue_scope_id__$C = undefined;
    /* module identifier */
    const __vue_module_identifier__$C = undefined;
    /* functional template */
    const __vue_is_functional_template__$C = false;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    normalizeComponent(
      { render: __vue_render__$m, staticRenderFns: __vue_staticRenderFns__$m },
      __vue_inject_styles__$C,
      __vue_script__$C,
      __vue_scope_id__$C,
      __vue_is_functional_template__$C,
      __vue_module_identifier__$C,
      false,
      undefined,
      undefined,
      undefined
    );

  var MessageBanner = function () {
    function MessageBanner(container) {
      this._textContainerMaxWidth = 700;
      this._bufferElementsWidth = 88;
      this._bufferElementsWidthSmall = 35;
      this.SMALL_BREAK_POINT = 480;
      this.container = container;
      this.init();
    }

    MessageBanner.prototype.init = function () {
      this._cacheDOM();

      this._setListeners();

      this._clientWidth = this._errorBanner.offsetWidth;
      this._initTextWidth = this._clipper.offsetWidth;

      this._onResize();
    };

    MessageBanner.prototype.show = function () {
      this._errorBanner.className = "ms-MessageBanner";
    };

    MessageBanner.prototype.showBanner = function () {
      this.show();
    };

    MessageBanner.prototype.hide = function () {
      if (this._errorBanner.className.indexOf("hide") === -1) {
        this._errorBanner.className += " hide";
        setTimeout(this._hideMessageBanner.bind(this), 500);
      }
    };

    MessageBanner.prototype._hideMessageBanner = function () {
      this._errorBanner.className = "ms-MessageBanner is-hidden";
    };

    MessageBanner.prototype._onResize = function () {
      this._clientWidth = this._errorBanner.offsetWidth;

      if (window.innerWidth >= this.SMALL_BREAK_POINT) {
        this._resizeRegular();
      } else {
        this._resizeSmall();
      }
    };

    MessageBanner.prototype._resizeRegular = function () {
      if (this._clientWidth - this._bufferSize > this._initTextWidth && this._initTextWidth < this._textContainerMaxWidth) {
        this._textWidth = "auto";
        this._chevronButton.className = "ms-MessageBanner-expand";

        this._collapse();
      } else {
        this._textWidth = Math.min(this._clientWidth - this._bufferSize, this._textContainerMaxWidth) + "px";

        if (this._chevronButton.className.indexOf("is-visible") === -1) {
          this._chevronButton.className += " is-visible";
        }
      }

      this._clipper.style.width = this._textWidth;
    };

    MessageBanner.prototype._resizeSmall = function () {
      if (this._clientWidth - (this._bufferElementsWidthSmall + this._closeButton.offsetWidth) > this._initTextWidth) {
        this._textWidth = "auto";

        this._collapse();
      } else {
        this._textWidth = this._clientWidth - (this._bufferElementsWidthSmall + this._closeButton.offsetWidth) + "px";
      }

      this._clipper.style.width = this._textWidth;
    };

    MessageBanner.prototype._cacheDOM = function () {
      this._errorBanner = this.container;
      this._clipper = this.container.querySelector(".ms-MessageBanner-clipper");
      this._chevronButton = this.container.querySelector(".ms-MessageBanner-expand");
      this._actionButton = this.container.querySelector(".ms-MessageBanner-action");
      this._bufferSize = this._actionButton.offsetWidth + this._bufferElementsWidth;
      this._closeButton = this.container.querySelector(".ms-MessageBanner-close");
    };

    MessageBanner.prototype._expand = function () {
      var icon = this._chevronButton.querySelector(".ms-Icon");

      this._errorBanner.className += " is-expanded";
      icon.className = "ms-Icon ms-Icon--DoubleChevronUp";
    };

    MessageBanner.prototype._collapse = function () {
      var icon = this._chevronButton.querySelector(".ms-Icon");

      this._errorBanner.className = "ms-MessageBanner";
      icon.className = "ms-Icon ms-Icon--DoubleChevronDown";
    };

    MessageBanner.prototype._toggleExpansion = function () {
      if (this._errorBanner.className.indexOf("is-expanded") > -1) {
        this._collapse();
      } else {
        this._expand();
      }
    };

    MessageBanner.prototype._setListeners = function () {
      window.addEventListener("resize", this._onResize.bind(this), false);

      this._chevronButton.addEventListener("click", this._toggleExpansion.bind(this), false);

      this._closeButton.addEventListener("click", this.hide.bind(this), false);
    };

    return MessageBanner;
  }();

  //
  var script$D = {
    loadStyles: loadThemedStyles.loadStyles,
    props: {
      value: Boolean
    },
    data: function data() {
      return {
        instance: null
      };
    },
    watch: {
      value: function value() {
        this.setVisibility();
      }
    },
    methods: {
      setVisibility: function setVisibility() {
        var _this = this;

        if (this.value) {
          if (!this.instance) {
            this.instance = new MessageBanner(this.$refs.messageBanner);

            this.instance._closeButton.addEventListener("click", function () {
              console.log("closed");

              _this.$emit('input', false); // this.value = false;

            }, false);
          }

          this.instance.show();
        } else if (this.instance && this.$refs.messageBanner.className.indexOf("is-hidden") < 0) this.instance.hide();
      }
    },
    mounted: function mounted() {
      this.setVisibility();
    }
  };

  /* script */
  const __vue_script__$D = script$D;

  /* template */
  var __vue_render__$n = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{ref:"messageBanner",staticClass:"ms-MessageBanner is-hidden"},[_c('div',{staticClass:"ms-MessageBanner-content"},[_c('div',{staticClass:"ms-MessageBanner-text"},[_c('div',{staticClass:"ms-MessageBanner-clipper"},[_vm._t("default")],2)]),_vm._v(" "),_vm._m(0),_vm._v(" "),_c('div',{staticClass:"ms-MessageBanner-action"},[_vm._t("actions")],2)]),_vm._v(" "),_vm._m(1)])};
  var __vue_staticRenderFns__$n = [function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('button',{staticClass:"ms-MessageBanner-expand"},[_c('i',{staticClass:"ms-Icon ms-Icon--ChevronDown"})])},function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('button',{staticClass:"ms-MessageBanner-close"},[_c('i',{staticClass:"ms-Icon ms-Icon--Clear"})])}];

    /* style */
    const __vue_inject_styles__$D = function (inject) {
      if (!inject) return
      inject("data-v-4979d51c_0", { source: "@charset \"UTF-8\";.ms-u-slideRightIn10[data-v-4979d51c]{-webkit-animation-name:fadeIn-data-v-4979d51c,slideRightIn10-data-v-4979d51c;-moz-animation-name:fadeIn-data-v-4979d51c,slideRightIn10-data-v-4979d51c;-ms-animation-name:fadeIn-data-v-4979d51c,slideRightIn10-data-v-4979d51c;-o-animation-name:fadeIn-data-v-4979d51c,slideRightIn10-data-v-4979d51c;animation-name:fadeIn-data-v-4979d51c,slideRightIn10-data-v-4979d51c;-webkit-animation-duration:367ms;-moz-animation-duration:367ms;-ms-animation-duration:367ms;-o-animation-duration:367ms;-webkit-animation-timing-function:cubic-bezier(.1,.9,.2,1);-moz-animation-timing-function:cubic-bezier(.1,.9,.2,1);-ms-animation-timing-function:cubic-bezier(.1,.9,.2,1);-o-animation-timing-function:cubic-bezier(.1,.9,.2,1);animation-timing-function:cubic-bezier(.1,.9,.2,1);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideRightIn10-data-v-4979d51c{from{-webkit-transform:translate3d(-10px,0,0)}to{-webkit-transform:translate3d(0,0,0)}}@keyframes slideRightIn10-data-v-4979d51c{from{transform:translate3d(-10px,0,0)}to{transform:translate3d(0,0,0)}}.ms-u-slideRightIn20[data-v-4979d51c]{-webkit-animation-name:fadeIn-data-v-4979d51c,slideRightIn20-data-v-4979d51c;-moz-animation-name:fadeIn-data-v-4979d51c,slideRightIn20-data-v-4979d51c;-ms-animation-name:fadeIn-data-v-4979d51c,slideRightIn20-data-v-4979d51c;-o-animation-name:fadeIn-data-v-4979d51c,slideRightIn20-data-v-4979d51c;animation-name:fadeIn-data-v-4979d51c,slideRightIn20-data-v-4979d51c;-webkit-animation-duration:367ms;-moz-animation-duration:367ms;-ms-animation-duration:367ms;-o-animation-duration:367ms;-webkit-animation-timing-function:cubic-bezier(.1,.9,.2,1);-moz-animation-timing-function:cubic-bezier(.1,.9,.2,1);-ms-animation-timing-function:cubic-bezier(.1,.9,.2,1);-o-animation-timing-function:cubic-bezier(.1,.9,.2,1);animation-timing-function:cubic-bezier(.1,.9,.2,1);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideRightIn20-data-v-4979d51c{from{-webkit-transform:translate3d(-20px,0,0)}to{-webkit-transform:translate3d(0,0,0)}}@keyframes slideRightIn20-data-v-4979d51c{from{transform:translate3d(-20px,0,0)}to{transform:translate3d(0,0,0)}}.ms-u-slideRightIn40[data-v-4979d51c]{-webkit-animation-name:fadeIn-data-v-4979d51c,slideRightIn40-data-v-4979d51c;-moz-animation-name:fadeIn-data-v-4979d51c,slideRightIn40-data-v-4979d51c;-ms-animation-name:fadeIn-data-v-4979d51c,slideRightIn40-data-v-4979d51c;-o-animation-name:fadeIn-data-v-4979d51c,slideRightIn40-data-v-4979d51c;animation-name:fadeIn-data-v-4979d51c,slideRightIn40-data-v-4979d51c;-webkit-animation-duration:367ms;-moz-animation-duration:367ms;-ms-animation-duration:367ms;-o-animation-duration:367ms;-webkit-animation-timing-function:cubic-bezier(.1,.9,.2,1);-moz-animation-timing-function:cubic-bezier(.1,.9,.2,1);-ms-animation-timing-function:cubic-bezier(.1,.9,.2,1);-o-animation-timing-function:cubic-bezier(.1,.9,.2,1);animation-timing-function:cubic-bezier(.1,.9,.2,1);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideRightIn40-data-v-4979d51c{from{-webkit-transform:translate3d(-40px,0,0)}to{-webkit-transform:translate3d(0,0,0)}}@keyframes slideRightIn40-data-v-4979d51c{from{transform:translate3d(-40px,0,0)}to{transform:translate3d(0,0,0)}}.ms-u-slideLeftIn10[data-v-4979d51c]{-webkit-animation-name:fadeIn-data-v-4979d51c,slideLeftIn10-data-v-4979d51c;-moz-animation-name:fadeIn-data-v-4979d51c,slideLeftIn10-data-v-4979d51c;-ms-animation-name:fadeIn-data-v-4979d51c,slideLeftIn10-data-v-4979d51c;-o-animation-name:fadeIn-data-v-4979d51c,slideLeftIn10-data-v-4979d51c;animation-name:fadeIn-data-v-4979d51c,slideLeftIn10-data-v-4979d51c;-webkit-animation-duration:367ms;-moz-animation-duration:367ms;-ms-animation-duration:367ms;-o-animation-duration:367ms;-webkit-animation-timing-function:cubic-bezier(.1,.9,.2,1);-moz-animation-timing-function:cubic-bezier(.1,.9,.2,1);-ms-animation-timing-function:cubic-bezier(.1,.9,.2,1);-o-animation-timing-function:cubic-bezier(.1,.9,.2,1);animation-timing-function:cubic-bezier(.1,.9,.2,1);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideLeftIn10-data-v-4979d51c{from{-webkit-transform:translate3d(10px,0,0)}to{-webkit-transform:translate3d(0,0,0)}}@keyframes slideLeftIn10-data-v-4979d51c{from{transform:translate3d(10px,0,0)}to{transform:translate3d(0,0,0)}}.ms-u-slideLeftIn20[data-v-4979d51c]{-webkit-animation-name:fadeIn-data-v-4979d51c,slideLeftIn20-data-v-4979d51c;-moz-animation-name:fadeIn-data-v-4979d51c,slideLeftIn20-data-v-4979d51c;-ms-animation-name:fadeIn-data-v-4979d51c,slideLeftIn20-data-v-4979d51c;-o-animation-name:fadeIn-data-v-4979d51c,slideLeftIn20-data-v-4979d51c;animation-name:fadeIn-data-v-4979d51c,slideLeftIn20-data-v-4979d51c;-webkit-animation-duration:367ms;-moz-animation-duration:367ms;-ms-animation-duration:367ms;-o-animation-duration:367ms;-webkit-animation-timing-function:cubic-bezier(.1,.9,.2,1);-moz-animation-timing-function:cubic-bezier(.1,.9,.2,1);-ms-animation-timing-function:cubic-bezier(.1,.9,.2,1);-o-animation-timing-function:cubic-bezier(.1,.9,.2,1);animation-timing-function:cubic-bezier(.1,.9,.2,1);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideLeftIn20-data-v-4979d51c{from{-webkit-transform:translate3d(20px,0,0)}to{-webkit-transform:translate3d(0,0,0)}}@keyframes slideLeftIn20-data-v-4979d51c{from{transform:translate3d(20px,0,0)}to{transform:translate3d(0,0,0)}}.ms-u-slideLeftIn40[data-v-4979d51c]{-webkit-animation-name:fadeIn-data-v-4979d51c,slideLeftIn40-data-v-4979d51c;-moz-animation-name:fadeIn-data-v-4979d51c,slideLeftIn40-data-v-4979d51c;-ms-animation-name:fadeIn-data-v-4979d51c,slideLeftIn40-data-v-4979d51c;-o-animation-name:fadeIn-data-v-4979d51c,slideLeftIn40-data-v-4979d51c;animation-name:fadeIn-data-v-4979d51c,slideLeftIn40-data-v-4979d51c;-webkit-animation-duration:367ms;-moz-animation-duration:367ms;-ms-animation-duration:367ms;-o-animation-duration:367ms;-webkit-animation-timing-function:cubic-bezier(.1,.9,.2,1);-moz-animation-timing-function:cubic-bezier(.1,.9,.2,1);-ms-animation-timing-function:cubic-bezier(.1,.9,.2,1);-o-animation-timing-function:cubic-bezier(.1,.9,.2,1);animation-timing-function:cubic-bezier(.1,.9,.2,1);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideLeftIn40-data-v-4979d51c{from{-webkit-transform:translate3d(40px,0,0)}to{-webkit-transform:translate3d(0,0,0)}}@keyframes slideLeftIn40-data-v-4979d51c{from{transform:translate3d(40px,0,0)}to{transform:translate3d(0,0,0)}}.ms-u-slideRightIn400[data-v-4979d51c]{-webkit-animation-name:fadeIn-data-v-4979d51c,slideRightIn400-data-v-4979d51c;-moz-animation-name:fadeIn-data-v-4979d51c,slideRightIn400-data-v-4979d51c;-ms-animation-name:fadeIn-data-v-4979d51c,slideRightIn400-data-v-4979d51c;-o-animation-name:fadeIn-data-v-4979d51c,slideRightIn400-data-v-4979d51c;animation-name:fadeIn-data-v-4979d51c,slideRightIn400-data-v-4979d51c;-webkit-animation-duration:367ms;-moz-animation-duration:367ms;-ms-animation-duration:367ms;-o-animation-duration:367ms;-webkit-animation-timing-function:cubic-bezier(.1,.9,.2,1);-moz-animation-timing-function:cubic-bezier(.1,.9,.2,1);-ms-animation-timing-function:cubic-bezier(.1,.9,.2,1);-o-animation-timing-function:cubic-bezier(.1,.9,.2,1);animation-timing-function:cubic-bezier(.1,.9,.2,1);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideRightIn400-data-v-4979d51c{from{-webkit-transform:translate3d(-400px,0,0)}to{-webkit-transform:translate3d(0,0,0)}}@keyframes slideRightIn400-data-v-4979d51c{from{transform:translate3d(-400px,0,0)}to{transform:translate3d(0,0,0)}}.ms-u-slideLeftIn400[data-v-4979d51c]{-webkit-animation-name:fadeIn-data-v-4979d51c,slideLeft400-data-v-4979d51c;-moz-animation-name:fadeIn-data-v-4979d51c,slideLeft400-data-v-4979d51c;-ms-animation-name:fadeIn-data-v-4979d51c,slideLeft400-data-v-4979d51c;-o-animation-name:fadeIn-data-v-4979d51c,slideLeft400-data-v-4979d51c;animation-name:fadeIn-data-v-4979d51c,slideLeft400-data-v-4979d51c;-webkit-animation-duration:367ms;-moz-animation-duration:367ms;-ms-animation-duration:367ms;-o-animation-duration:367ms;-webkit-animation-timing-function:cubic-bezier(.1,.9,.2,1);-moz-animation-timing-function:cubic-bezier(.1,.9,.2,1);-ms-animation-timing-function:cubic-bezier(.1,.9,.2,1);-o-animation-timing-function:cubic-bezier(.1,.9,.2,1);animation-timing-function:cubic-bezier(.1,.9,.2,1);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideLeft400-data-v-4979d51c{from{-webkit-transform:translate3d(400px,0,0)}to{-webkit-transform:translate3d(0,0,0)}}@keyframes slideLeft400-data-v-4979d51c{from{transform:translate3d(400px,0,0)}to{transform:translate3d(0,0,0)}}.ms-u-slideUpIn20[data-v-4979d51c]{-webkit-animation-name:fadeIn-data-v-4979d51c,slideUpIn20-data-v-4979d51c;-moz-animation-name:fadeIn-data-v-4979d51c,slideUpIn20-data-v-4979d51c;-ms-animation-name:fadeIn-data-v-4979d51c,slideUpIn20-data-v-4979d51c;-o-animation-name:fadeIn-data-v-4979d51c,slideUpIn20-data-v-4979d51c;animation-name:fadeIn-data-v-4979d51c,slideUpIn20-data-v-4979d51c;-webkit-animation-duration:367ms;-moz-animation-duration:367ms;-ms-animation-duration:367ms;-o-animation-duration:367ms;-webkit-animation-timing-function:cubic-bezier(.1,.9,.2,1);-moz-animation-timing-function:cubic-bezier(.1,.9,.2,1);-ms-animation-timing-function:cubic-bezier(.1,.9,.2,1);-o-animation-timing-function:cubic-bezier(.1,.9,.2,1);animation-timing-function:cubic-bezier(.1,.9,.2,1);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideUpIn20-data-v-4979d51c{from{-webkit-transform:translate3d(0,20px,0)}to{-webkit-transform:translate3d(0,0,0)}}@keyframes slideUpIn20-data-v-4979d51c{from{transform:translate3d(0,20px,0)}to{transform:translate3d(0,0,0)}}.ms-u-slideUpIn10[data-v-4979d51c]{-webkit-animation-name:fadeIn-data-v-4979d51c,slideUpIn10-data-v-4979d51c;-moz-animation-name:fadeIn-data-v-4979d51c,slideUpIn10-data-v-4979d51c;-ms-animation-name:fadeIn-data-v-4979d51c,slideUpIn10-data-v-4979d51c;-o-animation-name:fadeIn-data-v-4979d51c,slideUpIn10-data-v-4979d51c;animation-name:fadeIn-data-v-4979d51c,slideUpIn10-data-v-4979d51c;-webkit-animation-duration:167ms;-moz-animation-duration:167ms;-ms-animation-duration:167ms;-o-animation-duration:167ms;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-moz-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-ms-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-o-animation-timing-function:cubic-bezier(.1,.25,.75,.9);animation-timing-function:cubic-bezier(.1,.25,.75,.9);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideUpIn10-data-v-4979d51c{from{-webkit-transform:translate3d(0,10px,0)}to{-webkit-transform:translate3d(0,0,0)}}@keyframes slideUpIn10-data-v-4979d51c{from{transform:translate3d(0,10px,0)}to{transform:translate3d(0,0,0)}}.ms-u-slideDownIn20[data-v-4979d51c]{-webkit-animation-name:fadeIn-data-v-4979d51c,slideDownIn20-data-v-4979d51c;-moz-animation-name:fadeIn-data-v-4979d51c,slideDownIn20-data-v-4979d51c;-ms-animation-name:fadeIn-data-v-4979d51c,slideDownIn20-data-v-4979d51c;-o-animation-name:fadeIn-data-v-4979d51c,slideDownIn20-data-v-4979d51c;animation-name:fadeIn-data-v-4979d51c,slideDownIn20-data-v-4979d51c;-webkit-animation-duration:367ms;-moz-animation-duration:367ms;-ms-animation-duration:367ms;-o-animation-duration:367ms;-webkit-animation-timing-function:cubic-bezier(.1,.9,.2,1);-moz-animation-timing-function:cubic-bezier(.1,.9,.2,1);-ms-animation-timing-function:cubic-bezier(.1,.9,.2,1);-o-animation-timing-function:cubic-bezier(.1,.9,.2,1);animation-timing-function:cubic-bezier(.1,.9,.2,1);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideDownIn20-data-v-4979d51c{from{-webkit-transform:translate3d(0,-20px,0)}to{-webkit-transform:translate3d(0,0,0)}}@keyframes slideDownIn20-data-v-4979d51c{from{transform:translate3d(0,-20px,0)}to{transform:translate3d(0,0,0)}}.ms-u-slideDownIn10[data-v-4979d51c]{-webkit-animation-name:fadeIn-data-v-4979d51c,slideDownIn10-data-v-4979d51c;-moz-animation-name:fadeIn-data-v-4979d51c,slideDownIn10-data-v-4979d51c;-ms-animation-name:fadeIn-data-v-4979d51c,slideDownIn10-data-v-4979d51c;-o-animation-name:fadeIn-data-v-4979d51c,slideDownIn10-data-v-4979d51c;animation-name:fadeIn-data-v-4979d51c,slideDownIn10-data-v-4979d51c;-webkit-animation-duration:167ms;-moz-animation-duration:167ms;-ms-animation-duration:167ms;-o-animation-duration:167ms;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-moz-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-ms-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-o-animation-timing-function:cubic-bezier(.1,.25,.75,.9);animation-timing-function:cubic-bezier(.1,.25,.75,.9);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideDownIn10-data-v-4979d51c{from{-webkit-transform:translate3d(0,-10px,0)}to{-webkit-transform:translate3d(0,0,0)}}@keyframes slideDownIn10-data-v-4979d51c{from{transform:translate3d(0,-10px,0)}to{transform:translate3d(0,0,0)}}.ms-u-slideRightOut40[data-v-4979d51c]{-webkit-animation-name:fadeOut-data-v-4979d51c,slideRightOut40-data-v-4979d51c;-moz-animation-name:fadeOut-data-v-4979d51c,slideRightOut40-data-v-4979d51c;-ms-animation-name:fadeOut-data-v-4979d51c,slideRightOut40-data-v-4979d51c;-o-animation-name:fadeOut-data-v-4979d51c,slideRightOut40-data-v-4979d51c;animation-name:fadeOut-data-v-4979d51c,slideRightOut40-data-v-4979d51c;-webkit-animation-duration:167ms;-moz-animation-duration:167ms;-ms-animation-duration:167ms;-o-animation-duration:167ms;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-moz-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-ms-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-o-animation-timing-function:cubic-bezier(.1,.25,.75,.9);animation-timing-function:cubic-bezier(.1,.25,.75,.9);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideRightOut40-data-v-4979d51c{from{-webkit-transform:translate3d(0,0,0)}to{-webkit-transform:translate3d(40px,0,0)}}@keyframes slideRightOut40-data-v-4979d51c{from{transform:translate3d(0,0,0)}to{transform:translate3d(40px,0,0)}}.ms-u-slideLeftOut40[data-v-4979d51c]{-webkit-animation-name:fadeOut-data-v-4979d51c,slideLeftOut40-data-v-4979d51c;-moz-animation-name:fadeOut-data-v-4979d51c,slideLeftOut40-data-v-4979d51c;-ms-animation-name:fadeOut-data-v-4979d51c,slideLeftOut40-data-v-4979d51c;-o-animation-name:fadeOut-data-v-4979d51c,slideLeftOut40-data-v-4979d51c;animation-name:fadeOut-data-v-4979d51c,slideLeftOut40-data-v-4979d51c;-webkit-animation-duration:167ms;-moz-animation-duration:167ms;-ms-animation-duration:167ms;-o-animation-duration:167ms;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-moz-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-ms-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-o-animation-timing-function:cubic-bezier(.1,.25,.75,.9);animation-timing-function:cubic-bezier(.1,.25,.75,.9);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideLeftOut40-data-v-4979d51c{from{-webkit-transform:translate3d(0,0,0)}to{-webkit-transform:translate3d(-40px,0,0)}}@keyframes slideLeftOut40-data-v-4979d51c{from{transform:translate3d(0,0,0)}to{transform:translate3d(-40px,0,0)}}.ms-u-slideRightOut400[data-v-4979d51c]{-webkit-animation-name:fadeOut-data-v-4979d51c,slideRightOut400-data-v-4979d51c;-moz-animation-name:fadeOut-data-v-4979d51c,slideRightOut400-data-v-4979d51c;-ms-animation-name:fadeOut-data-v-4979d51c,slideRightOut400-data-v-4979d51c;-o-animation-name:fadeOut-data-v-4979d51c,slideRightOut400-data-v-4979d51c;animation-name:fadeOut-data-v-4979d51c,slideRightOut400-data-v-4979d51c;-webkit-animation-duration:167ms;-moz-animation-duration:167ms;-ms-animation-duration:167ms;-o-animation-duration:167ms;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-moz-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-ms-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-o-animation-timing-function:cubic-bezier(.1,.25,.75,.9);animation-timing-function:cubic-bezier(.1,.25,.75,.9);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideRightOut400-data-v-4979d51c{from{-webkit-transform:translate3d(0,0,0)}to{-webkit-transform:translate3d(400px,0,0)}}@keyframes slideRightOut400-data-v-4979d51c{from{transform:translate3d(0,0,0)}to{transform:translate3d(400px,0,0)}}.ms-u-slideLeftOut400[data-v-4979d51c]{-webkit-animation-name:fadeOut-data-v-4979d51c,slideLeftOut400-data-v-4979d51c;-moz-animation-name:fadeOut-data-v-4979d51c,slideLeftOut400-data-v-4979d51c;-ms-animation-name:fadeOut-data-v-4979d51c,slideLeftOut400-data-v-4979d51c;-o-animation-name:fadeOut-data-v-4979d51c,slideLeftOut400-data-v-4979d51c;animation-name:fadeOut-data-v-4979d51c,slideLeftOut400-data-v-4979d51c;-webkit-animation-duration:167ms;-moz-animation-duration:167ms;-ms-animation-duration:167ms;-o-animation-duration:167ms;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-moz-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-ms-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-o-animation-timing-function:cubic-bezier(.1,.25,.75,.9);animation-timing-function:cubic-bezier(.1,.25,.75,.9);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideLeftOut400-data-v-4979d51c{from{-webkit-transform:translate3d(0,0,0)}to{-webkit-transform:translate3d(-400px,0,0)}}@keyframes slideLeftOut400-data-v-4979d51c{from{transform:translate3d(0,0,0)}to{transform:translate3d(-400px,0,0)}}.ms-u-slideUpOut20[data-v-4979d51c]{-webkit-animation-name:fadeOut-data-v-4979d51c,slideUpOut20-data-v-4979d51c;-moz-animation-name:fadeOut-data-v-4979d51c,slideUpOut20-data-v-4979d51c;-ms-animation-name:fadeOut-data-v-4979d51c,slideUpOut20-data-v-4979d51c;-o-animation-name:fadeOut-data-v-4979d51c,slideUpOut20-data-v-4979d51c;animation-name:fadeOut-data-v-4979d51c,slideUpOut20-data-v-4979d51c;-webkit-animation-duration:167ms;-moz-animation-duration:167ms;-ms-animation-duration:167ms;-o-animation-duration:167ms;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-moz-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-ms-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-o-animation-timing-function:cubic-bezier(.1,.25,.75,.9);animation-timing-function:cubic-bezier(.1,.25,.75,.9);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideUpOut20-data-v-4979d51c{from{-webkit-transform:translate3d(0,0,0)}to{-webkit-transform:translate3d(0,-20px,0)}}@keyframes slideUpOut20-data-v-4979d51c{from{transform:translate3d(0,0,0)}to{transform:translate3d(0,-20px,0)}}.ms-u-slideUpOut10[data-v-4979d51c]{-webkit-animation-name:fadeOut-data-v-4979d51c,slideUpOut10-data-v-4979d51c;-moz-animation-name:fadeOut-data-v-4979d51c,slideUpOut10-data-v-4979d51c;-ms-animation-name:fadeOut-data-v-4979d51c,slideUpOut10-data-v-4979d51c;-o-animation-name:fadeOut-data-v-4979d51c,slideUpOut10-data-v-4979d51c;animation-name:fadeOut-data-v-4979d51c,slideUpOut10-data-v-4979d51c;-webkit-animation-duration:167ms;-moz-animation-duration:167ms;-ms-animation-duration:167ms;-o-animation-duration:167ms;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-moz-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-ms-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-o-animation-timing-function:cubic-bezier(.1,.25,.75,.9);animation-timing-function:cubic-bezier(.1,.25,.75,.9);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideUpOut10-data-v-4979d51c{from{-webkit-transform:translate3d(0,0,0)}to{-webkit-transform:translate3d(0,-10px,0)}}@keyframes slideUpOut10-data-v-4979d51c{from{transform:translate3d(0,0,0)}to{transform:translate3d(0,-10px,0)}}.ms-u-slideDownOut20[data-v-4979d51c]{-webkit-animation-name:fadeOut-data-v-4979d51c,slideDownOut20-data-v-4979d51c;-moz-animation-name:fadeOut-data-v-4979d51c,slideDownOut20-data-v-4979d51c;-ms-animation-name:fadeOut-data-v-4979d51c,slideDownOut20-data-v-4979d51c;-o-animation-name:fadeOut-data-v-4979d51c,slideDownOut20-data-v-4979d51c;animation-name:fadeOut-data-v-4979d51c,slideDownOut20-data-v-4979d51c;-webkit-animation-duration:167ms;-moz-animation-duration:167ms;-ms-animation-duration:167ms;-o-animation-duration:167ms;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-moz-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-ms-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-o-animation-timing-function:cubic-bezier(.1,.25,.75,.9);animation-timing-function:cubic-bezier(.1,.25,.75,.9);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideDownOut20-data-v-4979d51c{from{-webkit-transform:translate3d(0,0,0)}to{-webkit-transform:translate3d(0,20px,0)}}@keyframes slideDownOut20-data-v-4979d51c{from{transform:translate3d(0,0,0)}to{transform:translate3d(0,20px,0)}}.ms-u-slideDownOut10[data-v-4979d51c]{-webkit-animation-name:fadeOut-data-v-4979d51c,slideDownOut10-data-v-4979d51c;-moz-animation-name:fadeOut-data-v-4979d51c,slideDownOut10-data-v-4979d51c;-ms-animation-name:fadeOut-data-v-4979d51c,slideDownOut10-data-v-4979d51c;-o-animation-name:fadeOut-data-v-4979d51c,slideDownOut10-data-v-4979d51c;animation-name:fadeOut-data-v-4979d51c,slideDownOut10-data-v-4979d51c;-webkit-animation-duration:167ms;-moz-animation-duration:167ms;-ms-animation-duration:167ms;-o-animation-duration:167ms;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-moz-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-ms-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-o-animation-timing-function:cubic-bezier(.1,.25,.75,.9);animation-timing-function:cubic-bezier(.1,.25,.75,.9);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideDownOut10-data-v-4979d51c{from{-webkit-transform:translate3d(0,0,0)}to{-webkit-transform:translate3d(0,10px,0)}}@keyframes slideDownOut10-data-v-4979d51c{from{transform:translate3d(0,0,0)}to{transform:translate3d(0,10px,0)}}.ms-u-scaleUpIn100[data-v-4979d51c]{-webkit-animation-name:fadeIn-data-v-4979d51c,scaleUp100-data-v-4979d51c;-moz-animation-name:fadeIn-data-v-4979d51c,scaleUp100-data-v-4979d51c;-ms-animation-name:fadeIn-data-v-4979d51c,scaleUp100-data-v-4979d51c;-o-animation-name:fadeIn-data-v-4979d51c,scaleUp100-data-v-4979d51c;animation-name:fadeIn-data-v-4979d51c,scaleUp100-data-v-4979d51c;-webkit-animation-duration:367ms;-moz-animation-duration:367ms;-ms-animation-duration:367ms;-o-animation-duration:367ms;-webkit-animation-timing-function:cubic-bezier(.1,.9,.2,1);-moz-animation-timing-function:cubic-bezier(.1,.9,.2,1);-ms-animation-timing-function:cubic-bezier(.1,.9,.2,1);-o-animation-timing-function:cubic-bezier(.1,.9,.2,1);animation-timing-function:cubic-bezier(.1,.9,.2,1);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes scaleUp100-data-v-4979d51c{from{-webkit-transform:scale3d(.98,.98,1)}to{-webkit-transform:scale3d(1,1,1)}}@keyframes scaleUp100-data-v-4979d51c{from{transform:scale3d(.98,.98,1)}to{transform:scale3d(1,1,1)}}.ms-u-scaleDownIn100[data-v-4979d51c]{-webkit-animation-name:fadeIn-data-v-4979d51c,scaleDown100-data-v-4979d51c;-moz-animation-name:fadeIn-data-v-4979d51c,scaleDown100-data-v-4979d51c;-ms-animation-name:fadeIn-data-v-4979d51c,scaleDown100-data-v-4979d51c;-o-animation-name:fadeIn-data-v-4979d51c,scaleDown100-data-v-4979d51c;animation-name:fadeIn-data-v-4979d51c,scaleDown100-data-v-4979d51c;-webkit-animation-duration:367ms;-moz-animation-duration:367ms;-ms-animation-duration:367ms;-o-animation-duration:367ms;-webkit-animation-timing-function:cubic-bezier(.1,.9,.2,1);-moz-animation-timing-function:cubic-bezier(.1,.9,.2,1);-ms-animation-timing-function:cubic-bezier(.1,.9,.2,1);-o-animation-timing-function:cubic-bezier(.1,.9,.2,1);animation-timing-function:cubic-bezier(.1,.9,.2,1);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes scaleDown100-data-v-4979d51c{from{-webkit-transform:scale3d(1.03,1.03,1)}to{-webkit-transform:scale3d(1,1,1)}}@keyframes scaleDown100-data-v-4979d51c{from{transform:scale3d(1.03,1.03,1)}to{transform:scale3d(1,1,1)}}.ms-u-scaleUpOut103[data-v-4979d51c]{-webkit-animation-name:fadeOut-data-v-4979d51c,scaleUp103-data-v-4979d51c;-moz-animation-name:fadeOut-data-v-4979d51c,scaleUp103-data-v-4979d51c;-ms-animation-name:fadeOut-data-v-4979d51c,scaleUp103-data-v-4979d51c;-o-animation-name:fadeOut-data-v-4979d51c,scaleUp103-data-v-4979d51c;animation-name:fadeOut-data-v-4979d51c,scaleUp103-data-v-4979d51c;-webkit-animation-duration:167ms;-moz-animation-duration:167ms;-ms-animation-duration:167ms;-o-animation-duration:167ms;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-moz-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-ms-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-o-animation-timing-function:cubic-bezier(.1,.25,.75,.9);animation-timing-function:cubic-bezier(.1,.25,.75,.9);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes scaleUp103-data-v-4979d51c{from{-webkit-transform:scale3d(1,1,1)}to{-webkit-transform:scale3d(1.03,1.03,1)}}@keyframes scaleUp103-data-v-4979d51c{from{transform:scale3d(1,1,1)}to{transform:scale3d(1.03,1.03,1)}}.ms-u-scaleDownOut98[data-v-4979d51c]{-webkit-animation-name:fadeOut-data-v-4979d51c,scaleDown98-data-v-4979d51c;-moz-animation-name:fadeOut-data-v-4979d51c,scaleDown98-data-v-4979d51c;-ms-animation-name:fadeOut-data-v-4979d51c,scaleDown98-data-v-4979d51c;-o-animation-name:fadeOut-data-v-4979d51c,scaleDown98-data-v-4979d51c;animation-name:fadeOut-data-v-4979d51c,scaleDown98-data-v-4979d51c;-webkit-animation-duration:167ms;-moz-animation-duration:167ms;-ms-animation-duration:167ms;-o-animation-duration:167ms;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-moz-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-ms-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-o-animation-timing-function:cubic-bezier(.1,.25,.75,.9);animation-timing-function:cubic-bezier(.1,.25,.75,.9);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes scaleDown98-data-v-4979d51c{from{-webkit-transform:scale3d(1,1,1)}to{-webkit-transform:scale3d(.98,.98,1)}}@keyframes scaleDown98-data-v-4979d51c{from{transform:scale3d(1,1,1)}to{transform:scale3d(.98,.98,1)}}.ms-u-fadeIn400[data-v-4979d51c]{-webkit-animation-duration:367ms;-webkit-animation-name:fadeIn-data-v-4979d51c;-webkit-animation-fill-mode:both;animation-duration:367ms;animation-name:fadeIn-data-v-4979d51c;animation-fill-mode:both}.ms-u-fadeIn100[data-v-4979d51c]{-webkit-animation-duration:367ms;-webkit-animation-name:fadeIn-data-v-4979d51c;-webkit-animation-fill-mode:both;animation-duration:367ms;animation-name:fadeIn-data-v-4979d51c;animation-fill-mode:both;-webkit-animation-duration:167ms;animation-duration:167ms}.ms-u-fadeIn200[data-v-4979d51c]{-webkit-animation-duration:367ms;-webkit-animation-name:fadeIn-data-v-4979d51c;-webkit-animation-fill-mode:both;animation-duration:367ms;animation-name:fadeIn-data-v-4979d51c;animation-fill-mode:both;-webkit-animation-duration:267ms;animation-duration:267ms}.ms-u-fadeIn500[data-v-4979d51c]{-webkit-animation-duration:367ms;-webkit-animation-name:fadeIn-data-v-4979d51c;-webkit-animation-fill-mode:both;animation-duration:367ms;animation-name:fadeIn-data-v-4979d51c;animation-fill-mode:both;-webkit-animation-duration:467ms;animation-duration:467ms}@-webkit-keyframes fadeIn-data-v-4979d51c{from{opacity:0;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9)}to{opacity:1}}@keyframes fadeIn-data-v-4979d51c{from{opacity:0;animation-timing-function:cubic-bezier(.1,.25,.75,.9)}to{opacity:1}}.ms-u-fadeOut400[data-v-4979d51c]{-webkit-animation-duration:367ms;-webkit-animation-name:fadeOut-data-v-4979d51c;-webkit-animation-fill-mode:both;animation-duration:367ms;animation-name:fadeOut-data-v-4979d51c;animation-fill-mode:both}.ms-u-fadeOut100[data-v-4979d51c]{-webkit-animation-duration:367ms;-webkit-animation-name:fadeOut-data-v-4979d51c;-webkit-animation-fill-mode:both;animation-duration:367ms;animation-name:fadeOut-data-v-4979d51c;animation-fill-mode:both;-webkit-animation-duration:.1s;animation-duration:.1s}.ms-u-fadeOut200[data-v-4979d51c]{-webkit-animation-duration:367ms;-webkit-animation-name:fadeOut-data-v-4979d51c;-webkit-animation-fill-mode:both;animation-duration:367ms;animation-name:fadeOut-data-v-4979d51c;animation-fill-mode:both;-webkit-animation-duration:167ms;animation-duration:167ms}.ms-u-fadeOut500[data-v-4979d51c]{-webkit-animation-duration:367ms;-webkit-animation-name:fadeOut-data-v-4979d51c;-webkit-animation-fill-mode:both;animation-duration:367ms;animation-name:fadeOut-data-v-4979d51c;animation-fill-mode:both;-webkit-animation-duration:467ms;animation-duration:467ms}@-webkit-keyframes fadeOut-data-v-4979d51c{from{opacity:1;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9)}to{opacity:0}}@keyframes fadeOut-data-v-4979d51c{from{opacity:1;animation-timing-function:cubic-bezier(.1,.25,.75,.9)}to{opacity:0}}.ms-u-rotate90deg[data-v-4979d51c]{-webkit-animation-name:rotate90-data-v-4979d51c;-moz-animation-name:rotate90-data-v-4979d51c;-ms-animation-name:rotate90-data-v-4979d51c;-o-animation-name:rotate90-data-v-4979d51c;animation-name:rotate90-data-v-4979d51c;-webkit-animation-duration:.1s;-moz-animation-duration:.1s;-ms-animation-duration:.1s;-o-animation-duration:.1s;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-moz-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-ms-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-o-animation-timing-function:cubic-bezier(.1,.25,.75,.9);animation-timing-function:cubic-bezier(.1,.25,.75,.9);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes rotate90-data-v-4979d51c{from{-webkit-transform:rotateZ(0)}to{-webkit-transform:rotateZ(90deg)}}@keyframes rotate90-data-v-4979d51c{from{transform:rotateZ(0)}to{transform:rotateZ(90deg)}}.ms-u-rotateN90deg[data-v-4979d51c]{-webkit-animation-name:rotateN90-data-v-4979d51c;-moz-animation-name:rotateN90-data-v-4979d51c;-ms-animation-name:rotateN90-data-v-4979d51c;-o-animation-name:rotateN90-data-v-4979d51c;animation-name:rotateN90-data-v-4979d51c;-webkit-animation-duration:.1s;-moz-animation-duration:.1s;-ms-animation-duration:.1s;-o-animation-duration:.1s;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-moz-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-ms-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-o-animation-timing-function:cubic-bezier(.1,.25,.75,.9);animation-timing-function:cubic-bezier(.1,.25,.75,.9);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes rotateN90-data-v-4979d51c{from{-webkit-transform:rotateZ(90deg)}to{-webkit-transform:rotateZ(0)}}@keyframes rotateN90-data-v-4979d51c{from{transform:rotateZ(90deg)}to{transform:rotateZ(0)}}.ms-u-expandCollapse400[data-v-4979d51c]{-webkit-transition:height 367ms cubic-bezier(.1,.25,.75,.9);transition:height 367ms cubic-bezier(.1,.25,.75,.9)}.ms-u-expandCollapse200[data-v-4979d51c]{-webkit-transition:height 167ms cubic-bezier(.1,.25,.75,.9);transition:height 167ms cubic-bezier(.1,.25,.75,.9)}.ms-u-expandCollapse100[data-v-4979d51c]{-webkit-transition:height .1s cubic-bezier(.1,.25,.75,.9);transition:height .1s cubic-bezier(.1,.25,.75,.9)}.ms-u-delay100[data-v-4979d51c]{-webkit-animation-delay:167ms;animation-delay:167ms}.ms-u-delay200[data-v-4979d51c]{-webkit-animation-delay:267ms;animation-delay:267ms}.ms-MessageBanner[data-v-4979d51c]{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;color:\"[theme:neutralPrimary, default: #333333]\";font-size:12px;font-weight:400;position:relative;border-bottom:1px solid \"[theme:neutralSecondaryAlt, default: #767676]\";background-color:\"[theme:themeLighterAlt, default: #eff6fc]\";min-width:320px;width:100%;height:52px;text-align:center;overflow:hidden;-webkit-animation-name:fadeIn-data-v-4979d51c,slideDownIn20-data-v-4979d51c;-moz-animation-name:fadeIn-data-v-4979d51c,slideDownIn20-data-v-4979d51c;-ms-animation-name:fadeIn-data-v-4979d51c,slideDownIn20-data-v-4979d51c;-o-animation-name:fadeIn-data-v-4979d51c,slideDownIn20-data-v-4979d51c;animation-name:fadeIn-data-v-4979d51c,slideDownIn20-data-v-4979d51c;-webkit-animation-duration:367ms;-moz-animation-duration:367ms;-ms-animation-duration:367ms;-o-animation-duration:367ms;-webkit-animation-timing-function:cubic-bezier(.1,.9,.2,1);-moz-animation-timing-function:cubic-bezier(.1,.9,.2,1);-ms-animation-timing-function:cubic-bezier(.1,.9,.2,1);-o-animation-timing-function:cubic-bezier(.1,.9,.2,1);animation-timing-function:cubic-bezier(.1,.9,.2,1);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}.ms-MessageBanner .ms-Icon[data-v-4979d51c]{font-size:16px}.ms-MessageBanner.hide[data-v-4979d51c]{-webkit-animation-name:fadeOut-data-v-4979d51c,slideUpOut20-data-v-4979d51c;-moz-animation-name:fadeOut-data-v-4979d51c,slideUpOut20-data-v-4979d51c;-ms-animation-name:fadeOut-data-v-4979d51c,slideUpOut20-data-v-4979d51c;-o-animation-name:fadeOut-data-v-4979d51c,slideUpOut20-data-v-4979d51c;animation-name:fadeOut-data-v-4979d51c,slideUpOut20-data-v-4979d51c;-webkit-animation-duration:167ms;-moz-animation-duration:167ms;-ms-animation-duration:167ms;-o-animation-duration:167ms;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-moz-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-ms-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-o-animation-timing-function:cubic-bezier(.1,.25,.75,.9);animation-timing-function:cubic-bezier(.1,.25,.75,.9);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}.ms-MessageBanner.is-hidden[data-v-4979d51c]{display:none}.ms-MessageBanner-close[data-v-4979d51c],.ms-MessageBanner-expand[data-v-4979d51c]{height:52px;width:40px;cursor:pointer;border:0;background-color:transparent}.ms-MessageBanner-close[data-v-4979d51c]{position:absolute;right:0;top:0;line-height:52px;color:\"[theme:neutralSecondary, default: #666666]\"}.ms-MessageBanner-text[data-v-4979d51c]{display:inline-block;padding:18px 0;margin-left:0;max-width:770px;overflow:hidden;text-align:left}.ms-MessageBanner-expand[data-v-4979d51c]{display:none;vertical-align:top}.ms-MessageBanner-expand.is-visible[data-v-4979d51c]{display:inline-block}.ms-MessageBanner-action[data-v-4979d51c]{display:inline-block;vertical-align:top;margin-top:10px;margin-left:10px;padding-right:36px}.ms-MessageBanner-action .ms-Button[data-v-4979d51c]{color:\"[theme:white, default: #ffffff]\"}.ms-MessageBanner-clipper[data-v-4979d51c]{overflow:hidden;white-space:nowrap;text-overflow:ellipsis;display:inline-block;vertical-align:top}.ms-MessageBanner.is-expanded[data-v-4979d51c]{height:auto}.ms-MessageBanner.is-expanded .ms-MessageBanner-clipper[data-v-4979d51c]{white-space:normal}@media screen and (max-width:479px){.ms-MessageBanner-action[data-v-4979d51c]{margin:0;display:block;text-align:right;padding:0 10px 10px 0}.ms-MessageBanner-text[data-v-4979d51c]{margin-left:-25px;padding:18px 0 10px;min-width:240px}.ms-MessageBanner-expand[data-v-4979d51c]{display:inline-block;padding:0;margin-left:-5px;width:20px}.ms-MessageBanner-expand .ms-Icon[data-v-4979d51c]{color:\"[theme:themePrimary, default: #0078d7]\"}}@font-face{font-family:FabricMDL2Icons-a13498cf;src:url(https://spoprod-a.akamaihd.net/files/fabric/assets/icons/fabric-icons-a13498cf.woff) format(\"woff\")}.ms-Icon[data-v-4979d51c]{display:inline-block;font-style:normal;font-weight:400}.ms-Icon.ms-Icon--Clear[data-v-4979d51c]::before{font-family:FabricMDL2Icons-a13498cf;content:\"\"}", map: undefined, media: undefined });

    };
    /* scoped */
    const __vue_scope_id__$D = "data-v-4979d51c";
    /* module identifier */
    const __vue_module_identifier__$D = undefined;
    /* functional template */
    const __vue_is_functional_template__$D = false;
    /* style inject */
    const __vue_create_injector__$f = function(context){ 
                  return function(scopeId, data)
                  {
                      if(window['wizstyle-'+scopeId])
                          return;
                      if(__vue_script__$D.loadStyles)
                          __vue_script__$D.loadStyles(data.source);
                      window['wizstyle-'+scopeId]=true;
                  }
              };
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var uiMessageBanner = normalizeComponent(
      { render: __vue_render__$n, staticRenderFns: __vue_staticRenderFns__$n },
      __vue_inject_styles__$D,
      __vue_script__$D,
      __vue_scope_id__$D,
      __vue_is_functional_template__$D,
      __vue_module_identifier__$D,
      false,
      __vue_create_injector__$f,
      undefined,
      undefined
    );

  var script$E = {
    name: 'ou-overlay',
    mixins: [type('dark')],
    props: {
      value: Boolean
    },
    data: function data() {
      return {
        overlayInstance: null
      };
    },
    watch: {
      value: function value() {
        this.setOverlayVisibility();
      }
    },
    computed: {
      overlayClass: function overlayClass() {
        return _defineProperty({}, "ms-Overlay--".concat(this.type), !!this.type);
      }
    },
    mounted: function mounted() {
      this.overlayInstance = new this.$fabric.Overlay(this.$refs.overlay);
      this.setOverlayVisibility();
      this.bindOverlayCloseEvent();
    },
    methods: {
      setOverlayVisibility: function setOverlayVisibility() {
        this.value ? this.overlayInstance.show() : this.overlayInstance.hide();
      },
      bindOverlayCloseEvent: function bindOverlayCloseEvent() {
        var _this = this;

        // Because the overlay component don't have callback when overlay closed,
        // So add a click event when click the overlay to set the value to false
        var overlayElement = this.$refs.overlay;

        var closeOverlay = function closeOverlay() {
          _this.$emit('input', false);
        };

        overlayElement.addEventListener('click', closeOverlay);
      }
    }
  };

  /* script */
  const __vue_script__$E = script$E;

  /* template */
  var __vue_render__$o = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{ref:"overlay",staticClass:"ms-Overlay",class:_vm.overlayClass})};
  var __vue_staticRenderFns__$o = [];

    /* style */
    const __vue_inject_styles__$E = undefined;
    /* scoped */
    const __vue_scope_id__$E = undefined;
    /* module identifier */
    const __vue_module_identifier__$E = undefined;
    /* functional template */
    const __vue_is_functional_template__$E = false;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var overlay = normalizeComponent(
      { render: __vue_render__$o, staticRenderFns: __vue_staticRenderFns__$o },
      __vue_inject_styles__$E,
      __vue_script__$E,
      __vue_scope_id__$E,
      __vue_is_functional_template__$E,
      __vue_module_identifier__$E,
      false,
      undefined,
      undefined,
      undefined
    );

  var script$F = {
    loadStyles: loadThemedStyles.loadStyles,
    beforeMount: function beforeMount() {
      this.$fabric = {
        Overlay: Overlay
      };
    },
    // watch:{
    //     useDarkOverlay:{
    //         handler(newVal){
    //         },
    //         immediate : true
    //     }
    // },
    // props : {
    //     useDarkOverlay: Boolean
    // },
    extends: overlay
  };

  /* script */
  const __vue_script__$F = script$F;

  /* template */

    /* style */
    const __vue_inject_styles__$F = function (inject) {
      if (!inject) return
      inject("data-v-4b14bf22_0", { source: ".ms-Overlay[data-v-4b14bf22]{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;background-color:\"[theme:whiteTranslucent40, default: rgba(255,255,255,.4)]\";position:fixed;bottom:0;left:0;right:0;top:0;z-index:0;display:none}.ms-Overlay.is-visible[data-v-4b14bf22]{display:block}.ms-Overlay--dark[data-v-4b14bf22]{background-color:\"[theme:blackTranslucent40, default: rgba(0,0,0,.4)]\"}.ms-u-overflowHidden[data-v-4b14bf22]{overflow:hidden}", map: undefined, media: undefined });

    };
    /* scoped */
    const __vue_scope_id__$F = "data-v-4b14bf22";
    /* module identifier */
    const __vue_module_identifier__$F = undefined;
    /* functional template */
    const __vue_is_functional_template__$F = undefined;
    /* style inject */
    const __vue_create_injector__$g = function(context){ 
                  return function(scopeId, data)
                  {
                      if(window['wizstyle-'+scopeId])
                          return;
                      if(__vue_script__$F.loadStyles)
                          __vue_script__$F.loadStyles(data.source);
                      window['wizstyle-'+scopeId]=true;
                  }
              };
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var uiOverlay = normalizeComponent(
      {},
      __vue_inject_styles__$F,
      __vue_script__$F,
      __vue_scope_id__$F,
      __vue_is_functional_template__$F,
      __vue_module_identifier__$F,
      false,
      __vue_create_injector__$g,
      undefined,
      undefined
    );

  function size () {
    for (var _len = arguments.length, size = new Array(_len), _key = 0; _key < _len; _key++) {
      size[_key] = arguments[_key];
    }

    size.push('');
    return {
      props: {
        size: {
          type: String,
          default: '',
          validator: function validator(value) {
            return size.indexOf(value) !== -1;
          }
        }
      }
    };
  }

  var script$G = {
    name: 'ou-panel',
    mixins: [size('md', 'lg', 'xl', 'xxl')],
    props: {
      value: Boolean,
      title: String,
      fixed: {
        type: Boolean,
        default: false
      },
      left: {
        type: Boolean,
        default: false
      },
      block: {
        type: Boolean,
        default: false
      }
    },
    data: function data() {
      return {
        panelInstance: null
      };
    },
    watch: {
      value: function value() {
        this.setPanelVisibility();
      }
    },
    computed: {
      panelClass: function panelClass() {
        var _ref;

        return _ref = {}, _defineProperty(_ref, "ms-Panel--".concat(this.size), !!this.size), _defineProperty(_ref, 'ms-Panel--fixed', this.fixed), _defineProperty(_ref, 'ms-Panel--left', this.left), _ref;
      }
    },
    mounted: function mounted() {
      this.setPanelVisibility();
    },
    methods: {
      setPanelVisibility: function setPanelVisibility() {
        if (this.value) {
          this.panelInstance = new this.$fabric.Panel(this.$refs.panel);
          this.bindOverlayCloseEvent();
        } else if (this.panelInstance) {
          this.panelInstance.dismiss();
        }
      },
      // Because the office ui fabric js don't support on_close or on_open event in panel
      // component, So I have to write some hacking code to change the visible status when
      // click the overlay. Otherwise the visible status can't change, when click the overlay
      // to close the panel.
      bindOverlayCloseEvent: function bindOverlayCloseEvent() {
        var overlayElement = this.panelInstance.panelHost.overlay.overlayElement;

        if (this.block) {
          // Remove overlayElement to avoid close panel when click overlay.
          overlayElement.remove();
        } else {
          overlayElement.addEventListener('click', this.closePanel);
        }
      },
      closePanel: function closePanel() {
        this.$emit('input', false); // Because the panel overlay have event to fire dismiss method when click it to
        // close panel. To prevent fire the panel dismiss method again and raise some error,
        // so set the panelInstance to null

        this.panelInstance = null;
      }
    }
  };

  /* script */
  const __vue_script__$G = script$G;

  /* template */
  var __vue_render__$p = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{ref:"panel",staticClass:"ms-Panel",class:_vm.panelClass},[_c('button',{staticClass:"ms-Panel-closeButton ms-PanelAction-close",on:{"click":_vm.closePanel}},[_c('i',{staticClass:"ms-Panel-closeIcon ms-Icon ms-Icon--Cancel"})]),_vm._v(" "),_c('div',{staticClass:"ms-Panel-contentInner"},[_c('p',{staticClass:"ms-Panel-headerText"},[_vm._v(_vm._s(_vm.title))]),_vm._v(" "),_c('div',{staticClass:"ms-Panel-content"},[_vm._t("default")],2)])])};
  var __vue_staticRenderFns__$p = [];

    /* style */
    const __vue_inject_styles__$G = undefined;
    /* scoped */
    const __vue_scope_id__$G = undefined;
    /* module identifier */
    const __vue_module_identifier__$G = undefined;
    /* functional template */
    const __vue_is_functional_template__$G = false;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var panel = normalizeComponent(
      { render: __vue_render__$p, staticRenderFns: __vue_staticRenderFns__$p },
      __vue_inject_styles__$G,
      __vue_script__$G,
      __vue_scope_id__$G,
      __vue_is_functional_template__$G,
      __vue_module_identifier__$G,
      false,
      undefined,
      undefined,
      undefined
    );

  var script$H = {
    loadStyles: loadThemedStyles.loadStyles,
    beforeMount: function beforeMount() {
      this.$fabric = {
        Panel: Panel
      };
    },
    watch: {
      value: function value(newVal) {
        if (newVal) {
          this.panelInstance.panelHost.overlay.overlayElement.setAttribute(this.$options._scopeId, "");
        }
      }
    },
    beforeDestroy: function beforeDestroy() {
      if (this.panelInstance != null) this.panelInstance.dismiss();
    },
    extends: panel
  };

  /* script */
  const __vue_script__$H = script$H;

  /* template */

    /* style */
    const __vue_inject_styles__$H = function (inject) {
      if (!inject) return
      inject("data-v-0930174c_0", { source: "@charset \"UTF-8\";.ms-u-slideRightIn10[data-v-0930174c]{-webkit-animation-name:fadeIn-data-v-0930174c,slideRightIn10-data-v-0930174c;-moz-animation-name:fadeIn-data-v-0930174c,slideRightIn10-data-v-0930174c;-ms-animation-name:fadeIn-data-v-0930174c,slideRightIn10-data-v-0930174c;-o-animation-name:fadeIn-data-v-0930174c,slideRightIn10-data-v-0930174c;animation-name:fadeIn-data-v-0930174c,slideRightIn10-data-v-0930174c;-webkit-animation-duration:367ms;-moz-animation-duration:367ms;-ms-animation-duration:367ms;-o-animation-duration:367ms;-webkit-animation-timing-function:cubic-bezier(.1,.9,.2,1);-moz-animation-timing-function:cubic-bezier(.1,.9,.2,1);-ms-animation-timing-function:cubic-bezier(.1,.9,.2,1);-o-animation-timing-function:cubic-bezier(.1,.9,.2,1);animation-timing-function:cubic-bezier(.1,.9,.2,1);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideRightIn10-data-v-0930174c{from{-webkit-transform:translate3d(-10px,0,0)}to{-webkit-transform:translate3d(0,0,0)}}@keyframes slideRightIn10-data-v-0930174c{from{transform:translate3d(-10px,0,0)}to{transform:translate3d(0,0,0)}}.ms-u-slideRightIn20[data-v-0930174c]{-webkit-animation-name:fadeIn-data-v-0930174c,slideRightIn20-data-v-0930174c;-moz-animation-name:fadeIn-data-v-0930174c,slideRightIn20-data-v-0930174c;-ms-animation-name:fadeIn-data-v-0930174c,slideRightIn20-data-v-0930174c;-o-animation-name:fadeIn-data-v-0930174c,slideRightIn20-data-v-0930174c;animation-name:fadeIn-data-v-0930174c,slideRightIn20-data-v-0930174c;-webkit-animation-duration:367ms;-moz-animation-duration:367ms;-ms-animation-duration:367ms;-o-animation-duration:367ms;-webkit-animation-timing-function:cubic-bezier(.1,.9,.2,1);-moz-animation-timing-function:cubic-bezier(.1,.9,.2,1);-ms-animation-timing-function:cubic-bezier(.1,.9,.2,1);-o-animation-timing-function:cubic-bezier(.1,.9,.2,1);animation-timing-function:cubic-bezier(.1,.9,.2,1);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideRightIn20-data-v-0930174c{from{-webkit-transform:translate3d(-20px,0,0)}to{-webkit-transform:translate3d(0,0,0)}}@keyframes slideRightIn20-data-v-0930174c{from{transform:translate3d(-20px,0,0)}to{transform:translate3d(0,0,0)}}.ms-u-slideRightIn40[data-v-0930174c]{-webkit-animation-name:fadeIn-data-v-0930174c,slideRightIn40-data-v-0930174c;-moz-animation-name:fadeIn-data-v-0930174c,slideRightIn40-data-v-0930174c;-ms-animation-name:fadeIn-data-v-0930174c,slideRightIn40-data-v-0930174c;-o-animation-name:fadeIn-data-v-0930174c,slideRightIn40-data-v-0930174c;animation-name:fadeIn-data-v-0930174c,slideRightIn40-data-v-0930174c;-webkit-animation-duration:367ms;-moz-animation-duration:367ms;-ms-animation-duration:367ms;-o-animation-duration:367ms;-webkit-animation-timing-function:cubic-bezier(.1,.9,.2,1);-moz-animation-timing-function:cubic-bezier(.1,.9,.2,1);-ms-animation-timing-function:cubic-bezier(.1,.9,.2,1);-o-animation-timing-function:cubic-bezier(.1,.9,.2,1);animation-timing-function:cubic-bezier(.1,.9,.2,1);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideRightIn40-data-v-0930174c{from{-webkit-transform:translate3d(-40px,0,0)}to{-webkit-transform:translate3d(0,0,0)}}@keyframes slideRightIn40-data-v-0930174c{from{transform:translate3d(-40px,0,0)}to{transform:translate3d(0,0,0)}}.ms-u-slideLeftIn10[data-v-0930174c]{-webkit-animation-name:fadeIn-data-v-0930174c,slideLeftIn10-data-v-0930174c;-moz-animation-name:fadeIn-data-v-0930174c,slideLeftIn10-data-v-0930174c;-ms-animation-name:fadeIn-data-v-0930174c,slideLeftIn10-data-v-0930174c;-o-animation-name:fadeIn-data-v-0930174c,slideLeftIn10-data-v-0930174c;animation-name:fadeIn-data-v-0930174c,slideLeftIn10-data-v-0930174c;-webkit-animation-duration:367ms;-moz-animation-duration:367ms;-ms-animation-duration:367ms;-o-animation-duration:367ms;-webkit-animation-timing-function:cubic-bezier(.1,.9,.2,1);-moz-animation-timing-function:cubic-bezier(.1,.9,.2,1);-ms-animation-timing-function:cubic-bezier(.1,.9,.2,1);-o-animation-timing-function:cubic-bezier(.1,.9,.2,1);animation-timing-function:cubic-bezier(.1,.9,.2,1);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideLeftIn10-data-v-0930174c{from{-webkit-transform:translate3d(10px,0,0)}to{-webkit-transform:translate3d(0,0,0)}}@keyframes slideLeftIn10-data-v-0930174c{from{transform:translate3d(10px,0,0)}to{transform:translate3d(0,0,0)}}.ms-u-slideLeftIn20[data-v-0930174c]{-webkit-animation-name:fadeIn-data-v-0930174c,slideLeftIn20-data-v-0930174c;-moz-animation-name:fadeIn-data-v-0930174c,slideLeftIn20-data-v-0930174c;-ms-animation-name:fadeIn-data-v-0930174c,slideLeftIn20-data-v-0930174c;-o-animation-name:fadeIn-data-v-0930174c,slideLeftIn20-data-v-0930174c;animation-name:fadeIn-data-v-0930174c,slideLeftIn20-data-v-0930174c;-webkit-animation-duration:367ms;-moz-animation-duration:367ms;-ms-animation-duration:367ms;-o-animation-duration:367ms;-webkit-animation-timing-function:cubic-bezier(.1,.9,.2,1);-moz-animation-timing-function:cubic-bezier(.1,.9,.2,1);-ms-animation-timing-function:cubic-bezier(.1,.9,.2,1);-o-animation-timing-function:cubic-bezier(.1,.9,.2,1);animation-timing-function:cubic-bezier(.1,.9,.2,1);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideLeftIn20-data-v-0930174c{from{-webkit-transform:translate3d(20px,0,0)}to{-webkit-transform:translate3d(0,0,0)}}@keyframes slideLeftIn20-data-v-0930174c{from{transform:translate3d(20px,0,0)}to{transform:translate3d(0,0,0)}}.ms-u-slideLeftIn40[data-v-0930174c]{-webkit-animation-name:fadeIn-data-v-0930174c,slideLeftIn40-data-v-0930174c;-moz-animation-name:fadeIn-data-v-0930174c,slideLeftIn40-data-v-0930174c;-ms-animation-name:fadeIn-data-v-0930174c,slideLeftIn40-data-v-0930174c;-o-animation-name:fadeIn-data-v-0930174c,slideLeftIn40-data-v-0930174c;animation-name:fadeIn-data-v-0930174c,slideLeftIn40-data-v-0930174c;-webkit-animation-duration:367ms;-moz-animation-duration:367ms;-ms-animation-duration:367ms;-o-animation-duration:367ms;-webkit-animation-timing-function:cubic-bezier(.1,.9,.2,1);-moz-animation-timing-function:cubic-bezier(.1,.9,.2,1);-ms-animation-timing-function:cubic-bezier(.1,.9,.2,1);-o-animation-timing-function:cubic-bezier(.1,.9,.2,1);animation-timing-function:cubic-bezier(.1,.9,.2,1);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideLeftIn40-data-v-0930174c{from{-webkit-transform:translate3d(40px,0,0)}to{-webkit-transform:translate3d(0,0,0)}}@keyframes slideLeftIn40-data-v-0930174c{from{transform:translate3d(40px,0,0)}to{transform:translate3d(0,0,0)}}.ms-u-slideRightIn400[data-v-0930174c]{-webkit-animation-name:fadeIn-data-v-0930174c,slideRightIn400-data-v-0930174c;-moz-animation-name:fadeIn-data-v-0930174c,slideRightIn400-data-v-0930174c;-ms-animation-name:fadeIn-data-v-0930174c,slideRightIn400-data-v-0930174c;-o-animation-name:fadeIn-data-v-0930174c,slideRightIn400-data-v-0930174c;animation-name:fadeIn-data-v-0930174c,slideRightIn400-data-v-0930174c;-webkit-animation-duration:367ms;-moz-animation-duration:367ms;-ms-animation-duration:367ms;-o-animation-duration:367ms;-webkit-animation-timing-function:cubic-bezier(.1,.9,.2,1);-moz-animation-timing-function:cubic-bezier(.1,.9,.2,1);-ms-animation-timing-function:cubic-bezier(.1,.9,.2,1);-o-animation-timing-function:cubic-bezier(.1,.9,.2,1);animation-timing-function:cubic-bezier(.1,.9,.2,1);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideRightIn400-data-v-0930174c{from{-webkit-transform:translate3d(-400px,0,0)}to{-webkit-transform:translate3d(0,0,0)}}@keyframes slideRightIn400-data-v-0930174c{from{transform:translate3d(-400px,0,0)}to{transform:translate3d(0,0,0)}}.ms-u-slideLeftIn400[data-v-0930174c]{-webkit-animation-name:fadeIn-data-v-0930174c,slideLeft400-data-v-0930174c;-moz-animation-name:fadeIn-data-v-0930174c,slideLeft400-data-v-0930174c;-ms-animation-name:fadeIn-data-v-0930174c,slideLeft400-data-v-0930174c;-o-animation-name:fadeIn-data-v-0930174c,slideLeft400-data-v-0930174c;animation-name:fadeIn-data-v-0930174c,slideLeft400-data-v-0930174c;-webkit-animation-duration:367ms;-moz-animation-duration:367ms;-ms-animation-duration:367ms;-o-animation-duration:367ms;-webkit-animation-timing-function:cubic-bezier(.1,.9,.2,1);-moz-animation-timing-function:cubic-bezier(.1,.9,.2,1);-ms-animation-timing-function:cubic-bezier(.1,.9,.2,1);-o-animation-timing-function:cubic-bezier(.1,.9,.2,1);animation-timing-function:cubic-bezier(.1,.9,.2,1);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideLeft400-data-v-0930174c{from{-webkit-transform:translate3d(400px,0,0)}to{-webkit-transform:translate3d(0,0,0)}}@keyframes slideLeft400-data-v-0930174c{from{transform:translate3d(400px,0,0)}to{transform:translate3d(0,0,0)}}.ms-u-slideUpIn20[data-v-0930174c]{-webkit-animation-name:fadeIn-data-v-0930174c,slideUpIn20-data-v-0930174c;-moz-animation-name:fadeIn-data-v-0930174c,slideUpIn20-data-v-0930174c;-ms-animation-name:fadeIn-data-v-0930174c,slideUpIn20-data-v-0930174c;-o-animation-name:fadeIn-data-v-0930174c,slideUpIn20-data-v-0930174c;animation-name:fadeIn-data-v-0930174c,slideUpIn20-data-v-0930174c;-webkit-animation-duration:367ms;-moz-animation-duration:367ms;-ms-animation-duration:367ms;-o-animation-duration:367ms;-webkit-animation-timing-function:cubic-bezier(.1,.9,.2,1);-moz-animation-timing-function:cubic-bezier(.1,.9,.2,1);-ms-animation-timing-function:cubic-bezier(.1,.9,.2,1);-o-animation-timing-function:cubic-bezier(.1,.9,.2,1);animation-timing-function:cubic-bezier(.1,.9,.2,1);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideUpIn20-data-v-0930174c{from{-webkit-transform:translate3d(0,20px,0)}to{-webkit-transform:translate3d(0,0,0)}}@keyframes slideUpIn20-data-v-0930174c{from{transform:translate3d(0,20px,0)}to{transform:translate3d(0,0,0)}}.ms-u-slideUpIn10[data-v-0930174c]{-webkit-animation-name:fadeIn-data-v-0930174c,slideUpIn10-data-v-0930174c;-moz-animation-name:fadeIn-data-v-0930174c,slideUpIn10-data-v-0930174c;-ms-animation-name:fadeIn-data-v-0930174c,slideUpIn10-data-v-0930174c;-o-animation-name:fadeIn-data-v-0930174c,slideUpIn10-data-v-0930174c;animation-name:fadeIn-data-v-0930174c,slideUpIn10-data-v-0930174c;-webkit-animation-duration:167ms;-moz-animation-duration:167ms;-ms-animation-duration:167ms;-o-animation-duration:167ms;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-moz-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-ms-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-o-animation-timing-function:cubic-bezier(.1,.25,.75,.9);animation-timing-function:cubic-bezier(.1,.25,.75,.9);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideUpIn10-data-v-0930174c{from{-webkit-transform:translate3d(0,10px,0)}to{-webkit-transform:translate3d(0,0,0)}}@keyframes slideUpIn10-data-v-0930174c{from{transform:translate3d(0,10px,0)}to{transform:translate3d(0,0,0)}}.ms-u-slideDownIn20[data-v-0930174c]{-webkit-animation-name:fadeIn-data-v-0930174c,slideDownIn20-data-v-0930174c;-moz-animation-name:fadeIn-data-v-0930174c,slideDownIn20-data-v-0930174c;-ms-animation-name:fadeIn-data-v-0930174c,slideDownIn20-data-v-0930174c;-o-animation-name:fadeIn-data-v-0930174c,slideDownIn20-data-v-0930174c;animation-name:fadeIn-data-v-0930174c,slideDownIn20-data-v-0930174c;-webkit-animation-duration:367ms;-moz-animation-duration:367ms;-ms-animation-duration:367ms;-o-animation-duration:367ms;-webkit-animation-timing-function:cubic-bezier(.1,.9,.2,1);-moz-animation-timing-function:cubic-bezier(.1,.9,.2,1);-ms-animation-timing-function:cubic-bezier(.1,.9,.2,1);-o-animation-timing-function:cubic-bezier(.1,.9,.2,1);animation-timing-function:cubic-bezier(.1,.9,.2,1);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideDownIn20-data-v-0930174c{from{-webkit-transform:translate3d(0,-20px,0)}to{-webkit-transform:translate3d(0,0,0)}}@keyframes slideDownIn20-data-v-0930174c{from{transform:translate3d(0,-20px,0)}to{transform:translate3d(0,0,0)}}.ms-u-slideDownIn10[data-v-0930174c]{-webkit-animation-name:fadeIn-data-v-0930174c,slideDownIn10-data-v-0930174c;-moz-animation-name:fadeIn-data-v-0930174c,slideDownIn10-data-v-0930174c;-ms-animation-name:fadeIn-data-v-0930174c,slideDownIn10-data-v-0930174c;-o-animation-name:fadeIn-data-v-0930174c,slideDownIn10-data-v-0930174c;animation-name:fadeIn-data-v-0930174c,slideDownIn10-data-v-0930174c;-webkit-animation-duration:167ms;-moz-animation-duration:167ms;-ms-animation-duration:167ms;-o-animation-duration:167ms;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-moz-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-ms-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-o-animation-timing-function:cubic-bezier(.1,.25,.75,.9);animation-timing-function:cubic-bezier(.1,.25,.75,.9);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideDownIn10-data-v-0930174c{from{-webkit-transform:translate3d(0,-10px,0)}to{-webkit-transform:translate3d(0,0,0)}}@keyframes slideDownIn10-data-v-0930174c{from{transform:translate3d(0,-10px,0)}to{transform:translate3d(0,0,0)}}.ms-u-slideRightOut40[data-v-0930174c]{-webkit-animation-name:fadeOut-data-v-0930174c,slideRightOut40-data-v-0930174c;-moz-animation-name:fadeOut-data-v-0930174c,slideRightOut40-data-v-0930174c;-ms-animation-name:fadeOut-data-v-0930174c,slideRightOut40-data-v-0930174c;-o-animation-name:fadeOut-data-v-0930174c,slideRightOut40-data-v-0930174c;animation-name:fadeOut-data-v-0930174c,slideRightOut40-data-v-0930174c;-webkit-animation-duration:167ms;-moz-animation-duration:167ms;-ms-animation-duration:167ms;-o-animation-duration:167ms;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-moz-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-ms-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-o-animation-timing-function:cubic-bezier(.1,.25,.75,.9);animation-timing-function:cubic-bezier(.1,.25,.75,.9);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideRightOut40-data-v-0930174c{from{-webkit-transform:translate3d(0,0,0)}to{-webkit-transform:translate3d(40px,0,0)}}@keyframes slideRightOut40-data-v-0930174c{from{transform:translate3d(0,0,0)}to{transform:translate3d(40px,0,0)}}.ms-u-slideLeftOut40[data-v-0930174c]{-webkit-animation-name:fadeOut-data-v-0930174c,slideLeftOut40-data-v-0930174c;-moz-animation-name:fadeOut-data-v-0930174c,slideLeftOut40-data-v-0930174c;-ms-animation-name:fadeOut-data-v-0930174c,slideLeftOut40-data-v-0930174c;-o-animation-name:fadeOut-data-v-0930174c,slideLeftOut40-data-v-0930174c;animation-name:fadeOut-data-v-0930174c,slideLeftOut40-data-v-0930174c;-webkit-animation-duration:167ms;-moz-animation-duration:167ms;-ms-animation-duration:167ms;-o-animation-duration:167ms;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-moz-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-ms-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-o-animation-timing-function:cubic-bezier(.1,.25,.75,.9);animation-timing-function:cubic-bezier(.1,.25,.75,.9);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideLeftOut40-data-v-0930174c{from{-webkit-transform:translate3d(0,0,0)}to{-webkit-transform:translate3d(-40px,0,0)}}@keyframes slideLeftOut40-data-v-0930174c{from{transform:translate3d(0,0,0)}to{transform:translate3d(-40px,0,0)}}.ms-u-slideRightOut400[data-v-0930174c]{-webkit-animation-name:fadeOut-data-v-0930174c,slideRightOut400-data-v-0930174c;-moz-animation-name:fadeOut-data-v-0930174c,slideRightOut400-data-v-0930174c;-ms-animation-name:fadeOut-data-v-0930174c,slideRightOut400-data-v-0930174c;-o-animation-name:fadeOut-data-v-0930174c,slideRightOut400-data-v-0930174c;animation-name:fadeOut-data-v-0930174c,slideRightOut400-data-v-0930174c;-webkit-animation-duration:167ms;-moz-animation-duration:167ms;-ms-animation-duration:167ms;-o-animation-duration:167ms;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-moz-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-ms-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-o-animation-timing-function:cubic-bezier(.1,.25,.75,.9);animation-timing-function:cubic-bezier(.1,.25,.75,.9);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideRightOut400-data-v-0930174c{from{-webkit-transform:translate3d(0,0,0)}to{-webkit-transform:translate3d(400px,0,0)}}@keyframes slideRightOut400-data-v-0930174c{from{transform:translate3d(0,0,0)}to{transform:translate3d(400px,0,0)}}.ms-u-slideLeftOut400[data-v-0930174c]{-webkit-animation-name:fadeOut-data-v-0930174c,slideLeftOut400-data-v-0930174c;-moz-animation-name:fadeOut-data-v-0930174c,slideLeftOut400-data-v-0930174c;-ms-animation-name:fadeOut-data-v-0930174c,slideLeftOut400-data-v-0930174c;-o-animation-name:fadeOut-data-v-0930174c,slideLeftOut400-data-v-0930174c;animation-name:fadeOut-data-v-0930174c,slideLeftOut400-data-v-0930174c;-webkit-animation-duration:167ms;-moz-animation-duration:167ms;-ms-animation-duration:167ms;-o-animation-duration:167ms;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-moz-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-ms-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-o-animation-timing-function:cubic-bezier(.1,.25,.75,.9);animation-timing-function:cubic-bezier(.1,.25,.75,.9);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideLeftOut400-data-v-0930174c{from{-webkit-transform:translate3d(0,0,0)}to{-webkit-transform:translate3d(-400px,0,0)}}@keyframes slideLeftOut400-data-v-0930174c{from{transform:translate3d(0,0,0)}to{transform:translate3d(-400px,0,0)}}.ms-u-slideUpOut20[data-v-0930174c]{-webkit-animation-name:fadeOut-data-v-0930174c,slideUpOut20-data-v-0930174c;-moz-animation-name:fadeOut-data-v-0930174c,slideUpOut20-data-v-0930174c;-ms-animation-name:fadeOut-data-v-0930174c,slideUpOut20-data-v-0930174c;-o-animation-name:fadeOut-data-v-0930174c,slideUpOut20-data-v-0930174c;animation-name:fadeOut-data-v-0930174c,slideUpOut20-data-v-0930174c;-webkit-animation-duration:167ms;-moz-animation-duration:167ms;-ms-animation-duration:167ms;-o-animation-duration:167ms;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-moz-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-ms-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-o-animation-timing-function:cubic-bezier(.1,.25,.75,.9);animation-timing-function:cubic-bezier(.1,.25,.75,.9);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideUpOut20-data-v-0930174c{from{-webkit-transform:translate3d(0,0,0)}to{-webkit-transform:translate3d(0,-20px,0)}}@keyframes slideUpOut20-data-v-0930174c{from{transform:translate3d(0,0,0)}to{transform:translate3d(0,-20px,0)}}.ms-u-slideUpOut10[data-v-0930174c]{-webkit-animation-name:fadeOut-data-v-0930174c,slideUpOut10-data-v-0930174c;-moz-animation-name:fadeOut-data-v-0930174c,slideUpOut10-data-v-0930174c;-ms-animation-name:fadeOut-data-v-0930174c,slideUpOut10-data-v-0930174c;-o-animation-name:fadeOut-data-v-0930174c,slideUpOut10-data-v-0930174c;animation-name:fadeOut-data-v-0930174c,slideUpOut10-data-v-0930174c;-webkit-animation-duration:167ms;-moz-animation-duration:167ms;-ms-animation-duration:167ms;-o-animation-duration:167ms;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-moz-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-ms-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-o-animation-timing-function:cubic-bezier(.1,.25,.75,.9);animation-timing-function:cubic-bezier(.1,.25,.75,.9);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideUpOut10-data-v-0930174c{from{-webkit-transform:translate3d(0,0,0)}to{-webkit-transform:translate3d(0,-10px,0)}}@keyframes slideUpOut10-data-v-0930174c{from{transform:translate3d(0,0,0)}to{transform:translate3d(0,-10px,0)}}.ms-u-slideDownOut20[data-v-0930174c]{-webkit-animation-name:fadeOut-data-v-0930174c,slideDownOut20-data-v-0930174c;-moz-animation-name:fadeOut-data-v-0930174c,slideDownOut20-data-v-0930174c;-ms-animation-name:fadeOut-data-v-0930174c,slideDownOut20-data-v-0930174c;-o-animation-name:fadeOut-data-v-0930174c,slideDownOut20-data-v-0930174c;animation-name:fadeOut-data-v-0930174c,slideDownOut20-data-v-0930174c;-webkit-animation-duration:167ms;-moz-animation-duration:167ms;-ms-animation-duration:167ms;-o-animation-duration:167ms;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-moz-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-ms-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-o-animation-timing-function:cubic-bezier(.1,.25,.75,.9);animation-timing-function:cubic-bezier(.1,.25,.75,.9);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideDownOut20-data-v-0930174c{from{-webkit-transform:translate3d(0,0,0)}to{-webkit-transform:translate3d(0,20px,0)}}@keyframes slideDownOut20-data-v-0930174c{from{transform:translate3d(0,0,0)}to{transform:translate3d(0,20px,0)}}.ms-u-slideDownOut10[data-v-0930174c]{-webkit-animation-name:fadeOut-data-v-0930174c,slideDownOut10-data-v-0930174c;-moz-animation-name:fadeOut-data-v-0930174c,slideDownOut10-data-v-0930174c;-ms-animation-name:fadeOut-data-v-0930174c,slideDownOut10-data-v-0930174c;-o-animation-name:fadeOut-data-v-0930174c,slideDownOut10-data-v-0930174c;animation-name:fadeOut-data-v-0930174c,slideDownOut10-data-v-0930174c;-webkit-animation-duration:167ms;-moz-animation-duration:167ms;-ms-animation-duration:167ms;-o-animation-duration:167ms;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-moz-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-ms-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-o-animation-timing-function:cubic-bezier(.1,.25,.75,.9);animation-timing-function:cubic-bezier(.1,.25,.75,.9);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes slideDownOut10-data-v-0930174c{from{-webkit-transform:translate3d(0,0,0)}to{-webkit-transform:translate3d(0,10px,0)}}@keyframes slideDownOut10-data-v-0930174c{from{transform:translate3d(0,0,0)}to{transform:translate3d(0,10px,0)}}.ms-u-scaleUpIn100[data-v-0930174c]{-webkit-animation-name:fadeIn-data-v-0930174c,scaleUp100-data-v-0930174c;-moz-animation-name:fadeIn-data-v-0930174c,scaleUp100-data-v-0930174c;-ms-animation-name:fadeIn-data-v-0930174c,scaleUp100-data-v-0930174c;-o-animation-name:fadeIn-data-v-0930174c,scaleUp100-data-v-0930174c;animation-name:fadeIn-data-v-0930174c,scaleUp100-data-v-0930174c;-webkit-animation-duration:367ms;-moz-animation-duration:367ms;-ms-animation-duration:367ms;-o-animation-duration:367ms;-webkit-animation-timing-function:cubic-bezier(.1,.9,.2,1);-moz-animation-timing-function:cubic-bezier(.1,.9,.2,1);-ms-animation-timing-function:cubic-bezier(.1,.9,.2,1);-o-animation-timing-function:cubic-bezier(.1,.9,.2,1);animation-timing-function:cubic-bezier(.1,.9,.2,1);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes scaleUp100-data-v-0930174c{from{-webkit-transform:scale3d(.98,.98,1)}to{-webkit-transform:scale3d(1,1,1)}}@keyframes scaleUp100-data-v-0930174c{from{transform:scale3d(.98,.98,1)}to{transform:scale3d(1,1,1)}}.ms-u-scaleDownIn100[data-v-0930174c]{-webkit-animation-name:fadeIn-data-v-0930174c,scaleDown100-data-v-0930174c;-moz-animation-name:fadeIn-data-v-0930174c,scaleDown100-data-v-0930174c;-ms-animation-name:fadeIn-data-v-0930174c,scaleDown100-data-v-0930174c;-o-animation-name:fadeIn-data-v-0930174c,scaleDown100-data-v-0930174c;animation-name:fadeIn-data-v-0930174c,scaleDown100-data-v-0930174c;-webkit-animation-duration:367ms;-moz-animation-duration:367ms;-ms-animation-duration:367ms;-o-animation-duration:367ms;-webkit-animation-timing-function:cubic-bezier(.1,.9,.2,1);-moz-animation-timing-function:cubic-bezier(.1,.9,.2,1);-ms-animation-timing-function:cubic-bezier(.1,.9,.2,1);-o-animation-timing-function:cubic-bezier(.1,.9,.2,1);animation-timing-function:cubic-bezier(.1,.9,.2,1);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes scaleDown100-data-v-0930174c{from{-webkit-transform:scale3d(1.03,1.03,1)}to{-webkit-transform:scale3d(1,1,1)}}@keyframes scaleDown100-data-v-0930174c{from{transform:scale3d(1.03,1.03,1)}to{transform:scale3d(1,1,1)}}.ms-u-scaleUpOut103[data-v-0930174c]{-webkit-animation-name:fadeOut-data-v-0930174c,scaleUp103-data-v-0930174c;-moz-animation-name:fadeOut-data-v-0930174c,scaleUp103-data-v-0930174c;-ms-animation-name:fadeOut-data-v-0930174c,scaleUp103-data-v-0930174c;-o-animation-name:fadeOut-data-v-0930174c,scaleUp103-data-v-0930174c;animation-name:fadeOut-data-v-0930174c,scaleUp103-data-v-0930174c;-webkit-animation-duration:167ms;-moz-animation-duration:167ms;-ms-animation-duration:167ms;-o-animation-duration:167ms;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-moz-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-ms-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-o-animation-timing-function:cubic-bezier(.1,.25,.75,.9);animation-timing-function:cubic-bezier(.1,.25,.75,.9);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes scaleUp103-data-v-0930174c{from{-webkit-transform:scale3d(1,1,1)}to{-webkit-transform:scale3d(1.03,1.03,1)}}@keyframes scaleUp103-data-v-0930174c{from{transform:scale3d(1,1,1)}to{transform:scale3d(1.03,1.03,1)}}.ms-u-scaleDownOut98[data-v-0930174c]{-webkit-animation-name:fadeOut-data-v-0930174c,scaleDown98-data-v-0930174c;-moz-animation-name:fadeOut-data-v-0930174c,scaleDown98-data-v-0930174c;-ms-animation-name:fadeOut-data-v-0930174c,scaleDown98-data-v-0930174c;-o-animation-name:fadeOut-data-v-0930174c,scaleDown98-data-v-0930174c;animation-name:fadeOut-data-v-0930174c,scaleDown98-data-v-0930174c;-webkit-animation-duration:167ms;-moz-animation-duration:167ms;-ms-animation-duration:167ms;-o-animation-duration:167ms;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-moz-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-ms-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-o-animation-timing-function:cubic-bezier(.1,.25,.75,.9);animation-timing-function:cubic-bezier(.1,.25,.75,.9);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes scaleDown98-data-v-0930174c{from{-webkit-transform:scale3d(1,1,1)}to{-webkit-transform:scale3d(.98,.98,1)}}@keyframes scaleDown98-data-v-0930174c{from{transform:scale3d(1,1,1)}to{transform:scale3d(.98,.98,1)}}.ms-u-fadeIn400[data-v-0930174c]{-webkit-animation-duration:367ms;-webkit-animation-name:fadeIn-data-v-0930174c;-webkit-animation-fill-mode:both;animation-duration:367ms;animation-name:fadeIn-data-v-0930174c;animation-fill-mode:both}.ms-u-fadeIn100[data-v-0930174c]{-webkit-animation-duration:367ms;-webkit-animation-name:fadeIn-data-v-0930174c;-webkit-animation-fill-mode:both;animation-duration:367ms;animation-name:fadeIn-data-v-0930174c;animation-fill-mode:both;-webkit-animation-duration:167ms;animation-duration:167ms}.ms-u-fadeIn200[data-v-0930174c]{-webkit-animation-duration:367ms;-webkit-animation-name:fadeIn-data-v-0930174c;-webkit-animation-fill-mode:both;animation-duration:367ms;animation-name:fadeIn-data-v-0930174c;animation-fill-mode:both;-webkit-animation-duration:267ms;animation-duration:267ms}.ms-u-fadeIn500[data-v-0930174c]{-webkit-animation-duration:367ms;-webkit-animation-name:fadeIn-data-v-0930174c;-webkit-animation-fill-mode:both;animation-duration:367ms;animation-name:fadeIn-data-v-0930174c;animation-fill-mode:both;-webkit-animation-duration:467ms;animation-duration:467ms}@-webkit-keyframes fadeIn-data-v-0930174c{from{opacity:0;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9)}to{opacity:1}}@keyframes fadeIn-data-v-0930174c{from{opacity:0;animation-timing-function:cubic-bezier(.1,.25,.75,.9)}to{opacity:1}}.ms-u-fadeOut400[data-v-0930174c]{-webkit-animation-duration:367ms;-webkit-animation-name:fadeOut-data-v-0930174c;-webkit-animation-fill-mode:both;animation-duration:367ms;animation-name:fadeOut-data-v-0930174c;animation-fill-mode:both}.ms-u-fadeOut100[data-v-0930174c]{-webkit-animation-duration:367ms;-webkit-animation-name:fadeOut-data-v-0930174c;-webkit-animation-fill-mode:both;animation-duration:367ms;animation-name:fadeOut-data-v-0930174c;animation-fill-mode:both;-webkit-animation-duration:.1s;animation-duration:.1s}.ms-u-fadeOut200[data-v-0930174c]{-webkit-animation-duration:367ms;-webkit-animation-name:fadeOut-data-v-0930174c;-webkit-animation-fill-mode:both;animation-duration:367ms;animation-name:fadeOut-data-v-0930174c;animation-fill-mode:both;-webkit-animation-duration:167ms;animation-duration:167ms}.ms-u-fadeOut500[data-v-0930174c]{-webkit-animation-duration:367ms;-webkit-animation-name:fadeOut-data-v-0930174c;-webkit-animation-fill-mode:both;animation-duration:367ms;animation-name:fadeOut-data-v-0930174c;animation-fill-mode:both;-webkit-animation-duration:467ms;animation-duration:467ms}@-webkit-keyframes fadeOut-data-v-0930174c{from{opacity:1;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9)}to{opacity:0}}@keyframes fadeOut-data-v-0930174c{from{opacity:1;animation-timing-function:cubic-bezier(.1,.25,.75,.9)}to{opacity:0}}.ms-u-rotate90deg[data-v-0930174c]{-webkit-animation-name:rotate90-data-v-0930174c;-moz-animation-name:rotate90-data-v-0930174c;-ms-animation-name:rotate90-data-v-0930174c;-o-animation-name:rotate90-data-v-0930174c;animation-name:rotate90-data-v-0930174c;-webkit-animation-duration:.1s;-moz-animation-duration:.1s;-ms-animation-duration:.1s;-o-animation-duration:.1s;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-moz-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-ms-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-o-animation-timing-function:cubic-bezier(.1,.25,.75,.9);animation-timing-function:cubic-bezier(.1,.25,.75,.9);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes rotate90-data-v-0930174c{from{-webkit-transform:rotateZ(0)}to{-webkit-transform:rotateZ(90deg)}}@keyframes rotate90-data-v-0930174c{from{transform:rotateZ(0)}to{transform:rotateZ(90deg)}}.ms-u-rotateN90deg[data-v-0930174c]{-webkit-animation-name:rotateN90-data-v-0930174c;-moz-animation-name:rotateN90-data-v-0930174c;-ms-animation-name:rotateN90-data-v-0930174c;-o-animation-name:rotateN90-data-v-0930174c;animation-name:rotateN90-data-v-0930174c;-webkit-animation-duration:.1s;-moz-animation-duration:.1s;-ms-animation-duration:.1s;-o-animation-duration:.1s;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-moz-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-ms-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-o-animation-timing-function:cubic-bezier(.1,.25,.75,.9);animation-timing-function:cubic-bezier(.1,.25,.75,.9);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes rotateN90-data-v-0930174c{from{-webkit-transform:rotateZ(90deg)}to{-webkit-transform:rotateZ(0)}}@keyframes rotateN90-data-v-0930174c{from{transform:rotateZ(90deg)}to{transform:rotateZ(0)}}.ms-u-expandCollapse400[data-v-0930174c]{-webkit-transition:height 367ms cubic-bezier(.1,.25,.75,.9);transition:height 367ms cubic-bezier(.1,.25,.75,.9)}.ms-u-expandCollapse200[data-v-0930174c]{-webkit-transition:height 167ms cubic-bezier(.1,.25,.75,.9);transition:height 167ms cubic-bezier(.1,.25,.75,.9)}.ms-u-expandCollapse100[data-v-0930174c]{-webkit-transition:height .1s cubic-bezier(.1,.25,.75,.9);transition:height .1s cubic-bezier(.1,.25,.75,.9)}.ms-u-delay100[data-v-0930174c]{-webkit-animation-delay:167ms;animation-delay:167ms}.ms-u-delay200[data-v-0930174c]{-webkit-animation-delay:267ms;animation-delay:267ms}.ms-Panel[data-v-0930174c]{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;background-color:\"[theme:white, default: #ffffff]\";width:100%;max-width:340px;box-shadow:-30px 0 30px -30px rgba(0,0,0,.2);position:absolute;top:0;right:0;bottom:0;z-index:10;display:none;height:100%}.ms-Panel.animate-in[data-v-0930174c]{-webkit-animation-name:fadeIn-data-v-0930174c,slideLeftIn40-data-v-0930174c;-moz-animation-name:fadeIn-data-v-0930174c,slideLeftIn40-data-v-0930174c;-ms-animation-name:fadeIn-data-v-0930174c,slideLeftIn40-data-v-0930174c;-o-animation-name:fadeIn-data-v-0930174c,slideLeftIn40-data-v-0930174c;animation-name:fadeIn-data-v-0930174c,slideLeftIn40-data-v-0930174c;-webkit-animation-duration:367ms;-moz-animation-duration:367ms;-ms-animation-duration:367ms;-o-animation-duration:367ms;-webkit-animation-timing-function:cubic-bezier(.1,.9,.2,1);-moz-animation-timing-function:cubic-bezier(.1,.9,.2,1);-ms-animation-timing-function:cubic-bezier(.1,.9,.2,1);-o-animation-timing-function:cubic-bezier(.1,.9,.2,1);animation-timing-function:cubic-bezier(.1,.9,.2,1);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}.ms-Panel.animate-out[data-v-0930174c]{-webkit-animation-name:fadeOut-data-v-0930174c,slideRightOut40-data-v-0930174c;-moz-animation-name:fadeOut-data-v-0930174c,slideRightOut40-data-v-0930174c;-ms-animation-name:fadeOut-data-v-0930174c,slideRightOut40-data-v-0930174c;-o-animation-name:fadeOut-data-v-0930174c,slideRightOut40-data-v-0930174c;animation-name:fadeOut-data-v-0930174c,slideRightOut40-data-v-0930174c;-webkit-animation-duration:167ms;-moz-animation-duration:167ms;-ms-animation-duration:167ms;-o-animation-duration:167ms;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-moz-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-ms-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-o-animation-timing-function:cubic-bezier(.1,.25,.75,.9);animation-timing-function:cubic-bezier(.1,.25,.75,.9);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}.ms-Panel.is-open[data-v-0930174c]{display:block}.ms-Panel .ms-CommandBar[data-v-0930174c]{padding-right:0;padding-left:8px}.ms-Panel.ms-Panel--md[data-v-0930174c]{max-width:340px}.ms-Panel.ms-Panel--lg[data-v-0930174c]{max-width:644px}.ms-Panel.ms-Panel--xl[data-v-0930174c]{max-width:940px}.ms-Panel.ms-Panel--xxl[data-v-0930174c]{max-width:1192px}.ms-Panel--left[data-v-0930174c]{box-shadow:-30px 0 30px 30px rgba(0,0,0,.2);left:0;right:auto}.ms-Panel--left.animate-in[data-v-0930174c]{-webkit-animation-name:fadeIn-data-v-0930174c,slideRightIn40-data-v-0930174c;-moz-animation-name:fadeIn-data-v-0930174c,slideRightIn40-data-v-0930174c;-ms-animation-name:fadeIn-data-v-0930174c,slideRightIn40-data-v-0930174c;-o-animation-name:fadeIn-data-v-0930174c,slideRightIn40-data-v-0930174c;animation-name:fadeIn-data-v-0930174c,slideRightIn40-data-v-0930174c;-webkit-animation-duration:367ms;-moz-animation-duration:367ms;-ms-animation-duration:367ms;-o-animation-duration:367ms;-webkit-animation-timing-function:cubic-bezier(.1,.9,.2,1);-moz-animation-timing-function:cubic-bezier(.1,.9,.2,1);-ms-animation-timing-function:cubic-bezier(.1,.9,.2,1);-o-animation-timing-function:cubic-bezier(.1,.9,.2,1);animation-timing-function:cubic-bezier(.1,.9,.2,1);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}.ms-Panel--left.animate-out[data-v-0930174c]{-webkit-animation-name:fadeOut-data-v-0930174c,slideLeftOut40-data-v-0930174c;-moz-animation-name:fadeOut-data-v-0930174c,slideLeftOut40-data-v-0930174c;-ms-animation-name:fadeOut-data-v-0930174c,slideLeftOut40-data-v-0930174c;-o-animation-name:fadeOut-data-v-0930174c,slideLeftOut40-data-v-0930174c;animation-name:fadeOut-data-v-0930174c,slideLeftOut40-data-v-0930174c;-webkit-animation-duration:167ms;-moz-animation-duration:167ms;-ms-animation-duration:167ms;-o-animation-duration:167ms;-webkit-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-moz-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-ms-animation-timing-function:cubic-bezier(.1,.25,.75,.9);-o-animation-timing-function:cubic-bezier(.1,.25,.75,.9);animation-timing-function:cubic-bezier(.1,.25,.75,.9);-webkit-animation-fill-mode:both;-moz-animation-fill-mode:both;-ms-animation-fill-mode:both;-o-animation-fill-mode:both;animation-fill-mode:both}.ms-Panel-closeButton[data-v-0930174c]{background:0 0;border:0;cursor:pointer;position:absolute;right:6px;top:0;height:40px;width:40px;line-height:40px;outline:0;padding:0;color:\"[theme:neutralSecondary, default: #666666]\";font-size:16px}.ms-Panel-closeButton[data-v-0930174c]:hover{color:\"[theme:neutralPrimary, default: #333333]\"}.ms-Panel-closeButton .ms-Icon--Cancel[data-v-0930174c]{margin-top:2px}@media (max-width:639px){.ms-Panel-closeButton[data-v-0930174c]{font-size:20px;line-height:20px;height:44px;right:4px}}.ms-Panel-contentInner[data-v-0930174c]{margin-top:40px;padding:0 16px 20px;overflow-y:auto;height:100%}@media (min-width:640px){.ms-Panel-contentInner[data-v-0930174c]{padding:0 32px 20px}}@media (min-width:1366px){.ms-Panel-contentInner[data-v-0930174c]{padding:0 40px 20px}}.ms-Panel-headerText[data-v-0930174c]{font-weight:100;font-size:21px;color:\"[theme:neutralPrimary, default: #333333]\";margin:10px 0;padding:4px 0;line-height:1;text-overflow:ellipsis;overflow:hidden}@media (min-width:1024px){.ms-Panel-headerText[data-v-0930174c]{margin-top:30px}}.ms-Overlay[data-v-0930174c]{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;background-color:\"[theme:whiteTranslucent40, default: rgba(255,255,255,.4)]\";position:fixed;bottom:0;left:0;right:0;top:0;z-index:0;display:none}.ms-Overlay.is-visible[data-v-0930174c]{display:block}.ms-Overlay--dark[data-v-0930174c]{background-color:\"[theme:blackTranslucent40, default: rgba(0,0,0,.4)]\"}.ms-u-overflowHidden[data-v-0930174c]{overflow:hidden}.ms-Panel-contentInner[data-v-0930174c]{margin-top:0;border-top:solid 40px transparent;box-sizing:border-box}@font-face{font-family:FabricMDL2Icons-a13498cf;src:url(https://spoprod-a.akamaihd.net/files/fabric/assets/icons/fabric-icons-a13498cf.woff) format(\"woff\")}.ms-Icon[data-v-0930174c]{display:inline-block;font-style:normal;font-weight:400}.ms-Icon.ms-Icon--Cancel[data-v-0930174c]::before{font-family:FabricMDL2Icons-a13498cf;content:\"\"}", map: undefined, media: undefined });

    };
    /* scoped */
    const __vue_scope_id__$H = "data-v-0930174c";
    /* module identifier */
    const __vue_module_identifier__$H = undefined;
    /* functional template */
    const __vue_is_functional_template__$H = undefined;
    /* style inject */
    const __vue_create_injector__$h = function(context){ 
                  return function(scopeId, data)
                  {
                      if(window['wizstyle-'+scopeId])
                          return;
                      if(__vue_script__$H.loadStyles)
                          __vue_script__$H.loadStyles(data.source);
                      window['wizstyle-'+scopeId]=true;
                  }
              };
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var uiPanel = normalizeComponent(
      {},
      __vue_inject_styles__$H,
      __vue_script__$H,
      __vue_scope_id__$H,
      __vue_is_functional_template__$H,
      __vue_module_identifier__$H,
      false,
      __vue_create_injector__$h,
      undefined,
      undefined
    );

  var script$I = {
    name: 'ou-persona',
    mixins: [size('tiny', 'xs', 'sm', 'lg', 'xl'), type('available', 'away', 'blocked', 'busy', 'dnd', 'offline')],
    data: function data() {
      if (this.initials) {
        var validateColor = ['blue', 'blueLight', 'blueDark', 'teal', 'greenLight', 'green', 'greenDark', 'magentaLight', 'magenta', 'purpleLight', 'purple', 'black', 'orange', 'red', 'redDark'];
        var initialsLetter = this.initials[0].toUpperCase();
        var initialsIndex = initialsLetter.charCodeAt() - 65; // get radom color from validateColor

        return {
          initialsColor: validateColor[Math.round(validateColor.length / 26 * initialsIndex)]
        };
      }

      return {
        initialsColor: ''
      };
    },
    props: {
      src: String,
      initials: String,
      primaryText: String,
      secondaryText: String,
      tertiaryText: String,
      optionalText: String
    },
    computed: {
      personaClass: function personaClass() {
        var _ref;

        return _ref = {}, _defineProperty(_ref, "ms-Persona--".concat(this.size), !!this.size), _defineProperty(_ref, "ms-Persona--".concat(this.type), !!this.type), _ref;
      },
      initialsPersonaClass: function initialsPersonaClass() {
        return _defineProperty({}, "ms-Persona-initials--".concat(this.initialsColor), !!this.initialsColor);
      },
      personaIconClass: function personaIconClass() {
        var icon = '';

        switch (this.type) {
          case 'available':
            icon = 'SkypeCheck';
            break;

          case 'away':
            icon = 'SkypeClock';
            break;

          case 'dnd':
            icon = 'SkypeMinus';
            break;
        }

        if (icon) {
          return "ms-Icon--".concat(icon);
        }
      }
    }
  };

  /* script */
  const __vue_script__$I = script$I;

  /* template */
  var __vue_render__$q = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"ms-Persona",class:_vm.personaClass},[_c('div',{staticClass:"ms-Persona-imageArea"},[(!_vm.initials)?_c('img',{staticClass:"ms-Persona-image",attrs:{"src":_vm.src}}):_c('div',{staticClass:"ms-Persona-initials",class:_vm.initialsPersonaClass},[_vm._v(_vm._s(_vm.initials.toUpperCase()))])]),_vm._v(" "),(_vm.type)?_c('div',{staticClass:"ms-Persona-presence"},[_c('i',{staticClass:"ms-Persona-presenceIcon ms-Icon",class:_vm.personaIconClass})]):_vm._e(),_vm._v(" "),_c('div',{staticClass:"ms-Persona-details"},[_c('div',{staticClass:"ms-Persona-primaryText"},[_vm._v(_vm._s(_vm.primaryText))]),_vm._v(" "),_c('div',{staticClass:"ms-Persona-secondaryText"},[_vm._v(_vm._s(_vm.secondaryText))]),_vm._v(" "),_c('div',{staticClass:"ms-Persona-tertiaryText"},[_vm._v(_vm._s(_vm.tertiaryText))]),_vm._v(" "),_c('div',{staticClass:"ms-Persona-optionalText"},[_vm._v(_vm._s(_vm.optionalText))])])])};
  var __vue_staticRenderFns__$q = [];

    /* style */
    const __vue_inject_styles__$I = undefined;
    /* scoped */
    const __vue_scope_id__$I = undefined;
    /* module identifier */
    const __vue_module_identifier__$I = undefined;
    /* functional template */
    const __vue_is_functional_template__$I = false;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var persona = normalizeComponent(
      { render: __vue_render__$q, staticRenderFns: __vue_staticRenderFns__$q },
      __vue_inject_styles__$I,
      __vue_script__$I,
      __vue_scope_id__$I,
      __vue_is_functional_template__$I,
      __vue_module_identifier__$I,
      false,
      undefined,
      undefined,
      undefined
    );

  var SCROLL_FRAME_RATE = 33;

  var Animate = function () {
    function Animate() {}

    Animate.transition = function (element, props) {
      var obj = {
        element: element,
        props: props,
        transformations: {}
      };

      Animate._animationObjects.push(obj);

      Animate._parseProperties(obj);

      Animate._createTransition(obj);

      setTimeout(Animate._setProperties, 0, obj);

      Animate._setCallback(obj);
    };

    Animate.animation = function (element, keyframes, props) {
      var obj = {
        element: element,
        keyframes: keyframes,
        props: props
      };

      Animate._animationObjects.push(obj);

      Animate._parseProperties(obj);

      Animate._createAnimation(obj);

      Animate._setCallback(obj);
    };

    Animate.scrollTo = function (element, props) {
      var obj = {
        element: element,
        props: props,
        step: 0
      };

      Animate._setScrollProperties(obj);

      if (obj.props.delay) {
        setTimeout(Animate._animationObjects, obj.props.delay * 1000, obj);
      } else {
        Animate._animateScroll(obj);
      }

      Animate._animationObjects.push(obj);
    };

    Animate._setScrollProperties = function (obj) {
      obj.beginTop = obj.element.scrollTop;
      obj.change = obj.props.top - obj.beginTop;
      obj.props.duration = obj.props.duration * 1000;
    };

    Animate._parseProperties = function (obj) {
      var nonTweenProps = Animate._timeProps.concat(Animate._callbackProps);

      obj.tweenObj = {};

      for (var key in obj.props) {
        if (Animate._contains(nonTweenProps, key)) {
          obj[key] = obj.props[key];
        } else {
          obj.tweenObj[key] = obj.props[key];
        }
      }
    };

    Animate._animateScroll = function (obj) {
      var totalSteps = obj.props.duration / SCROLL_FRAME_RATE;

      var top = Animate._easeOutExpo(obj.step++, obj.beginTop, obj.change, totalSteps);

      obj.element.scrollTop = top;

      if (obj.step >= totalSteps) {
        obj.element.scrollTop = obj.props.top;

        Animate._executeCallback(obj.props);

        Animate._removeAnimationObject(obj);
      } else {
        setTimeout(function () {
          requestAnimationFrame(function () {
            Animate._animateScroll(obj);
          });
        }, SCROLL_FRAME_RATE);
      }
    };

    Animate._createTransition = function (obj) {
      var duration = obj.duration || 0;
      var delay = obj.delay || 0;
      obj.element.style.transitionProperty = Animate._getTransitionProperties(obj.tweenObj);
      obj.element.style.transitionDuration = duration.toString() + "s";
      obj.element.style.transitionTimingFunction = obj.ease || "linear";
      obj.element.style.transitionDelay = delay.toString() + "s";
    };

    Animate._createAnimation = function (obj) {
      var duration = obj.duration || 0;
      var delay = obj.delay || 0;
      obj.element.style.animationName = obj.keyframes;
      obj.element.style.animationDuration = duration.toString() + "s";
      obj.element.style.animationTimingFunction = obj.ease || "linear";
      obj.element.style.animationDelay = delay.toString() + "s";
      obj.element.style.animationFillMode = "both";
    };

    Animate._getTransitionProperties = function (obj) {
      var hasTransform = false;
      var hasFilter = false;
      var properties = [];

      for (var key in obj) {
        if (Animate._contains(Animate._transformProps, key)) {
          hasTransform = true;
        } else if (Animate._contains(Animate._filters, key)) {
          hasFilter = true;
        } else {
          properties.push(Animate._camelCaseToDash(key));
        }
      }

      if (hasTransform) {
        properties.push("transform");
      }

      if (hasFilter) {
        properties.push("-webkit-filter");
        properties.push("filter");
      }

      return properties.join(", ");
    };

    Animate._setProperties = function (obj) {
      for (var key in obj.tweenObj) {
        if (Animate._contains(Animate._transformProps, key)) {
          Animate._setTransformValues(obj, key);
        } else if (Animate._contains(Animate._filters, key)) {
          Animate._setFilterValues(obj, key);
        } else {
          Animate._setRegularValues(obj, key);
        }
      }

      if (obj.transformations) {
        Animate._setTransformations(obj);
      }
    };

    Animate._setRegularValues = function (obj, key) {
      var value = obj.tweenObj[key];

      if (value.toString().indexOf("%") === -1) {
        value += key !== "opacity" && key !== "backgroundColor" && key !== "boxShadow" ? "px" : "";
      }

      obj.element.style[key] = value;
    };

    Animate._setFilterValues = function (obj, key) {
      var value = obj.tweenObj[key];

      if (key === "hueRotate") {
        value = "(" + value + "deg)";
      } else {
        value = key === "blur" ? "(" + value + "px)" : "(" + value + "%)";
      }

      key = Animate._camelCaseToDash(key);
      obj.element.style.webkitFilter = key + value;
      obj.element.style.filter = key + value;
    };

    Animate._setTransformValues = function (obj, key) {
      if (/x|y|z|scaleX|scaleY|scaleZ|rotate|rotateX|rotateY|rotateZ|skewX|skewY/.test(key)) {
        obj.transformations[key] = obj.tweenObj[key];
      }
    };

    Animate._setTransformations = function (obj) {
      var rotate = "",
          scale = "",
          skew = "",
          translate = "";
      var trans = obj.transformations;
      translate += trans.x !== undefined && trans.x ? "translateX(" + trans.x + "px) " : "";
      translate += trans.y !== undefined && trans.y ? "translateY(" + trans.y + "px) " : "";
      translate += trans.z !== undefined && trans.z ? "translateZ(" + trans.z + "px) " : "";
      rotate += trans.rotate !== undefined && trans.rotate ? "rotate(" + trans.rotate + "deg) " : "";
      rotate += trans.rotateX !== undefined && trans.rotateX ? "rotateX(" + trans.rotateX + "deg) " : "";
      rotate += trans.rotateY !== undefined && trans.rotateY ? "rotate(" + trans.rotateY + "deg) " : "";
      rotate += trans.rotateZ !== undefined && trans.rotateZ ? "rotate(" + trans.rotateZ + "deg) " : "";
      scale += trans.scaleX !== undefined && trans.scaleX ? "scaleX(" + trans.scaleX + ") " : "";
      scale += trans.scaleY !== undefined && trans.scaleY ? "scaleY(" + trans.scaleY + ") " : "";
      scale += trans.scaleZ !== undefined && trans.scaleZ ? "scaleZ(" + trans.scaleZ + ") " : "";
      skew += trans.skewX !== undefined && trans.skewX ? "skewX(" + trans.skewX + "deg) " : "";
      skew += trans.skewY !== undefined && trans.skewY ? "skewY(" + trans.skewY + "deg) " : "";
      obj.element.style.transform = translate + rotate + scale + skew;
    };

    Animate._setCallback = function (obj) {
      obj.element.addEventListener("webkitTransitionEnd", Animate._complete, false);
      obj.element.addEventListener("transitionend", Animate._complete, false);
      obj.element.addEventListener("webkitAnimationEnd", Animate._complete, false);
      obj.element.addEventListener("animationend", Animate._complete, false);
    };

    Animate._complete = function (event) {
      event.target.removeEventListener("webkitTransitionEnd", Animate._complete);
      event.target.removeEventListener("transitionend", Animate._complete);
      event.target.removeEventListener("webkitAnimationEnd", Animate._complete);
      event.target.removeEventListener("animationend", Animate._complete);

      var obj = Animate._getAnimationObjByElement(event.target);

      Animate._executeCallback(obj);

      Animate._removeAnimationObject(obj);
    };

    Animate._getAnimationObjByElement = function (element) {
      var i = Animate._animationObjects.length;

      while (i--) {
        if (Animate._animationObjects[i].element === element) {
          return Animate._animationObjects[i];
        }
      }

      return null;
    };

    Animate._removeAnimationObject = function (obj) {
      var i = Animate._animationObjects.length;

      while (i--) {
        if (Animate._animationObjects[i] === obj) {
          Animate._animationObjects.splice(i, 1);
        }
      }
    };

    Animate._executeCallback = function (obj) {
      if (obj.onEnd) {
        var endArgs = obj.onEndArgs || [];
        obj.onEnd.apply(null, endArgs);
      }
    };

    Animate._contains = function (array, value) {
      var i = array.length;

      while (i--) {
        if (value === array[i]) {
          return true;
        }
      }

      return false;
    };

    Animate._camelCaseToDash = function (value) {
      return value.replace(/\W+/g, "-").replace(/([a-z\d])([A-Z])/g, "$1-$2").toLowerCase();
    };

    Animate._easeOutExpo = function (time, begin, change, duration) {
      return time === duration ? begin + change : change * (-Math.pow(2, -10 * time / duration) + 1) + begin;
    };

    Animate._transformProps = ["x", "y", "z", "scaleX", "scaleY", "scaleZ", "rotate", "rotateX", "rotateY", "rotateZ", "skewX", "skewY"];
    Animate._filters = ["blur", "brightness", "contrast", "dropShadow", "grayscale", "hueRotate", "invert", "saturate", "sepia"];
    Animate._timeProps = ["duration", "ease", "delay"];
    Animate._callbackProps = ["onEnd", "onEndArgs"];
    Animate._animationObjects = [];
    return Animate;
  }();

  var Ease = function () {
    function Ease() {}

    Ease.CB = "cubic-bezier";
    Ease.QUAD_EASE_IN = Ease.CB + "(0.550, 0.085, 0.680, 0.530)";
    Ease.CUBIC_EASE_IN = Ease.CB + "(0.550, 0.055, 0.675, 0.190)";
    Ease.QUART_EASE_IN = Ease.CB + "(0.895, 0.030, 0.685, 0.220)";
    Ease.QUINT_EASE_IN = Ease.CB + "(0.755, 0.050, 0.855, 0.060)";
    Ease.SINE_EASE_IN = Ease.CB + "(0.470, 0, 0.745, 0.715)";
    Ease.EXPO_EASE_IN = Ease.CB + "(0.950, 0.050, 0.795, 0.035)";
    Ease.CIRC_EASE_IN = Ease.CB + "(0.600, 0.040, 0.980, 0.335)";
    Ease.BACK_EASE_IN = Ease.CB + "(0.600, 0.040, 0.980, 0.335)";
    Ease.QUAD_EASE_OUT = Ease.CB + "(0.250, 0.460, 0.450, 0.940)";
    Ease.CUBIC_EASE_OUT = Ease.CB + "(0.215, 0.610, 0.355, 1)";
    Ease.QUART_EASE_OUT = Ease.CB + "(0.165, 0.840, 0.440, 1)";
    Ease.QUINT_EASE_OUT = Ease.CB + "(0.230, 1, 0.320, 1)";
    Ease.SINE_EASE_OUT = Ease.CB + "(0.390, 0.575, 0.565, 1)";
    Ease.EXPO_EASE_OUT = Ease.CB + "(0.190, 1, 0.220, 1)";
    Ease.CIRC_EASE_OUT = Ease.CB + "(0.075, 0.820, 0.165, 1)";
    Ease.BACK_EASE_OUT = Ease.CB + "(0.175, 0.885, 0.320, 1.275)";
    Ease.QUAD_EASE_IN_OUT = Ease.CB + "(0.455, 0.030, 0.515, 0.955)";
    Ease.CUBIC_EASE_IN_OUT = Ease.CB + "(0.645, 0.045, 0.355, 1)";
    Ease.QUART_EASE_IN_OUT = Ease.CB + "(0.770, 0, 0.175, 1)";
    Ease.QUINT_EASE_IN_OUT = Ease.CB + "(0.860, 0, 0.070, 1)";
    Ease.SINE_EASE_IN_OUT = Ease.CB + "(0.445, 0.050, 0.550, 0.950)";
    Ease.EXPO_EASE_IN_OUT = Ease.CB + "(1, 0, 0, 1)";
    Ease.CIRC_EASE_IN_OUT = Ease.CB + "(0.785, 0.135, 0.150, 0.860)";
    Ease.BACK_EASE_IN_OUT = Ease.CB + "(0.680, -0.550, 0.265, 1.550)";
    return Ease;
  }();

  var PersonaCard = function () {
    function PersonaCard(container) {
      this._container = container;

      var activeElement = this._container.querySelector(".ms-PersonaCard-action.is-active");

      var activeId = activeElement.getAttribute("data-action-id");
      this._actions = this._container.querySelector(".ms-PersonaCard-actions");
      this._expander = this._container.querySelector(".ms-PersonaCard-detailExpander");
      this._actionDetailBox = this._container.querySelector(".ms-PersonaCard-actionDetailBox");

      this._setDetail(activeId);

      this._boundOnActionClick = this._onActionClick.bind(this);
      this._boundOnExpanderClick = this._onExpanderClick.bind(this);
      this._boundOnTab = this._onTab.bind(this);

      this._addListeners();
    }

    PersonaCard.prototype.removeListeners = function () {
      this._actions.removeEventListener("click", this._boundOnActionClick);

      this._expander.removeEventListener("click", this._boundOnExpanderClick);

      this._container.removeEventListener("keydown", this._boundOnTab);
    };

    PersonaCard.prototype._addListeners = function () {
      this._actions.addEventListener("click", this._boundOnActionClick, false);

      this._expander.addEventListener("click", this._boundOnExpanderClick, false);

      this._container.addEventListener("keydown", this._boundOnTab, false);
    };

    PersonaCard.prototype._onTab = function (event) {
      var target = event.target;

      if (event.keyCode === 9 && target.classList.contains("ms-PersonaCard-action")) {
        this._onActionClick(event);
      }
    };

    PersonaCard.prototype._onExpanderClick = function (event) {
      var parent = event.target.parentElement;

      if (parent.classList.contains("is-collapsed")) {
        parent.classList.remove("is-collapsed");
      } else {
        parent.classList.add("is-collapsed");
      }

      var parentHeight = parent.clientHeight;

      this._animateDetail(parentHeight);
    };

    PersonaCard.prototype._onActionClick = function (event) {
      var target = event.target;
      var actionId = target.getAttribute("data-action-id");

      if (actionId && target.className.indexOf("is-active") === -1) {
        this._setAction(target);

        this._setDetail(actionId);
      }
    };

    PersonaCard.prototype._setAction = function (target) {
      var activeElement = this._container.querySelector(".ms-PersonaCard-action.is-active");

      activeElement.classList.remove("is-active");
      target.classList.add("is-active");
    };

    PersonaCard.prototype._setDetail = function (activeId) {
      var selector = ".ms-PersonaCard-details[data-detail-id='" + activeId + "']";

      var lastDetail = this._container.querySelector(".ms-PersonaCard-details.is-active");

      var activeDetail = this._container.querySelector(selector);

      if (lastDetail) {
        lastDetail.classList.remove("is-active");
      }

      activeDetail.classList.add("is-active");
      var detailHeight = activeDetail.clientHeight;

      this._animateDetail(detailHeight);
    };

    PersonaCard.prototype._animateDetail = function (height) {
      var _this = this;

      this._actionDetailBox.style.overflowY = "hidden";
      Animate.transition(this._actionDetailBox, {
        height: height,
        duration: 0.25,
        ease: Ease.SINE_EASE_OUT,
        onEnd: function onEnd() {
          _this._actionDetailBox.style.overflowY = "auto";
        }
      });
    };

    return PersonaCard;
  }();

  var MODAL_POSITION$2 = "top";

  var Persona = function () {
    function Persona(container) {
      this._persona = container;
      this._personaCard = this._persona.querySelector(".ms-PersonaCard");

      if (this._personaCard) {
        this._assignEvents();

        this._personaCard.setAttribute("style", "display: none;");

        this._createPersonaCard();
      }
    }

    Persona.prototype._createPersonaCard = function () {
      this._personaCardInstance = new PersonaCard(this._personaCard);
    };

    Persona.prototype._createContextualHostInstance = function () {
      this._personaCard.setAttribute("style", "display: block;");

      this._contextualHostInstance = new ContextualHost(this._personaCard, MODAL_POSITION$2, this._persona);
    };

    Persona.prototype._personaEventHandler = function () {
      this._createContextualHostInstance();
    };

    Persona.prototype._assignEvents = function () {
      var _this = this;

      this._persona.addEventListener("click", this._personaEventHandler.bind(this), false);

      this._persona.addEventListener("keyup", function (e) {
        return e.keyCode === 32 ? _this._personaEventHandler() : null;
      }, false);
    };

    return Persona;
  }();

  var script$J = {
    loadStyles: loadThemedStyles.loadStyles,
    beforeMount: function beforeMount() {
      this.$fabric = {
        Persona: Persona
      };
    },
    extends: persona
  };

  /* script */
  const __vue_script__$J = script$J;

  /* template */

    /* style */
    const __vue_inject_styles__$J = function (inject) {
      if (!inject) return
      inject("data-v-aab71c4c_0", { source: ".ms-Persona[data-v-aab71c4c]{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;box-sizing:border-box;margin:0;padding:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;color:\"[theme:neutralPrimary, default: #333333]\";font-size:14px;font-weight:400;line-height:1;position:relative;width:100%;height:48px;display:table;table-layout:fixed;border-collapse:separate}.ms-Persona .ms-ContextualHost[data-v-aab71c4c]{display:none}.ms-Persona-imageArea[data-v-aab71c4c]{position:absolute;overflow:hidden;text-align:center;max-width:48px;height:48px;border-radius:50%;z-index:0;width:100%;top:0;left:0}@media screen and (-ms-high-contrast:active){.ms-Persona-imageArea[data-v-aab71c4c]{border:1px solid \"[theme:white, default: #ffffff]\"}}@media screen and (-ms-high-contrast:black-on-white){.ms-Persona-imageArea[data-v-aab71c4c]{border:1px solid \"[theme:black, default: #000000]\"}}.ms-Persona-placeholder[data-v-aab71c4c]{color:\"[theme:white, default: #ffffff]\";position:absolute;right:0;left:0;font-size:47px;top:9px;z-index:5}.ms-Persona-initials[data-v-aab71c4c]{color:\"[theme:white, default: #ffffff]\";font-size:17px;font-weight:100;line-height:48px}.ms-Persona-initials.ms-Persona-initials--blueLight[data-v-aab71c4c]{background-color:\"[theme:blueLight, default: #00bcf2]\"}.ms-Persona-initials.ms-Persona-initials--blue[data-v-aab71c4c]{background-color:\"[theme:blue, default: #0078d7]\"}.ms-Persona-initials.ms-Persona-initials--blueDark[data-v-aab71c4c]{background-color:\"[theme:blueDark, default: #002050]\"}.ms-Persona-initials.ms-Persona-initials--teal[data-v-aab71c4c]{background-color:\"[theme:teal, default: #008272]\"}.ms-Persona-initials.ms-Persona-initials--greenLight[data-v-aab71c4c]{background-color:\"[theme:greenLight, default: #bad80a]\"}.ms-Persona-initials.ms-Persona-initials--green[data-v-aab71c4c]{background-color:\"[theme:green, default: #107c10]\"}.ms-Persona-initials.ms-Persona-initials--greenDark[data-v-aab71c4c]{background-color:\"[theme:greenDark, default: #004b1c]\"}.ms-Persona-initials.ms-Persona-initials--magentaLight[data-v-aab71c4c]{background-color:\"[theme:magentaLight, default: #e3008c]\"}.ms-Persona-initials.ms-Persona-initials--magenta[data-v-aab71c4c]{background-color:\"[theme:magenta, default: #b4009e]\"}.ms-Persona-initials.ms-Persona-initials--purpleLight[data-v-aab71c4c]{background-color:\"[theme:purpleLight, default: #b4a0ff]\"}.ms-Persona-initials.ms-Persona-initials--purple[data-v-aab71c4c]{background-color:\"[theme:purple, default: #5c2d91]\"}.ms-Persona-initials.ms-Persona-initials--black[data-v-aab71c4c]{background-color:\"[theme:black, default: #000000]\"}.ms-Persona-initials.ms-Persona-initials--orange[data-v-aab71c4c]{background-color:\"[theme:orange, default: #d83b01]\"}.ms-Persona-initials.ms-Persona-initials--red[data-v-aab71c4c]{background-color:\"[theme:red, default: #e81123]\"}.ms-Persona-initials.ms-Persona-initials--redDark[data-v-aab71c4c]{background-color:\"[theme:redDark, default: #a80000]\"}.ms-Persona-image[data-v-aab71c4c]{position:absolute;top:0;left:0;height:48px;z-index:10;width:100%}.ms-Persona-image[src][data-v-aab71c4c]{display:none}.ms-Persona-presence[data-v-aab71c4c]{background-color:#7fba00;position:absolute;height:12px;width:12px;border-radius:50%;top:auto;left:34px;bottom:-1px;border:2px solid \"[theme:white, default: #ffffff]\";text-align:center}@media screen and (-ms-high-contrast:active){.ms-Persona-presence[data-v-aab71c4c]{border-color:\"[theme:black, default: #000000]\";box-shadow:0 0 0 1px #1aebff inset;color:\"[theme:black, default: #000000]\";background-color:\"[theme:white, default: #ffffff]\"}}@media screen and (-ms-high-contrast:black-on-white){.ms-Persona-presence[data-v-aab71c4c]{border-color:\"[theme:white, default: #ffffff]\";box-shadow:0 0 0 1px #37006e inset;color:\"[theme:white, default: #ffffff]\";background-color:\"[theme:black, default: #000000]\"}}.ms-Persona-presenceIcon[data-v-aab71c4c]{color:\"[theme:white, default: #ffffff]\";font-size:8px;line-height:12px;vertical-align:top}.ms-Persona-details[data-v-aab71c4c]{padding:0 12px;vertical-align:middle;overflow:hidden;text-align:left;padding-left:60px;display:table-cell;width:100%}.ms-Persona-optionalText[data-v-aab71c4c],.ms-Persona-primaryText[data-v-aab71c4c],.ms-Persona-secondaryText[data-v-aab71c4c],.ms-Persona-tertiaryText[data-v-aab71c4c]{display:block;overflow:hidden;text-overflow:ellipsis;white-space:nowrap;width:100%;overflow:hidden;text-overflow:ellipsis}.ms-Persona-primaryText[data-v-aab71c4c]{color:\"[theme:neutralPrimary, default: #333333]\";font-weight:400;font-size:17px;margin-top:-3px;line-height:1.4}.ms-Persona-optionalText[data-v-aab71c4c],.ms-Persona-secondaryText[data-v-aab71c4c],.ms-Persona-tertiaryText[data-v-aab71c4c]{color:\"[theme:neutralSecondary, default: #666666]\";font-weight:400;font-size:12px;white-space:nowrap;line-height:1.3}.ms-Persona-secondaryText[data-v-aab71c4c]{padding-top:3px}.ms-Persona-optionalText[data-v-aab71c4c],.ms-Persona-tertiaryText[data-v-aab71c4c]{padding-top:5px;display:none}.ms-Persona.ms-Persona--tiny[data-v-aab71c4c]{height:30px;display:inline-block}.ms-Persona.ms-Persona--tiny .ms-Persona-imageArea[data-v-aab71c4c]{overflow:visible;display:none}.ms-Persona.ms-Persona--tiny .ms-Persona-presence[data-v-aab71c4c]{right:auto;top:10px;left:0;border:0}@media screen and (-ms-high-contrast:active){.ms-Persona.ms-Persona--tiny .ms-Persona-presence[data-v-aab71c4c]{top:9px;border:1px solid \"[theme:white, default: #ffffff]\"}}@media screen and (-ms-high-contrast:black-on-white){.ms-Persona.ms-Persona--tiny .ms-Persona-presence[data-v-aab71c4c]{border:1px solid \"[theme:black, default: #000000]\"}}.ms-Persona.ms-Persona--tiny .ms-Persona-details[data-v-aab71c4c]{padding-left:20px}.ms-Persona.ms-Persona--tiny .ms-Persona-primaryText[data-v-aab71c4c]{font-size:14px;padding-top:9px}.ms-Persona.ms-Persona--tiny .ms-Persona-secondaryText[data-v-aab71c4c]{display:none}.ms-Persona.ms-Persona--tiny.ms-Persona--readonly[data-v-aab71c4c]{padding:0;background-color:transparent}.ms-Persona.ms-Persona--tiny.ms-Persona--readonly .ms-Persona-primaryText[data-v-aab71c4c]::after{content:\";\"}.ms-Persona.ms-Persona--facePile[data-v-aab71c4c],.ms-Persona.ms-Persona--token[data-v-aab71c4c],.ms-Persona.ms-Persona--xs[data-v-aab71c4c]{height:32px}.ms-Persona.ms-Persona--facePile .ms-Persona-image[data-v-aab71c4c],.ms-Persona.ms-Persona--facePile .ms-Persona-imageArea[data-v-aab71c4c],.ms-Persona.ms-Persona--token .ms-Persona-image[data-v-aab71c4c],.ms-Persona.ms-Persona--token .ms-Persona-imageArea[data-v-aab71c4c],.ms-Persona.ms-Persona--xs .ms-Persona-image[data-v-aab71c4c],.ms-Persona.ms-Persona--xs .ms-Persona-imageArea[data-v-aab71c4c]{max-width:32px;height:32px}.ms-Persona.ms-Persona--facePile .ms-Persona-placeholder[data-v-aab71c4c],.ms-Persona.ms-Persona--token .ms-Persona-placeholder[data-v-aab71c4c],.ms-Persona.ms-Persona--xs .ms-Persona-placeholder[data-v-aab71c4c]{font-size:28px;top:6px}.ms-Persona.ms-Persona--facePile .ms-Persona-initials[data-v-aab71c4c],.ms-Persona.ms-Persona--token .ms-Persona-initials[data-v-aab71c4c],.ms-Persona.ms-Persona--xs .ms-Persona-initials[data-v-aab71c4c]{font-size:12px;line-height:32px}.ms-Persona.ms-Persona--facePile .ms-Persona-presence[data-v-aab71c4c],.ms-Persona.ms-Persona--token .ms-Persona-presence[data-v-aab71c4c],.ms-Persona.ms-Persona--xs .ms-Persona-presence[data-v-aab71c4c]{left:19px}.ms-Persona.ms-Persona--facePile .ms-Persona-details[data-v-aab71c4c],.ms-Persona.ms-Persona--token .ms-Persona-details[data-v-aab71c4c],.ms-Persona.ms-Persona--xs .ms-Persona-details[data-v-aab71c4c]{padding-left:40px}.ms-Persona.ms-Persona--facePile .ms-Persona-primaryText[data-v-aab71c4c],.ms-Persona.ms-Persona--token .ms-Persona-primaryText[data-v-aab71c4c],.ms-Persona.ms-Persona--xs .ms-Persona-primaryText[data-v-aab71c4c]{font-size:14px;padding-top:3px}.ms-Persona.ms-Persona--facePile .ms-Persona-secondaryText[data-v-aab71c4c],.ms-Persona.ms-Persona--token .ms-Persona-secondaryText[data-v-aab71c4c],.ms-Persona.ms-Persona--xs .ms-Persona-secondaryText[data-v-aab71c4c]{display:none}.ms-Persona.ms-Persona--sm[data-v-aab71c4c]{height:40px}.ms-Persona.ms-Persona--sm .ms-Persona-image[data-v-aab71c4c],.ms-Persona.ms-Persona--sm .ms-Persona-imageArea[data-v-aab71c4c]{max-width:40px;height:40px}.ms-Persona.ms-Persona--sm .ms-Persona-placeholder[data-v-aab71c4c]{font-size:38px;top:5px}.ms-Persona.ms-Persona--sm .ms-Persona-initials[data-v-aab71c4c]{font-size:14px;line-height:40px}.ms-Persona.ms-Persona--sm .ms-Persona-presence[data-v-aab71c4c]{left:27px}.ms-Persona.ms-Persona--sm .ms-Persona-details[data-v-aab71c4c]{padding-left:48px}.ms-Persona.ms-Persona--sm .ms-Persona-primaryText[data-v-aab71c4c]{font-size:14px}.ms-Persona.ms-Persona--sm .ms-Persona-primaryText[data-v-aab71c4c],.ms-Persona.ms-Persona--sm .ms-Persona-secondaryText[data-v-aab71c4c]{padding-top:1px}.ms-Persona.ms-Persona--lg[data-v-aab71c4c]{height:72px}.ms-Persona.ms-Persona--lg .ms-Persona-image[data-v-aab71c4c],.ms-Persona.ms-Persona--lg .ms-Persona-imageArea[data-v-aab71c4c]{max-width:72px;height:72px}.ms-Persona.ms-Persona--lg .ms-Persona-placeholder[data-v-aab71c4c]{font-size:67px;top:10px}.ms-Persona.ms-Persona--lg .ms-Persona-initials[data-v-aab71c4c]{font-size:28px;line-height:72px}.ms-Persona.ms-Persona--lg .ms-Persona-presence[data-v-aab71c4c]{left:49px;height:20px;width:20px;border-width:3px}.ms-Persona.ms-Persona--lg .ms-Persona-presenceIcon[data-v-aab71c4c]{line-height:20px;font-size:14px}.ms-Persona.ms-Persona--lg .ms-Persona-details[data-v-aab71c4c]{padding-left:84px}.ms-Persona.ms-Persona--lg .ms-Persona-secondaryText[data-v-aab71c4c]{padding-top:3px}.ms-Persona.ms-Persona--lg .ms-Persona-tertiaryText[data-v-aab71c4c]{padding-top:5px;display:block}.ms-Persona.ms-Persona--xl[data-v-aab71c4c]{height:100px}.ms-Persona.ms-Persona--xl .ms-Persona-image[data-v-aab71c4c],.ms-Persona.ms-Persona--xl .ms-Persona-imageArea[data-v-aab71c4c]{max-width:100px;height:100px}.ms-Persona.ms-Persona--xl .ms-Persona-placeholder[data-v-aab71c4c]{font-size:95px;top:12px}.ms-Persona.ms-Persona--xl .ms-Persona-initials[data-v-aab71c4c]{font-size:42px;line-height:100px}.ms-Persona.ms-Persona--xl .ms-Persona-presence[data-v-aab71c4c]{height:28px;width:28px;left:71px;border-width:4px}.ms-Persona.ms-Persona--xl .ms-Persona-presenceIcon[data-v-aab71c4c]{line-height:28px;font-size:21px;position:relative;top:1px}.ms-Persona.ms-Persona--xl .ms-Persona-details[data-v-aab71c4c]{padding-left:120px}.ms-Persona.ms-Persona--xl .ms-Persona-primaryText[data-v-aab71c4c]{font-size:21px;font-weight:300;margin-top:0}.ms-Persona.ms-Persona--xl .ms-Persona-secondaryText[data-v-aab71c4c]{padding-top:2px}.ms-Persona.ms-Persona--xl .ms-Persona-optionalText[data-v-aab71c4c],.ms-Persona.ms-Persona--xl .ms-Persona-tertiaryText[data-v-aab71c4c]{padding-top:5px;display:block}.ms-Persona.ms-Persona--darkText .ms-Persona-primaryText[data-v-aab71c4c]{color:\"[theme:neutralDark, default: #212121]\"}.ms-Persona.ms-Persona--darkText .ms-Persona-optionalText[data-v-aab71c4c],.ms-Persona.ms-Persona--darkText .ms-Persona-secondaryText[data-v-aab71c4c],.ms-Persona.ms-Persona--darkText .ms-Persona-tertiaryText[data-v-aab71c4c]{color:\"[theme:neutralPrimary, default: #333333]\"}.ms-Persona.ms-Persona--selectable[data-v-aab71c4c]{cursor:pointer;padding:0 10px}.ms-Persona.ms-Persona--selectable[data-v-aab71c4c]:not(.ms-Persona--xl):focus,.ms-Persona.ms-Persona--selectable[data-v-aab71c4c]:not(.ms-Persona--xl):hover{background-color:\"[theme:themeLighter, default: #deecf9]\";outline:1px solid transparent}.ms-Persona.ms-Persona--available .ms-Persona-presence[data-v-aab71c4c]{background-color:#7fba00}.ms-Persona.ms-Persona--away .ms-Persona-presence[data-v-aab71c4c]{background-color:#fcd116}.ms-Persona.ms-Persona--away .ms-Persona-presenceIcon[data-v-aab71c4c]{position:relative;left:1px}.ms-Persona.ms-Persona--blocked .ms-Persona-presence[data-v-aab71c4c]{background-color:\"[theme:white, default: #ffffff]\"}.ms-Persona.ms-Persona--blocked .ms-Persona-presence[data-v-aab71c4c]::before{content:\"\";width:100%;height:100%;position:absolute;top:0;left:0;box-shadow:0 0 0 2px #d93b3b inset;border-radius:50%}.ms-Persona.ms-Persona--blocked .ms-Persona-presence[data-v-aab71c4c]::after{content:\"\";width:100%;height:2px;background-color:#d93b3b;transform:rotate(-45deg);position:absolute;top:5px;left:0}.ms-Persona.ms-Persona--blocked.ms-Persona--lg .ms-Persona-presence[data-v-aab71c4c]::after{top:9px}.ms-Persona.ms-Persona--blocked.ms-Persona--xl .ms-Persona-presence[data-v-aab71c4c]::after{top:13px}.ms-Persona.ms-Persona--busy .ms-Persona-presence[data-v-aab71c4c]{background-color:#d93b3b}@media screen and (-ms-high-contrast:active){.ms-Persona.ms-Persona--busy .ms-Persona-presence[data-v-aab71c4c]{background-color:#1aebff}}@media screen and (-ms-high-contrast:black-on-white){.ms-Persona.ms-Persona--busy .ms-Persona-presence[data-v-aab71c4c]{background-color:#37006e}}.ms-Persona.ms-Persona--dnd .ms-Persona-presence[data-v-aab71c4c]{background-color:#e81123}.ms-Persona.ms-Persona--offline .ms-Persona-presence[data-v-aab71c4c]{background-color:#93abbd}@media screen and (-ms-high-contrast:active){.ms-Persona.ms-Persona--offline .ms-Persona-presence[data-v-aab71c4c]{background-color:\"[theme:black, default: #000000]\";box-shadow:0 0 0 1px \"[theme:white, default: #ffffff]\" inset}}@media screen and (-ms-high-contrast:black-on-white){.ms-Persona.ms-Persona--offline .ms-Persona-presence[data-v-aab71c4c]{background-color:\"[theme:white, default: #ffffff]\";box-shadow:0 0 0 1px \"[theme:black, default: #000000]\" inset}}.ms-Persona.ms-Persona--facePile[data-v-aab71c4c]{display:inline-block;width:auto}.ms-Persona.ms-Persona--facePile[data-v-aab71c4c]:hover{cursor:pointer}.ms-Persona.ms-Persona--facePile .ms-Persona-imageArea[data-v-aab71c4c]{position:relative;width:100%;min-width:32px}.ms-Persona.ms-Persona--facePile .ms-Persona-initials[data-v-aab71c4c]{position:relative}.ms-Persona.ms-Persona--facePile .ms-Persona-details[data-v-aab71c4c]{display:none}.ms-Persona.ms-Persona--facePile .ms-Persona-presence[data-v-aab71c4c]{display:none}.ms-Persona.ms-Persona--token[data-v-aab71c4c]{display:inline-flex;width:auto;background-color:\"[theme:neutralLighter, default: #f4f4f4]\";border-radius:20px;margin:4px}.ms-Persona.ms-Persona--token[data-v-aab71c4c]:hover{cursor:pointer}.ms-Persona.ms-Persona--token .ms-Persona-actionIcon[data-v-aab71c4c]{border-radius:20px;display:inline-block;width:32px;height:32px;padding:0;line-height:30px;transition:background-color 167ms cubic-bezier(.1,.9,.2,1);text-align:center}.ms-Persona.ms-Persona--token .ms-Persona-actionIcon[data-v-aab71c4c]:hover{background-color:\"[theme:neutralLight, default: #eaeaea]\"}.ms-Persona.ms-Persona--token .ms-Persona-imageArea[data-v-aab71c4c]{width:100%;min-width:32px}.ms-Persona.ms-Persona--token .ms-Persona-details[data-v-aab71c4c]{height:30px;display:inline-block;width:auto;padding-right:8px}.ms-Persona.ms-Persona--token .ms-Persona-primaryText[data-v-aab71c4c]{padding-top:0;line-height:34px}.ms-Persona.ms-Persona--token .ms-Persona-initials[data-v-aab71c4c]{position:relative}", map: undefined, media: undefined });

    };
    /* scoped */
    const __vue_scope_id__$J = "data-v-aab71c4c";
    /* module identifier */
    const __vue_module_identifier__$J = undefined;
    /* functional template */
    const __vue_is_functional_template__$J = undefined;
    /* style inject */
    const __vue_create_injector__$i = function(context){ 
                  return function(scopeId, data)
                  {
                      if(window['wizstyle-'+scopeId])
                          return;
                      if(__vue_script__$J.loadStyles)
                          __vue_script__$J.loadStyles(data.source);
                      window['wizstyle-'+scopeId]=true;
                  }
              };
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var uiPersona = normalizeComponent(
      {},
      __vue_inject_styles__$J,
      __vue_script__$J,
      __vue_scope_id__$J,
      __vue_is_functional_template__$J,
      __vue_module_identifier__$J,
      false,
      __vue_create_injector__$i,
      undefined,
      undefined
    );

  var script$K = {
    name: 'ou-pivot',
    mixins: [size('large'), type('tabs'), eventHub],
    data: function data() {
      return {
        pivotItems: []
      };
    },
    computed: {
      pivotClass: function pivotClass() {
        var _ref;

        return _ref = {}, _defineProperty(_ref, "ms-Pivot--".concat(this.size), !!this.size), _defineProperty(_ref, "ms-Pivot--".concat(this.type), !!this.type), _ref;
      }
    },
    created: function created() {
      this.eventHub.$on('addPivotItem', this.addPivotItem);
    },
    beforeDestroy: function beforeDestroy() {
      this.eventHub.$off('addPivotItem', this.addPivotItem);
    },
    mounted: function mounted() {
      new this.$fabric.Pivot(this.$refs.pivot);
    },
    methods: {
      addPivotItem: function addPivotItem(label) {
        this.pivotItems.push(label);
      },
      clickEvent: function clickEvent(event) {
        if (event.target.tagName == 'LI') {
          this.$emit('click', event);
        }
      }
    }
  };

  /* script */
  const __vue_script__$K = script$K;

  /* template */
  var __vue_render__$r = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{ref:"pivot",staticClass:"ms-Pivot",class:_vm.pivotClass},[_c('ul',{staticClass:"ms-Pivot-links",on:{"click":_vm.clickEvent}},_vm._l((_vm.pivotItems),function(item,index){return _c('li',{staticClass:"ms-Pivot-link",class:{ 'is-selected': index == 0 },attrs:{"tabindex":"1","data-content":item,"title":item}},[_vm._v("\n      "+_vm._s(item)+"\n    ")])}),0),_vm._v(" "),_vm._t("default")],2)};
  var __vue_staticRenderFns__$r = [];

    /* style */
    const __vue_inject_styles__$K = undefined;
    /* scoped */
    const __vue_scope_id__$K = undefined;
    /* module identifier */
    const __vue_module_identifier__$K = undefined;
    /* functional template */
    const __vue_is_functional_template__$K = false;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var pivot = normalizeComponent(
      { render: __vue_render__$r, staticRenderFns: __vue_staticRenderFns__$r },
      __vue_inject_styles__$K,
      __vue_script__$K,
      __vue_scope_id__$K,
      __vue_is_functional_template__$K,
      __vue_module_identifier__$K,
      false,
      undefined,
      undefined,
      undefined
    );

  var Pivot = function () {
    function Pivot(container) {
      this._container = container;

      this._addListeners();

      var firstContent = this._container.querySelector(".ms-Pivot-content");

      firstContent.style.display = "block";
    }

    Pivot.prototype.removeListeners = function () {
      this._container.removeEventListener("click", this._selectTab.bind(this));
    };

    Pivot.prototype._addListeners = function () {
      var _this = this;

      this._container.querySelector(".ms-Pivot-links").addEventListener("click", this._selectTabMouse.bind(this), false);

      this._container.addEventListener("keyup", function (event) {
        if (event.keyCode === 13) {
          _this._selectTabKeyboard(event);
        }
      }, true);
    };

    Pivot.prototype._selectTab = function (selectedTab) {
      if (selectedTab.classList.contains("ms-Pivot-link") && !selectedTab.querySelector(".ms-Pivot-ellipsis")) {
        var sibling = selectedTab.parentElement.firstElementChild;

        while (sibling) {
          sibling.classList.remove("is-selected");
          sibling = sibling.nextElementSibling;
        }

        selectedTab.classList.add("is-selected");

        var containers = this._container.querySelectorAll(".ms-Pivot-content");

        Array.prototype.forEach.call(containers, function (el, i) {
          el.style.display = "none";
        });
        var selectedContentName = selectedTab.getAttribute("data-content");

        var selectedContent = this._container.querySelector(".ms-Pivot-content[data-content='" + selectedContentName + "']");

        selectedContent.style.display = "block";
      }
    };

    Pivot.prototype._selectTabMouse = function (event) {
      event.preventDefault();
      var selectedTab = event.target;

      this._selectTab(selectedTab);
    };

    Pivot.prototype._selectTabKeyboard = function (event) {
      event.preventDefault();
      var selectedTab = event.target;

      this._selectTab(selectedTab);
    };

    return Pivot;
  }();

  var script$L = {
    loadStyles: loadThemedStyles.loadStyles,
    beforeMount: function beforeMount() {
      this.$fabric = {
        Pivot: Pivot
      };
    },
    extends: pivot
  };

  /* script */
  const __vue_script__$L = script$L;

  /* template */

    /* style */
    const __vue_inject_styles__$L = function (inject) {
      if (!inject) return
      inject("data-v-777772a0_0", { source: ".ms-Pivot[data-v-777772a0]{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;box-sizing:border-box;margin:0;padding:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;font-size:14px;font-weight:400}.ms-Pivot-links[data-v-777772a0]{font-size:0;height:40px;list-style-type:none;padding:0;white-space:nowrap}.ms-Pivot-link[data-v-777772a0]{color:\"[theme:neutralPrimary, default: #333333]\";display:inline-block;font-size:14px;font-weight:400;line-height:40px;margin-right:8px;padding:0 8px;text-align:center;vertical-align:top}.ms-Pivot-link[data-v-777772a0]:hover{cursor:pointer}.ms-Pivot-link[data-v-777772a0]::before{background-color:transparent;bottom:0;content:\"\";height:2px;left:8px;position:absolute;right:8px;transition:background-color 267ms cubic-bezier(.1,.25,.75,.9)}.ms-Pivot-link[data-v-777772a0]::after{color:transparent;content:attr(title);display:block;font-weight:700;height:1px;overflow:hidden;visibility:hidden}.ms-Pivot-link.is-selected[data-v-777772a0]{font-weight:600;position:relative}.ms-Pivot-link.is-selected[data-v-777772a0]::before{background-color:\"[theme:themePrimary, default: #0078d7]\"}.ms-Pivot-link.is-disabled[data-v-777772a0]{color:\"[theme:neutralTertiary, default: #a6a6a6]\"}.ms-Pivot-link.ms-Pivot-link--overflow[data-v-777772a0]{color:\"[theme:neutralSecondary, default: #666666]\"}.ms-Pivot-link.ms-Pivot-link--overflow.is-selected[data-v-777772a0]{color:\"[theme:themePrimary, default: #0078d7]\"}.ms-Pivot-link.ms-Pivot-link--overflow[data-v-777772a0]:focus:not(.is-selected),.ms-Pivot-link.ms-Pivot-link--overflow[data-v-777772a0]:hover:not(.is-selected){color:\"[theme:neutralDark, default: #212121]\"}.ms-Pivot-link.ms-Pivot-link--overflow[data-v-777772a0]:active{color:\"[theme:themePrimary, default: #0078d7]\"}.ms-Pivot-ellipsis[data-v-777772a0]{font-size:15px;position:relative;top:0}.ms-Pivot-content[data-v-777772a0]{display:none;margin-top:20px}.ms-Pivot.ms-Pivot--large .ms-Pivot-link[data-v-777772a0]{font-size:17px}.ms-Pivot.ms-Pivot--large .ms-Pivot-link.is-selected[data-v-777772a0]{font-weight:300}.ms-Pivot.ms-Pivot--large .ms-Pivot-link.ms-Pivot-link--overflow[data-v-777772a0]::after{font-size:17px}.ms-Pivot.ms-Pivot--tabs .ms-Pivot-link[data-v-777772a0]{height:40px;background-color:\"[theme:neutralLighter, default: #f4f4f4]\";line-height:40px;margin-right:-2px;padding:0 10px}.ms-Pivot.ms-Pivot--tabs .ms-Pivot-link[data-v-777772a0]:focus:not(.is-selected):not(.ms-Pivot-link--overflow),.ms-Pivot.ms-Pivot--tabs .ms-Pivot-link[data-v-777772a0]:hover:not(.is-selected):not(.ms-Pivot-link--overflow){color:\"[theme:black, default: #000000]\"}.ms-Pivot.ms-Pivot--tabs .ms-Pivot-link[data-v-777772a0]:active{color:\"[theme:white, default: #ffffff]\";background-color:\"[theme:themePrimary, default: #0078d7]\"}.ms-Pivot.ms-Pivot--tabs .ms-Pivot-link.is-selected[data-v-777772a0]{background-color:\"[theme:themePrimary, default: #0078d7]\";color:\"[theme:white, default: #ffffff]\";font-weight:300}.ms-Pivot.ms-Pivot--tabs .ms-Pivot-link.ms-Pivot-link--overflow[data-v-777772a0]:focus:not(.is-selected),.ms-Pivot.ms-Pivot--tabs .ms-Pivot-link.ms-Pivot-link--overflow[data-v-777772a0]:hover:not(.is-selected){background-color:\"[theme:white, default: #ffffff]\"}.ms-Pivot.ms-Pivot--tabs .ms-Pivot-link.ms-Pivot-link--overflow[data-v-777772a0]:active{background-color:\"[theme:themePrimary, default: #0078d7]\"}@media screen and (-ms-high-contrast:active){.ms-Pivot.ms-Pivot--tabs .ms-Pivot-link.is-selected[data-v-777772a0]{font-weight:600}}", map: undefined, media: undefined });

    };
    /* scoped */
    const __vue_scope_id__$L = "data-v-777772a0";
    /* module identifier */
    const __vue_module_identifier__$L = undefined;
    /* functional template */
    const __vue_is_functional_template__$L = undefined;
    /* style inject */
    const __vue_create_injector__$j = function(context){ 
                  return function(scopeId, data)
                  {
                      if(window['wizstyle-'+scopeId])
                          return;
                      if(__vue_script__$L.loadStyles)
                          __vue_script__$L.loadStyles(data.source);
                      window['wizstyle-'+scopeId]=true;
                  }
              };
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var uiPivot = normalizeComponent(
      {},
      __vue_inject_styles__$L,
      __vue_script__$L,
      __vue_scope_id__$L,
      __vue_is_functional_template__$L,
      __vue_module_identifier__$L,
      false,
      __vue_create_injector__$j,
      undefined,
      undefined
    );

  //
  //
  //
  var script$M = {
    name: 'ou-pivot-item',
    inject: ['eventHub'],
    props: {
      label: {
        type: String,
        required: true
      }
    },
    beforeMount: function beforeMount() {
      this.eventHub.$emit('addPivotItem', this.label);
    }
  };

  /* script */
  const __vue_script__$M = script$M;

  /* template */
  var __vue_render__$s = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"ms-Pivot-content",attrs:{"data-content":_vm.label}},[_vm._t("default")],2)};
  var __vue_staticRenderFns__$s = [];

    /* style */
    const __vue_inject_styles__$M = undefined;
    /* scoped */
    const __vue_scope_id__$M = undefined;
    /* module identifier */
    const __vue_module_identifier__$M = undefined;
    /* functional template */
    const __vue_is_functional_template__$M = false;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var PivotItem = normalizeComponent(
      { render: __vue_render__$s, staticRenderFns: __vue_staticRenderFns__$s },
      __vue_inject_styles__$M,
      __vue_script__$M,
      __vue_scope_id__$M,
      __vue_is_functional_template__$M,
      __vue_module_identifier__$M,
      false,
      undefined,
      undefined,
      undefined
    );

  var script$N = {
    extends: PivotItem
  };

  /* script */
  const __vue_script__$N = script$N;

  /* template */

    /* style */
    const __vue_inject_styles__$N = undefined;
    /* scoped */
    const __vue_scope_id__$N = undefined;
    /* module identifier */
    const __vue_module_identifier__$N = undefined;
    /* functional template */
    const __vue_is_functional_template__$N = undefined;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var uiPivotItem = normalizeComponent(
      {},
      __vue_inject_styles__$N,
      __vue_script__$N,
      __vue_scope_id__$N,
      __vue_is_functional_template__$N,
      __vue_module_identifier__$N,
      false,
      undefined,
      undefined,
      undefined
    );

  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  var script$O = {
    name: 'ou-progress-indicator',
    props: {
      name: String,
      description: String,
      percent: {
        type: Number,
        validator: function validator(value) {
          return value >= 0 && value <= 1;
        }
      }
    },
    data: function data() {
      return {
        progressIndicatorInstance: null
      };
    },
    watch: {
      percent: function percent() {
        this.setProgressIndicator();
      }
    },
    mounted: function mounted() {
      var progressIndicatorElement = this.$refs.progressIndicator;
      this.progressIndicatorInstance = new this.$fabric.ProgressIndicator(progressIndicatorElement);
      this.setProgressIndicator();
    },
    methods: {
      setProgressIndicator: function setProgressIndicator() {
        this.progressIndicatorInstance.setProgressPercent(this.percent);
      }
    }
  };

  /* script */
  const __vue_script__$O = script$O;

  /* template */
  var __vue_render__$t = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{ref:"progressIndicator",staticClass:"ms-ProgressIndicator"},[(_vm.name)?_c('div',{staticClass:"ms-ProgressIndicator-itemName"},[_vm._v(_vm._s(_vm.name))]):_vm._e(),_vm._v(" "),_vm._m(0),_vm._v(" "),(_vm.description)?_c('div',{staticClass:"ms-ProgressIndicator-itemDescription"},[_vm._v(_vm._s(_vm.description))]):_vm._e()])};
  var __vue_staticRenderFns__$t = [function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"ms-ProgressIndicator-itemProgress"},[_c('div',{staticClass:"ms-ProgressIndicator-progressTrack"}),_vm._v(" "),_c('div',{staticClass:"ms-ProgressIndicator-progressBar"})])}];

    /* style */
    const __vue_inject_styles__$O = undefined;
    /* scoped */
    const __vue_scope_id__$O = undefined;
    /* module identifier */
    const __vue_module_identifier__$O = undefined;
    /* functional template */
    const __vue_is_functional_template__$O = false;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var ProgressIndicator = normalizeComponent(
      { render: __vue_render__$t, staticRenderFns: __vue_staticRenderFns__$t },
      __vue_inject_styles__$O,
      __vue_script__$O,
      __vue_scope_id__$O,
      __vue_is_functional_template__$O,
      __vue_module_identifier__$O,
      false,
      undefined,
      undefined,
      undefined
    );

  var ProgressIndicator$1 = function () {
    function ProgressIndicator(container) {
      this.container = container;
      this.cacheDOM();
    }

    ProgressIndicator.prototype.setProgressPercent = function (percent) {
      this._progressBar.style.width = Math.round(this._width * percent) + "px";
    };

    ProgressIndicator.prototype.setProgress = function (progress) {
      this._progress = progress;
      var percentage = this._progress / this._total;
      this.setProgressPercent(percentage);
    };

    ProgressIndicator.prototype.setTotal = function (total) {
      this._total = total;
    };

    ProgressIndicator.prototype.setName = function (name) {
      this._itemName.innerHTML = name;
    };

    ProgressIndicator.prototype.setDescription = function (description) {
      this._itemDescription.innerHTML = description;
    };

    ProgressIndicator.prototype.cacheDOM = function () {
      this._itemName = this.container.querySelector(".ms-ProgressIndicator-itemName") || null;
      this._itemDescription = this.container.querySelector(".ms-ProgressIndicator-itemDescription") || null;
      this._progressBar = this.container.querySelector(".ms-ProgressIndicator-progressBar");
      var itemProgress = this.container.querySelector(".ms-ProgressIndicator-itemProgress");
      this._width = itemProgress.offsetWidth;
    };

    return ProgressIndicator;
  }();

  var script$P = {
    loadStyles: loadThemedStyles.loadStyles,
    beforeMount: function beforeMount() {
      this.$fabric = {
        ProgressIndicator: ProgressIndicator$1
      };
    },
    extends: ProgressIndicator
  };

  /* script */
  const __vue_script__$P = script$P;

  /* template */

    /* style */
    const __vue_inject_styles__$P = function (inject) {
      if (!inject) return
      inject("data-v-18bcd5df_0", { source: ".ms-ProgressIndicator[data-v-18bcd5df]{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;font-weight:400}.ms-ProgressIndicator-itemName[data-v-18bcd5df]{color:\"[theme:neutralPrimary, default: #333333]\";font-size:14px;text-overflow:ellipsis;overflow:hidden;white-space:nowrap;padding-top:4px;line-height:20px}.ms-ProgressIndicator-itemDescription[data-v-18bcd5df]{color:\"[theme:neutralSecondaryAlt, default: #767676]\";font-size:11px;line-height:18px}.ms-ProgressIndicator-itemProgress[data-v-18bcd5df]{position:relative;width:180px;height:2px;padding:8px 0}.ms-ProgressIndicator-progressTrack[data-v-18bcd5df]{position:absolute;width:100%;height:2px;background-color:\"[theme:neutralLight, default: #eaeaea]\";outline:1px solid transparent}.ms-ProgressIndicator-progressBar[data-v-18bcd5df]{background-color:\"[theme:themePrimary, default: #0078d7]\";height:2px;position:absolute;transition:width .3s ease;width:0}@media screen and (-ms-high-contrast:active){.ms-ProgressIndicator-progressBar[data-v-18bcd5df]{background-color:\"[theme:white, default: #ffffff]\"}}@media screen and (-ms-high-contrast:black-on-white){.ms-ProgressIndicator-progressBar[data-v-18bcd5df]{background-color:\"[theme:black, default: #000000]\"}}", map: undefined, media: undefined });

    };
    /* scoped */
    const __vue_scope_id__$P = "data-v-18bcd5df";
    /* module identifier */
    const __vue_module_identifier__$P = undefined;
    /* functional template */
    const __vue_is_functional_template__$P = undefined;
    /* style inject */
    const __vue_create_injector__$k = function(context){ 
                  return function(scopeId, data)
                  {
                      if(window['wizstyle-'+scopeId])
                          return;
                      if(__vue_script__$P.loadStyles)
                          __vue_script__$P.loadStyles(data.source);
                      window['wizstyle-'+scopeId]=true;
                  }
              };
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var uiProgressIndicator = normalizeComponent(
      {},
      __vue_inject_styles__$P,
      __vue_script__$P,
      __vue_scope_id__$P,
      __vue_is_functional_template__$P,
      __vue_module_identifier__$P,
      false,
      __vue_create_injector__$k,
      undefined,
      undefined
    );

  var script$Q = {
    name: 'ou-search-box',
    mixins: [type('commandBar')],
    props: {
      value: String,
      placeholder: String,
      collapsed: {
        type: Boolean,
        default: false
      }
    },
    data: function data() {
      return {
        hasValue: !!this.value,
        searchBoxInstance: null
      };
    },
    computed: {
      searchBoxClass: function searchBoxClass() {
        var _ref;

        return _ref = {}, _defineProperty(_ref, "ms-SearchBox--".concat(this.type), !!this.type), _defineProperty(_ref, 'is-collapsed', this.collapsed), _ref;
      }
    },
    mounted: function mounted() {
      this.searchBoxInstance = new this.$fabric.SearchBox(this.$refs.searchBox); // Overwrite the default blur event on searchBoxField
      // to prevent lose content when searchBox blur.
      // You can see here https://github.com/OfficeDev/office-ui-fabric-js/issues/301

      this.searchBoxInstance._searchBoxField.removeEventListener('blur', this.searchBoxInstance._boundHandleBlur, true);

      this.searchBoxInstance._searchBoxField.addEventListener('blur', this.blurEvent, true);
    },
    methods: {
      updateValue: function updateValue(event) {
        this.$emit('input', event.target.value);
      },
      clearValue: function clearValue() {
        this.$emit('input', '');
      },
      blurEvent: function blurEvent() {
        var self = this.searchBoxInstance;

        if (!self._clearOnly) {
          self._searchBox.removeEventListener('keyup', self._boundEnableClose);

          setTimeout(function () {
            if (!self._searchBox.contains(document.activeElement) && self._searchBoxField.value == '') {
              self._clearSearchBox();

              self._collapseSearchBox();

              self.setCollapsedListeners();
            }
          }, 10);
        } else {
          self._searchBoxField.focus();
        }

        self._clearOnly = false;
      }
    }
  };

  /* script */
  const __vue_script__$Q = script$Q;

  /* template */
  var __vue_render__$u = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{ref:"searchBox",staticClass:"ms-SearchBox",class:_vm.searchBoxClass},[_c('input',{ref:"searchBoxInput",staticClass:"ms-SearchBox-field",attrs:{"type":"text"},domProps:{"value":_vm.value},on:{"input":_vm.updateValue}}),_vm._v(" "),_c('label',{staticClass:"ms-SearchBox-label"},[_c('i',{staticClass:"ms-SearchBox-icon ms-Icon ms-Icon--Search"}),_vm._v(" "),(!_vm.hasValue)?_c('span',{staticClass:"ms-SearchBox-text"},[_vm._v(_vm._s(_vm.placeholder))]):_vm._e()]),_vm._v(" "),_c('div',{staticClass:"ms-CommandButton ms-SearchBox-clear ms-CommandButton--noLabel",on:{"mousedown":_vm.clearValue}},[_vm._m(0)])])};
  var __vue_staticRenderFns__$u = [function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('button',{staticClass:"ms-CommandButton-button"},[_c('span',{staticClass:"ms-CommandButton-icon"},[_c('i',{staticClass:"ms-Icon ms-Icon--Clear"})]),_vm._v(" "),_c('span',{staticClass:"ms-CommandButton-label"})])}];

    /* style */
    const __vue_inject_styles__$Q = undefined;
    /* scoped */
    const __vue_scope_id__$Q = undefined;
    /* module identifier */
    const __vue_module_identifier__$Q = undefined;
    /* functional template */
    const __vue_is_functional_template__$Q = false;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var searchBox = normalizeComponent(
      { render: __vue_render__$u, staticRenderFns: __vue_staticRenderFns__$u },
      __vue_inject_styles__$Q,
      __vue_script__$Q,
      __vue_scope_id__$Q,
      __vue_is_functional_template__$Q,
      __vue_module_identifier__$Q,
      false,
      undefined,
      undefined,
      undefined
    );

  var script$R = {
    loadStyles: loadThemedStyles.loadStyles,
    beforeMount: function beforeMount() {
      this.$fabric = {
        SearchBox: SearchBox
      };
    },
    extends: searchBox
  };

  /* script */
  const __vue_script__$R = script$R;

  /* template */

    /* style */
    const __vue_inject_styles__$R = function (inject) {
      if (!inject) return
      inject("data-v-52df783c_0", { source: "@charset \"UTF-8\";.ms-Label[data-v-52df783c]{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;box-sizing:border-box;margin:0;padding:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;color:\"[theme:neutralPrimary, default: #333333]\";font-size:12px;font-weight:400;box-sizing:border-box;display:block;padding:5px 0}.ms-Label.is-required[data-v-52df783c]::after{content:\" *\";color:\"[theme:error, default: #a80000]\"}.ms-Label.is-disabled[data-v-52df783c]{color:\"[theme:neutralTertiary, default: #a6a6a6]\"}.ms-CommandButton[data-v-52df783c]{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;display:inline-block;position:relative;vertical-align:top}.ms-CommandButton.is-hidden[data-v-52df783c]{display:none}.ms-CommandButton.is-disabled .ms-CommandButton-button[data-v-52df783c],.ms-CommandButton:disabled .ms-CommandButton-button[data-v-52df783c]{cursor:default}.ms-CommandButton.is-disabled .ms-CommandButton-button[data-v-52df783c]:hover,.ms-CommandButton:disabled .ms-CommandButton-button[data-v-52df783c]:hover{background-color:\"[theme:themeLighterAlt, default: #eff6fc]\"}.ms-CommandButton.is-disabled .ms-CommandButton-button .ms-CommandButton-label[data-v-52df783c],.ms-CommandButton:disabled .ms-CommandButton-button .ms-CommandButton-label[data-v-52df783c]{color:\"[theme:neutralTertiary, default: #a6a6a6]\"}.ms-CommandButton.is-disabled .ms-CommandButton-button .ms-CommandButton-icon[data-v-52df783c],.ms-CommandButton:disabled .ms-CommandButton-button .ms-CommandButton-icon[data-v-52df783c]{color:\"[theme:neutralTertiary, default: #a6a6a6]\"}.ms-CommandButton .ms-ContextualMenu[data-v-52df783c]{display:none}.ms-CommandButton-button[data-v-52df783c],.ms-CommandButton-splitIcon[data-v-52df783c]{box-sizing:border-box;margin:0;padding:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;color:\"[theme:neutralPrimary, default: #333333]\";font-size:14px;font-weight:400;cursor:pointer;display:inline-block;height:40px;line-height:40px;outline:1px solid transparent;padding:0 8px;position:relative;vertical-align:top;background:0 0}.ms-CommandButton-button[data-v-52df783c]:hover,.ms-CommandButton-splitIcon[data-v-52df783c]:hover{background-color:\"[theme:neutralLight, default: #eaeaea]\"}.ms-CommandButton-button:hover .ms-CommandButton-label[data-v-52df783c],.ms-CommandButton-splitIcon:hover .ms-CommandButton-label[data-v-52df783c]{color:\"[theme:neutralDark, default: #212121]\"}.ms-CommandButton-button[data-v-52df783c]:active,.ms-CommandButton-splitIcon[data-v-52df783c]:active{background-color:\"[theme:neutralLight, default: #eaeaea]\"}.ms-CommandButton-button[data-v-52df783c]:focus::before,.ms-CommandButton-splitIcon[data-v-52df783c]:focus::before{top:3px;left:3px;right:3px;bottom:3px;border:1px solid \"[theme:neutralPrimary, default: #333333]\";position:absolute;z-index:10;content:\"\";outline:0}.ms-CommandButton-button[data-v-52df783c]:focus,.ms-CommandButton-splitIcon[data-v-52df783c]:focus{outline:0}@media only screen and (max-width:639px){.ms-CommandButton-button[data-v-52df783c],.ms-CommandButton-splitIcon[data-v-52df783c]{height:44px}.ms-CommandButton-button .ms-CommandButton-icon[data-v-52df783c],.ms-CommandButton-splitIcon .ms-CommandButton-icon[data-v-52df783c]{font-size:20px}.ms-CommandButton-button .ms-CommandButton-label[data-v-52df783c],.ms-CommandButton-splitIcon .ms-CommandButton-label[data-v-52df783c]{line-height:44px}}.ms-CommandButton-button[data-v-52df783c]{border:0;margin:0}.ms-CommandButton+.ms-CommandButton[data-v-52df783c]{margin-left:8px}@media only screen and (max-width:639px){.ms-CommandButton+.ms-CommandButton[data-v-52df783c]{margin-left:4px}}.ms-CommandButton-icon[data-v-52df783c]{display:inline-block;margin-right:8px;position:relative;font-size:16px;min-width:16px;height:100%}.ms-CommandButton-icon .ms-Icon[data-v-52df783c]{position:absolute;top:50%;left:50%;transform:translate(-50%,-50%)}.ms-CommandButton-label[data-v-52df783c]{font-size:14px;font-weight:400;color:\"[theme:neutralPrimary, default: #333333]\";line-height:40px;height:100%;display:inline-block;vertical-align:top}.ms-CommandButton-label[data-v-52df783c]:hover{color:\"[theme:neutralDark, default: #212121]\"}.ms-CommandButton-dropdownIcon[data-v-52df783c],.ms-CommandButton-splitIcon[data-v-52df783c]{display:inline-block;position:relative;color:\"[theme:neutralPrimary, default: #333333]\";font-size:12px;font-weight:300;min-width:12px;height:100%;vertical-align:top;margin-left:8px}.ms-CommandButton-dropdownIcon .ms-Icon[data-v-52df783c],.ms-CommandButton-splitIcon .ms-Icon[data-v-52df783c]{line-height:normal;padding-top:16px}.ms-CommandButton-dropdownIcon[data-v-52df783c]:focus::before,.ms-CommandButton-splitIcon[data-v-52df783c]:focus::before{top:3px;left:3px;right:3px;bottom:3px;border:1px solid \"[theme:neutralPrimary, default: #333333]\";position:absolute;z-index:10;content:\"\";outline:0}@media only screen and (max-width:639px){.ms-CommandButton-dropdownIcon[data-v-52df783c],.ms-CommandButton-splitIcon[data-v-52df783c]{display:none}}.ms-CommandButton-splitIcon[data-v-52df783c]{margin-left:-2px;width:27px;border:0}.ms-CommandButton-splitIcon .ms-Icon[data-v-52df783c]{margin-left:-1px;position:relative;padding-top:16px}.ms-CommandButton-splitIcon .ms-Icon[data-v-52df783c]::after{position:absolute;content:\" \";width:1px;height:16px;top:12px;left:-8px;border-left:1px solid \"[theme:neutralTertiaryAlt, default: #c8c8c8]\"}.ms-CommandButton.ms-CommandButton--noLabel .ms-CommandButton-icon[data-v-52df783c]{margin-right:0}.ms-CommandButton.ms-CommandButton--noLabel .ms-CommandButton-label[data-v-52df783c]{display:none}.ms-CommandButton.ms-CommandButton--noLabel .ms-CommandButton-button[data-v-52df783c]{padding:0 12px}.ms-CommandButton.ms-CommandButton--inline .ms-CommandButton-button[data-v-52df783c]{background:0 0}.ms-CommandButton.ms-CommandButton--actionButton .ms-CommandButton-button[data-v-52df783c]{width:50px;height:40px}.ms-CommandButton.ms-CommandButton--actionButton .ms-CommandButton-icon[data-v-52df783c]{position:absolute;top:50%;left:50%;transform:translate(-50%,-50%);width:16px;height:16px;padding-right:0}.ms-CommandButton.ms-CommandButton--pivot.is-active[data-v-52df783c]::before{content:\"\";height:2px;position:absolute;left:0;right:0;background-color:\"[theme:themePrimary, default: #0078d7]\";bottom:0;z-index:5}.ms-CommandButton.ms-CommandButton--pivot[data-v-52df783c]:hover::before{content:\"\";height:2px;position:absolute;left:0;right:0;background-color:\"[theme:themePrimary, default: #0078d7]\";bottom:0;z-index:5}.ms-CommandButton.ms-CommandButton--pivot .ms-CommandButton-label[data-v-52df783c],.ms-CommandButton.ms-CommandButton--textOnly .ms-CommandButton-label[data-v-52df783c]{display:inline-block}@media only screen and (max-width:479px){.ms-CommandButton.ms-CommandButton--pivot .ms-CommandButton-label[data-v-52df783c],.ms-CommandButton.ms-CommandButton--textOnly .ms-CommandButton-label[data-v-52df783c]{font-size:16px}}.ms-SearchBox[data-v-52df783c]{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;box-sizing:border-box;margin:0;padding:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;height:36px;color:\"[theme:neutralPrimary, default: #333333]\";font-size:14px;font-weight:400;position:relative;margin-bottom:10px;display:inline-block;overflow:hidden;background-color:\"[theme:white, default: #ffffff]\"}.ms-SearchBox.is-active[data-v-52df783c]{z-index:10}.ms-SearchBox.is-active .ms-SearchBox-label[data-v-52df783c]{display:none}.ms-SearchBox.is-active .ms-SearchBox-clear[data-v-52df783c]{display:block}.ms-SearchBox[data-v-52df783c]:hover{background-color:\"[theme:themeLighter, default: #deecf9]\"}.ms-SearchBox:hover .ms-SearchBox-label[data-v-52df783c]{color:\"[theme:black, default: #000000]\"}.ms-SearchBox:hover .ms-SearchBox-label .ms-Icon[data-v-52df783c]{color:\"[theme:neutralPrimary, default: #333333]\"}.ms-SearchBox.is-disabled[data-v-52df783c]{background-color:#f4f4f4;pointer-events:none}.ms-SearchBox.is-disabled .ms-SearchBox-label[data-v-52df783c]{color:\"[theme:neutralTertiary, default: #a6a6a6]\"}.ms-SearchBox.is-disabled .ms-SearchBox-icon[data-v-52df783c]{color:\"[theme:neutralTertiary, default: #a6a6a6]\"}.ms-SearchBox.is-disabled .ms-SearchBox-field[data-v-52df783c]{color:\"[theme:neutralTertiary, default: #a6a6a6]\";background-color:transparent;border-color:\"[theme:neutralLighter, default: #f4f4f4]\";cursor:default}.ms-SearchBox-clear[data-v-52df783c]{display:none;position:absolute;top:0;right:0;z-index:10}.ms-SearchBox-clear .ms-CommandButton-button[data-v-52df783c]{background-color:\"[theme:themePrimary, default: #0078d7]\";color:\"[theme:white, default: #ffffff]\";height:36px}.ms-SearchBox-clear .ms-CommandButton-icon[data-v-52df783c]{color:\"[theme:white, default: #ffffff]\"}.ms-SearchBox-icon[data-v-52df783c]{position:relative;top:50%;transform:translateY(-50%);display:inline-block;font-size:16px;width:16px;margin-left:12px;margin-right:6px;color:\"[theme:themePrimary, default: #0078d7]\";vertical-align:top}.ms-SearchBox-field[data-v-52df783c]{position:relative;box-sizing:border-box;margin:0;padding:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;border:1px solid \"[theme:themeTertiary, default: #71afe5]\";outline:transparent 1px solid;font-weight:300;font-size:14px;color:\"[theme:black, default: #000000]\";height:36px;padding:6px 3px 7px 45px;width:208px;background-color:transparent;z-index:5;transition:padding-left 167ms}.ms-SearchBox-field[data-v-52df783c]:focus{padding:6px 32px 7px 10px;border-color:\"[theme:themePrimary, default: #0078d7]\";background-color:\"[theme:themeLighter, default: #deecf9]\"}.ms-SearchBox-field[data-v-52df783c]::-ms-clear{display:none}.ms-SearchBox-label[data-v-52df783c]{position:absolute;top:0;left:0;height:36px;line-height:36px;color:\"[theme:neutralSecondary, default: #666666]\"}.ms-SearchBox.ms-SearchBox--commandBar[data-v-52df783c]{background-color:\"[theme:white, default: #ffffff]\";width:208px;height:40px}.ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-field[data-v-52df783c],.ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-label[data-v-52df783c]{height:40px}.ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-field[data-v-52df783c]{transition:none;border:0}.ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-field[data-v-52df783c]:focus{background-color:transparent;padding:6px 3px 7px 45px}.ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-clear[data-v-52df783c],.ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-exit[data-v-52df783c],.ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-filter[data-v-52df783c]{display:none;position:absolute;top:0;z-index:10;color:\"[theme:neutralTertiary, default: #a6a6a6]\"}.ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-clear .ms-CommandButton-button[data-v-52df783c],.ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-exit .ms-CommandButton-button[data-v-52df783c],.ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-filter .ms-CommandButton-button[data-v-52df783c]{height:40px;background-color:transparent}.ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-clear[data-v-52df783c]{right:8px}.ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-filter[data-v-52df783c]{right:8px}.ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-filter .ms-CommandButton-icon[data-v-52df783c]{color:\"[theme:themePrimary, default: #0078d7]\"}.ms-SearchBox.ms-SearchBox--commandBar[data-v-52df783c]::before{position:absolute;content:\" \";right:0;bottom:0;left:0;margin:0 8px;border-bottom:1px solid \"[theme:neutralLight, default: #eaeaea]\"}.ms-SearchBox.ms-SearchBox--commandBar[data-v-52df783c]:hover{background-color:\"[theme:white, default: #ffffff]\"}.ms-SearchBox.ms-SearchBox--commandBar:hover .ms-SearchBox-label[data-v-52df783c]{color:\"[theme:neutralDark, default: #212121]\"}.ms-SearchBox.ms-SearchBox--commandBar:hover .ms-SearchBox-icon[data-v-52df783c]{color:\"[theme:themePrimary, default: #0078d7]\"}.ms-SearchBox.ms-SearchBox--commandBar[data-v-52df783c]:focus{background-color:transparent}.ms-SearchBox.ms-SearchBox--commandBar.is-active .ms-CommandButton .ms-SearchBox-exit[data-v-52df783c],.ms-SearchBox.ms-SearchBox--commandBar.is-active .ms-CommandButton .ms-SearchBox-filter[data-v-52df783c]{display:block}.ms-SearchBox.ms-SearchBox--commandBar.is-collapsed[data-v-52df783c]{width:50px;min-height:40px;z-index:0;background-color:#f4f4f4}.ms-SearchBox.ms-SearchBox--commandBar.is-collapsed .ms-SearchBox-text[data-v-52df783c]{display:none}.ms-SearchBox.ms-SearchBox--commandBar.is-collapsed .ms-SearchBox-field[data-v-52df783c]{cursor:pointer;width:calc(100% - 50px)}.ms-SearchBox.ms-SearchBox--commandBar.is-collapsed[data-v-52df783c]::before{visibility:hidden}.ms-SearchBox.ms-SearchBox--commandBar.is-collapsed.is-active[data-v-52df783c]{width:100%}.ms-SearchBox.ms-SearchBox--commandBar.is-collapsed.is-active .ms-SearchBox-field[data-v-52df783c]{display:block;cursor:text}.ms-SearchBox.ms-SearchBox--commandBar.is-collapsed.is-active .ms-SearchBox-text[data-v-52df783c]{display:inline-block}@media only screen and (max-width:639px){.ms-SearchBox.ms-SearchBox--commandBar.is-collapsed.is-active[data-v-52df783c]{width:100%}.ms-SearchBox.ms-SearchBox--commandBar.is-collapsed.is-active .ms-SearchBox-clear[data-v-52df783c]{display:inline-block;right:58px}.ms-SearchBox.ms-SearchBox--commandBar.is-collapsed.is-active .ms-SearchBox-filter[data-v-52df783c]{display:inline-block}.ms-SearchBox.ms-SearchBox--commandBar.is-collapsed.is-active.is-animated[data-v-52df783c]{transition:width 167ms cubic-bezier(.1,.9,.2,1)}}.ms-SearchBox.ms-SearchBox--commandBar.is-collapsed.is-active[data-v-52df783c]::before{visibility:visible}.ms-SearchBox.ms-SearchBox--commandBar.has-text .ms-SearchBox-clear[data-v-52df783c]{display:inline-block}.ms-SearchBox.ms-SearchBox--commandBar.has-text .ms-SearchBox-clear .ms-CommandButton-icon[data-v-52df783c]{color:\"[theme:neutralTertiary, default: #a6a6a6]\"}.ms-SearchBox.ms-SearchBox--commandBar.has-text .ms-SearchBox-clear .ms-CommandButton-icon[data-v-52df783c]:active{color:\"[theme:themePrimary, default: #0078d7]\"}@media only screen and (min-width:1024px){.ms-SearchBox.ms-SearchBox--commandBar[data-v-52df783c]{background-color:\"[theme:white, default: #ffffff]\";border-right:1px solid \"[theme:neutralLight, default: #eaeaea]\"}}@media only screen and (max-width:639px){.ms-SearchBox.ms-SearchBox--commandBar[data-v-52df783c]{height:44px}.ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-exit[data-v-52df783c],.ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-field[data-v-52df783c],.ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-icon[data-v-52df783c],.ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-label[data-v-52df783c]{height:44px;line-height:44px}.ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-clear[data-v-52df783c],.ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-exit[data-v-52df783c],.ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-filter[data-v-52df783c],.ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-icon[data-v-52df783c]{font-size:20px}.ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-clear .ms-CommandButton-button[data-v-52df783c],.ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-exit .ms-CommandButton-button[data-v-52df783c],.ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-filter .ms-CommandButton-button[data-v-52df783c],.ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-icon .ms-CommandButton-button[data-v-52df783c]{height:44px}.ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-field[data-v-52df783c],.ms-SearchBox.ms-SearchBox--commandBar .ms-SearchBox-label[data-v-52df783c]{font-size:16px}}.ms-SearchBox.ms-SearchBox--commandBar.is-active[data-v-52df783c]{background-color:\"[theme:white, default: #ffffff]\"}.ms-SearchBox.ms-SearchBox--commandBar.is-active .ms-SearchBox-label[data-v-52df783c]{display:block;line-height:40px;height:40px}.ms-SearchBox.ms-SearchBox--commandBar.is-active .ms-SearchBox-label .ms-SearchBox-text[data-v-52df783c]{display:none}.ms-SearchBox.ms-SearchBox--commandBar.is-active[data-v-52df783c]::before{visibility:visible}@media only screen and (max-width:639px){.ms-SearchBox.ms-SearchBox--commandBar.is-active .ms-SearchBox-field[data-v-52df783c]{width:100%;padding-right:100px}.ms-SearchBox.ms-SearchBox--commandBar.is-active .ms-SearchBox-icon[data-v-52df783c]{display:none}.ms-SearchBox.ms-SearchBox--commandBar.is-active .ms-SearchBox-exit[data-v-52df783c]{display:inline-block}.ms-SearchBox.ms-SearchBox--commandBar.is-active.has-text .ms-SearchBox-filter .ms-CommandButton-icon[data-v-52df783c]{color:\"[theme:neutralTertiary, default: #a6a6a6]\"}}@font-face{font-family:FabricMDL2Icons-a13498cf;src:url(https://spoprod-a.akamaihd.net/files/fabric/assets/icons/fabric-icons-a13498cf.woff) format(\"woff\")}.ms-Icon[data-v-52df783c]{display:inline-block;font-style:normal;font-weight:400}.ms-Icon.ms-Icon--Search[data-v-52df783c]::before{font-family:FabricMDL2Icons-a13498cf;content:\"\"}.ms-Icon.ms-Icon--Clear[data-v-52df783c]::before{font-family:FabricMDL2Icons-a13498cf;content:\"\"}", map: undefined, media: undefined });

    };
    /* scoped */
    const __vue_scope_id__$R = "data-v-52df783c";
    /* module identifier */
    const __vue_module_identifier__$R = undefined;
    /* functional template */
    const __vue_is_functional_template__$R = undefined;
    /* style inject */
    const __vue_create_injector__$l = function(context){ 
                  return function(scopeId, data)
                  {
                      if(window['wizstyle-'+scopeId])
                          return;
                      if(__vue_script__$R.loadStyles)
                          __vue_script__$R.loadStyles(data.source);
                      window['wizstyle-'+scopeId]=true;
                  }
              };
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var uiSearchbox = normalizeComponent(
      {},
      __vue_inject_styles__$R,
      __vue_script__$R,
      __vue_scope_id__$R,
      __vue_is_functional_template__$R,
      __vue_module_identifier__$R,
      false,
      __vue_create_injector__$l,
      undefined,
      undefined
    );

  var script$S = {
    name: 'ou-spinner',
    mixins: [type('large')],
    props: {
      label: String
    },
    computed: {
      spinnerClass: function spinnerClass() {
        return _defineProperty({}, "ms-Spinner--".concat(this.type), !!this.type);
      }
    },
    mounted: function mounted() {
      new this.$fabric.Spinner(this.$refs.spinner);
    }
  };

  /* script */
  const __vue_script__$S = script$S;

  /* template */
  var __vue_render__$v = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{ref:"spinner",staticClass:"ms-Spinner",class:_vm.spinnerClass},[(_vm.label)?_c('div',{staticClass:"ms-Spinner-label"},[_vm._v(_vm._s(_vm.label))]):_vm._e()])};
  var __vue_staticRenderFns__$v = [];

    /* style */
    const __vue_inject_styles__$S = undefined;
    /* scoped */
    const __vue_scope_id__$S = undefined;
    /* module identifier */
    const __vue_module_identifier__$S = undefined;
    /* functional template */
    const __vue_is_functional_template__$S = false;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var Spinner = normalizeComponent(
      { render: __vue_render__$v, staticRenderFns: __vue_staticRenderFns__$v },
      __vue_inject_styles__$S,
      __vue_script__$S,
      __vue_scope_id__$S,
      __vue_is_functional_template__$S,
      __vue_module_identifier__$S,
      false,
      undefined,
      undefined,
      undefined
    );

  var CircleObject = function () {
    function CircleObject(element, j) {
      this.element = element;
      this.j = j;
    }

    return CircleObject;
  }();

  var Spinner$1 = function () {
    function Spinner(container) {
      this.eightSize = 0.2;
      this.animationSpeed = 90;
      this.parentSize = 20;
      this.fadeIncrement = 0;
      this.circleObjects = [];
      this._target = container;

      this._init();
    }

    Spinner.prototype.start = function () {
      var _this = this;

      this.stop();
      this.interval = setInterval(function () {
        var i = _this.circleObjects.length;

        while (i--) {
          _this._fade(_this.circleObjects[i]);
        }
      }, this.animationSpeed);
    };

    Spinner.prototype.stop = function () {
      clearInterval(this.interval);
    };

    Spinner.prototype._init = function () {
      this._setTargetElement();

      this._setPropertiesForSize();

      this._createCirclesAndArrange();

      this._initializeOpacities();

      this.start();
    };

    Spinner.prototype._setPropertiesForSize = function () {
      if (this.spinner.className.indexOf("large") > -1) {
        this.parentSize = 28;
        this.eightSize = 0.179;
      }

      this.offsetSize = this.eightSize;
      this.numCircles = 8;
    };

    Spinner.prototype._setTargetElement = function () {
      if (this._target.className.indexOf("ms-Spinner") === -1) {
        this.spinner = document.createElement("div");
        this.spinner.className = "ms-Spinner";

        this._target.appendChild(this.spinner);
      } else {
        this.spinner = this._target;
      }
    };

    Spinner.prototype._initializeOpacities = function () {
      var i = 0;
      var j = 1;
      var opacity;
      this.fadeIncrement = 1 / this.numCircles;

      for (i; i < this.numCircles; i++) {
        var circleObject = this.circleObjects[i];
        opacity = this.fadeIncrement * j++;

        this._setOpacity(circleObject.element, opacity);
      }
    };

    Spinner.prototype._fade = function (circleObject) {
      var opacity = this._getOpacity(circleObject.element) - this.fadeIncrement;

      if (opacity <= 0) {
        opacity = 1;
      }

      this._setOpacity(circleObject.element, opacity);
    };

    Spinner.prototype._getOpacity = function (element) {
      return parseFloat(window.getComputedStyle(element).getPropertyValue("opacity"));
    };

    Spinner.prototype._setOpacity = function (element, opacity) {
      element.style.opacity = opacity.toString();
    };

    Spinner.prototype._createCircle = function () {
      var circle = document.createElement("div");
      circle.className = "ms-Spinner-circle";
      circle.style.width = circle.style.height = this.parentSize * this.offsetSize + "px";
      return circle;
    };

    Spinner.prototype._createCirclesAndArrange = function () {
      var angle = 0;
      var offset = this.parentSize * this.offsetSize;
      var step = 2 * Math.PI / this.numCircles;
      var i = this.numCircles;
      var circleObject;
      var radius = (this.parentSize - offset) * 0.5;

      while (i--) {
        var circle = this._createCircle();

        var x = Math.round(this.parentSize * 0.5 + radius * Math.cos(angle) - circle.clientWidth * 0.5) - offset * 0.5;
        var y = Math.round(this.parentSize * 0.5 + radius * Math.sin(angle) - circle.clientHeight * 0.5) - offset * 0.5;
        this.spinner.appendChild(circle);
        circle.style.left = x + "px";
        circle.style.top = y + "px";
        angle += step;
        circleObject = new CircleObject(circle, i);
        this.circleObjects.push(circleObject);
      }
    };

    return Spinner;
  }();

  var script$T = {
    loadStyles: loadThemedStyles.loadStyles,
    beforeMount: function beforeMount() {
      this.$fabric = {
        Spinner: Spinner$1
      };
    },
    mounted: function mounted() {
      var _this = this;

      // console.log("spin", this.$refs.spinner);
      var childs = this.$refs.spinner.querySelectorAll(":not([" + this.$options._scopeId + "])"); //IE vs. Array.From vs. querySelectorAll = no work >.<
      //Array.prototype.slice, does the trick instead 

      Array.prototype.slice.call(childs).map(function (c) {
        return c.setAttribute(_this.$options._scopeId, "");
      }); // Array.from(childs).map(c=>c.setAttribute(this.$options._scopeId, ""));
    },
    extends: Spinner
  };

  /* script */
  const __vue_script__$T = script$T;

  /* template */

    /* style */
    const __vue_inject_styles__$T = function (inject) {
      if (!inject) return
      inject("data-v-da2fe6b4_0", { source: ".ms-Spinner[data-v-da2fe6b4]{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;position:relative;height:20px}.ms-Spinner.ms-Spinner--large[data-v-da2fe6b4]{height:28px}.ms-Spinner.ms-Spinner--large .ms-Spinner-label[data-v-da2fe6b4]{left:34px;top:6px}.ms-Spinner-circle[data-v-da2fe6b4]{position:absolute;border-radius:100px;background-color:\"[theme:themePrimary, default: #0078d7]\";opacity:0}@media screen and (-ms-high-contrast:active){.ms-Spinner-circle[data-v-da2fe6b4]{background-color:\"[theme:white, default: #ffffff]\"}}@media screen and (-ms-high-contrast:black-on-white){.ms-Spinner-circle[data-v-da2fe6b4]{background-color:\"[theme:black, default: #000000]\"}}.ms-Spinner-label[data-v-da2fe6b4]{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;position:relative;font-size:12px;font-weight:400;color:\"[theme:themePrimary, default: #0078d7]\";left:28px;top:2px}", map: undefined, media: undefined });

    };
    /* scoped */
    const __vue_scope_id__$T = "data-v-da2fe6b4";
    /* module identifier */
    const __vue_module_identifier__$T = undefined;
    /* functional template */
    const __vue_is_functional_template__$T = undefined;
    /* style inject */
    const __vue_create_injector__$m = function(context){ 
                  return function(scopeId, data)
                  {
                      if(window['wizstyle-'+scopeId])
                          return;
                      if(__vue_script__$T.loadStyles)
                          __vue_script__$T.loadStyles(data.source);
                      window['wizstyle-'+scopeId]=true;
                  }
              };
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var uiSpinner = normalizeComponent(
      {},
      __vue_inject_styles__$T,
      __vue_script__$T,
      __vue_scope_id__$T,
      __vue_is_functional_template__$T,
      __vue_module_identifier__$T,
      false,
      __vue_create_injector__$m,
      undefined,
      undefined
    );

  var script$U = {
    name: 'ou-text-field',
    inheritAttrs: false,
    mixins: [type('multiline', 'underlined'), disabled],
    props: {
      value: [String, Number],
      label: String,
      placeholder: String,
      inputType: {
        type: String,
        default: 'text',
        validator: function validator(value) {
          return ['text', 'password', 'file', 'number'].indexOf(value) !== -1;
        }
      }
    },
    computed: {
      attrs: function attrs() {
        return this.$attrs;
      },
      textFieldClass: function textFieldClass() {
        var _ref;

        return _ref = {}, _defineProperty(_ref, "ms-TextField--".concat(this.type), !!this.type), _defineProperty(_ref, 'is-disabled', this.disabled), _ref;
      }
    },
    mounted: function mounted() {
      new this.$fabric.TextField(this.$refs.textField);
    },
    methods: {
      updateValue: function updateValue(event) {
        this.$emit('input', event.target.value);
      },
      blurEvent: function blurEvent(event) {
        this.$emit('blur', event.target.value);
      },
      changeEvent: function changeEvent(event) {
        this.$emit('change', event.target.value);
      }
    }
  };

  /* script */
  const __vue_script__$U = script$U;

  /* template */
  var __vue_render__$w = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{ref:"textField",staticClass:"ms-TextField",class:_vm.textFieldClass},[_c('label',{staticClass:"ms-Label"},[_vm._v(_vm._s(_vm.label))]),_vm._v(" "),(_vm.type == 'multiline')?_c('textarea',_vm._b({staticClass:"ms-TextField-field",attrs:{"placeholder":_vm.placeholder,"type":"text","disabled":_vm.disabled},domProps:{"value":_vm.value},on:{"input":_vm.updateValue,"change":_vm.changeEvent,"blur":_vm.blurEvent}},'textarea',_vm.attrs,false)):_c('input',_vm._b({staticClass:"ms-TextField-field",attrs:{"placeholder":_vm.placeholder,"type":_vm.inputType,"disabled":_vm.disabled},domProps:{"value":_vm.value},on:{"input":_vm.updateValue,"change":_vm.changeEvent,"blur":_vm.blurEvent}},'input',_vm.attrs,false))])};
  var __vue_staticRenderFns__$w = [];

    /* style */
    const __vue_inject_styles__$U = undefined;
    /* scoped */
    const __vue_scope_id__$U = undefined;
    /* module identifier */
    const __vue_module_identifier__$U = undefined;
    /* functional template */
    const __vue_is_functional_template__$U = false;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var textField = normalizeComponent(
      { render: __vue_render__$w, staticRenderFns: __vue_staticRenderFns__$w },
      __vue_inject_styles__$U,
      __vue_script__$U,
      __vue_scope_id__$U,
      __vue_is_functional_template__$U,
      __vue_module_identifier__$U,
      false,
      undefined,
      undefined,
      undefined
    );

  var TextFieldConsts;

  (function (TextFieldConsts) {
    var Type;

    (function (Type) {
      Type[Type["Placeholder"] = 0] = "Placeholder";
      Type[Type["Underlined"] = 1] = "Underlined";
    })(Type = TextFieldConsts.Type || (TextFieldConsts.Type = {}));
  })(TextFieldConsts || (TextFieldConsts = {}));

  var TextField = function () {
    function TextField(container) {
      this._container = container;
      this._type = [];
      this._textField = this._container.querySelector(".ms-TextField-field");
      this._textFieldLabel = this._container.querySelector(".ms-Label");

      this._setTextFieldType();

      this._addListeners();
    }

    TextField.prototype._setTextFieldType = function () {
      if (this._container.classList.contains("ms-TextField--placeholder")) {
        this._type.push(TextFieldConsts.Type.Placeholder);
      }

      if (this._container.classList.contains("ms-TextField--underlined")) {
        this._type.push(TextFieldConsts.Type.Underlined);
      }
    };

    TextField.prototype._addListeners = function () {
      var _this = this;

      this._textFieldLabel.addEventListener("click", function (event) {
        _this._textField.focus();
      });

      if (this._type.indexOf(TextFieldConsts.Type.Placeholder) >= 0) {
        this._textField.addEventListener("focus", function (event) {
          _this._textFieldLabel.style.display = "none";
        });

        this._textField.addEventListener("blur", function (event) {
          if (_this._textField.value.length === 0) {
            _this._textFieldLabel.style.display = "block";
          }
        });
      }

      if (this._type.indexOf(TextFieldConsts.Type.Underlined) >= 0) {
        this._textField.addEventListener("focus", function (event) {
          _this._container.classList.add("is-active");
        });

        this._textField.addEventListener("blur", function (event) {
          _this._container.classList.remove("is-active");
        });
      }
    };

    return TextField;
  }();

  var script$V = {
    loadStyles: loadThemedStyles.loadStyles,
    beforeMount: function beforeMount() {
      this.$fabric = {
        TextField: TextField
      };
    },
    extends: textField
  };

  /* script */
  const __vue_script__$V = script$V;

  /* template */

    /* style */
    const __vue_inject_styles__$V = function (inject) {
      if (!inject) return
      inject("data-v-b66577ac_0", { source: ".ms-Label[data-v-b66577ac]{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;box-sizing:border-box;margin:0;padding:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;color:\"[theme:neutralPrimary, default: #333333]\";font-size:12px;font-weight:400;box-sizing:border-box;display:block;padding:5px 0}.ms-Label.is-required[data-v-b66577ac]::after{content:\" *\";color:\"[theme:error, default: #a80000]\"}.ms-Label.is-disabled[data-v-b66577ac]{color:\"[theme:neutralTertiary, default: #a6a6a6]\"}.ms-TextField[data-v-b66577ac]{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;box-sizing:border-box;margin:0;padding:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;color:\"[theme:neutralPrimary, default: #333333]\";font-size:14px;font-weight:400;margin-bottom:8px}.ms-TextField .ms-Label[data-v-b66577ac]{font-size:14px;font-weight:600}.ms-TextField.is-disabled .ms-TextField-field[data-v-b66577ac]{background-color:\"[theme:neutralLighter, default: #f4f4f4]\";border-color:\"[theme:neutralLighter, default: #f4f4f4]\";pointer-events:none;cursor:default}.ms-TextField.is-disabled[data-v-b66577ac]::-webkit-input-placeholder{color:\"[theme:neutralTertiary, default: #a6a6a6]\"}.ms-TextField.is-disabled[data-v-b66577ac]::-moz-placeholder{color:\"[theme:neutralTertiary, default: #a6a6a6]\"}.ms-TextField.is-disabled[data-v-b66577ac]:-moz-placeholder{color:\"[theme:neutralTertiary, default: #a6a6a6]\"}.ms-TextField.is-disabled[data-v-b66577ac]:-ms-input-placeholder{color:\"[theme:neutralTertiary, default: #a6a6a6]\"}.ms-TextField.is-required .ms-Label[data-v-b66577ac]::after{content:\" *\";color:\"[theme:error, default: #a80000]\"}.ms-TextField.is-required[data-v-b66577ac]::-webkit-input-placeholder::after{content:\" *\";color:\"[theme:error, default: #a80000]\"}.ms-TextField.is-required[data-v-b66577ac]::-moz-placeholder::after{content:\" *\";color:\"[theme:error, default: #a80000]\"}.ms-TextField.is-required[data-v-b66577ac]:-moz-placeholder::after{content:\" *\";color:\"[theme:error, default: #a80000]\"}.ms-TextField.is-required[data-v-b66577ac]:-ms-input-placeholder::after{content:\" *\";color:\"[theme:error, default: #a80000]\"}.ms-TextField.is-active[data-v-b66577ac]{border-color:\"[theme:themePrimary, default: #0078d7]\"}.ms-TextField-field[data-v-b66577ac]{box-sizing:border-box;margin:0;padding:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;border:1px solid \"[theme:neutralTertiaryAlt, default: #c8c8c8]\";border-radius:0;font-weight:300;font-size:14px;color:\"[theme:neutralPrimary, default: #333333]\";height:32px;padding:6px 12px 7px;width:100%;min-width:180px;outline:0;text-overflow:ellipsis}.ms-TextField-field[data-v-b66577ac]:hover{border-color:\"[theme:neutralSecondaryAlt, default: #767676]\"}.ms-TextField-field[data-v-b66577ac]:focus{border-color:\"[theme:themePrimary, default: #0078d7]\"}@media screen and (-ms-high-contrast:active){.ms-TextField-field[data-v-b66577ac]:focus,.ms-TextField-field[data-v-b66577ac]:hover{border-color:#1aebff}}@media screen and (-ms-high-contrast:black-on-white){.ms-TextField-field[data-v-b66577ac]:focus,.ms-TextField-field[data-v-b66577ac]:hover{border-color:#37006e}}.ms-TextField-field[disabled][data-v-b66577ac]{background-color:\"[theme:neutralLighter, default: #f4f4f4]\";border-color:\"[theme:neutralLighter, default: #f4f4f4]\";pointer-events:none;cursor:default}.ms-TextField-field[data-v-b66577ac]::-webkit-input-placeholder{color:\"[theme:neutralSecondary, default: #666666]\"}.ms-TextField-field[data-v-b66577ac]::-moz-placeholder{color:\"[theme:neutralSecondary, default: #666666]\"}.ms-TextField-field[data-v-b66577ac]:-moz-placeholder{color:\"[theme:neutralSecondary, default: #666666]\"}.ms-TextField-field[data-v-b66577ac]:-ms-input-placeholder{color:\"[theme:neutralSecondary, default: #666666]\"}.ms-TextField-description[data-v-b66577ac]{color:\"[theme:neutralSecondaryAlt, default: #767676]\";font-size:11px}.ms-TextField.ms-TextField--placeholder[data-v-b66577ac]{position:relative;background-color:\"[theme:white, default: #ffffff]\"}.ms-TextField.ms-TextField--placeholder .ms-TextField-field[data-v-b66577ac]{position:relative;background-color:transparent;z-index:5}.ms-TextField.ms-TextField--placeholder .ms-Label[data-v-b66577ac]{position:absolute;font-weight:300;font-size:14px;color:\"[theme:neutralSecondary, default: #666666]\";padding:6px 12px 7px;pointer-events:none;z-index:0}.ms-TextField.ms-TextField--placeholder.is-disabled[data-v-b66577ac]{color:\"[theme:neutralTertiary, default: #a6a6a6]\"}.ms-TextField.ms-TextField--placeholder.is-disabled .ms-Label[data-v-b66577ac]{color:\"[theme:neutralTertiary, default: #a6a6a6]\"}.ms-TextField.ms-TextField--underlined[data-v-b66577ac]{border-bottom:1px solid \"[theme:neutralTertiaryAlt, default: #c8c8c8]\";display:table;width:100%;min-width:180px}.ms-TextField.ms-TextField--underlined[data-v-b66577ac]:hover{border-color:\"[theme:neutralSecondaryAlt, default: #767676]\"}@media screen and (-ms-high-contrast:active){.ms-TextField.ms-TextField--underlined[data-v-b66577ac]:hover{border-color:#1aebff}}@media screen and (-ms-high-contrast:black-on-white){.ms-TextField.ms-TextField--underlined[data-v-b66577ac]:hover{border-color:#37006e}}.ms-TextField.ms-TextField--underlined[data-v-b66577ac]:active,.ms-TextField.ms-TextField--underlined[data-v-b66577ac]:focus{border-color:\"[theme:themePrimary, default: #0078d7]\"}.ms-TextField.ms-TextField--underlined .ms-Label[data-v-b66577ac]{font-size:14px;margin-right:8px;display:table-cell;vertical-align:top;padding-left:12px;padding-top:9px;height:32px;width:1%;white-space:nowrap}.ms-TextField.ms-TextField--underlined .ms-TextField-field[data-v-b66577ac]{border:0;float:left;display:table-cell;text-align:left;padding-top:8px;padding-bottom:3px}.ms-TextField.ms-TextField--underlined .ms-TextField-field[data-v-b66577ac]:active,.ms-TextField.ms-TextField--underlined .ms-TextField-field[data-v-b66577ac]:focus,.ms-TextField.ms-TextField--underlined .ms-TextField-field[data-v-b66577ac]:hover{outline:0}.ms-TextField.ms-TextField--underlined.is-disabled[data-v-b66577ac]{border-bottom-color:\"[theme:neutralLight, default: #eaeaea]\"}.ms-TextField.ms-TextField--underlined.is-disabled .ms-Label[data-v-b66577ac]{color:\"[theme:neutralTertiary, default: #a6a6a6]\"}.ms-TextField.ms-TextField--underlined.is-disabled .ms-TextField-field[data-v-b66577ac]{background-color:transparent;color:\"[theme:neutralTertiary, default: #a6a6a6]\"}.ms-TextField.ms-TextField--underlined.is-active[data-v-b66577ac]{border-color:\"[theme:themePrimary, default: #0078d7]\"}@media screen and (-ms-high-contrast:active){.ms-TextField.ms-TextField--underlined.is-active[data-v-b66577ac]{border-color:#1aebff}}@media screen and (-ms-high-contrast:black-on-white){.ms-TextField.ms-TextField--underlined.is-active[data-v-b66577ac]{border-color:#37006e}}.ms-TextField.ms-TextField--multiline .ms-TextField-field[data-v-b66577ac]{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;color:\"[theme:neutralSecondary, default: #666666]\";font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;font-size:14px;font-weight:400;line-height:17px;min-height:60px;min-width:260px;padding-top:6px;overflow:auto}", map: undefined, media: undefined });

    };
    /* scoped */
    const __vue_scope_id__$V = "data-v-b66577ac";
    /* module identifier */
    const __vue_module_identifier__$V = undefined;
    /* functional template */
    const __vue_is_functional_template__$V = undefined;
    /* style inject */
    const __vue_create_injector__$n = function(context){ 
                  return function(scopeId, data)
                  {
                      if(window['wizstyle-'+scopeId])
                          return;
                      if(__vue_script__$V.loadStyles)
                          __vue_script__$V.loadStyles(data.source);
                      window['wizstyle-'+scopeId]=true;
                  }
              };
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var uiTextfield = normalizeComponent(
      {},
      __vue_inject_styles__$V,
      __vue_script__$V,
      __vue_scope_id__$V,
      __vue_is_functional_template__$V,
      __vue_module_identifier__$V,
      false,
      __vue_create_injector__$n,
      undefined,
      undefined
    );

  var script$W = {
    name: 'ou-toggle',
    mixins: [type('textLeft'), disabled],
    props: {
      value: Boolean,
      onLabel: String,
      offLabel: String,
      description: String
    },
    computed: {
      toggleClass: function toggleClass() {
        var _ref;

        return _ref = {}, _defineProperty(_ref, "ms-Toggle--".concat(this.type), !!this.type), _defineProperty(_ref, 'is-disabled', this.disabled), _ref;
      }
    },
    mounted: function mounted() {
      new this.$fabric.Toggle(this.$refs.toggle);
    },
    methods: {
      toggle: function toggle() {
        if (!this.disabled) {
          this.$emit('input', !this.value);
        }
      }
    }
  };

  /* script */
  const __vue_script__$W = script$W;

  /* template */
  var __vue_render__$x = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{ref:"toggle",staticClass:"ms-Toggle",class:_vm.toggleClass},[(_vm.description)?_c('span',{staticClass:"ms-Toggle-description"},[_vm._v("\n    "+_vm._s(_vm.description)+"\n  ")]):_vm._e(),_vm._v(" "),_c('input',{staticClass:"ms-Toggle-input",attrs:{"type":"checkbox"}}),_vm._v(" "),_c('span',{staticClass:"ms-Toggle-trigger",on:{"click":_vm.toggle}},[_c('label',{ref:"toggleLabel",staticClass:"ms-Toggle-field",class:{ 'is-selected': _vm.value },attrs:{"tabindex":"0"}},[_c('span',{staticClass:"ms-Label ms-Label--off"},[_vm._v(_vm._s(_vm.offLabel))]),_vm._v(" "),_c('span',{staticClass:"ms-Label ms-Label--on"},[_vm._v(_vm._s(_vm.onLabel))])])])])};
  var __vue_staticRenderFns__$x = [];

    /* style */
    const __vue_inject_styles__$W = undefined;
    /* scoped */
    const __vue_scope_id__$W = undefined;
    /* module identifier */
    const __vue_module_identifier__$W = undefined;
    /* functional template */
    const __vue_is_functional_template__$W = false;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var toggle = normalizeComponent(
      { render: __vue_render__$x, staticRenderFns: __vue_staticRenderFns__$x },
      __vue_inject_styles__$W,
      __vue_script__$W,
      __vue_scope_id__$W,
      __vue_is_functional_template__$W,
      __vue_module_identifier__$W,
      false,
      undefined,
      undefined,
      undefined
    );

  var Toggle = function () {
    function Toggle(container) {
      this._container = container;
      this._toggleField = this._container.querySelector(".ms-Toggle-field");

      this._addListeners();
    }

    Toggle.prototype.removeListeners = function () {
      this._toggleField.removeEventListener("click", this._toggleHandler.bind(this));
    };

    Toggle.prototype._addListeners = function () {
      var _this = this;

      this._toggleField.addEventListener("click", this._toggleHandler.bind(this), false);

      this._toggleField.addEventListener("keyup", function (e) {
        return e.keyCode === 32 ? _this._toggleHandler() : null;
      }, false);
    };

    Toggle.prototype._toggleHandler = function () {
      this._toggleField.classList.toggle("is-selected");
    };

    return Toggle;
  }();

  var script$X = {
    loadStyles: loadThemedStyles.loadStyles,
    beforeMount: function beforeMount() {
      this.$fabric = {
        Toggle: Toggle
      };
    },
    extends: toggle
  };

  /* script */
  const __vue_script__$X = script$X;

  /* template */

    /* style */
    const __vue_inject_styles__$X = function (inject) {
      if (!inject) return
      inject("data-v-29e08c9d_0", { source: ".ms-Label[data-v-29e08c9d]{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;box-sizing:border-box;margin:0;padding:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;color:\"[theme:neutralPrimary, default: #333333]\";font-size:12px;font-weight:400;box-sizing:border-box;display:block;padding:5px 0}.ms-Label.is-required[data-v-29e08c9d]::after{content:\" *\";color:\"[theme:error, default: #a80000]\"}.ms-Label.is-disabled[data-v-29e08c9d]{color:\"[theme:neutralTertiary, default: #a6a6a6]\"}.ms-Toggle[data-v-29e08c9d]{font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;font-size:14px;font-weight:400;box-sizing:border-box;margin:0;padding:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;position:relative;display:block;margin-bottom:26px}.ms-Toggle .ms-Label[data-v-29e08c9d]{position:relative;top:-2px;padding:0 0 0 50px}.ms-Toggle .ms-Toggle-field[data-v-29e08c9d]::before{position:absolute;top:3px;width:10px;height:10px;border-radius:10px;content:\"\";left:4px;background-color:\"[theme:neutralSecondary, default: #666666]\";outline:1px solid transparent;transition-property:background,left;transition-duration:250ms;transition-timing-function:cubic-bezier(.4,0,.23,1)}@media screen and (-ms-high-contrast:active){.ms-Toggle .ms-Toggle-field[data-v-29e08c9d]::before{border:2.5px solid \"[theme:white, default: #ffffff]\";height:15px;outline:0}}@media screen and (-ms-high-contrast:black-on-white){.ms-Toggle .ms-Toggle-field[data-v-29e08c9d]::before{border-color:\"[theme:black, default: #000000]\"}}.ms-Toggle .ms-Toggle-field[data-v-29e08c9d]::before{right:auto}.ms-Toggle .ms-Toggle-field .ms-Label--off[data-v-29e08c9d]{display:block}.ms-Toggle .ms-Toggle-field .ms-Label--on[data-v-29e08c9d]{display:none}.ms-Toggle .ms-Toggle-field.is-selected[data-v-29e08c9d]{background-color:\"[theme:themePrimary, default: #0078d7]\";border-color:\"[theme:themePrimary, default: #0078d7]\"}.ms-Toggle .ms-Toggle-field.is-selected[data-v-29e08c9d]::before{position:absolute;top:3px;width:10px;height:10px;border-radius:10px;content:\"\";right:4px;background-color:\"[theme:neutralSecondary, default: #666666]\";outline:1px solid transparent;transition-property:background,left;transition-duration:250ms;transition-timing-function:cubic-bezier(.4,0,.23,1)}@media screen and (-ms-high-contrast:active){.ms-Toggle .ms-Toggle-field.is-selected[data-v-29e08c9d]::before{border:2.5px solid \"[theme:white, default: #ffffff]\";height:15px;outline:0}}@media screen and (-ms-high-contrast:black-on-white){.ms-Toggle .ms-Toggle-field.is-selected[data-v-29e08c9d]::before{border-color:\"[theme:black, default: #000000]\"}}.ms-Toggle .ms-Toggle-field.is-selected[data-v-29e08c9d]::before{background-color:\"[theme:white, default: #ffffff]\";left:28px}.ms-Toggle .ms-Toggle-field.is-selected .ms-Label--off[data-v-29e08c9d]{display:none}.ms-Toggle .ms-Toggle-field.is-selected .ms-Label--on[data-v-29e08c9d]{display:block}@media screen and (-ms-high-contrast:active){.ms-Toggle .ms-Toggle-field.is-selected[data-v-29e08c9d]{background-color:\"[theme:white, default: #ffffff]\"}}@media screen and (-ms-high-contrast:black-on-white){.ms-Toggle .ms-Toggle-field.is-selected[data-v-29e08c9d]{background-color:\"[theme:black, default: #000000]\"}}.ms-Toggle:focus+.ms-Toggle-field[data-v-29e08c9d],.ms-Toggle:hover+.ms-Toggle-field[data-v-29e08c9d]{border-color:\"[theme:neutralSecondary, default: #666666]\"}.ms-Toggle:focus+.ms-Toggle-field[data-v-29e08c9d]::before,.ms-Toggle:hover+.ms-Toggle-field[data-v-29e08c9d]::before{background-color:\"[theme:neutralPrimary, default: #333333]\"}.ms-Toggle:focus:checked+.ms-Toggle-field[data-v-29e08c9d],.ms-Toggle:hover:checked+.ms-Toggle-field[data-v-29e08c9d]{background-color:\"[theme:themeDarkAlt, default: #106ebe]\";border-color:\"[theme:themeDarkAlt, default: #106ebe]\"}.ms-Toggle:focus:checked+.ms-Toggle-field[data-v-29e08c9d]::before,.ms-Toggle:hover:checked+.ms-Toggle-field[data-v-29e08c9d]::before{background-color:\"[theme:white, default: #ffffff]\"}.ms-Toggle:active:checked+.ms-Toggle-field[data-v-29e08c9d]{background-color:\"[theme:themeDark, default: #005a9e]\";border-color:\"[theme:themeDark, default: #005a9e]\"}.ms-Toggle .ms-Toggle-field[data-v-29e08c9d]:focus,.ms-Toggle .ms-Toggle-field[data-v-29e08c9d]:hover{border-color:\"[theme:neutralPrimary, default: #333333]\"}.ms-Toggle .ms-Toggle-field.is-selected[data-v-29e08c9d]:focus,.ms-Toggle .ms-Toggle-field.is-selected[data-v-29e08c9d]:hover{background-color:\"[theme:themeDarkAlt, default: #106ebe]\";border-color:\"[theme:themeDarkAlt, default: #106ebe]\"}.ms-Toggle .ms-Toggle-field .ms-Label[data-v-29e08c9d]{color:\"[theme:black, default: #000000]\";user-select:none}.ms-Toggle .ms-Toggle-field:hover .ms-Label[data-v-29e08c9d]{color:\"[theme:black, default: #000000]\"}.ms-Toggle .ms-Toggle-field:active .ms-Label[data-v-29e08c9d]{color:\"[theme:neutralPrimary, default: #333333]\"}.ms-Toggle.is-disabled .ms-Label[data-v-29e08c9d]{color:\"[theme:neutralTertiary, default: #a6a6a6]\"}.ms-Toggle.is-disabled .ms-Toggle-field[data-v-29e08c9d]{background-color:\"[theme:white, default: #ffffff]\";border-color:\"[theme:neutralTertiaryAlt, default: #c8c8c8]\";pointer-events:none;cursor:default}.ms-Toggle.is-disabled .ms-Toggle-field[data-v-29e08c9d]::before{background-color:\"[theme:neutralTertiaryAlt, default: #c8c8c8]\"}@media screen and (-ms-high-contrast:active){.ms-Toggle.is-disabled .ms-Toggle-field[data-v-29e08c9d],.ms-Toggle.is-disabled .ms-Toggle-field[data-v-29e08c9d]::before{border-color:#0f0}}@media screen and (-ms-high-contrast:black-on-white){.ms-Toggle.is-disabled .ms-Toggle-field[data-v-29e08c9d],.ms-Toggle.is-disabled .ms-Toggle-field[data-v-29e08c9d]::before{border-color:#600000}}.ms-Toggle-description[data-v-29e08c9d]{position:relative;font-size:14px;vertical-align:top;display:block;margin-bottom:8px}.ms-Toggle-field[data-v-29e08c9d]{position:relative;display:inline-block;width:45px;height:20px;box-sizing:border-box;border:2px solid \"[theme:neutralTertiary, default: #a6a6a6]\";border-radius:20px;cursor:pointer;transition-property:background,left,border-color;transition-duration:250ms;transition-timing-function:cubic-bezier(.4,0,.23,1);outline:0}.ms-Toggle-field[data-v-29e08c9d]:focus,.ms-Toggle-field[data-v-29e08c9d]:hover{border-color:\"[theme:neutralSecondary, default: #666666]\"}.ms-Toggle-input[data-v-29e08c9d]{display:none}.ms-Toggle.ms-Toggle--textLeft[data-v-29e08c9d]{width:225px;margin-bottom:40px}.ms-Toggle.ms-Toggle--textLeft .ms-Toggle-description[data-v-29e08c9d]{display:inline-block;max-width:150px;top:-3px;margin-bottom:0}.ms-Toggle.ms-Toggle--textLeft .ms-Toggle-field[data-v-29e08c9d]{float:right}", map: undefined, media: undefined });

    };
    /* scoped */
    const __vue_scope_id__$X = "data-v-29e08c9d";
    /* module identifier */
    const __vue_module_identifier__$X = undefined;
    /* functional template */
    const __vue_is_functional_template__$X = undefined;
    /* style inject */
    const __vue_create_injector__$o = function(context){ 
                  return function(scopeId, data)
                  {
                      if(window['wizstyle-'+scopeId])
                          return;
                      if(__vue_script__$X.loadStyles)
                          __vue_script__$X.loadStyles(data.source);
                      window['wizstyle-'+scopeId]=true;
                  }
              };
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var uiToggle = normalizeComponent(
      {},
      __vue_inject_styles__$X,
      __vue_script__$X,
      __vue_scope_id__$X,
      __vue_is_functional_template__$X,
      __vue_module_identifier__$X,
      false,
      __vue_create_injector__$o,
      undefined,
      undefined
    );

  var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

  function unwrapExports (x) {
  	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
  }

  function createCommonjsModule(fn, module) {
  	return module = { exports: {} }, fn(module, module.exports), module.exports;
  }

  /*! *****************************************************************************
  Copyright (c) Microsoft Corporation. All rights reserved.
  Licensed under the Apache License, Version 2.0 (the "License"); you may not use
  this file except in compliance with the License. You may obtain a copy of the
  License at http://www.apache.org/licenses/LICENSE-2.0

  THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
  WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
  MERCHANTABLITY OR NON-INFRINGEMENT.

  See the Apache Version 2.0 License for specific language governing permissions
  and limitations under the License.
  ***************************************************************************** */
  /* global Reflect, Promise */

  var extendStatics = function(d, b) {
      extendStatics = Object.setPrototypeOf ||
          ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
          function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
      return extendStatics(d, b);
  };

  function __extends(d, b) {
      extendStatics(d, b);
      function __() { this.constructor = d; }
      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  }

  var __assign = function() {
      __assign = Object.assign || function __assign(t) {
          for (var s, i = 1, n = arguments.length; i < n; i++) {
              s = arguments[i];
              for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
          }
          return t;
      };
      return __assign.apply(this, arguments);
  };

  function __rest(s, e) {
      var t = {};
      for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
          t[p] = s[p];
      if (s != null && typeof Object.getOwnPropertySymbols === "function")
          for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)
              t[p[i]] = s[p[i]];
      return t;
  }

  function __decorate(decorators, target, key, desc) {
      var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
      if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
      else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
      return c > 3 && r && Object.defineProperty(target, key, r), r;
  }

  function __param(paramIndex, decorator) {
      return function (target, key) { decorator(target, key, paramIndex); }
  }

  function __metadata(metadataKey, metadataValue) {
      if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
  }

  function __awaiter(thisArg, _arguments, P, generator) {
      return new (P || (P = Promise))(function (resolve, reject) {
          function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
          function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
          function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
          step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
  }

  function __generator(thisArg, body) {
      var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
      return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
      function verb(n) { return function (v) { return step([n, v]); }; }
      function step(op) {
          if (f) throw new TypeError("Generator is already executing.");
          while (_) try {
              if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
              if (y = 0, t) op = [op[0] & 2, t.value];
              switch (op[0]) {
                  case 0: case 1: t = op; break;
                  case 4: _.label++; return { value: op[1], done: false };
                  case 5: _.label++; y = op[1]; op = [0]; continue;
                  case 7: op = _.ops.pop(); _.trys.pop(); continue;
                  default:
                      if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                      if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                      if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                      if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                      if (t[2]) _.ops.pop();
                      _.trys.pop(); continue;
              }
              op = body.call(thisArg, _);
          } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
          if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
      }
  }

  function __exportStar(m, exports) {
      for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
  }

  function __values(o) {
      var m = typeof Symbol === "function" && o[Symbol.iterator], i = 0;
      if (m) return m.call(o);
      return {
          next: function () {
              if (o && i >= o.length) o = void 0;
              return { value: o && o[i++], done: !o };
          }
      };
  }

  function __read(o, n) {
      var m = typeof Symbol === "function" && o[Symbol.iterator];
      if (!m) return o;
      var i = m.call(o), r, ar = [], e;
      try {
          while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
      }
      catch (error) { e = { error: error }; }
      finally {
          try {
              if (r && !r.done && (m = i["return"])) m.call(i);
          }
          finally { if (e) throw e.error; }
      }
      return ar;
  }

  function __spread() {
      for (var ar = [], i = 0; i < arguments.length; i++)
          ar = ar.concat(__read(arguments[i]));
      return ar;
  }

  function __await(v) {
      return this instanceof __await ? (this.v = v, this) : new __await(v);
  }

  function __asyncGenerator(thisArg, _arguments, generator) {
      if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
      var g = generator.apply(thisArg, _arguments || []), i, q = [];
      return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
      function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
      function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
      function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
      function fulfill(value) { resume("next", value); }
      function reject(value) { resume("throw", value); }
      function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
  }

  function __asyncDelegator(o) {
      var i, p;
      return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
      function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: n === "return" } : f ? f(v) : v; } : f; }
  }

  function __asyncValues(o) {
      if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
      var m = o[Symbol.asyncIterator], i;
      return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
      function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
      function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
  }

  function __makeTemplateObject(cooked, raw) {
      if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
      return cooked;
  }
  function __importStar(mod) {
      if (mod && mod.__esModule) return mod;
      var result = {};
      if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
      result.default = mod;
      return result;
  }

  function __importDefault(mod) {
      return (mod && mod.__esModule) ? mod : { default: mod };
  }

  var tslib_es6 = /*#__PURE__*/Object.freeze({
    __proto__: null,
    __extends: __extends,
    get __assign () { return __assign; },
    __rest: __rest,
    __decorate: __decorate,
    __param: __param,
    __metadata: __metadata,
    __awaiter: __awaiter,
    __generator: __generator,
    __exportStar: __exportStar,
    __values: __values,
    __read: __read,
    __spread: __spread,
    __await: __await,
    __asyncGenerator: __asyncGenerator,
    __asyncDelegator: __asyncDelegator,
    __asyncValues: __asyncValues,
    __makeTemplateObject: __makeTemplateObject,
    __importStar: __importStar,
    __importDefault: __importDefault
  });

  var Stylesheet_1 = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  /**
   * Injection mode for the stylesheet.
   *
   * @public
   */
  var InjectionMode;
  (function (InjectionMode) {
      /**
       * Avoids style injection, use getRules() to read the styles.
       */
      InjectionMode[InjectionMode["none"] = 0] = "none";
      /**
       * Inserts rules using the insertRule api.
       */
      InjectionMode[InjectionMode["insertNode"] = 1] = "insertNode";
      /**
       * Appends rules using appendChild.
       */
      InjectionMode[InjectionMode["appendChild"] = 2] = "appendChild";
  })(InjectionMode = exports.InjectionMode || (exports.InjectionMode = {}));
  var STYLESHEET_SETTING = '__stylesheet__';
  var _stylesheet;
  /**
   * Represents the state of styles registered in the page. Abstracts
   * the surface for adding styles to the stylesheet, exposes helpers
   * for reading the styles registered in server rendered scenarios.
   *
   * @public
   */
  var Stylesheet = /** @class */ (function () {
      function Stylesheet(config) {
          this._rules = [];
          this._rulesToInsert = [];
          this._counter = 0;
          this._keyToClassName = {};
          // tslint:disable-next-line:no-any
          this._classNameToArgs = {};
          this._config = tslib_es6.__assign({ injectionMode: 1 /* insertNode */, defaultPrefix: 'css' }, config);
      }
      /**
       * Gets the singleton instance.
       */
      Stylesheet.getInstance = function () {
          // tslint:disable-next-line:no-any
          var win = typeof window !== 'undefined' ? window : {};
          _stylesheet = win[STYLESHEET_SETTING];
          if (!_stylesheet) {
              // tslint:disable-next-line:no-string-literal
              var fabricConfig = (win && win['FabricConfig']) || {};
              _stylesheet = win[STYLESHEET_SETTING] = new Stylesheet(fabricConfig.mergeStyles);
          }
          return _stylesheet;
      };
      /**
       * Configures the stylesheet.
       */
      Stylesheet.prototype.setConfig = function (config) {
          this._config = tslib_es6.__assign({}, this._config, config);
      };
      /**
       * Generates a unique classname.
       *
       * @param displayName - Optional value to use as a prefix.
       */
      Stylesheet.prototype.getClassName = function (displayName) {
          var prefix = displayName || this._config.defaultPrefix;
          return prefix + "-" + this._counter++;
      };
      /**
       * Used internally to cache information about a class which was
       * registered with the stylesheet.
       */
      Stylesheet.prototype.cacheClassName = function (className, key, args, rules) {
          this._keyToClassName[key] = className;
          this._classNameToArgs[className] = {
              args: args,
              rules: rules
          };
      };
      /**
       * Gets the appropriate classname given a key which was previously
       * registered using cacheClassName.
       */
      Stylesheet.prototype.classNameFromKey = function (key) {
          return this._keyToClassName[key];
      };
      /**
       * Gets the arguments associated with a given classname which was
       * previously registered using cacheClassName.
       */
      Stylesheet.prototype.argsFromClassName = function (className) {
          var entry = this._classNameToArgs[className];
          return (entry && entry.args);
      };
      /**
     * Gets the arguments associated with a given classname which was
     * previously registered using cacheClassName.
     */
      Stylesheet.prototype.insertedRulesFromClassName = function (className) {
          var entry = this._classNameToArgs[className];
          return (entry && entry.rules);
      };
      /**
       * Inserts a css rule into the stylesheet.
       */
      Stylesheet.prototype.insertRule = function (rule) {
          var injectionMode = this._config.injectionMode;
          var element = injectionMode !== 0 /* none */ ? this._getStyleElement() : undefined;
          if (element) {
              switch (this._config.injectionMode) {
                  case 1 /* insertNode */:
                      var sheet = element.sheet;
                      try {
                          sheet.insertRule(rule, sheet.cssRules.length);
                      }
                      catch (e) {
                          // The browser will throw exceptions on unsupported rules (such as a moz prefix in webkit.)
                          // We need to swallow the exceptions for this scenario, otherwise we'd need to filter
                          // which could be slower and bulkier.
                      }
                      break;
                  case 2 /* appendChild */:
                      element.appendChild(document.createTextNode(rule));
                      break;
              }
          }
          else {
              this._rules.push(rule);
          }
          if (this._config.onInsertRule) {
              this._config.onInsertRule(rule);
          }
      };
      /**
       * Gets all rules registered with the stylesheet; only valid when
       * using InsertionMode.none.
       */
      Stylesheet.prototype.getRules = function () {
          return (this._rules.join('') || '') + (this._rulesToInsert.join('') || '');
      };
      /**
       * Resets the internal state of the stylesheet. Only used in server
       * rendered scenarios where we're using InsertionMode.none.
       */
      Stylesheet.prototype.reset = function () {
          this._rules = [];
          this._rulesToInsert = [];
          this._counter = 0;
          this._classNameToArgs = {};
          this._keyToClassName = {};
      };
      // Forces the regeneration of incoming styles without totally resetting the stylesheet.
      Stylesheet.prototype.resetKeys = function () {
          this._keyToClassName = {};
      };
      Stylesheet.prototype._getStyleElement = function () {
          var _this = this;
          if (!this._styleElement && typeof document !== 'undefined') {
              this._styleElement = this._createStyleElement();
              // Reset the style element on the next frame.
              window.requestAnimationFrame(function () {
                  _this._styleElement = undefined;
              });
          }
          return this._styleElement;
      };
      Stylesheet.prototype._createStyleElement = function () {
          var styleElement = document.createElement('style');
          styleElement.setAttribute('data-merge-styles', 'true');
          styleElement.type = 'text/css';
          if (this._lastStyleElement && this._lastStyleElement.nextElementSibling) {
              document.head.insertBefore(styleElement, this._lastStyleElement.nextElementSibling);
          }
          else {
              document.head.appendChild(styleElement);
          }
          this._lastStyleElement = styleElement;
          return styleElement;
      };
      return Stylesheet;
  }());
  exports.Stylesheet = Stylesheet;

  });

  unwrapExports(Stylesheet_1);
  var Stylesheet_2 = Stylesheet_1.InjectionMode;
  var Stylesheet_3 = Stylesheet_1.Stylesheet;

  var kebabRules_1 = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });
  function kebabRules(rulePairs, index) {
      rulePairs[index] = rulePairs[index].replace(/([A-Z])/g, '-$1').toLowerCase();
  }
  exports.kebabRules = kebabRules;

  });

  unwrapExports(kebabRules_1);
  var kebabRules_2 = kebabRules_1.kebabRules;

  var getVendorSettings_1 = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });
  var _vendorSettings;
  function getVendorSettings() {
      if (!_vendorSettings) {
          var doc = typeof document !== 'undefined' ? document : undefined;
          var nav = typeof navigator !== 'undefined' ? navigator : undefined;
          var userAgent = nav ? nav.userAgent.toLowerCase() : undefined;
          if (!doc) {
              _vendorSettings = {
                  isWebkit: true,
                  isMoz: true,
                  isOpera: true,
                  isMs: true
              };
          }
          else {
              _vendorSettings = {
                  isWebkit: !!(doc && 'WebkitAppearance' in doc.documentElement.style),
                  isMoz: !!(userAgent && userAgent.indexOf('firefox') > -1),
                  isOpera: !!(userAgent && userAgent.indexOf('opera') > -1),
                  isMs: !!(nav && (/rv:11.0/i.test(nav.userAgent) || /Edge\/\d./i.test(navigator.userAgent)))
              };
          }
      }
      return _vendorSettings;
  }
  exports.getVendorSettings = getVendorSettings;
  /**
   * Sets the vendor settings for prefixing and vendor specific operations.
   */
  function setVendorSettings(vendorSettings) {
      _vendorSettings = vendorSettings;
  }
  exports.setVendorSettings = setVendorSettings;

  });

  unwrapExports(getVendorSettings_1);
  var getVendorSettings_2 = getVendorSettings_1.getVendorSettings;
  var getVendorSettings_3 = getVendorSettings_1.setVendorSettings;

  var prefixRules_1 = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  var autoPrefixNames = {
      'user-select': 1
  };
  function prefixRules(rulePairs, index) {
      var vendorSettings = getVendorSettings_1.getVendorSettings();
      var name = rulePairs[index];
      if (autoPrefixNames[name]) {
          var value = rulePairs[index + 1];
          if (autoPrefixNames[name]) {
              if (vendorSettings.isWebkit) {
                  rulePairs.push('-webkit-' + name, value);
              }
              if (vendorSettings.isMoz) {
                  rulePairs.push('-moz-' + name, value);
              }
              if (vendorSettings.isMs) {
                  rulePairs.push('-ms-' + name, value);
              }
              if (vendorSettings.isOpera) {
                  rulePairs.push('-o-' + name, value);
              }
          }
      }
  }
  exports.prefixRules = prefixRules;

  });

  unwrapExports(prefixRules_1);
  var prefixRules_2 = prefixRules_1.prefixRules;

  var provideUnits_1 = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });
  var NON_PIXEL_NUMBER_PROPS = [
      'column-count',
      'font-weight',
      'flex-basis',
      'flex',
      'flex-grow',
      'flex-shrink',
      'fill-opacity',
      'opacity',
      'order',
      'z-index',
      'zoom'
  ];
  function provideUnits(rulePairs, index) {
      var name = rulePairs[index];
      var value = rulePairs[index + 1];
      if (typeof value === 'number') {
          var unit = (NON_PIXEL_NUMBER_PROPS.indexOf(name) === -1) ? 'px' : '';
          rulePairs[index + 1] = "" + value + unit;
      }
  }
  exports.provideUnits = provideUnits;

  });

  unwrapExports(provideUnits_1);
  var provideUnits_2 = provideUnits_1.provideUnits;

  var rtlifyRules_1 = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  var LEFT = 'left';
  var RIGHT = 'right';
  var NO_FLIP = '@noflip';
  var NAME_REPLACEMENTS = (_a = {},
      _a[LEFT] = RIGHT,
      _a[RIGHT] = LEFT,
      _a);
  var VALUE_REPLACEMENTS = {
      'w-resize': 'e-resize',
      'sw-resize': 'se-resize',
      'nw-resize': 'ne-resize'
  };
  var _rtl = getRTL();
  /**
   * Sets the current RTL value.
   */
  function setRTL(isRTL) {
      if (_rtl !== isRTL) {
          Stylesheet_1.Stylesheet.getInstance().resetKeys();
          _rtl = isRTL;
      }
  }
  exports.setRTL = setRTL;
  /**
   * Gets the current RTL value.
   */
  function getRTL() {
      if (_rtl === undefined) {
          _rtl = (typeof document !== 'undefined' &&
              !!document.documentElement &&
              document.documentElement.getAttribute('dir') === 'rtl');
      }
      return _rtl;
  }
  exports.getRTL = getRTL;
  /**
   * RTLifies the rulePair in the array at the current index. This mutates the array for performance
   * reasons.
   */
  function rtlifyRules(rulePairs, index) {
      if (getRTL()) {
          var name_1 = rulePairs[index];
          if (!name_1) {
              return;
          }
          var value = rulePairs[index + 1];
          if (typeof value === 'string' && value.indexOf(NO_FLIP) >= 0) {
              rulePairs[index + 1] = value.replace(/\s*(?:\/\*\s*)?\@noflip\b(?:\s*\*\/)?\s*?/g, '');
          }
          else if (name_1.indexOf(LEFT) >= 0) {
              rulePairs[index] = name_1.replace(LEFT, RIGHT);
          }
          else if (name_1.indexOf(RIGHT) >= 0) {
              rulePairs[index] = name_1.replace(RIGHT, LEFT);
          }
          else if (String(value).indexOf(LEFT) >= 0) {
              rulePairs[index + 1] = value.replace(LEFT, RIGHT);
          }
          else if (String(value).indexOf(RIGHT) >= 0) {
              rulePairs[index + 1] = value.replace(RIGHT, LEFT);
          }
          else if (NAME_REPLACEMENTS[name_1]) {
              rulePairs[index] = NAME_REPLACEMENTS[name_1];
          }
          else if (VALUE_REPLACEMENTS[value]) {
              rulePairs[index + 1] = VALUE_REPLACEMENTS[value];
          }
          else {
              switch (name_1) {
                  case 'margin':
                  case 'padding':
                      rulePairs[index + 1] = flipQuad(value);
                      break;
                  case 'box-shadow':
                      rulePairs[index + 1] = negateNum(value, 0);
                      break;
              }
          }
      }
  }
  exports.rtlifyRules = rtlifyRules;
  /**
   * Given a string value in a space delimited format (e.g. "1 2 3 4"), negates a particular value.
   */
  function negateNum(value, partIndex) {
      var parts = value.split(' ');
      var numberVal = parseInt(parts[partIndex], 10);
      parts[0] = parts[0].replace(String(numberVal), String(numberVal * -1));
      return parts.join(' ');
  }
  /**
   * Given a string quad, flips the left and right values.
   */
  function flipQuad(value) {
      if (typeof value === 'string') {
          var parts = value.split(' ');
          if (parts.length === 4) {
              return parts[0] + " " + parts[3] + " " + parts[2] + " " + parts[1];
          }
      }
      return value;
  }
  var _a;

  });

  unwrapExports(rtlifyRules_1);
  var rtlifyRules_2 = rtlifyRules_1.setRTL;
  var rtlifyRules_3 = rtlifyRules_1.getRTL;
  var rtlifyRules_4 = rtlifyRules_1.rtlifyRules;

  var styleToClassName_1 = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });





  var DISPLAY_NAME = 'displayName';
  function getDisplayName(rules) {
      var rootStyle = rules && rules['&'];
      return rootStyle ? rootStyle.displayName : undefined;
  }
  function extractRules(args, rules, currentSelector) {
      if (rules === void 0) { rules = { __order: [] }; }
      if (currentSelector === void 0) { currentSelector = '&'; }
      var stylesheet = Stylesheet_1.Stylesheet.getInstance();
      var currentRules = rules[currentSelector];
      if (!currentRules) {
          currentRules = {};
          rules[currentSelector] = currentRules;
          rules.__order.push(currentSelector);
      }
      for (var _i = 0, args_1 = args; _i < args_1.length; _i++) {
          var arg = args_1[_i];
          // If the arg is a string, we need to look up the class map and merge.
          if (typeof arg === 'string') {
              var expandedRules = stylesheet.argsFromClassName(arg);
              if (expandedRules) {
                  extractRules(expandedRules, rules, currentSelector);
              }
              // Else if the arg is an array, we need to recurse in.
          }
          else if (Array.isArray(arg)) {
              extractRules(arg, rules, currentSelector);
          }
          else {
              // tslint:disable-next-line:no-any
              for (var prop in arg) {
                  if (prop === 'selectors') {
                      // tslint:disable-next-line:no-any
                      var selectors = arg.selectors;
                      for (var newSelector in selectors) {
                          if (selectors.hasOwnProperty(newSelector)) {
                              var selectorValue = selectors[newSelector];
                              if (newSelector.indexOf(':global(') === 0) {
                                  newSelector = newSelector.replace(/:global\(|\)$/g, '');
                              }
                              else if (newSelector.indexOf('@media') === 0) {
                                  newSelector = newSelector + '{' + currentSelector;
                              }
                              else if (newSelector.indexOf(':') === 0) {
                                  newSelector = currentSelector + newSelector;
                              }
                              else if (newSelector.indexOf('&') < 0) {
                                  newSelector = currentSelector + ' ' + newSelector;
                              }
                              extractRules([selectorValue], rules, newSelector);
                          }
                      }
                  }
                  else {
                      // Else, add the rule to the currentSelector.
                      if (prop === 'margin' || prop === 'padding') {
                          // tslint:disable-next-line:no-any
                          expandQuads(currentRules, prop, arg[prop]);
                      }
                      else {
                          // tslint:disable-next-line:no-any
                          currentRules[prop] = arg[prop];
                      }
                  }
              }
          }
      }
      return rules;
  }
  function expandQuads(currentRules, name, value) {
      var parts = (typeof value === 'string') ? value.split(' ') : [value];
      currentRules[name + 'Top'] = parts[0];
      currentRules[name + 'Right'] = parts[1] || parts[0];
      currentRules[name + 'Bottom'] = parts[2] || parts[0];
      currentRules[name + 'Left'] = parts[3] || parts[1] || parts[0];
  }
  function getKeyForRules(rules) {
      var serialized = [];
      var hasProps = false;
      for (var _i = 0, _a = rules.__order; _i < _a.length; _i++) {
          var selector = _a[_i];
          serialized.push(selector);
          var rulesForSelector = rules[selector];
          for (var propName in rulesForSelector) {
              if (rulesForSelector.hasOwnProperty(propName) && rulesForSelector[propName] !== undefined) {
                  hasProps = true;
                  serialized.push(propName, rulesForSelector[propName]);
              }
          }
      }
      return hasProps ? serialized.join('') : undefined;
  }
  function serializeRuleEntries(ruleEntries) {
      if (!ruleEntries) {
          return '';
      }
      var allEntries = [];
      for (var entry in ruleEntries) {
          if (ruleEntries.hasOwnProperty(entry) && entry !== DISPLAY_NAME && ruleEntries[entry] !== undefined) {
              allEntries.push(entry, ruleEntries[entry]);
          }
      }
      // Apply transforms.
      for (var i = 0; i < allEntries.length; i += 2) {
          kebabRules_1.kebabRules(allEntries, i);
          provideUnits_1.provideUnits(allEntries, i);
          rtlifyRules_1.rtlifyRules(allEntries, i);
          prefixRules_1.prefixRules(allEntries, i);
      }
      // Apply punctuation.
      for (var i = 1; i < allEntries.length; i += 4) {
          allEntries.splice(i, 1, ':', allEntries[i], ';');
      }
      return allEntries.join('');
  }
  exports.serializeRuleEntries = serializeRuleEntries;
  function styleToRegistration() {
      var args = [];
      for (var _i = 0; _i < arguments.length; _i++) {
          args[_i] = arguments[_i];
      }
      var rules = extractRules(args);
      var key = getKeyForRules(rules);
      if (key) {
          var stylesheet = Stylesheet_1.Stylesheet.getInstance();
          var registration = {
              className: stylesheet.classNameFromKey(key),
              key: key,
              args: args
          };
          if (!registration.className) {
              registration.className = stylesheet.getClassName(getDisplayName(rules));
              var rulesToInsert = [];
              for (var _a = 0, _b = rules.__order; _a < _b.length; _a++) {
                  var selector = _b[_a];
                  rulesToInsert.push(selector, serializeRuleEntries(rules[selector]));
              }
              registration.rulesToInsert = rulesToInsert;
          }
          return registration;
      }
  }
  exports.styleToRegistration = styleToRegistration;
  function applyRegistration(registration, classMap) {
      var stylesheet = Stylesheet_1.Stylesheet.getInstance();
      var className = registration.className, key = registration.key, args = registration.args, rulesToInsert = registration.rulesToInsert;
      if (rulesToInsert) {
          // rulesToInsert is an ordered array of selector/rule pairs.
          for (var i = 0; i < rulesToInsert.length; i += 2) {
              var rules = rulesToInsert[i + 1];
              if (rules) {
                  var selector = rulesToInsert[i];
                  // Fix selector using map.
                  selector = selector.replace(/(&)|\$([\w-]+)\b/g, function (match, amp, cn) {
                      if (amp) {
                          return '.' + registration.className;
                      }
                      else if (cn) {
                          return '.' + ((classMap && classMap[cn]) || cn);
                      }
                      return '';
                  });
                  // Insert. Note if a media query, we must close the query with a final bracket.
                  var processedRule = selector + "{" + rules + "}" + ((selector.indexOf('@media') === 0) ? '}' : '');
                  stylesheet.insertRule(processedRule);
              }
          }
          stylesheet.cacheClassName(className, key, args, rulesToInsert);
      }
  }
  exports.applyRegistration = applyRegistration;
  function styleToClassName() {
      var args = [];
      for (var _i = 0; _i < arguments.length; _i++) {
          args[_i] = arguments[_i];
      }
      var registration = styleToRegistration.apply(void 0, args);
      if (registration) {
          applyRegistration(registration);
          return registration.className;
      }
      return '';
  }
  exports.styleToClassName = styleToClassName;

  });

  unwrapExports(styleToClassName_1);
  var styleToClassName_2 = styleToClassName_1.serializeRuleEntries;
  var styleToClassName_3 = styleToClassName_1.styleToRegistration;
  var styleToClassName_4 = styleToClassName_1.applyRegistration;
  var styleToClassName_5 = styleToClassName_1.styleToClassName;

  var extractStyleParts_1 = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  /**
   * Separates the classes and style objects. Any classes that are pre-registered
   * args are auto expanded into objects.
   */
  function extractStyleParts() {
      var args = [];
      for (var _i = 0; _i < arguments.length; _i++) {
          args[_i] = arguments[_i];
      }
      var classes = [];
      var objects = [];
      var stylesheet = Stylesheet_1.Stylesheet.getInstance();
      function _processArgs(argsList) {
          for (var _i = 0, argsList_1 = argsList; _i < argsList_1.length; _i++) {
              var arg = argsList_1[_i];
              if (arg) {
                  if (typeof arg === 'string') {
                      if (arg.indexOf(' ') >= 0) {
                          _processArgs(arg.split(' '));
                      }
                      else {
                          var translatedArgs = stylesheet.argsFromClassName(arg);
                          if (translatedArgs) {
                              _processArgs(translatedArgs);
                          }
                          else {
                              // Avoid adding the same class twice.
                              if (classes.indexOf(arg) === -1) {
                                  classes.push(arg);
                              }
                          }
                      }
                  }
                  else if (Array.isArray(arg)) {
                      _processArgs(arg);
                  }
                  else if (typeof arg === 'object') {
                      objects.push(arg);
                  }
              }
          }
      }
      _processArgs(args);
      return {
          classes: classes,
          objects: objects
      };
  }
  exports.extractStyleParts = extractStyleParts;

  });

  unwrapExports(extractStyleParts_1);
  var extractStyleParts_2 = extractStyleParts_1.extractStyleParts;

  var mergeStyles_1 = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });


  /**
   * Concatination helper, which can merge class names together. Skips over falsey values.
   *
   * @public
   */
  function mergeStyles() {
      var args = [];
      for (var _i = 0; _i < arguments.length; _i++) {
          args[_i] = arguments[_i];
      }
      var _a = extractStyleParts_1.extractStyleParts(args), classes = _a.classes, objects = _a.objects;
      if (objects.length) {
          classes.push(styleToClassName_1.styleToClassName(objects));
      }
      return classes.join(' ');
  }
  exports.mergeStyles = mergeStyles;

  });

  unwrapExports(mergeStyles_1);
  var mergeStyles_2 = mergeStyles_1.mergeStyles;

  var concatStyleSets_1 = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });
  /**
   * Combine a set of styles together (but does not register css classes.)
   * @public
   */
  function concatStyleSets() {
      var args = [];
      for (var _i = 0; _i < arguments.length; _i++) {
          args[_i] = arguments[_i];
      }
      // tslint:disable-next-line:no-any
      var mergedSet = {};
      for (var _a = 0, args_1 = args; _a < args_1.length; _a++) {
          var currentSet = args_1[_a];
          if (currentSet) {
              for (var prop in currentSet) {
                  if (currentSet.hasOwnProperty(prop)) {
                      var mergedValue = mergedSet[prop];
                      var currentValue = currentSet[prop];
                      if (mergedValue === undefined) {
                          mergedSet[prop] = currentValue;
                      }
                      else {
                          mergedSet[prop] = (Array.isArray(mergedValue) ? mergedValue : [mergedValue]).concat((Array.isArray(currentValue) ? currentValue : [currentValue]));
                      }
                  }
              }
          }
      }
      return mergedSet;
  }
  exports.concatStyleSets = concatStyleSets;

  });

  unwrapExports(concatStyleSets_1);
  var concatStyleSets_2 = concatStyleSets_1.concatStyleSets;

  var mergeStyleSets_1 = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });



  /**
   * Allows you to pass in 1 or more sets of areas which will return a merged
   * set of classes.
   *
   * @public
   */
  function mergeStyleSets() {
      var cssSets = [];
      for (var _i = 0; _i < arguments.length; _i++) {
          cssSets[_i] = arguments[_i];
      }
      // tslint:disable-next-line:no-any
      var classNameSet = {};
      var classMap = {};
      var cssSet = cssSets[0];
      if (cssSet) {
          if (cssSets.length > 1) {
              cssSet = concatStyleSets_1.concatStyleSets.apply(void 0, cssSets);
          }
          var registrations = [];
          for (var prop in cssSet) {
              if (cssSet.hasOwnProperty(prop)) {
                  var args = cssSet[prop];
                  // tslint:disable-next-line:no-any
                  var _a = extractStyleParts_1.extractStyleParts(args), classes = _a.classes, objects = _a.objects;
                  var registration = styleToClassName_1.styleToRegistration({ displayName: prop }, objects);
                  registrations.push(registration);
                  if (registration) {
                      classMap[prop] = registration.className;
                      classNameSet[prop] = classes.concat([registration.className]).join(' ');
                  }
              }
          }
          for (var _b = 0, registrations_1 = registrations; _b < registrations_1.length; _b++) {
              var registration = registrations_1[_b];
              if (registration) {
                  styleToClassName_1.applyRegistration(registration, classMap);
              }
          }
      }
      return classNameSet;
  }
  exports.mergeStyleSets = mergeStyleSets;

  });

  unwrapExports(mergeStyleSets_1);
  var mergeStyleSets_2 = mergeStyleSets_1.mergeStyleSets;

  var fontFace_1 = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });


  /**
   * Registers a font face.
   * @public
   */
  function fontFace(font) {
      Stylesheet_1.Stylesheet.getInstance().insertRule("@font-face{" + styleToClassName_1.serializeRuleEntries(font) + "}");
  }
  exports.fontFace = fontFace;

  });

  unwrapExports(fontFace_1);
  var fontFace_2 = fontFace_1.fontFace;

  var keyframes_1 = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });


  /**
   * Registers keyframe definitions.
   *
   * @public
   */
  function keyframes(timeline) {
      var stylesheet = Stylesheet_1.Stylesheet.getInstance();
      var name = stylesheet.getClassName();
      var rulesArray = [];
      for (var prop in timeline) {
          if (timeline.hasOwnProperty(prop)) {
              rulesArray.push(prop, '{', styleToClassName_1.serializeRuleEntries(timeline[prop]), '}');
          }
      }
      var rules = rulesArray.join('');
      stylesheet.insertRule("@keyframes " + name + "{" + rules + "}");
      stylesheet.cacheClassName(name, rules, [], ['keyframes', rules]);
      return name;
  }
  exports.keyframes = keyframes;

  });

  unwrapExports(keyframes_1);
  var keyframes_2 = keyframes_1.keyframes;

  var lib = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.mergeStyles = mergeStyles_1.mergeStyles;

  exports.mergeStyleSets = mergeStyleSets_1.mergeStyleSets;

  exports.concatStyleSets = concatStyleSets_1.concatStyleSets;

  exports.fontFace = fontFace_1.fontFace;

  exports.keyframes = keyframes_1.keyframes;

  exports.InjectionMode = Stylesheet_1.InjectionMode;
  exports.Stylesheet = Stylesheet_1.Stylesheet;

  });

  unwrapExports(lib);
  var lib_1 = lib.mergeStyles;
  var lib_2 = lib.mergeStyleSets;
  var lib_3 = lib.concatStyleSets;
  var lib_4 = lib.fontFace;
  var lib_5 = lib.keyframes;
  var lib_6 = lib.InjectionMode;
  var lib_7 = lib.Stylesheet;

  //
  //
  //
  //
  var iconData = [{
    bundle: 'a13498cf',
    icons: {
      GlobalNavButton: 'E700',
      ChevronDown: 'E70D',
      ChevronUp: 'E70E',
      Edit: 'E70F',
      Add: 'E710',
      Cancel: 'E711',
      More: 'E712',
      Settings: 'E713',
      Mail: 'E715',
      Filter: 'E71C',
      Search: 'E721',
      Share: 'E72D',
      BlockedSite: 'E72F',
      FavoriteStar: 'E734',
      FavoriteStarFill: 'E735',
      CheckMark: 'E73E',
      Delete: 'E74D',
      ChevronLeft: 'E76B',
      ChevronRight: 'E76C',
      Calendar: 'E787',
      Megaphone: 'E789',
      Undo: 'E7A7',
      Flag: 'E7C1',
      Page: 'E7C3',
      Pinned: 'E840',
      View: 'E890',
      Clear: 'E894',
      Download: 'E896',
      Upload: 'E898',
      Folder: 'E8B7',
      Sort: 'E8CB',
      AlignRight: 'E8E2',
      AlignLeft: 'E8E4',
      Tag: 'E8EC',
      AddFriend: 'E8FA',
      Info: 'E946',
      SortLines: 'E9D0',
      List: 'EA37',
      CircleRing: 'EA3A',
      Heart: 'EB51',
      HeartFill: 'EB52',
      Tiles: 'ECA5',
      Embed: 'ECCE',
      Glimmer: 'ECF4',
      Ascending: 'EDC0',
      Descending: 'EDC1',
      SortUp: 'EE68',
      SortDown: 'EE69',
      SyncToPC: 'EE6E',
      LargeGrid: 'EECB',
      SkypeCheck: 'EF80',
      SkypeClock: 'EF81',
      SkypeMinus: 'EF82',
      ClearFilter: 'EF8F',
      Flow: 'EF90',
      StatusCircleCheckmark: 'F13E',
      MoreVertical: 'F2BC'
    }
  }, {
    bundle: '0-29734c63',
    icons: {
      DecreaseIndentLegacy: 'E290',
      IncreaseIndentLegacy: 'E291',
      SizeLegacy: 'E2B2',
      InternetSharing: 'E704',
      Brightness: 'E706',
      MapPin: 'E707',
      Airplane: 'E709',
      Tablet: 'E70A',
      QuickNote: 'E70B',
      Video: 'E714',
      People: 'E716',
      Phone: 'E717',
      Pin: 'E718',
      Shop: 'E719',
      Stop: 'E71A',
      Link: 'E71B',
      AllApps: 'E71D',
      Zoom: 'E71E',
      ZoomOut: 'E71F',
      Microphone: 'E720',
      Camera: 'E722',
      Attach: 'E723',
      Send: 'E724',
      FavoriteList: 'E728',
      PageSolid: 'E729',
      Forward: 'E72A',
      Back: 'E72B',
      Refresh: 'E72C',
      Lock: 'E72E',
      ReportHacked: 'E730',
      EMI: 'E731',
      MiniLink: 'E732',
      Blocked: 'E733',
      ReadingMode: 'E736',
      Favicon: 'E737',
      Remove: 'E738',
      Checkbox: 'E739',
      CheckboxComposite: 'E73A',
      CheckboxIndeterminate: 'E73C',
      CheckboxCompositeReversed: 'E73D',
      BackToWindow: 'E73F',
      FullScreen: 'E740',
      Print: 'E749',
      Up: 'E74A',
      Down: 'E74B',
      OEM: 'E74C',
      Save: 'E74E',
      Cloud: 'E753',
      CommandPrompt: 'E756',
      Sad: 'E757',
      SIPMove: 'E759',
      EraseTool: 'E75C',
      GripperTool: 'E75E',
      Dialpad: 'E75F',
      PageLeft: 'E760',
      PageRight: 'E761',
      MultiSelect: 'E762',
      KeyboardClassic: 'E765',
      Play: 'E768',
      Pause: 'E769',
      Emoji2: 'E76E',
      GripperBarHorizontal: 'E76F',
      System: 'E770',
      Personalize: 'E771',
      SearchAndApps: 'E773',
      Globe: 'E774',
      ContactInfo: 'E779',
      Unpin: 'E77A',
      Contact: 'E77B',
      Memo: 'E77C',
      Paste: 'E77F',
      WindowsLogo: 'E782',
      Error: 'E783',
      GripperBarVertical: 'E784',
      Unlock: 'E785',
      AutoEnhanceOn: 'E78D',
      AutoEnhanceOff: 'E78E',
      Color: 'E790',
      SaveAs: 'E792',
      Light: 'E793',
      Filters: 'E795',
      AspectRatio: 'E799',
      Contrast: 'E7A1',
      Redo: 'E7A6',
      Crop: 'E7A8',
      PhotoCollection: 'E7AA',
      Album: 'E7AB',
      Rotate: 'E7AD',
      PanoIndicator: 'E7B0',
      RedEye: 'E7B3',
      ThumbnailView: 'E7B6',
      Package: 'E7B8',
      Warning: 'E7BA',
      Financial: 'E7BB',
      Education: 'E7BE',
      ShoppingCart: 'E7BF',
      Train: 'E7C0',
      Move: 'E7C2',
      TouchPointer: 'E7C9',
      Merge: 'E7D5'
    }
  }, {
    bundle: '1-a653c37c',
    icons: {
      TurnRight: 'E7DB',
      Ferry: 'E7E3',
      Highlight: 'E7E6',
      PowerButton: 'E7E8',
      Tab: 'E7E9',
      Admin: 'E7EF',
      TVMonitor: 'E7F4',
      Speakers: 'E7F5',
      StackIndicator: 'E7FF',
      Nav2DMapView: 'E800',
      Car: 'E804',
      Bus: 'E806',
      EatDrink: 'E807',
      LocationCircle: 'E80E',
      Home: 'E80F',
      SwitcherStartEnd: 'E810',
      ParkingLocation: 'E811',
      IncidentTriangle: 'E814',
      Touch: 'E815',
      MapDirections: 'E816',
      CaretHollow: 'E817',
      CaretSolid: 'E818',
      History: 'E81C',
      Location: 'E81D',
      Work: 'E821',
      Recent: 'E823',
      Hotel: 'E824',
      LocationDot: 'E827',
      Dictionary: 'E82D',
      ChromeBack: 'E830',
      FolderOpen: 'E838',
      PinnedFill: 'E842',
      RevToggleKey: 'E845',
      Previous: 'E892',
      Next: 'E893',
      Sync: 'E895',
      Help: 'E897',
      Emoji: 'E899',
      MailForward: 'E89C',
      ClosePane: 'E89F',
      OpenPane: 'E8A0',
      PreviewLink: 'E8A1',
      ZoomIn: 'E8A3',
      Bookmarks: 'E8A4',
      Document: 'E8A5',
      ProtectedDocument: 'E8A6',
      OpenInNewWindow: 'E8A7',
      MailFill: 'E8A8',
      ViewAll: 'E8A9',
      Switch: 'E8AB',
      Rename: 'E8AC',
      Remote: 'E8AF',
      SelectAll: 'E8B3',
      Orientation: 'E8B4',
      Import: 'E8B5',
      Picture: 'E8B9',
      ChromeClose: 'E8BB',
      ShowResults: 'E8BC',
      Message: 'E8BD',
      CalendarDay: 'E8BF',
      CalendarWeek: 'E8C0',
      MailReplyAll: 'E8C2',
      Read: 'E8C3',
      Cut: 'E8C6',
      PaymentCard: 'E8C7',
      Copy: 'E8C8',
      Important: 'E8C9',
      MailReply: 'E8CA',
      GotoToday: 'E8D1',
      Font: 'E8D2',
      FontColor: 'E8D3',
      FolderFill: 'E8D5',
      Permissions: 'E8D7',
      DisableUpdates: 'E8D8',
      Unfavorite: 'E8D9',
      Italic: 'E8DB',
      Underline: 'E8DC',
      Bold: 'E8DD',
      MoveToFolder: 'E8DE',
      Dislike: 'E8E0',
      Like: 'E8E1',
      AlignCenter: 'E8E3',
      OpenFile: 'E8E5',
      FontDecrease: 'E8E7',
      FontIncrease: 'E8E8',
      FontSize: 'E8E9',
      CellPhone: 'E8EA',
      Calculator: 'E8EF',
      Library: 'E8F1',
      PostUpdate: 'E8F3',
      NewFolder: 'E8F4',
      CalendarReply: 'E8F5',
      UnsyncFolder: 'E8F6',
      SyncFolder: 'E8F7',
      BlockContact: 'E8F8',
      Accept: 'E8FB',
      BulletedList: 'E8FD',
      Preview: 'E8FF',
      News: 'E900',
      Chat: 'E901'
    }
  }, {
    bundle: '2-b9379dbc',
    icons: {
      Group: 'E902',
      World: 'E909',
      Comment: 'E90A',
      DockLeft: 'E90C',
      DockRight: 'E90D',
      Repair: 'E90F',
      Accounts: 'E910',
      RadioBullet: 'E915',
      Stopwatch: 'E916',
      Clock: 'E917',
      WorldClock: 'E918',
      AlarmClock: 'E919',
      Photo: 'E91B',
      Hospital: 'E91D',
      Timer: 'E91E',
      FullCircleMask: 'E91F',
      LocationFill: 'E920',
      ChromeMinimize: 'E921',
      Annotation: 'E924',
      Fingerprint: 'E928',
      Handwriting: 'E929',
      Completed: 'E930',
      Label: 'E932',
      FlickDown: 'E935',
      FlickUp: 'E936',
      FlickLeft: 'E937',
      FlickRight: 'E938',
      MiniExpand: 'E93A',
      MiniContract: 'E93B',
      Streaming: 'E93E',
      MusicInCollection: 'E940',
      OneDriveLogo: 'E941',
      CompassNW: 'E942',
      Code: 'E943',
      LightningBolt: 'E945',
      CalculatorMultiply: 'E947',
      CalculatorAddition: 'E948',
      CalculatorSubtract: 'E949',
      CalculatorEqualTo: 'E94E',
      PrintfaxPrinterFile: 'E956',
      Communications: 'E95A',
      Headset: 'E95B',
      Health: 'E95E',
      ChevronUpSmall: 'E96D',
      ChevronDownSmall: 'E96E',
      ChevronLeftSmall: 'E96F',
      ChevronRightSmall: 'E970',
      ChevronUpMed: 'E971',
      ChevronDownMed: 'E972',
      ChevronLeftMed: 'E973',
      ChevronRightMed: 'E974',
      PC1: 'E977',
      PresenceChickletVideo: 'E979',
      Reply: 'E97A',
      HalfAlpha: 'E97E',
      ConstructionCone: 'E98F',
      DoubleChevronLeftMed: 'E991',
      Volume0: 'E992',
      Volume1: 'E993',
      Volume2: 'E994',
      Volume3: 'E995',
      Chart: 'E999',
      Robot: 'E99A',
      Manufacturing: 'E99C',
      LockSolid: 'E9A2',
      BidiLtr: 'E9AA',
      BidiRtl: 'E9AB',
      RightDoubleQuote: 'E9B1',
      Sunny: 'E9BD',
      CloudWeather: 'E9BE',
      Cloudy: 'E9BF',
      PartlyCloudyDay: 'E9C0',
      PartlyCloudyNight: 'E9C1',
      ClearNight: 'E9C2',
      RainShowersDay: 'E9C3',
      Rain: 'E9C4',
      Thunderstorms: 'E9C6',
      RainSnow: 'E9C7',
      Snow: 'E9C8',
      BlowingSnow: 'E9C9',
      Frigid: 'E9CA',
      Fog: 'E9CB',
      Squalls: 'E9CC',
      Duststorm: 'E9CD',
      Unknown: 'E9CE',
      Precipitation: 'E9CF',
      Ribbon: 'E9D1',
      AreaChart: 'E9D2',
      Assign: 'E9D3',
      CheckList: 'E9D5',
      Diagnostic: 'E9D9',
      Generate: 'E9DA',
      LineChart: 'E9E6',
      Equalizer: 'E9E9',
      BarChartHorizontal: 'E9EB',
      BarChartVertical: 'E9EC',
      Freezing: 'E9EF',
      Processing: 'E9F5',
      SnowShowerDay: 'E9FD',
      HailDay: 'EA00'
    }
  }, {
    bundle: '3-ef2110da',
    icons: {
      WorkFlow: 'EA01',
      HourGlass: 'EA03',
      StoreLogoMed20: 'EA04',
      TimeSheet: 'EA05',
      TriangleSolid: 'EA08',
      VideoSolid: 'EA0C',
      RainShowersNight: 'EA0F',
      SnowShowerNight: 'EA11',
      Teamwork: 'EA12',
      HailNight: 'EA13',
      PeopleAdd: 'EA15',
      Glasses: 'EA16',
      DateTime2: 'EA17',
      Shield: 'EA18',
      Header1: 'EA19',
      PageAdd: 'EA1A',
      NumberedList: 'EA1C',
      PowerBILogo: 'EA1E',
      Info2: 'EA1F',
      MusicInCollectionFill: 'EA36',
      Asterisk: 'EA38',
      ErrorBadge: 'EA39',
      CircleFill: 'EA3B',
      Record2: 'EA3F',
      AllAppsMirrored: 'EA40',
      BookmarksMirrored: 'EA41',
      BulletedListMirrored: 'EA42',
      CaretHollowMirrored: 'EA45',
      CaretSolidMirrored: 'EA46',
      ChromeBackMirrored: 'EA47',
      ClosePaneMirrored: 'EA49',
      DockLeftMirrored: 'EA4C',
      DoubleChevronLeftMedMirrored: 'EA4D',
      HelpMirrored: 'EA51',
      ImportMirrored: 'EA52',
      ListMirrored: 'EA55',
      MailForwardMirrored: 'EA56',
      MailReplyMirrored: 'EA57',
      MailReplyAllMirrored: 'EA58',
      OpenPaneMirrored: 'EA5B',
      ParkingLocationMirrored: 'EA5E',
      SendMirrored: 'EA63',
      ShowResultsMirrored: 'EA65',
      ThumbnailViewMirrored: 'EA67',
      Devices3: 'EA6C',
      Lightbulb: 'EA80',
      StatusTriangle: 'EA82',
      VolumeDisabled: 'EA85',
      Puzzle: 'EA86',
      EmojiNeutral: 'EA87',
      EmojiDisappointed: 'EA88',
      HomeSolid: 'EA8A',
      Ringer: 'EA8F',
      PDF: 'EA90',
      HeartBroken: 'EA92',
      StoreLogo16: 'EA96',
      MultiSelectMirrored: 'EA98',
      Broom: 'EA99',
      Cocktails: 'EA9D',
      Wines: 'EABF',
      Articles: 'EAC1',
      Cycling: 'EAC7',
      DietPlanNotebook: 'EAC8',
      Pill: 'EACB',
      ExerciseTracker: 'EACC',
      HandsFree: 'EAD0',
      Medical: 'EAD4',
      Running: 'EADA',
      Weights: 'EADB',
      Trackers: 'EADF',
      AddNotes: 'EAE3',
      AllCurrency: 'EAE4',
      BarChart4: 'EAE7',
      CirclePlus: 'EAEE',
      Coffee: 'EAEF',
      Cotton: 'EAF3',
      Market: 'EAFC',
      Money: 'EAFD',
      PieDouble: 'EB04',
      PieSingle: 'EB05',
      RemoveFilter: 'EB08',
      Savings: 'EB0B',
      Sell: 'EB0C',
      StockDown: 'EB0F',
      StockUp: 'EB11',
      Lamp: 'EB19',
      Source: 'EB1B',
      MSNVideos: 'EB1C',
      Cricket: 'EB1E',
      Golf: 'EB1F',
      Baseball: 'EB20',
      Soccer: 'EB21',
      MoreSports: 'EB22',
      AutoRacing: 'EB24',
      CollegeHoops: 'EB25',
      CollegeFootball: 'EB26',
      ProFootball: 'EB27',
      ProHockey: 'EB28',
      Rugby: 'EB2D',
      SubstitutionsIn: 'EB31'
    }
  }, {
    bundle: '4-aeecd474',
    icons: {
      Tennis: 'EB33',
      Arrivals: 'EB34',
      Design: 'EB3C',
      Website: 'EB41',
      Drop: 'EB42',
      SkiResorts: 'EB45',
      Snowflake: 'EB46',
      BusSolid: 'EB47',
      FerrySolid: 'EB48',
      AirplaneSolid: 'EB4C',
      TrainSolid: 'EB4D',
      Ticket: 'EB54',
      Devices4: 'EB66',
      AzureLogo: 'EB6A',
      BingLogo: 'EB6B',
      MSNLogo: 'EB6C',
      OutlookLogoInverse: 'EB6D',
      OfficeLogo: 'EB6E',
      SkypeLogo: 'EB6F',
      Door: 'EB75',
      EditMirrored: 'EB7E',
      GiftCard: 'EB8E',
      DoubleBookmark: 'EB8F',
      StatusErrorFull: 'EB90',
      Certificate: 'EB95',
      FastForward: 'EB9D',
      Rewind: 'EB9E',
      Photo2: 'EB9F',
      OpenSource: 'EBC2',
      Movers: 'EBCD',
      CloudDownload: 'EBD3',
      Family: 'EBDA',
      WindDirection: 'EBE6',
      Bug: 'EBE8',
      SiteScan: 'EBEC',
      BrowserScreenShot: 'EBED',
      F12DevTools: 'EBEE',
      CSS: 'EBEF',
      JS: 'EBF0',
      DeliveryTruck: 'EBF4',
      ReminderPerson: 'EBF7',
      ReminderGroup: 'EBF8',
      TabletMode: 'EBFC',
      Umbrella: 'EC04',
      NetworkTower: 'EC05',
      CityNext: 'EC06',
      Section: 'EC0C',
      OneNoteLogoInverse: 'EC0D',
      ToggleFilled: 'EC11',
      ToggleBorder: 'EC12',
      SliderThumb: 'EC13',
      ToggleThumb: 'EC14',
      Documentation: 'EC17',
      Badge: 'EC1B',
      Giftbox: 'EC1F',
      VisualStudioLogo: 'EC22',
      ExcelLogoInverse: 'EC28',
      WordLogoInverse: 'EC29',
      PowerPointLogoInverse: 'EC2A',
      Cafe: 'EC32',
      SpeedHigh: 'EC4A',
      Commitments: 'EC4D',
      ThisPC: 'EC4E',
      MusicNote: 'EC4F',
      MicOff: 'EC54',
      EdgeLogo: 'EC60',
      CompletedSolid: 'EC61',
      AlbumRemove: 'EC62',
      MessageFill: 'EC70',
      TabletSelected: 'EC74',
      MobileSelected: 'EC75',
      LaptopSelected: 'EC76',
      TVMonitorSelected: 'EC77',
      DeveloperTools: 'EC7A',
      InsertTextBox: 'EC7D',
      LowerBrightness: 'EC8A',
      DOM: 'EC8D',
      CloudUpload: 'EC8E',
      ScrollUpDown: 'EC8F',
      DateTime: 'EC92',
      Event: 'ECA3',
      Cake: 'ECA4',
      Org: 'ECA6',
      PartyLeader: 'ECA7',
      DRM: 'ECA8',
      CloudAdd: 'ECA9',
      AppIconDefault: 'ECAA',
      Photo2Add: 'ECAB',
      Photo2Remove: 'ECAC',
      POI: 'ECAF',
      AddTo: 'ECC8',
      RadioBtnOff: 'ECCA',
      RadioBtnOn: 'ECCB',
      ExploreContent: 'ECCD',
      Product: 'ECDC',
      ProgressLoopInner: 'ECDE',
      ProgressLoopOuter: 'ECDF',
      Blocked2: 'ECE4',
      FangBody: 'ECEB',
      ChatInviteFriend: 'ECFE'
    }
  }, {
    bundle: '5-f6547654',
    icons: {
      Crown: 'ED01',
      Diamond: 'ED02',
      ScaleUp: 'ED09',
      Feedback: 'ED15',
      SharepointLogoInverse: 'ED18',
      YammerLogo: 'ED19',
      Hide: 'ED1A',
      Uneditable: 'ED1D',
      ReturnToSession: 'ED24',
      OpenFolderHorizontal: 'ED25',
      CalendarMirrored: 'ED28',
      SwayLogoInverse: 'ED29',
      OutOfOffice: 'ED34',
      Trophy: 'ED3F',
      ReopenPages: 'ED50',
      EmojiTabSymbols: 'ED58',
      AADLogo: 'ED68',
      AccessLogo: 'ED69',
      AdminALogoInverse32: 'ED6A',
      AdminCLogoInverse32: 'ED6B',
      AdminDLogoInverse32: 'ED6C',
      AdminELogoInverse32: 'ED6D',
      AdminLLogoInverse32: 'ED6E',
      AdminMLogoInverse32: 'ED6F',
      AdminOLogoInverse32: 'ED70',
      AdminPLogoInverse32: 'ED71',
      AdminSLogoInverse32: 'ED72',
      AdminYLogoInverse32: 'ED73',
      DelveLogoInverse: 'ED76',
      ExchangeLogoInverse: 'ED78',
      LyncLogo: 'ED79',
      OfficeVideoLogoInverse: 'ED7A',
      SocialListeningLogo: 'ED7C',
      VisioLogoInverse: 'ED7D',
      Balloons: 'ED7E',
      Cat: 'ED7F',
      MailAlert: 'ED80',
      MailCheck: 'ED81',
      MailLowImportance: 'ED82',
      MailPause: 'ED83',
      MailRepeat: 'ED84',
      SecurityGroup: 'ED85',
      Table: 'ED86',
      VoicemailForward: 'ED87',
      VoicemailReply: 'ED88',
      Waffle: 'ED89',
      RemoveEvent: 'ED8A',
      EventInfo: 'ED8B',
      ForwardEvent: 'ED8C',
      WipePhone: 'ED8D',
      AddOnlineMeeting: 'ED8E',
      JoinOnlineMeeting: 'ED8F',
      RemoveLink: 'ED90',
      PeopleBlock: 'ED91',
      PeopleRepeat: 'ED92',
      PeopleAlert: 'ED93',
      PeoplePause: 'ED94',
      TransferCall: 'ED95',
      AddPhone: 'ED96',
      UnknownCall: 'ED97',
      NoteReply: 'ED98',
      NoteForward: 'ED99',
      NotePinned: 'ED9A',
      RemoveOccurrence: 'ED9B',
      Timeline: 'ED9C',
      EditNote: 'ED9D',
      CircleHalfFull: 'ED9E',
      Room: 'ED9F',
      Unsubscribe: 'EDA0',
      Subscribe: 'EDA1',
      HardDrive: 'EDA2',
      RecurringTask: 'EDB2',
      TaskManager: 'EDB7',
      TaskManagerMirrored: 'EDB8',
      Combine: 'EDBB',
      Split: 'EDBC',
      DoubleChevronUp: 'EDBD',
      DoubleChevronLeft: 'EDBE',
      DoubleChevronRight: 'EDBF',
      TextBox: 'EDC2',
      TextField: 'EDC3',
      NumberField: 'EDC4',
      Dropdown: 'EDC5',
      BookingsLogo: 'EDC7',
      ClassNotebookLogoInverse: 'EDC8',
      DelveAnalyticsLogo: 'EDCA',
      DocsLogoInverse: 'EDCB',
      Dynamics365Logo: 'EDCC',
      DynamicSMBLogo: 'EDCD',
      OfficeAssistantLogo: 'EDCE',
      OfficeStoreLogo: 'EDCF',
      OneNoteEduLogoInverse: 'EDD0',
      PlannerLogo: 'EDD1',
      PowerApps: 'EDD2',
      Suitcase: 'EDD3',
      ProjectLogoInverse: 'EDD4',
      CaretLeft8: 'EDD5',
      CaretRight8: 'EDD6',
      CaretUp8: 'EDD7',
      CaretDown8: 'EDD8'
    }
  }, {
    bundle: '6-3954c770',
    icons: {
      CaretLeftSolid8: 'EDD9',
      CaretRightSolid8: 'EDDA',
      CaretUpSolid8: 'EDDB',
      CaretDownSolid8: 'EDDC',
      ClearFormatting: 'EDDD',
      Superscript: 'EDDE',
      Subscript: 'EDDF',
      Strikethrough: 'EDE0',
      Export: 'EDE1',
      ExportMirrored: 'EDE2',
      SingleBookmark: 'EDFF',
      SingleBookmarkSolid: 'EE00',
      DoubleChevronDown: 'EE04',
      FollowUser: 'EE05',
      ReplyAll: 'EE0A',
      WorkforceManagement: 'EE0F',
      RecruitmentManagement: 'EE12',
      Questionnaire: 'EE19',
      ManagerSelfService: 'EE23',
      ReplyMirrored: 'EE35',
      ReplyAllMirrored: 'EE36',
      Medal: 'EE38',
      AddGroup: 'EE3D',
      QuestionnaireMirrored: 'EE4B',
      TemporaryUser: 'EE58',
      CaretSolid16: 'EE62',
      GroupedDescending: 'EE66',
      GroupedAscending: 'EE67',
      AwayStatus: 'EE6A',
      MyMoviesTV: 'EE6C',
      GenericScan: 'EE6F',
      AustralianRules: 'EE70',
      WifiEthernet: 'EE77',
      TrackersMirrored: 'EE92',
      DateTimeMirrored: 'EE93',
      StopSolid: 'EE95',
      DoubleChevronUp12: 'EE96',
      DoubleChevronDown12: 'EE97',
      DoubleChevronLeft12: 'EE98',
      DoubleChevronRight12: 'EE99',
      CalendarAgenda: 'EE9A',
      AddEvent: 'EEB5',
      AssetLibrary: 'EEB6',
      DataConnectionLibrary: 'EEB7',
      DocLibrary: 'EEB8',
      FormLibrary: 'EEB9',
      FormLibraryMirrored: 'EEBA',
      ReportLibrary: 'EEBB',
      ReportLibraryMirrored: 'EEBC',
      ContactCard: 'EEBD',
      CustomList: 'EEBE',
      CustomListMirrored: 'EEBF',
      IssueTracking: 'EEC0',
      IssueTrackingMirrored: 'EEC1',
      PictureLibrary: 'EEC2',
      OfficeAddinsLogo: 'EEC7',
      OfflineOneDriveParachute: 'EEC8',
      OfflineOneDriveParachuteDisabled: 'EEC9',
      TriangleSolidUp12: 'EECC',
      TriangleSolidDown12: 'EECD',
      TriangleSolidLeft12: 'EECE',
      TriangleSolidRight12: 'EECF',
      TriangleUp12: 'EED0',
      TriangleDown12: 'EED1',
      TriangleLeft12: 'EED2',
      TriangleRight12: 'EED3',
      ArrowUpRight8: 'EED4',
      ArrowDownRight8: 'EED5',
      DocumentSet: 'EED6',
      DelveAnalytics: 'EEEE',
      ArrowUpRightMirrored8: 'EEEF',
      ArrowDownRightMirrored8: 'EEF0',
      CompanyDirectory: 'EF0D',
      CompanyDirectoryMirrored: 'EF2B',
      OneDriveAdd: 'EF32',
      ProfileSearch: 'EF35',
      Header2: 'EF36',
      Header3: 'EF37',
      Header4: 'EF38',
      Eyedropper: 'EF3C',
      MarketDown: 'EF42',
      CalendarWorkWeek: 'EF51',
      SidePanel: 'EF52',
      GlobeFavorite: 'EF53',
      CaretTopLeftSolid8: 'EF54',
      CaretTopRightSolid8: 'EF55',
      ViewAll2: 'EF56',
      DocumentReply: 'EF57',
      PlayerSettings: 'EF58',
      ReceiptForward: 'EF59',
      ReceiptReply: 'EF5A',
      ReceiptCheck: 'EF5B',
      Fax: 'EF5C',
      RecurringEvent: 'EF5D',
      ReplyAlt: 'EF5E',
      ReplyAllAlt: 'EF5F',
      EditStyle: 'EF60',
      EditMail: 'EF61',
      Lifesaver: 'EF62',
      LifesaverLock: 'EF63'
    }
  }, {
    bundle: '7-02107cf8',
    icons: {
      InboxCheck: 'EF64',
      FolderSearch: 'EF65',
      CollapseMenu: 'EF66',
      ExpandMenu: 'EF67',
      Boards: 'EF68',
      SunAdd: 'EF69',
      SunQuestionMark: 'EF6A',
      LandscapeOrientation: 'EF6B',
      DocumentSearch: 'EF6C',
      PublicCalendar: 'EF6D',
      PublicContactCard: 'EF6E',
      PublicEmail: 'EF6F',
      PublicFolder: 'EF70',
      WordDocument: 'EF71',
      PowerPointDocument: 'EF72',
      ExcelDocument: 'EF73',
      GroupedList: 'EF74',
      ClassroomLogo: 'EF75',
      Sections: 'EF76',
      EditPhoto: 'EF77',
      Starburst: 'EF78',
      ShareiOS: 'EF79',
      AirTickets: 'EF7A',
      PencilReply: 'EF7B',
      Tiles2: 'EF7C',
      SkypeCircleCheck: 'EF7D',
      SkypeCircleClock: 'EF7E',
      SkypeCircleMinus: 'EF7F',
      SkypeMessage: 'EF83',
      ClosedCaption: 'EF84',
      ATPLogo: 'EF85',
      OfficeFormsLogoInverse: 'EF86',
      RecycleBin: 'EF87',
      EmptyRecycleBin: 'EF88',
      Hide2: 'EF89',
      Breadcrumb: 'EF8C',
      BirthdayCake: 'EF8D',
      TimeEntry: 'EF95',
      PageEdit: 'EFB6',
      PageRemove: 'EFBA',
      Database: 'EFC7',
      EditContact: 'EFD3',
      ConnectContacts: 'EFD4',
      ActivateOrders: 'EFE0',
      DeactivateOrders: 'EFE1',
      DocumentManagement: 'EFFC',
      CRMReport: 'EFFE',
      ZipFolder: 'F012',
      SurveyQuestions: 'F01B',
      TextDocument: 'F029',
      TextDocumentShared: 'F02B',
      PageCheckedOut: 'F02C',
      SaveAndClose: 'F038',
      Script: 'F03A',
      Archive: 'F03F',
      ActivityFeed: 'F056',
      EventDate: 'F059',
      ArrowUpRight: 'F069',
      CaretRight: 'F06B',
      SetAction: 'F071',
      CaretSolidLeft: 'F08D',
      CaretSolidDown: 'F08E',
      CaretSolidRight: 'F08F',
      CaretSolidUp: 'F090',
      PowerAppsLogo: 'F091',
      PowerApps2Logo: 'F092',
      SearchIssue: 'F09A',
      SearchIssueMirrored: 'F09B',
      FabricAssetLibrary: 'F09C',
      FabricDataConnectionLibrary: 'F09D',
      FabricDocLibrary: 'F09E',
      FabricFormLibrary: 'F09F',
      FabricFormLibraryMirrored: 'F0A0',
      FabricReportLibrary: 'F0A1',
      FabricReportLibraryMirrored: 'F0A2',
      FabricPublicFolder: 'F0A3',
      FabricFolderSearch: 'F0A4',
      FabricMovetoFolder: 'F0A5',
      FabricUnsyncFolder: 'F0A6',
      FabricSyncFolder: 'F0A7',
      FabricOpenFolderHorizontal: 'F0A8',
      FabricFolder: 'F0A9',
      FabricFolderFill: 'F0AA',
      FabricNewFolder: 'F0AB',
      FabricPictureLibrary: 'F0AC',
      AddFavorite: 'F0C8',
      AddFavoriteFill: 'F0C9',
      BufferTimeBefore: 'F0CF',
      BufferTimeAfter: 'F0D0',
      BufferTimeBoth: 'F0D1',
      CannedChat: 'F0F2',
      SkypeForBusinessLogo: 'F0FC',
      PageCheckedin: 'F104',
      ReadOutLoud: 'F112',
      CaretBottomLeftSolid8: 'F121',
      CaretBottomRightSolid8: 'F122',
      FolderHorizontal: 'F12B',
      MicrosoftStaffhubLogo: 'F130',
      GiftboxOpen: 'F133',
      StatusCircleOuter: 'F136'
    }
  }, {
    bundle: '8-645fa64e',
    icons: {
      StatusCircleInner: 'F137',
      StatusCircleRing: 'F138',
      StatusTriangleOuter: 'F139',
      StatusTriangleInner: 'F13A',
      StatusTriangleExclamation: 'F13B',
      StatusCircleExclamation: 'F13C',
      StatusCircleErrorX: 'F13D',
      StatusCircleInfo: 'F13F',
      StatusCircleBlock2: 'F141',
      StatusCircleQuestionMark: 'F142',
      Toll: 'F160',
      ExploreContentSingle: 'F164',
      CollapseContent: 'F165',
      CollapseContentSingle: 'F166',
      InfoSolid: 'F167',
      ProgressRingDots: 'F16A',
      CaloriesAdd: 'F172',
      BranchFork: 'F173',
      MobileReport: 'F18A',
      HardDriveGroup: 'F18F',
      FastMode: 'F19A',
      ToggleOn: 'F19E',
      ToggleOff: 'F19F',
      Trophy2: 'F1AE',
      BucketColor: 'F1B6',
      BucketColorFill: 'F1B7',
      Taskboard: 'F1C2',
      SingleColumn: 'F1D3',
      DoubleColumn: 'F1D4',
      TripleColumn: 'F1D5',
      ColumnLeftTwoThirds: 'F1D6',
      ColumnRightTwoThirds: 'F1D7',
      AccessLogoFill: 'F1DB',
      AnalyticsLogo: 'F1DE',
      AnalyticsQuery: 'F1DF',
      NewAnalyticsQuery: 'F1E0',
      AnalyticsReport: 'F1E1',
      WordLogo: 'F1E3',
      WordLogoFill: 'F1E4',
      ExcelLogo: 'F1E5',
      ExcelLogoFill: 'F1E6',
      OneNoteLogo: 'F1E7',
      OneNoteLogoFill: 'F1E8',
      OutlookLogo: 'F1E9',
      OutlookLogoFill: 'F1EA',
      PowerPointLogo: 'F1EB',
      PowerPointLogoFill: 'F1EC',
      PublisherLogo: 'F1ED',
      PublisherLogoFill: 'F1EE',
      ScheduleEventAction: 'F1EF',
      FlameSolid: 'F1F3',
      ServerProcesses: 'F1FE',
      Server: 'F201',
      SaveAll: 'F203',
      LinkedInLogo: 'F20A',
      Decimals: 'F218',
      SidePanelMirrored: 'F221',
      ProtectRestrict: 'F22A',
      UnknownMirrored: 'F22E',
      PublicContactCardMirrored: 'F230',
      GridViewSmall: 'F232',
      GridViewMedium: 'F233',
      GridViewLarge: 'F234',
      Step: 'F241',
      StepInsert: 'F242',
      StepShared: 'F243',
      StepSharedAdd: 'F244',
      StepSharedInsert: 'F245',
      ViewDashboard: 'F246',
      ViewList: 'F247',
      ViewListGroup: 'F248',
      ViewListTree: 'F249',
      TriggerAuto: 'F24A',
      TriggerUser: 'F24B',
      PivotChart: 'F24C',
      StackedBarChart: 'F24D',
      StackedLineChart: 'F24E',
      BuildQueue: 'F24F',
      BuildQueueNew: 'F250',
      UserFollowed: 'F25C',
      ContactLink: 'F25F',
      Stack: 'F26F',
      Bullseye: 'F272',
      VennDiagram: 'F273',
      FiveTileGrid: 'F274',
      FocalPoint: 'F277',
      RingerRemove: 'F279',
      TeamsLogoInverse: 'F27A',
      TeamsLogo: 'F27B',
      TeamsLogoFill: 'F27C',
      SkypeForBusinessLogoFill: 'F27D',
      SharepointLogo: 'F27E',
      SharepointLogoFill: 'F27F',
      DelveLogo: 'F280',
      DelveLogoFill: 'F281',
      OfficeVideoLogo: 'F282',
      OfficeVideoLogoFill: 'F283',
      ExchangeLogo: 'F284',
      ExchangeLogoFill: 'F285',
      DocumentApproval: 'F28B'
    }
  }, {
    bundle: '9-53746c82',
    icons: {
      CloneToDesktop: 'F28C',
      InstallToDrive: 'F28D',
      Blur: 'F28E',
      Build: 'F28F',
      ProcessMetaTask: 'F290',
      BranchFork2: 'F291',
      BranchLocked: 'F292',
      BranchCommit: 'F293',
      BranchCompare: 'F294',
      BranchMerge: 'F295',
      BranchPullRequest: 'F296',
      BranchSearch: 'F297',
      BranchShelveset: 'F298',
      RawSource: 'F299',
      MergeDuplicate: 'F29A',
      RowsGroup: 'F29B',
      RowsChild: 'F29C',
      Deploy: 'F29D',
      Redeploy: 'F29E',
      ServerEnviroment: 'F29F',
      VisioDiagram: 'F2A0',
      HighlightMappedShapes: 'F2A1',
      TextCallout: 'F2A2',
      IconSetsFlag: 'F2A4',
      VisioLogo: 'F2A7',
      VisioLogoFill: 'F2A8',
      VisioDocument: 'F2A9',
      TimelineProgress: 'F2AA',
      TimelineDelivery: 'F2AB',
      Backlog: 'F2AC',
      TeamFavorite: 'F2AD',
      TaskGroup: 'F2AE',
      TaskGroupMirrored: 'F2AF',
      ScopeTemplate: 'F2B0',
      AssessmentGroupTemplate: 'F2B1',
      NewTeamProject: 'F2B2',
      CommentAdd: 'F2B3',
      CommentNext: 'F2B4',
      CommentPrevious: 'F2B5',
      ShopServer: 'F2B6',
      LocaleLanguage: 'F2B7',
      QueryList: 'F2B8',
      UserSync: 'F2B9',
      UserPause: 'F2BA',
      StreamingOff: 'F2BB',
      ArrowTallUpLeft: 'F2BD',
      ArrowTallUpRight: 'F2BE',
      ArrowTallDownLeft: 'F2BF',
      ArrowTallDownRight: 'F2C0',
      FieldEmpty: 'F2C1',
      FieldFilled: 'F2C2',
      FieldChanged: 'F2C3',
      FieldNotChanged: 'F2C4',
      RingerOff: 'F2C5',
      PlayResume: 'F2C6',
      BulletedList2: 'F2C7',
      BulletedList2Mirrored: 'F2C8',
      ImageCrosshair: 'F2C9',
      GitGraph: 'F2CA',
      Repo: 'F2CB',
      RepoSolid: 'F2CC',
      FolderQuery: 'F2CD',
      FolderList: 'F2CE',
      FolderListMirrored: 'F2CF',
      LocationOutline: 'F2D0',
      POISolid: 'F2D1',
      CalculatorNotEqualTo: 'F2D2',
      BoxSubtractSolid: 'F2D3',
      BoxAdditionSolid: 'F2D4',
      BoxMultiplySolid: 'F2D5',
      BoxPlaySolid: 'F2D6',
      BoxCheckmarkSolid: 'F2D7',
      CirclePauseSolid: 'F2D8',
      CirclePause: 'F2D9',
      MSNVideosSolid: 'F2DA',
      CircleStopSolid: 'F2DB',
      CircleStop: 'F2DC',
      NavigateBack: 'F2DD',
      NavigateBackMirrored: 'F2DE',
      NavigateForward: 'F2DF',
      NavigateForwardMirrored: 'F2E0',
      UnknownSolid: 'F2E1',
      UnknownMirroredSolid: 'F2E2',
      CircleAddition: 'F2E3',
      CircleAdditionSolid: 'F2E4',
      FilePDB: 'F2E5',
      FileTemplate: 'F2E6',
      FileSQL: 'F2E7',
      FileJAVA: 'F2E8',
      FileASPX: 'F2E9',
      FileCSS: 'F2EA',
      FileSass: 'F2EB',
      FileLess: 'F2EC',
      FileHTML: 'F2ED',
      JavaScriptLanguage: 'F2EE',
      CSharpLanguage: 'F2EF',
      CSharp: 'F2F0',
      VisualBasicLanguage: 'F2F1',
      VB: 'F2F2',
      CPlusPlusLanguage: 'F2F3'
    }
  }, {
    bundle: '10-fb519450',
    icons: {
      CPlusPlus: 'F2F4',
      FSharpLanguage: 'F2F5',
      FSharp: 'F2F6',
      TypeScriptLanguage: 'F2F7',
      PythonLanguage: 'F2F8',
      PY: 'F2F9',
      CoffeeScript: 'F2FA',
      MarkDownLanguage: 'F2FB',
      FullWidth: 'F2FE',
      FullWidthEdit: 'F2FF',
      Plug: 'F300',
      PlugSolid: 'F301',
      PlugConnected: 'F302',
      PlugDisconnected: 'F303',
      UnlockSolid: 'F304',
      Variable: 'F305',
      Parameter: 'F306',
      CommentUrgent: 'F307',
      Storyboard: 'F308',
      DiffInline: 'F309',
      DiffSideBySide: 'F30A',
      ImageDiff: 'F30B',
      ImagePixel: 'F30C',
      FileBug: 'F30D',
      FileCode: 'F30E',
      FileComment: 'F30F',
      BusinessHoursSign: 'F310',
      FileImage: 'F311',
      FileSymlink: 'F312',
      AutoFillTemplate: 'F313',
      WorkItem: 'F314',
      WorkItemBug: 'F315',
      LogRemove: 'F316',
      ColumnOptions: 'F317',
      Packages: 'F318',
      BuildIssue: 'F319',
      AssessmentGroup: 'F31A',
      VariableGroup: 'F31B',
      FullHistory: 'F31C',
      SingleColumnEdit: 'F321',
      DoubleColumnEdit: 'F322',
      TripleColumnEdit: 'F323',
      ColumnLeftTwoThirdsEdit: 'F324',
      ColumnRightTwoThirdsEdit: 'F325',
      StreamLogo: 'F329',
      PassiveAuthentication: 'F32A',
      AlertSolid: 'F331',
      MegaphoneSolid: 'F332',
      TaskSolid: 'F333',
      ConfigurationSolid: 'F334',
      BugSolid: 'F335',
      CrownSolid: 'F336',
      Trophy2Solid: 'F337',
      QuickNoteSolid: 'F338',
      ConstructionConeSolid: 'F339',
      PageListSolid: 'F33A',
      PageListMirroredSolid: 'F33B',
      StarburstSolid: 'F33C',
      ReadingModeSolid: 'F33D',
      SadSolid: 'F33E',
      HealthSolid: 'F33F',
      ShieldSolid: 'F340',
      GiftBoxSolid: 'F341',
      ShoppingCartSolid: 'F342',
      MailSolid: 'F343',
      ChatSolid: 'F344',
      RibbonSolid: 'F345',
      FinancialSolid: 'F346',
      FinancialMirroredSolid: 'F347',
      HeadsetSolid: 'F348',
      PermissionsSolid: 'F349',
      ParkingSolid: 'F34A',
      ParkingMirroredSolid: 'F34B',
      DiamondSolid: 'F34C',
      AsteriskSolid: 'F34D',
      OfflineStorageSolid: 'F34E',
      BankSolid: 'F34F',
      DecisionSolid: 'F350',
      Parachute: 'F351',
      ParachuteSolid: 'F352',
      FiltersSolid: 'F353',
      ColorSolid: 'F354',
      ReviewSolid: 'F355',
      ReviewRequestSolid: 'F356',
      ReviewRequestMirroredSolid: 'F357',
      ReviewResponseSolid: 'F358',
      FeedbackRequestSolid: 'F359',
      FeedbackRequestMirroredSolid: 'F35A',
      FeedbackResponseSolid: 'F35B',
      WorkItemBar: 'F35C',
      WorkItemBarSolid: 'F35D',
      Separator: 'F35E',
      NavigateExternalInline: 'F35F',
      PlanView: 'F360',
      TimelineMatrixView: 'F361',
      EngineeringGroup: 'F362',
      ProjectCollection: 'F363',
      CaretBottomRightCenter8: 'F364',
      CaretBottomLeftCenter8: 'F365',
      CaretTopRightCenter8: 'F366'
    }
  }, {
    bundle: '11-a4026982',
    icons: {
      CaretTopLeftCenter8: 'F367',
      DonutChart: 'F368',
      ChevronUnfold10: 'F369',
      ChevronFold10: 'F36A',
      DoubleChevronDown8: 'F36B',
      DoubleChevronUp8: 'F36C',
      DoubleChevronLeft8: 'F36D',
      DoubleChevronRight8: 'F36E',
      ChevronDownEnd6: 'F36F',
      ChevronUpEnd6: 'F370',
      ChevronLeftEnd6: 'F371',
      ChevronRightEnd6: 'F372',
      ContextMenu: 'F37C',
      AzureAPIManagement: 'F37F',
      AzureServiceEndpoint: 'F380',
      VSTSLogo: 'F381',
      VSTSAltLogo1: 'F382',
      VSTSAltLogo2: 'F383',
      FileTypeSolution: 'F387',
      WordLogoInverse16: 'F390',
      WordLogo16: 'F391',
      WordLogoFill16: 'F392',
      PowerPointLogoInverse16: 'F393',
      PowerPointLogo16: 'F394',
      PowerPointLogoFill16: 'F395',
      ExcelLogoInverse16: 'F396',
      ExcelLogo16: 'F397',
      ExcelLogoFill16: 'F398',
      OneNoteLogoInverse16: 'F399',
      OneNoteLogo16: 'F39A',
      OneNoteLogoFill16: 'F39B',
      OutlookLogoInverse16: 'F39C',
      OutlookLogo16: 'F39D',
      OutlookLogoFill16: 'F39E',
      PublisherLogoInverse16: 'F39F',
      PublisherLogo16: 'F3A0',
      PublisherLogoFill16: 'F3A1',
      VisioLogoInverse16: 'F3A2',
      VisioLogo16: 'F3A3',
      VisioLogoFill16: 'F3A4',
      TestBeaker: 'F3A5',
      TestBeakerSolid: 'F3A6',
      TestExploreSolid: 'F3A7',
      TestAutoSolid: 'F3A8',
      TestUserSolid: 'F3A9',
      TestImpactSolid: 'F3AA',
      TestPlan: 'F3AB',
      TestStep: 'F3AC',
      TestParameter: 'F3AD',
      TestSuite: 'F3AE',
      TestCase: 'F3AF',
      Sprint: 'F3B0',
      SignOut: 'F3B1',
      TriggerApproval: 'F3B2',
      Rocket: 'F3B3',
      AzureKeyVault: 'F3B4',
      Transition: 'F3BC',
      LikeSolid: 'F3BF',
      DislikeSolid: 'F3C0',
      UnSetColor: 'F3F9',
      DeclineCall: 'F405',
      RectangularClipping: 'F407',
      TeamsLogo16: 'F40A',
      TeamsLogoFill16: 'F40B',
      Spacer: 'F40D',
      SkypeLogo16: 'F40E',
      SkypeForBusinessLogo16: 'F40F',
      SkypeForBusinessLogoFill16: 'F410',
      FilterSolid: 'F412',
      MailUndelivered: 'F415',
      MailTentative: 'F416',
      MailTentativeMirrored: 'F417',
      MailReminder: 'F418',
      ReceiptUndelivered: 'F419',
      ReceiptTentative: 'F41A',
      ReceiptTentativeMirrored: 'F41B',
      Inbox: 'F41C',
      IRMReply: 'F41D',
      IRMReplyMirrored: 'F41E',
      IRMForward: 'F41F',
      IRMForwardMirrored: 'F420',
      VoicemailIRM: 'F421',
      EventAccepted: 'F422',
      EventTentative: 'F423',
      EventTentativeMirrored: 'F424',
      EventDeclined: 'F425',
      IDBadge: 'F427',
      BackgroundColor: 'F42B',
      OfficeFormsLogoInverse16: 'F433',
      OfficeFormsLogo: 'F434',
      OfficeFormsLogoFill: 'F435',
      OfficeFormsLogo16: 'F436',
      OfficeFormsLogoFill16: 'F437',
      OfficeFormsLogoInverse24: 'F43A',
      OfficeFormsLogo24: 'F43B',
      OfficeFormsLogoFill24: 'F43C',
      PageLock: 'F43F',
      NotExecuted: 'F440',
      NotImpactedSolid: 'F441',
      FieldReadOnly: 'F442'
    }
  }, {
    bundle: '12-e6882c74',
    icons: {
      FieldRequired: 'F443',
      BacklogBoard: 'F444',
      ExternalBuild: 'F445',
      ExternalTFVC: 'F446',
      ExternalXAML: 'F447',
      IssueSolid: 'F448',
      DefectSolid: 'F449',
      LadybugSolid: 'F44A',
      NugetLogo: 'F44C',
      TFVCLogo: 'F44D',
      ProjectLogo32: 'F47E',
      ProjectLogoFill32: 'F47F',
      ProjectLogo16: 'F480',
      ProjectLogoFill16: 'F481',
      SwayLogo32: 'F482',
      SwayLogoFill32: 'F483',
      SwayLogo16: 'F484',
      SwayLogoFill16: 'F485',
      ClassNotebookLogo32: 'F486',
      ClassNotebookLogoFill32: 'F487',
      ClassNotebookLogo16: 'F488',
      ClassNotebookLogoFill16: 'F489',
      ClassNotebookLogoInverse32: 'F48A',
      ClassNotebookLogoInverse16: 'F48B',
      StaffNotebookLogo32: 'F48C',
      StaffNotebookLogoFill32: 'F48D',
      StaffNotebookLogo16: 'F48E',
      StaffNotebookLogoFill16: 'F48F',
      StaffNotebookLogoInverted32: 'F490',
      StaffNotebookLogoInverted16: 'F491',
      KaizalaLogo: 'F492',
      TaskLogo: 'F493',
      ProtectionCenterLogo32: 'F494',
      GallatinLogo: 'F496',
      Globe2: 'F49A',
      Guitar: 'F49B',
      Breakfast: 'F49C',
      Brunch: 'F49D',
      BeerMug: 'F49E',
      Vacation: 'F49F',
      Teeth: 'F4A0',
      Taxi: 'F4A1',
      Chopsticks: 'F4A2',
      SyncOccurence: 'F4A3',
      UnsyncOccurence: 'F4A4',
      PrimaryCalendar: 'F4AE',
      SearchCalendar: 'F4AF',
      VideoOff: 'F4B0',
      MicrosoftFlowLogo: 'F4B1',
      BusinessCenterLogo: 'F4B2',
      ToDoLogoBottom: 'F4B3',
      ToDoLogoTop: 'F4B4',
      EditSolid12: 'F4B5',
      EditSolidMirrored12: 'F4B6',
      UneditableSolid12: 'F4B7',
      UneditableSolidMirrored12: 'F4B8',
      UneditableMirrored: 'F4B9',
      AdminALogo32: 'F4BA',
      AdminALogoFill32: 'F4BB',
      ToDoLogoInverse: 'F4BC',
      Snooze: 'F4BD',
      WaffleOffice365: 'F4E0',
      ImageSearch: 'F4E8',
      NewsSearch: 'F4E9',
      VideoSearch: 'F4EA',
      R: 'F4EB',
      FontColorA: 'F4EC',
      FontColorSwatch: 'F4ED',
      LightWeight: 'F4EE',
      NormalWeight: 'F4EF',
      SemiboldWeight: 'F4F0',
      GroupObject: 'F4F1',
      UngroupObject: 'F4F2',
      AlignHorizontalLeft: 'F4F3',
      AlignHorizontalCenter: 'F4F4',
      AlignHorizontalRight: 'F4F5',
      AlignVerticalTop: 'F4F6',
      AlignVerticalCenter: 'F4F7',
      AlignVerticalBottom: 'F4F8',
      HorizontalDistributeCenter: 'F4F9',
      VerticalDistributeCenter: 'F4FA',
      Ellipse: 'F4FB',
      Line: 'F4FC',
      Octagon: 'F4FD',
      Hexagon: 'F4FE',
      Pentagon: 'F4FF',
      RightTriangle: 'F500',
      HalfCircle: 'F501',
      QuarterCircle: 'F502',
      ThreeQuarterCircle: 'F503',
      '6PointStar': 'F504',
      '12PointStar': 'F505',
      ArrangeBringToFront: 'F506',
      ArrangeSendToBack: 'F507',
      ArrangeSendBackward: 'F508',
      ArrangeBringForward: 'F509',
      BorderDash: 'F50A',
      BorderDot: 'F50B',
      LineStyle: 'F50C',
      LineThickness: 'F50D'
    }
  }, {
    bundle: '13-0980cd6d',
    icons: {
      WindowEdit: 'F50E',
      HintText: 'F50F',
      MediaAdd: 'F510',
      AnchorLock: 'F511',
      AutoHeight: 'F512',
      ChartSeries: 'F513',
      ChartXAngle: 'F514',
      ChartYAngle: 'F515',
      Combobox: 'F516',
      LineSpacing: 'F517',
      Padding: 'F518',
      PaddingTop: 'F519',
      PaddingBottom: 'F51A',
      PaddingLeft: 'F51B',
      PaddingRight: 'F51C',
      NavigationFlipper: 'F51D',
      AlignJustify: 'F51E',
      TextOverflow: 'F51F',
      VisualsFolder: 'F520',
      VisualsStore: 'F521',
      PictureCenter: 'F522',
      PictureFill: 'F523',
      PicturePosition: 'F524',
      PictureStretch: 'F525',
      PictureTile: 'F526',
      Slider: 'F527',
      SliderHandleSize: 'F528',
      DefaultRatio: 'F529',
      NumberSequence: 'F52A',
      GUID: 'F52B',
      ReportAdd: 'F52C',
      DashboardAdd: 'F52D',
      MapPinSolid: 'F52E',
      WebPublish: 'F52F',
      PieSingleSolid: 'F530',
      BlockedSolid: 'F531',
      DrillDown: 'F532',
      DrillDownSolid: 'F533',
      DrillExpand: 'F534',
      DrillShow: 'F535',
      OneDriveFolder16: 'F53B',
      FunctionalManagerDashboard: 'F542',
      BIDashboard: 'F543',
      CodeEdit: 'F544',
      RenewalCurrent: 'F545',
      RenewalFuture: 'F546',
      SplitObject: 'F547',
      BulkUpload: 'F548',
      DownloadDocument: 'F549',
      WaitlistConfirm: 'F550',
      WaitlistConfirmMirrored: 'F551',
      LaptopSecure: 'F552',
      DragObject: 'F553',
      EntryView: 'F554',
      EntryDecline: 'F555',
      ContactCardSettings: 'F556',
      ContactCardSettingsMirrored: 'F557',
      CalendarSettings: 'F558',
      CalendarSettingsMirrored: 'F559',
      HardDriveLock: 'F55A',
      HardDriveUnlock: 'F55B',
      AccountManagement: 'F55C',
      TransitionPop: 'F5B2',
      TransitionPush: 'F5B3',
      TransitionEffect: 'F5B4',
      LookupEntities: 'F5B5',
      ExploreData: 'F5B6',
      AddBookmark: 'F5B7',
      SearchBookmark: 'F5B8',
      DrillThrough: 'F5B9',
      MasterDatabase: 'F5BA',
      CertifiedDatabase: 'F5BB',
      MaximumValue: 'F5BC',
      MinimumValue: 'F5BD',
      VisualStudioIDELogo32: 'F5D0',
      PasteAsText: 'F5D5',
      PasteAsCode: 'F5D6',
      BrowserTab: 'F5D7',
      BrowserTabScreenshot: 'F5D8',
      DesktopScreenshot: 'F5D9',
      FileYML: 'F5DA',
      ClipboardSolid: 'F5DC',
      AnalyticsView: 'F5F1',
      Leave: 'F627',
      Trending12: 'F62D',
      Blocked12: 'F62E',
      Warning12: 'F62F',
      CheckedOutByOther12: 'F630',
      CheckedOutByYou12: 'F631',
      CircleShapeSolid: 'F63C',
      SquareShapeSolid: 'F63D',
      TriangleShapeSolid: 'F63E',
      DropShapeSolid: 'F63F',
      RectangleShapeSolid: 'F640',
      InsertColumnsLeft: 'F64A',
      InsertColumnsRight: 'F64B',
      InsertRowsAbove: 'F64C',
      InsertRowsBelow: 'F64D',
      DeleteColumns: 'F64E',
      DeleteRows: 'F64F'
    }
  }, {
    bundle: '14-eb4d1150',
    icons: {
      DeleteRowsMirrored: 'F650',
      DeleteTable: 'F651',
      VersionControlPush: 'F664',
      WhiteBoardApp16: 'F673',
      WhiteBoardApp32: 'F674',
      InsertSignatureLine: 'F677',
      ArrangeByFrom: 'F678',
      Phishing: 'F679',
      CreateMailRule: 'F67A',
      PublishCourse: 'F699',
      DictionaryRemove: 'F69A',
      UserRemove: 'F69B',
      UserEvent: 'F69C',
      Encryption: 'F69D',
      D365TalentLearn: 'F6BB',
      D365TalentInsight: 'F6BC',
      D365TalentHRCore: 'F6BD',
      BacklogList: 'F6BF',
      ButtonControl: 'F6C0',
      TableGroup: 'F6D9',
      MountainClimbing: 'F6DB',
      TagUnknown: 'F6DF',
      TagUnknownMirror: 'F6E0',
      TagUnknown12: 'F6E1',
      TagUnknown12Mirror: 'F6E2',
      Link12: 'F6E3',
      Presentation: 'F6E4',
      Presentation12: 'F6E5',
      Lock12: 'F6E6',
      BuildDefinition: 'F6E9',
      ReleaseDefinition: 'F6EA',
      SaveTemplate: 'F6EC',
      UserGauge: 'F6ED',
      BlockedSiteSolid12: 'F70A',
      TagSolid: 'F70E',
      OfficeChat: 'F70F',
      OfficeChatSolid: 'F710',
      MailSchedule: 'F72E'
    }
  }];
  var script$Y = {
    props: ["name"],
    computed: {
      iconClass: function iconClass() {
        return "ms-Icon ms-Icon--".concat(this.name, " ").concat(this.contentClass);
      }
    },
    data: function data() {
      return {
        contentClass: null
      };
    },
    mounted: function mounted() {
      // find bundle
      var unicode;
      var bundle;

      for (var b = 0; b < iconData.length && !unicode; b++) {
        if (unicode = iconData[b].icons[this.name]) bundle = iconData[b].bundle;
      }

      lib_4({
        fontFamily: "FabricMDL2Icons-" + bundle,
        src: "url(https://spoprod-a.akamaihd.net/files/fabric/assets/icons/fabric-icons-" + bundle + ".woff) format(\"woff\")"
      });
      this.contentClass = lib_1({
        displayName: this.$options._scopeId,
        display: 'inline-block',
        fontStyle: 'normal',
        fontWeight: '400',
        speak: 'none',
        selectors: {
          ":before": {
            fontFamily: "FabricMDL2Icons-" + bundle,
            content: "\"\\".concat(unicode, "\"")
          }
        }
      });
    }
  };

  /* script */
  const __vue_script__$Y = script$Y;

  /* template */
  var __vue_render__$y = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('i',{class:_vm.iconClass,on:{"click":function($event){return _vm.$emit('click')}}})};
  var __vue_staticRenderFns__$y = [];

    /* style */
    const __vue_inject_styles__$Y = undefined;
    /* scoped */
    const __vue_scope_id__$Y = undefined;
    /* module identifier */
    const __vue_module_identifier__$Y = undefined;
    /* functional template */
    const __vue_is_functional_template__$Y = false;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var uiDynamicIcon = normalizeComponent(
      { render: __vue_render__$y, staticRenderFns: __vue_staticRenderFns__$y },
      __vue_inject_styles__$Y,
      __vue_script__$Y,
      __vue_scope_id__$Y,
      __vue_is_functional_template__$Y,
      __vue_module_identifier__$Y,
      false,
      undefined,
      undefined,
      undefined
    );

  //
  var script$Z = {
    loadStyles: loadThemedStyles.loadStyles,
    components: {
      uiTextfield: uiTextfield
    },
    props: ["value"],
    watch: {
      hour: function hour(newVal, oldVal) {
        var _this = this;

        if (newVal * 1 != newVal || newVal < 0 || newVal > 23) this.$nextTick(function () {
          return _this.hour = oldVal;
        });else {
          var newDate = this.value ? new Date(this.value) : new Date(0);
          newDate.setHours(this.hour);
          this.$emit("input", newDate);
        }
      },
      minute: function minute(newVal, oldVal) {
        var _this2 = this;

        if (newVal * 1 != newVal || newVal < 0 || newVal > 59) this.$nextTick(function () {
          return _this2.minute = oldVal;
        });else {
          var newDate = this.value ? new Date(this.value) : new Date(0);
          newDate.setMinutes(this.minute);
          this.$emit("input", newDate);
        }
      },
      value: {
        handler: function handler(newVal) {
          if (newVal) {
            this.hour = newVal.getHours();
            this.minute = newVal.getMinutes();
          }
        },
        immediate: true
      }
    },
    methods: {
      upHour: function upHour() {
        this.hour = (this.hour + 1) % 24;
      },
      upMinute: function upMinute() {
        this.minute++;

        if (this.minute > 59) {
          this.upHour();
          this.minute = 0;
        }
      },
      downHour: function downHour() {
        this.hour--;
        if (this.hour < 0) this.hour = 23;
      },
      downMinute: function downMinute() {
        this.minute--;

        if (this.minute < 0) {
          this.downHour();
          this.minute = 59;
        }
      }
    },
    data: function data() {
      return {
        hour: 0,
        minute: 0
      };
    }
  };

  /* script */
  const __vue_script__$Z = script$Z;

  /* template */
  var __vue_render__$z = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('table',[_c('tr',[_c('td',{staticClass:"up",on:{"click":function($event){return _vm.upHour()}}},[_c('svg',{attrs:{"viewBox":"0 -0 2048 2048","width":"16","height":"16","version":"1.1","xmlns":"http://www.w3.org/2000/svg"}},[_c('path',{attrs:{"fill":"#000000","stroke":"none","transform":"translate(0, 2048) scale(1, -1)","d":"M1024 1607l1017 -1017l-242 -241l-775 775l-775 -775l-242 241l1017 1017v0z"}})])]),_vm._v(" "),_c('td',{staticClass:"seperator"}),_vm._v(" "),_c('td',{staticClass:"up",on:{"click":function($event){return _vm.upMinute()}}},[_c('svg',{attrs:{"viewBox":"0 -0 2048 2048","width":"16","height":"16","version":"1.1","xmlns":"http://www.w3.org/2000/svg"}},[_c('path',{attrs:{"fill":"#000000","stroke":"none","transform":"translate(0, 2048) scale(1, -1)","d":"M1024 1607l1017 -1017l-242 -241l-775 775l-775 -775l-242 241l1017 1017v0z"}})])])]),_vm._v(" "),_c('tr',[_c('td',[_c('uiTextfield',{staticClass:"textField",model:{value:(_vm.hour),callback:function ($$v) {_vm.hour=$$v;},expression:"hour"}})],1),_vm._v(" "),_c('td',{staticClass:"seperator"},[_vm._v(":")]),_vm._v(" "),_c('td',[_c('uiTextfield',{staticClass:"textField",model:{value:(_vm.minute),callback:function ($$v) {_vm.minute=$$v;},expression:"minute"}})],1)]),_vm._v(" "),_c('tr',[_c('td',{staticClass:"down",on:{"click":function($event){return _vm.downHour()}}},[_c('svg',{attrs:{"viewBox":"0 -0 2048 2048","width":"16","height":"16","version":"1.1","xmlns":"http://www.w3.org/2000/svg"}},[_c('path',{attrs:{"fill":"#000000","stroke":"none","transform":"translate(0, 2048) scale(1, -1)","d":"M1799 1699l242 -241l-1017 -1017l-1017 1017l242 241l775 -775l775 775v0z"}})])]),_vm._v(" "),_c('td',{staticClass:"seperator"}),_vm._v(" "),_c('td',{staticClass:"down",on:{"click":function($event){return _vm.downMinute()}}},[_c('svg',{attrs:{"viewBox":"0 -0 2048 2048","width":"16","height":"16","version":"1.1","xmlns":"http://www.w3.org/2000/svg"}},[_c('path',{attrs:{"fill":"#000000","stroke":"none","transform":"translate(0, 2048) scale(1, -1)","d":"M1799 1699l242 -241l-1017 -1017l-1017 1017l242 241l775 -775l775 775v0z"}})])])])])};
  var __vue_staticRenderFns__$z = [];

    /* style */
    const __vue_inject_styles__$Z = function (inject) {
      if (!inject) return
      inject("data-v-4b961c08_0", { source: "table[data-v-4b961c08]{border-spacing:0;min-width:90px}.seperator[data-v-4b961c08]{text-align:center;width:10px}.down[data-v-4b961c08],.up[data-v-4b961c08]{cursor:pointer;text-align:center;user-select:none}.textField[data-v-4b961c08]{width:100%;margin:0!important}.textField[data-v-4b961c08]  label{display:none}.textField[data-v-4b961c08]  input{text-align:center;min-width:unset;padding:6px 0}", map: undefined, media: undefined });

    };
    /* scoped */
    const __vue_scope_id__$Z = "data-v-4b961c08";
    /* module identifier */
    const __vue_module_identifier__$Z = undefined;
    /* functional template */
    const __vue_is_functional_template__$Z = false;
    /* style inject */
    const __vue_create_injector__$p = function(context){ 
                  return function(scopeId, data)
                  {
                      if(window['wizstyle-'+scopeId])
                          return;
                      if(__vue_script__$Z.loadStyles)
                          __vue_script__$Z.loadStyles(data.source);
                      window['wizstyle-'+scopeId]=true;
                  }
              };
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var uiTimePicker = normalizeComponent(
      { render: __vue_render__$z, staticRenderFns: __vue_staticRenderFns__$z },
      __vue_inject_styles__$Z,
      __vue_script__$Z,
      __vue_scope_id__$Z,
      __vue_is_functional_template__$Z,
      __vue_module_identifier__$Z,
      false,
      __vue_create_injector__$p,
      undefined,
      undefined
    );

  //
  var script$_ = {
    data: function data() {
      return {
        cl: ""
      };
    },
    computed: {
      iconClass: function iconClass() {
        return "ms-Icon ms-Icon--".concat(this.name, " ") + this.cl;
      }
    },
    mounted: function mounted() {

      if (!window["wizstyle-font-" + this.bundle]) {
        lib_4({
          fontFamily: "FabricMDL2Icons-" + this.bundle,
          src: "url(https://spoprod-a.akamaihd.net/files/fabric/assets/icons/fabric-icons-" + this.bundle + ".woff) format(\"woff\")"
        });
        window["wizstyle-font-" + this.bundle] = true;
      } // else
      //     console.log("skip loading font: " + this.bundle);


      this.cl = window["wizstyle-class-" + this.bundle + this.name] || lib_1({
        displayName: this.$options._scopeId,
        display: 'inline-block',
        fontStyle: 'normal',
        fontWeight: '400',
        speak: 'none',
        selectors: {
          ":before": {
            fontFamily: "FabricMDL2Icons-" + this.bundle,
            content: "'" + this.unicode + "'"
          }
        }
      });
      window["wizstyle-class-" + this.bundle + this.name] = this.cl;
    }
  };

  /* script */
  const __vue_script__$_ = script$_;

  /* template */
  var __vue_render__$A = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('i',{class:_vm.iconClass,on:{"click":function($event){return _vm.$emit('click')}}})};
  var __vue_staticRenderFns__$A = [];

    /* style */
    const __vue_inject_styles__$_ = undefined;
    /* scoped */
    const __vue_scope_id__$_ = undefined;
    /* module identifier */
    const __vue_module_identifier__$_ = undefined;
    /* functional template */
    const __vue_is_functional_template__$_ = false;
    /* style inject */
    
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var Icon = normalizeComponent(
      { render: __vue_render__$A, staticRenderFns: __vue_staticRenderFns__$A },
      __vue_inject_styles__$_,
      __vue_script__$_,
      __vue_scope_id__$_,
      __vue_is_functional_template__$_,
      __vue_module_identifier__$_,
      false,
      undefined,
      undefined,
      undefined
    );

  function uiIconAdd(resolve) {
    resolve({
      extends: Icon,
      data: function data() {
        return {
          name: "Add",
          unicode: "\uE710",
          bundle: "a13498cf"
        };
      }
    });
  }
  function uiIconMore(resolve) {
    resolve({
      extends: Icon,
      data: function data() {
        return {
          name: "More",
          unicode: "\uE712",
          bundle: "a13498cf"
        };
      }
    });
  }
  function uiIconSearch(resolve) {
    resolve({
      extends: Icon,
      data: function data() {
        return {
          name: "Search",
          unicode: "\uE721",
          bundle: "a13498cf"
        };
      }
    });
  }
  function uiIconCalendar(resolve) {
    resolve({
      extends: Icon,
      data: function data() {
        return {
          name: "Calendar",
          unicode: "\uE787",
          bundle: "a13498cf"
        };
      }
    });
  }
  function uiIconMegaphone(resolve) {
    resolve({
      extends: Icon,
      data: function data() {
        return {
          name: "Megaphone",
          unicode: "\uE789",
          bundle: "a13498cf"
        };
      }
    });
  }
  function uiIconCircleRing(resolve) {
    resolve({
      extends: Icon,
      data: function data() {
        return {
          name: "CircleRing",
          unicode: "\uEA3A",
          bundle: "a13498cf"
        };
      }
    });
  }
  function uiIconVideo(resolve) {
    resolve({
      extends: Icon,
      data: function data() {
        return {
          name: "Video",
          unicode: "\uE714",
          bundle: "0-29734c63"
        };
      }
    });
  }
  function uiIconRefresh(resolve) {
    resolve({
      extends: Icon,
      data: function data() {
        return {
          name: "Refresh",
          unicode: "\uE72C",
          bundle: "0-29734c63"
        };
      }
    });
  }
  function uiIconUp(resolve) {
    resolve({
      extends: Icon,
      data: function data() {
        return {
          name: "Up",
          unicode: "\uE74A",
          bundle: "0-29734c63"
        };
      }
    });
  }
  function uiIconDown(resolve) {
    resolve({
      extends: Icon,
      data: function data() {
        return {
          name: "Down",
          unicode: "\uE74B",
          bundle: "0-29734c63"
        };
      }
    });
  }
  function uiIconLocationDot(resolve) {
    resolve({
      extends: Icon,
      data: function data() {
        return {
          name: "LocationDot",
          unicode: "\uE827",
          bundle: "1-a653c37c"
        };
      }
    });
  }
  function uiIconLike(resolve) {
    resolve({
      extends: Icon,
      data: function data() {
        return {
          name: "Like",
          unicode: "\uE8E1",
          bundle: "1-a653c37c"
        };
      }
    });
  }
  function uiIconNews(resolve) {
    resolve({
      extends: Icon,
      data: function data() {
        return {
          name: "News",
          unicode: "\uE900",
          bundle: "1-a653c37c"
        };
      }
    });
  }
  function uiIconComment(resolve) {
    resolve({
      extends: Icon,
      data: function data() {
        return {
          name: "Comment",
          unicode: "\uE90A",
          bundle: "2-b9379dbc"
        };
      }
    });
  }
  function uiIconClock(resolve) {
    resolve({
      extends: Icon,
      data: function data() {
        return {
          name: "Clock",
          unicode: "\uE917",
          bundle: "2-b9379dbc"
        };
      }
    });
  }
  function uiIconCompleted(resolve) {
    resolve({
      extends: Icon,
      data: function data() {
        return {
          name: "Completed",
          unicode: "\uE930",
          bundle: "2-b9379dbc"
        };
      }
    });
  }
  function uiIconStreaming(resolve) {
    resolve({
      extends: Icon,
      data: function data() {
        return {
          name: "Streaming",
          unicode: "\uE93E",
          bundle: "2-b9379dbc"
        };
      }
    });
  }
  function uiIconChevronDownMed(resolve) {
    resolve({
      extends: Icon,
      data: function data() {
        return {
          name: "ChevronDownMed",
          unicode: "\uE972",
          bundle: "2-b9379dbc"
        };
      }
    });
  }
  function uiIconLikeSolid(resolve) {
    resolve({
      extends: Icon,
      data: function data() {
        return {
          name: "LikeSolid",
          unicode: "\uF3BF",
          bundle: "11-a4026982"
        };
      }
    });
  }

  var commonjsGlobal$1 = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

  function createCommonjsModule$1(fn, module) {
  	return module = { exports: {} }, fn(module, module.exports), module.exports;
  }

  function getCjsExportFromNamespace (n) {
  	return n && n['default'] || n;
  }

  /**!
   * @fileOverview Kickass library to create and place poppers near their reference elements.
   * @version 1.16.0
   * @license
   * Copyright (c) 2016 Federico Zivolo and contributors
   *
   * Permission is hereby granted, free of charge, to any person obtaining a copy
   * of this software and associated documentation files (the "Software"), to deal
   * in the Software without restriction, including without limitation the rights
   * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
   * copies of the Software, and to permit persons to whom the Software is
   * furnished to do so, subject to the following conditions:
   *
   * The above copyright notice and this permission notice shall be included in all
   * copies or substantial portions of the Software.
   *
   * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
   * SOFTWARE.
   */
  var isBrowser = typeof window !== 'undefined' && typeof document !== 'undefined' && typeof navigator !== 'undefined';

  var timeoutDuration = function () {
    var longerTimeoutBrowsers = ['Edge', 'Trident', 'Firefox'];

    for (var i = 0; i < longerTimeoutBrowsers.length; i += 1) {
      if (isBrowser && navigator.userAgent.indexOf(longerTimeoutBrowsers[i]) >= 0) {
        return 1;
      }
    }

    return 0;
  }();

  function microtaskDebounce(fn) {
    var called = false;
    return function () {
      if (called) {
        return;
      }

      called = true;
      window.Promise.resolve().then(function () {
        called = false;
        fn();
      });
    };
  }

  function taskDebounce(fn) {
    var scheduled = false;
    return function () {
      if (!scheduled) {
        scheduled = true;
        setTimeout(function () {
          scheduled = false;
          fn();
        }, timeoutDuration);
      }
    };
  }

  var supportsMicroTasks = isBrowser && window.Promise;
  /**
  * Create a debounced version of a method, that's asynchronously deferred
  * but called in the minimum time possible.
  *
  * @method
  * @memberof Popper.Utils
  * @argument {Function} fn
  * @returns {Function}
  */

  var debounce = supportsMicroTasks ? microtaskDebounce : taskDebounce;
  /**
   * Check if the given variable is a function
   * @method
   * @memberof Popper.Utils
   * @argument {Any} functionToCheck - variable to check
   * @returns {Boolean} answer to: is a function?
   */

  function isFunction(functionToCheck) {
    var getType = {};
    return functionToCheck && getType.toString.call(functionToCheck) === '[object Function]';
  }
  /**
   * Get CSS computed property of the given element
   * @method
   * @memberof Popper.Utils
   * @argument {Eement} element
   * @argument {String} property
   */


  function getStyleComputedProperty(element, property) {
    if (element.nodeType !== 1) {
      return [];
    } // NOTE: 1 DOM access here


    var window = element.ownerDocument.defaultView;
    var css = window.getComputedStyle(element, null);
    return property ? css[property] : css;
  }
  /**
   * Returns the parentNode or the host of the element
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element
   * @returns {Element} parent
   */


  function getParentNode(element) {
    if (element.nodeName === 'HTML') {
      return element;
    }

    return element.parentNode || element.host;
  }
  /**
   * Returns the scrolling parent of the given element
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element
   * @returns {Element} scroll parent
   */


  function getScrollParent(element) {
    // Return body, `getScroll` will take care to get the correct `scrollTop` from it
    if (!element) {
      return document.body;
    }

    switch (element.nodeName) {
      case 'HTML':
      case 'BODY':
        return element.ownerDocument.body;

      case '#document':
        return element.body;
    } // Firefox want us to check `-x` and `-y` variations as well


    var _getStyleComputedProp = getStyleComputedProperty(element),
        overflow = _getStyleComputedProp.overflow,
        overflowX = _getStyleComputedProp.overflowX,
        overflowY = _getStyleComputedProp.overflowY;

    if (/(auto|scroll|overlay)/.test(overflow + overflowY + overflowX)) {
      return element;
    }

    return getScrollParent(getParentNode(element));
  }
  /**
   * Returns the reference node of the reference object, or the reference object itself.
   * @method
   * @memberof Popper.Utils
   * @param {Element|Object} reference - the reference element (the popper will be relative to this)
   * @returns {Element} parent
   */


  function getReferenceNode(reference) {
    return reference && reference.referenceNode ? reference.referenceNode : reference;
  }

  var isIE11 = isBrowser && !!(window.MSInputMethodContext && document.documentMode);
  var isIE10 = isBrowser && /MSIE 10/.test(navigator.userAgent);
  /**
   * Determines if the browser is Internet Explorer
   * @method
   * @memberof Popper.Utils
   * @param {Number} version to check
   * @returns {Boolean} isIE
   */

  function isIE(version) {
    if (version === 11) {
      return isIE11;
    }

    if (version === 10) {
      return isIE10;
    }

    return isIE11 || isIE10;
  }
  /**
   * Returns the offset parent of the given element
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element
   * @returns {Element} offset parent
   */


  function getOffsetParent(element) {
    if (!element) {
      return document.documentElement;
    }

    var noOffsetParent = isIE(10) ? document.body : null; // NOTE: 1 DOM access here

    var offsetParent = element.offsetParent || null; // Skip hidden elements which don't have an offsetParent

    while (offsetParent === noOffsetParent && element.nextElementSibling) {
      offsetParent = (element = element.nextElementSibling).offsetParent;
    }

    var nodeName = offsetParent && offsetParent.nodeName;

    if (!nodeName || nodeName === 'BODY' || nodeName === 'HTML') {
      return element ? element.ownerDocument.documentElement : document.documentElement;
    } // .offsetParent will return the closest TH, TD or TABLE in case
    // no offsetParent is present, I hate this job...


    if (['TH', 'TD', 'TABLE'].indexOf(offsetParent.nodeName) !== -1 && getStyleComputedProperty(offsetParent, 'position') === 'static') {
      return getOffsetParent(offsetParent);
    }

    return offsetParent;
  }

  function isOffsetContainer(element) {
    var nodeName = element.nodeName;

    if (nodeName === 'BODY') {
      return false;
    }

    return nodeName === 'HTML' || getOffsetParent(element.firstElementChild) === element;
  }
  /**
   * Finds the root node (document, shadowDOM root) of the given element
   * @method
   * @memberof Popper.Utils
   * @argument {Element} node
   * @returns {Element} root node
   */


  function getRoot(node) {
    if (node.parentNode !== null) {
      return getRoot(node.parentNode);
    }

    return node;
  }
  /**
   * Finds the offset parent common to the two provided nodes
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element1
   * @argument {Element} element2
   * @returns {Element} common offset parent
   */


  function findCommonOffsetParent(element1, element2) {
    // This check is needed to avoid errors in case one of the elements isn't defined for any reason
    if (!element1 || !element1.nodeType || !element2 || !element2.nodeType) {
      return document.documentElement;
    } // Here we make sure to give as "start" the element that comes first in the DOM


    var order = element1.compareDocumentPosition(element2) & Node.DOCUMENT_POSITION_FOLLOWING;
    var start = order ? element1 : element2;
    var end = order ? element2 : element1; // Get common ancestor container

    var range = document.createRange();
    range.setStart(start, 0);
    range.setEnd(end, 0);
    var commonAncestorContainer = range.commonAncestorContainer; // Both nodes are inside #document

    if (element1 !== commonAncestorContainer && element2 !== commonAncestorContainer || start.contains(end)) {
      if (isOffsetContainer(commonAncestorContainer)) {
        return commonAncestorContainer;
      }

      return getOffsetParent(commonAncestorContainer);
    } // one of the nodes is inside shadowDOM, find which one


    var element1root = getRoot(element1);

    if (element1root.host) {
      return findCommonOffsetParent(element1root.host, element2);
    } else {
      return findCommonOffsetParent(element1, getRoot(element2).host);
    }
  }
  /**
   * Gets the scroll value of the given element in the given side (top and left)
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element
   * @argument {String} side `top` or `left`
   * @returns {number} amount of scrolled pixels
   */


  function getScroll(element) {
    var side = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'top';
    var upperSide = side === 'top' ? 'scrollTop' : 'scrollLeft';
    var nodeName = element.nodeName;

    if (nodeName === 'BODY' || nodeName === 'HTML') {
      var html = element.ownerDocument.documentElement;
      var scrollingElement = element.ownerDocument.scrollingElement || html;
      return scrollingElement[upperSide];
    }

    return element[upperSide];
  }
  /*
   * Sum or subtract the element scroll values (left and top) from a given rect object
   * @method
   * @memberof Popper.Utils
   * @param {Object} rect - Rect object you want to change
   * @param {HTMLElement} element - The element from the function reads the scroll values
   * @param {Boolean} subtract - set to true if you want to subtract the scroll values
   * @return {Object} rect - The modifier rect object
   */


  function includeScroll(rect, element) {
    var subtract = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    var scrollTop = getScroll(element, 'top');
    var scrollLeft = getScroll(element, 'left');
    var modifier = subtract ? -1 : 1;
    rect.top += scrollTop * modifier;
    rect.bottom += scrollTop * modifier;
    rect.left += scrollLeft * modifier;
    rect.right += scrollLeft * modifier;
    return rect;
  }
  /*
   * Helper to detect borders of a given element
   * @method
   * @memberof Popper.Utils
   * @param {CSSStyleDeclaration} styles
   * Result of `getStyleComputedProperty` on the given element
   * @param {String} axis - `x` or `y`
   * @return {number} borders - The borders size of the given axis
   */


  function getBordersSize(styles, axis) {
    var sideA = axis === 'x' ? 'Left' : 'Top';
    var sideB = sideA === 'Left' ? 'Right' : 'Bottom';
    return parseFloat(styles['border' + sideA + 'Width'], 10) + parseFloat(styles['border' + sideB + 'Width'], 10);
  }

  function getSize(axis, body, html, computedStyle) {
    return Math.max(body['offset' + axis], body['scroll' + axis], html['client' + axis], html['offset' + axis], html['scroll' + axis], isIE(10) ? parseInt(html['offset' + axis]) + parseInt(computedStyle['margin' + (axis === 'Height' ? 'Top' : 'Left')]) + parseInt(computedStyle['margin' + (axis === 'Height' ? 'Bottom' : 'Right')]) : 0);
  }

  function getWindowSizes(document) {
    var body = document.body;
    var html = document.documentElement;
    var computedStyle = isIE(10) && getComputedStyle(html);
    return {
      height: getSize('Height', body, html, computedStyle),
      width: getSize('Width', body, html, computedStyle)
    };
  }

  var classCallCheck = function classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  };

  var createClass = function () {
    function defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ("value" in descriptor) descriptor.writable = true;
        Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    return function (Constructor, protoProps, staticProps) {
      if (protoProps) defineProperties(Constructor.prototype, protoProps);
      if (staticProps) defineProperties(Constructor, staticProps);
      return Constructor;
    };
  }();

  var defineProperty = function defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  };

  var _extends$1 = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };
  /**
   * Given element offsets, generate an output similar to getBoundingClientRect
   * @method
   * @memberof Popper.Utils
   * @argument {Object} offsets
   * @returns {Object} ClientRect like output
   */


  function getClientRect(offsets) {
    return _extends$1({}, offsets, {
      right: offsets.left + offsets.width,
      bottom: offsets.top + offsets.height
    });
  }
  /**
   * Get bounding client rect of given element
   * @method
   * @memberof Popper.Utils
   * @param {HTMLElement} element
   * @return {Object} client rect
   */


  function getBoundingClientRect(element) {
    var rect = {}; // IE10 10 FIX: Please, don't ask, the element isn't
    // considered in DOM in some circumstances...
    // This isn't reproducible in IE10 compatibility mode of IE11

    try {
      if (isIE(10)) {
        rect = element.getBoundingClientRect();
        var scrollTop = getScroll(element, 'top');
        var scrollLeft = getScroll(element, 'left');
        rect.top += scrollTop;
        rect.left += scrollLeft;
        rect.bottom += scrollTop;
        rect.right += scrollLeft;
      } else {
        rect = element.getBoundingClientRect();
      }
    } catch (e) {}

    var result = {
      left: rect.left,
      top: rect.top,
      width: rect.right - rect.left,
      height: rect.bottom - rect.top
    }; // subtract scrollbar size from sizes

    var sizes = element.nodeName === 'HTML' ? getWindowSizes(element.ownerDocument) : {};
    var width = sizes.width || element.clientWidth || result.width;
    var height = sizes.height || element.clientHeight || result.height;
    var horizScrollbar = element.offsetWidth - width;
    var vertScrollbar = element.offsetHeight - height; // if an hypothetical scrollbar is detected, we must be sure it's not a `border`
    // we make this check conditional for performance reasons

    if (horizScrollbar || vertScrollbar) {
      var styles = getStyleComputedProperty(element);
      horizScrollbar -= getBordersSize(styles, 'x');
      vertScrollbar -= getBordersSize(styles, 'y');
      result.width -= horizScrollbar;
      result.height -= vertScrollbar;
    }

    return getClientRect(result);
  }

  function getOffsetRectRelativeToArbitraryNode(children, parent) {
    var fixedPosition = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    var isIE10 = isIE(10);
    var isHTML = parent.nodeName === 'HTML';
    var childrenRect = getBoundingClientRect(children);
    var parentRect = getBoundingClientRect(parent);
    var scrollParent = getScrollParent(children);
    var styles = getStyleComputedProperty(parent);
    var borderTopWidth = parseFloat(styles.borderTopWidth, 10);
    var borderLeftWidth = parseFloat(styles.borderLeftWidth, 10); // In cases where the parent is fixed, we must ignore negative scroll in offset calc

    if (fixedPosition && isHTML) {
      parentRect.top = Math.max(parentRect.top, 0);
      parentRect.left = Math.max(parentRect.left, 0);
    }

    var offsets = getClientRect({
      top: childrenRect.top - parentRect.top - borderTopWidth,
      left: childrenRect.left - parentRect.left - borderLeftWidth,
      width: childrenRect.width,
      height: childrenRect.height
    });
    offsets.marginTop = 0;
    offsets.marginLeft = 0; // Subtract margins of documentElement in case it's being used as parent
    // we do this only on HTML because it's the only element that behaves
    // differently when margins are applied to it. The margins are included in
    // the box of the documentElement, in the other cases not.

    if (!isIE10 && isHTML) {
      var marginTop = parseFloat(styles.marginTop, 10);
      var marginLeft = parseFloat(styles.marginLeft, 10);
      offsets.top -= borderTopWidth - marginTop;
      offsets.bottom -= borderTopWidth - marginTop;
      offsets.left -= borderLeftWidth - marginLeft;
      offsets.right -= borderLeftWidth - marginLeft; // Attach marginTop and marginLeft because in some circumstances we may need them

      offsets.marginTop = marginTop;
      offsets.marginLeft = marginLeft;
    }

    if (isIE10 && !fixedPosition ? parent.contains(scrollParent) : parent === scrollParent && scrollParent.nodeName !== 'BODY') {
      offsets = includeScroll(offsets, parent);
    }

    return offsets;
  }

  function getViewportOffsetRectRelativeToArtbitraryNode(element) {
    var excludeScroll = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    var html = element.ownerDocument.documentElement;
    var relativeOffset = getOffsetRectRelativeToArbitraryNode(element, html);
    var width = Math.max(html.clientWidth, window.innerWidth || 0);
    var height = Math.max(html.clientHeight, window.innerHeight || 0);
    var scrollTop = !excludeScroll ? getScroll(html) : 0;
    var scrollLeft = !excludeScroll ? getScroll(html, 'left') : 0;
    var offset = {
      top: scrollTop - relativeOffset.top + relativeOffset.marginTop,
      left: scrollLeft - relativeOffset.left + relativeOffset.marginLeft,
      width: width,
      height: height
    };
    return getClientRect(offset);
  }
  /**
   * Check if the given element is fixed or is inside a fixed parent
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element
   * @argument {Element} customContainer
   * @returns {Boolean} answer to "isFixed?"
   */


  function isFixed(element) {
    var nodeName = element.nodeName;

    if (nodeName === 'BODY' || nodeName === 'HTML') {
      return false;
    }

    if (getStyleComputedProperty(element, 'position') === 'fixed') {
      return true;
    }

    var parentNode = getParentNode(element);

    if (!parentNode) {
      return false;
    }

    return isFixed(parentNode);
  }
  /**
   * Finds the first parent of an element that has a transformed property defined
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element
   * @returns {Element} first transformed parent or documentElement
   */


  function getFixedPositionOffsetParent(element) {
    // This check is needed to avoid errors in case one of the elements isn't defined for any reason
    if (!element || !element.parentElement || isIE()) {
      return document.documentElement;
    }

    var el = element.parentElement;

    while (el && getStyleComputedProperty(el, 'transform') === 'none') {
      el = el.parentElement;
    }

    return el || document.documentElement;
  }
  /**
   * Computed the boundaries limits and return them
   * @method
   * @memberof Popper.Utils
   * @param {HTMLElement} popper
   * @param {HTMLElement} reference
   * @param {number} padding
   * @param {HTMLElement} boundariesElement - Element used to define the boundaries
   * @param {Boolean} fixedPosition - Is in fixed position mode
   * @returns {Object} Coordinates of the boundaries
   */


  function getBoundaries(popper, reference, padding, boundariesElement) {
    var fixedPosition = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false; // NOTE: 1 DOM access here

    var boundaries = {
      top: 0,
      left: 0
    };
    var offsetParent = fixedPosition ? getFixedPositionOffsetParent(popper) : findCommonOffsetParent(popper, getReferenceNode(reference)); // Handle viewport case

    if (boundariesElement === 'viewport') {
      boundaries = getViewportOffsetRectRelativeToArtbitraryNode(offsetParent, fixedPosition);
    } else {
      // Handle other cases based on DOM element used as boundaries
      var boundariesNode = void 0;

      if (boundariesElement === 'scrollParent') {
        boundariesNode = getScrollParent(getParentNode(reference));

        if (boundariesNode.nodeName === 'BODY') {
          boundariesNode = popper.ownerDocument.documentElement;
        }
      } else if (boundariesElement === 'window') {
        boundariesNode = popper.ownerDocument.documentElement;
      } else {
        boundariesNode = boundariesElement;
      }

      var offsets = getOffsetRectRelativeToArbitraryNode(boundariesNode, offsetParent, fixedPosition); // In case of HTML, we need a different computation

      if (boundariesNode.nodeName === 'HTML' && !isFixed(offsetParent)) {
        var _getWindowSizes = getWindowSizes(popper.ownerDocument),
            height = _getWindowSizes.height,
            width = _getWindowSizes.width;

        boundaries.top += offsets.top - offsets.marginTop;
        boundaries.bottom = height + offsets.top;
        boundaries.left += offsets.left - offsets.marginLeft;
        boundaries.right = width + offsets.left;
      } else {
        // for all the other DOM elements, this one is good
        boundaries = offsets;
      }
    } // Add paddings


    padding = padding || 0;
    var isPaddingNumber = typeof padding === 'number';
    boundaries.left += isPaddingNumber ? padding : padding.left || 0;
    boundaries.top += isPaddingNumber ? padding : padding.top || 0;
    boundaries.right -= isPaddingNumber ? padding : padding.right || 0;
    boundaries.bottom -= isPaddingNumber ? padding : padding.bottom || 0;
    return boundaries;
  }

  function getArea(_ref) {
    var width = _ref.width,
        height = _ref.height;
    return width * height;
  }
  /**
   * Utility used to transform the `auto` placement to the placement with more
   * available space.
   * @method
   * @memberof Popper.Utils
   * @argument {Object} data - The data object generated by update method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */


  function computeAutoPlacement(placement, refRect, popper, reference, boundariesElement) {
    var padding = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 0;

    if (placement.indexOf('auto') === -1) {
      return placement;
    }

    var boundaries = getBoundaries(popper, reference, padding, boundariesElement);
    var rects = {
      top: {
        width: boundaries.width,
        height: refRect.top - boundaries.top
      },
      right: {
        width: boundaries.right - refRect.right,
        height: boundaries.height
      },
      bottom: {
        width: boundaries.width,
        height: boundaries.bottom - refRect.bottom
      },
      left: {
        width: refRect.left - boundaries.left,
        height: boundaries.height
      }
    };
    var sortedAreas = Object.keys(rects).map(function (key) {
      return _extends$1({
        key: key
      }, rects[key], {
        area: getArea(rects[key])
      });
    }).sort(function (a, b) {
      return b.area - a.area;
    });
    var filteredAreas = sortedAreas.filter(function (_ref2) {
      var width = _ref2.width,
          height = _ref2.height;
      return width >= popper.clientWidth && height >= popper.clientHeight;
    });
    var computedPlacement = filteredAreas.length > 0 ? filteredAreas[0].key : sortedAreas[0].key;
    var variation = placement.split('-')[1];
    return computedPlacement + (variation ? '-' + variation : '');
  }
  /**
   * Get offsets to the reference element
   * @method
   * @memberof Popper.Utils
   * @param {Object} state
   * @param {Element} popper - the popper element
   * @param {Element} reference - the reference element (the popper will be relative to this)
   * @param {Element} fixedPosition - is in fixed position mode
   * @returns {Object} An object containing the offsets which will be applied to the popper
   */


  function getReferenceOffsets(state, popper, reference) {
    var fixedPosition = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
    var commonOffsetParent = fixedPosition ? getFixedPositionOffsetParent(popper) : findCommonOffsetParent(popper, getReferenceNode(reference));
    return getOffsetRectRelativeToArbitraryNode(reference, commonOffsetParent, fixedPosition);
  }
  /**
   * Get the outer sizes of the given element (offset size + margins)
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element
   * @returns {Object} object containing width and height properties
   */


  function getOuterSizes(element) {
    var window = element.ownerDocument.defaultView;
    var styles = window.getComputedStyle(element);
    var x = parseFloat(styles.marginTop || 0) + parseFloat(styles.marginBottom || 0);
    var y = parseFloat(styles.marginLeft || 0) + parseFloat(styles.marginRight || 0);
    var result = {
      width: element.offsetWidth + y,
      height: element.offsetHeight + x
    };
    return result;
  }
  /**
   * Get the opposite placement of the given one
   * @method
   * @memberof Popper.Utils
   * @argument {String} placement
   * @returns {String} flipped placement
   */


  function getOppositePlacement(placement) {
    var hash = {
      left: 'right',
      right: 'left',
      bottom: 'top',
      top: 'bottom'
    };
    return placement.replace(/left|right|bottom|top/g, function (matched) {
      return hash[matched];
    });
  }
  /**
   * Get offsets to the popper
   * @method
   * @memberof Popper.Utils
   * @param {Object} position - CSS position the Popper will get applied
   * @param {HTMLElement} popper - the popper element
   * @param {Object} referenceOffsets - the reference offsets (the popper will be relative to this)
   * @param {String} placement - one of the valid placement options
   * @returns {Object} popperOffsets - An object containing the offsets which will be applied to the popper
   */


  function getPopperOffsets(popper, referenceOffsets, placement) {
    placement = placement.split('-')[0]; // Get popper node sizes

    var popperRect = getOuterSizes(popper); // Add position, width and height to our offsets object

    var popperOffsets = {
      width: popperRect.width,
      height: popperRect.height
    }; // depending by the popper placement we have to compute its offsets slightly differently

    var isHoriz = ['right', 'left'].indexOf(placement) !== -1;
    var mainSide = isHoriz ? 'top' : 'left';
    var secondarySide = isHoriz ? 'left' : 'top';
    var measurement = isHoriz ? 'height' : 'width';
    var secondaryMeasurement = !isHoriz ? 'height' : 'width';
    popperOffsets[mainSide] = referenceOffsets[mainSide] + referenceOffsets[measurement] / 2 - popperRect[measurement] / 2;

    if (placement === secondarySide) {
      popperOffsets[secondarySide] = referenceOffsets[secondarySide] - popperRect[secondaryMeasurement];
    } else {
      popperOffsets[secondarySide] = referenceOffsets[getOppositePlacement(secondarySide)];
    }

    return popperOffsets;
  }
  /**
   * Mimics the `find` method of Array
   * @method
   * @memberof Popper.Utils
   * @argument {Array} arr
   * @argument prop
   * @argument value
   * @returns index or -1
   */


  function find(arr, check) {
    // use native find if supported
    if (Array.prototype.find) {
      return arr.find(check);
    } // use `filter` to obtain the same behavior of `find`


    return arr.filter(check)[0];
  }
  /**
   * Return the index of the matching object
   * @method
   * @memberof Popper.Utils
   * @argument {Array} arr
   * @argument prop
   * @argument value
   * @returns index or -1
   */


  function findIndex(arr, prop, value) {
    // use native findIndex if supported
    if (Array.prototype.findIndex) {
      return arr.findIndex(function (cur) {
        return cur[prop] === value;
      });
    } // use `find` + `indexOf` if `findIndex` isn't supported


    var match = find(arr, function (obj) {
      return obj[prop] === value;
    });
    return arr.indexOf(match);
  }
  /**
   * Loop trough the list of modifiers and run them in order,
   * each of them will then edit the data object.
   * @method
   * @memberof Popper.Utils
   * @param {dataObject} data
   * @param {Array} modifiers
   * @param {String} ends - Optional modifier name used as stopper
   * @returns {dataObject}
   */


  function runModifiers(modifiers, data, ends) {
    var modifiersToRun = ends === undefined ? modifiers : modifiers.slice(0, findIndex(modifiers, 'name', ends));
    modifiersToRun.forEach(function (modifier) {
      if (modifier['function']) {
        // eslint-disable-line dot-notation
        console.warn('`modifier.function` is deprecated, use `modifier.fn`!');
      }

      var fn = modifier['function'] || modifier.fn; // eslint-disable-line dot-notation

      if (modifier.enabled && isFunction(fn)) {
        // Add properties to offsets to make them a complete clientRect object
        // we do this before each modifier to make sure the previous one doesn't
        // mess with these values
        data.offsets.popper = getClientRect(data.offsets.popper);
        data.offsets.reference = getClientRect(data.offsets.reference);
        data = fn(data, modifier);
      }
    });
    return data;
  }
  /**
   * Updates the position of the popper, computing the new offsets and applying
   * the new style.<br />
   * Prefer `scheduleUpdate` over `update` because of performance reasons.
   * @method
   * @memberof Popper
   */


  function update() {
    // if popper is destroyed, don't perform any further update
    if (this.state.isDestroyed) {
      return;
    }

    var data = {
      instance: this,
      styles: {},
      arrowStyles: {},
      attributes: {},
      flipped: false,
      offsets: {}
    }; // compute reference element offsets

    data.offsets.reference = getReferenceOffsets(this.state, this.popper, this.reference, this.options.positionFixed); // compute auto placement, store placement inside the data object,
    // modifiers will be able to edit `placement` if needed
    // and refer to originalPlacement to know the original value

    data.placement = computeAutoPlacement(this.options.placement, data.offsets.reference, this.popper, this.reference, this.options.modifiers.flip.boundariesElement, this.options.modifiers.flip.padding); // store the computed placement inside `originalPlacement`

    data.originalPlacement = data.placement;
    data.positionFixed = this.options.positionFixed; // compute the popper offsets

    data.offsets.popper = getPopperOffsets(this.popper, data.offsets.reference, data.placement);
    data.offsets.popper.position = this.options.positionFixed ? 'fixed' : 'absolute'; // run the modifiers

    data = runModifiers(this.modifiers, data); // the first `update` will call `onCreate` callback
    // the other ones will call `onUpdate` callback

    if (!this.state.isCreated) {
      this.state.isCreated = true;
      this.options.onCreate(data);
    } else {
      this.options.onUpdate(data);
    }
  }
  /**
   * Helper used to know if the given modifier is enabled.
   * @method
   * @memberof Popper.Utils
   * @returns {Boolean}
   */


  function isModifierEnabled(modifiers, modifierName) {
    return modifiers.some(function (_ref) {
      var name = _ref.name,
          enabled = _ref.enabled;
      return enabled && name === modifierName;
    });
  }
  /**
   * Get the prefixed supported property name
   * @method
   * @memberof Popper.Utils
   * @argument {String} property (camelCase)
   * @returns {String} prefixed property (camelCase or PascalCase, depending on the vendor prefix)
   */


  function getSupportedPropertyName(property) {
    var prefixes = [false, 'ms', 'Webkit', 'Moz', 'O'];
    var upperProp = property.charAt(0).toUpperCase() + property.slice(1);

    for (var i = 0; i < prefixes.length; i++) {
      var prefix = prefixes[i];
      var toCheck = prefix ? '' + prefix + upperProp : property;

      if (typeof document.body.style[toCheck] !== 'undefined') {
        return toCheck;
      }
    }

    return null;
  }
  /**
   * Destroys the popper.
   * @method
   * @memberof Popper
   */


  function destroy() {
    this.state.isDestroyed = true; // touch DOM only if `applyStyle` modifier is enabled

    if (isModifierEnabled(this.modifiers, 'applyStyle')) {
      this.popper.removeAttribute('x-placement');
      this.popper.style.position = '';
      this.popper.style.top = '';
      this.popper.style.left = '';
      this.popper.style.right = '';
      this.popper.style.bottom = '';
      this.popper.style.willChange = '';
      this.popper.style[getSupportedPropertyName('transform')] = '';
    }

    this.disableEventListeners(); // remove the popper if user explicitly asked for the deletion on destroy
    // do not use `remove` because IE11 doesn't support it

    if (this.options.removeOnDestroy) {
      this.popper.parentNode.removeChild(this.popper);
    }

    return this;
  }
  /**
   * Get the window associated with the element
   * @argument {Element} element
   * @returns {Window}
   */


  function getWindow(element) {
    var ownerDocument = element.ownerDocument;
    return ownerDocument ? ownerDocument.defaultView : window;
  }

  function attachToScrollParents(scrollParent, event, callback, scrollParents) {
    var isBody = scrollParent.nodeName === 'BODY';
    var target = isBody ? scrollParent.ownerDocument.defaultView : scrollParent;
    target.addEventListener(event, callback, {
      passive: true
    });

    if (!isBody) {
      attachToScrollParents(getScrollParent(target.parentNode), event, callback, scrollParents);
    }

    scrollParents.push(target);
  }
  /**
   * Setup needed event listeners used to update the popper position
   * @method
   * @memberof Popper.Utils
   * @private
   */


  function setupEventListeners(reference, options, state, updateBound) {
    // Resize event listener on window
    state.updateBound = updateBound;
    getWindow(reference).addEventListener('resize', state.updateBound, {
      passive: true
    }); // Scroll event listener on scroll parents

    var scrollElement = getScrollParent(reference);
    attachToScrollParents(scrollElement, 'scroll', state.updateBound, state.scrollParents);
    state.scrollElement = scrollElement;
    state.eventsEnabled = true;
    return state;
  }
  /**
   * It will add resize/scroll events and start recalculating
   * position of the popper element when they are triggered.
   * @method
   * @memberof Popper
   */


  function enableEventListeners() {
    if (!this.state.eventsEnabled) {
      this.state = setupEventListeners(this.reference, this.options, this.state, this.scheduleUpdate);
    }
  }
  /**
   * Remove event listeners used to update the popper position
   * @method
   * @memberof Popper.Utils
   * @private
   */


  function removeEventListeners(reference, state) {
    // Remove resize event listener on window
    getWindow(reference).removeEventListener('resize', state.updateBound); // Remove scroll event listener on scroll parents

    state.scrollParents.forEach(function (target) {
      target.removeEventListener('scroll', state.updateBound);
    }); // Reset state

    state.updateBound = null;
    state.scrollParents = [];
    state.scrollElement = null;
    state.eventsEnabled = false;
    return state;
  }
  /**
   * It will remove resize/scroll events and won't recalculate popper position
   * when they are triggered. It also won't trigger `onUpdate` callback anymore,
   * unless you call `update` method manually.
   * @method
   * @memberof Popper
   */


  function disableEventListeners() {
    if (this.state.eventsEnabled) {
      cancelAnimationFrame(this.scheduleUpdate);
      this.state = removeEventListeners(this.reference, this.state);
    }
  }
  /**
   * Tells if a given input is a number
   * @method
   * @memberof Popper.Utils
   * @param {*} input to check
   * @return {Boolean}
   */


  function isNumeric(n) {
    return n !== '' && !isNaN(parseFloat(n)) && isFinite(n);
  }
  /**
   * Set the style to the given popper
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element - Element to apply the style to
   * @argument {Object} styles
   * Object with a list of properties and values which will be applied to the element
   */


  function setStyles(element, styles) {
    Object.keys(styles).forEach(function (prop) {
      var unit = ''; // add unit if the value is numeric and is one of the following

      if (['width', 'height', 'top', 'right', 'bottom', 'left'].indexOf(prop) !== -1 && isNumeric(styles[prop])) {
        unit = 'px';
      }

      element.style[prop] = styles[prop] + unit;
    });
  }
  /**
   * Set the attributes to the given popper
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element - Element to apply the attributes to
   * @argument {Object} styles
   * Object with a list of properties and values which will be applied to the element
   */


  function setAttributes(element, attributes) {
    Object.keys(attributes).forEach(function (prop) {
      var value = attributes[prop];

      if (value !== false) {
        element.setAttribute(prop, attributes[prop]);
      } else {
        element.removeAttribute(prop);
      }
    });
  }
  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by `update` method
   * @argument {Object} data.styles - List of style properties - values to apply to popper element
   * @argument {Object} data.attributes - List of attribute properties - values to apply to popper element
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The same data object
   */


  function applyStyle(data) {
    // any property present in `data.styles` will be applied to the popper,
    // in this way we can make the 3rd party modifiers add custom styles to it
    // Be aware, modifiers could override the properties defined in the previous
    // lines of this modifier!
    setStyles(data.instance.popper, data.styles); // any property present in `data.attributes` will be applied to the popper,
    // they will be set as HTML attributes of the element

    setAttributes(data.instance.popper, data.attributes); // if arrowElement is defined and arrowStyles has some properties

    if (data.arrowElement && Object.keys(data.arrowStyles).length) {
      setStyles(data.arrowElement, data.arrowStyles);
    }

    return data;
  }
  /**
   * Set the x-placement attribute before everything else because it could be used
   * to add margins to the popper margins needs to be calculated to get the
   * correct popper offsets.
   * @method
   * @memberof Popper.modifiers
   * @param {HTMLElement} reference - The reference element used to position the popper
   * @param {HTMLElement} popper - The HTML element used as popper
   * @param {Object} options - Popper.js options
   */


  function applyStyleOnLoad(reference, popper, options, modifierOptions, state) {
    // compute reference element offsets
    var referenceOffsets = getReferenceOffsets(state, popper, reference, options.positionFixed); // compute auto placement, store placement inside the data object,
    // modifiers will be able to edit `placement` if needed
    // and refer to originalPlacement to know the original value

    var placement = computeAutoPlacement(options.placement, referenceOffsets, popper, reference, options.modifiers.flip.boundariesElement, options.modifiers.flip.padding);
    popper.setAttribute('x-placement', placement); // Apply `position` to popper before anything else because
    // without the position applied we can't guarantee correct computations

    setStyles(popper, {
      position: options.positionFixed ? 'fixed' : 'absolute'
    });
    return options;
  }
  /**
   * @function
   * @memberof Popper.Utils
   * @argument {Object} data - The data object generated by `update` method
   * @argument {Boolean} shouldRound - If the offsets should be rounded at all
   * @returns {Object} The popper's position offsets rounded
   *
   * The tale of pixel-perfect positioning. It's still not 100% perfect, but as
   * good as it can be within reason.
   * Discussion here: https://github.com/FezVrasta/popper.js/pull/715
   *
   * Low DPI screens cause a popper to be blurry if not using full pixels (Safari
   * as well on High DPI screens).
   *
   * Firefox prefers no rounding for positioning and does not have blurriness on
   * high DPI screens.
   *
   * Only horizontal placement and left/right values need to be considered.
   */


  function getRoundedOffsets(data, shouldRound) {
    var _data$offsets = data.offsets,
        popper = _data$offsets.popper,
        reference = _data$offsets.reference;
    var round = Math.round,
        floor = Math.floor;

    var noRound = function noRound(v) {
      return v;
    };

    var referenceWidth = round(reference.width);
    var popperWidth = round(popper.width);
    var isVertical = ['left', 'right'].indexOf(data.placement) !== -1;
    var isVariation = data.placement.indexOf('-') !== -1;
    var sameWidthParity = referenceWidth % 2 === popperWidth % 2;
    var bothOddWidth = referenceWidth % 2 === 1 && popperWidth % 2 === 1;
    var horizontalToInteger = !shouldRound ? noRound : isVertical || isVariation || sameWidthParity ? round : floor;
    var verticalToInteger = !shouldRound ? noRound : round;
    return {
      left: horizontalToInteger(bothOddWidth && !isVariation && shouldRound ? popper.left - 1 : popper.left),
      top: verticalToInteger(popper.top),
      bottom: verticalToInteger(popper.bottom),
      right: horizontalToInteger(popper.right)
    };
  }

  var isFirefox = isBrowser && /Firefox/i.test(navigator.userAgent);
  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by `update` method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */

  function computeStyle(data, options) {
    var x = options.x,
        y = options.y;
    var popper = data.offsets.popper; // Remove this legacy support in Popper.js v2

    var legacyGpuAccelerationOption = find(data.instance.modifiers, function (modifier) {
      return modifier.name === 'applyStyle';
    }).gpuAcceleration;

    if (legacyGpuAccelerationOption !== undefined) {
      console.warn('WARNING: `gpuAcceleration` option moved to `computeStyle` modifier and will not be supported in future versions of Popper.js!');
    }

    var gpuAcceleration = legacyGpuAccelerationOption !== undefined ? legacyGpuAccelerationOption : options.gpuAcceleration;
    var offsetParent = getOffsetParent(data.instance.popper);
    var offsetParentRect = getBoundingClientRect(offsetParent); // Styles

    var styles = {
      position: popper.position
    };
    var offsets = getRoundedOffsets(data, window.devicePixelRatio < 2 || !isFirefox);
    var sideA = x === 'bottom' ? 'top' : 'bottom';
    var sideB = y === 'right' ? 'left' : 'right'; // if gpuAcceleration is set to `true` and transform is supported,
    //  we use `translate3d` to apply the position to the popper we
    // automatically use the supported prefixed version if needed

    var prefixedProperty = getSupportedPropertyName('transform'); // now, let's make a step back and look at this code closely (wtf?)
    // If the content of the popper grows once it's been positioned, it
    // may happen that the popper gets misplaced because of the new content
    // overflowing its reference element
    // To avoid this problem, we provide two options (x and y), which allow
    // the consumer to define the offset origin.
    // If we position a popper on top of a reference element, we can set
    // `x` to `top` to make the popper grow towards its top instead of
    // its bottom.

    var left = void 0,
        top = void 0;

    if (sideA === 'bottom') {
      // when offsetParent is <html> the positioning is relative to the bottom of the screen (excluding the scrollbar)
      // and not the bottom of the html element
      if (offsetParent.nodeName === 'HTML') {
        top = -offsetParent.clientHeight + offsets.bottom;
      } else {
        top = -offsetParentRect.height + offsets.bottom;
      }
    } else {
      top = offsets.top;
    }

    if (sideB === 'right') {
      if (offsetParent.nodeName === 'HTML') {
        left = -offsetParent.clientWidth + offsets.right;
      } else {
        left = -offsetParentRect.width + offsets.right;
      }
    } else {
      left = offsets.left;
    }

    if (gpuAcceleration && prefixedProperty) {
      styles[prefixedProperty] = 'translate3d(' + left + 'px, ' + top + 'px, 0)';
      styles[sideA] = 0;
      styles[sideB] = 0;
      styles.willChange = 'transform';
    } else {
      // othwerise, we use the standard `top`, `left`, `bottom` and `right` properties
      var invertTop = sideA === 'bottom' ? -1 : 1;
      var invertLeft = sideB === 'right' ? -1 : 1;
      styles[sideA] = top * invertTop;
      styles[sideB] = left * invertLeft;
      styles.willChange = sideA + ', ' + sideB;
    } // Attributes


    var attributes = {
      'x-placement': data.placement
    }; // Update `data` attributes, styles and arrowStyles

    data.attributes = _extends$1({}, attributes, data.attributes);
    data.styles = _extends$1({}, styles, data.styles);
    data.arrowStyles = _extends$1({}, data.offsets.arrow, data.arrowStyles);
    return data;
  }
  /**
   * Helper used to know if the given modifier depends from another one.<br />
   * It checks if the needed modifier is listed and enabled.
   * @method
   * @memberof Popper.Utils
   * @param {Array} modifiers - list of modifiers
   * @param {String} requestingName - name of requesting modifier
   * @param {String} requestedName - name of requested modifier
   * @returns {Boolean}
   */


  function isModifierRequired(modifiers, requestingName, requestedName) {
    var requesting = find(modifiers, function (_ref) {
      var name = _ref.name;
      return name === requestingName;
    });
    var isRequired = !!requesting && modifiers.some(function (modifier) {
      return modifier.name === requestedName && modifier.enabled && modifier.order < requesting.order;
    });

    if (!isRequired) {
      var _requesting = '`' + requestingName + '`';

      var requested = '`' + requestedName + '`';
      console.warn(requested + ' modifier is required by ' + _requesting + ' modifier in order to work, be sure to include it before ' + _requesting + '!');
    }

    return isRequired;
  }
  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by update method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */


  function arrow(data, options) {
    var _data$offsets$arrow; // arrow depends on keepTogether in order to work


    if (!isModifierRequired(data.instance.modifiers, 'arrow', 'keepTogether')) {
      return data;
    }

    var arrowElement = options.element; // if arrowElement is a string, suppose it's a CSS selector

    if (typeof arrowElement === 'string') {
      arrowElement = data.instance.popper.querySelector(arrowElement); // if arrowElement is not found, don't run the modifier

      if (!arrowElement) {
        return data;
      }
    } else {
      // if the arrowElement isn't a query selector we must check that the
      // provided DOM node is child of its popper node
      if (!data.instance.popper.contains(arrowElement)) {
        console.warn('WARNING: `arrow.element` must be child of its popper element!');
        return data;
      }
    }

    var placement = data.placement.split('-')[0];
    var _data$offsets = data.offsets,
        popper = _data$offsets.popper,
        reference = _data$offsets.reference;
    var isVertical = ['left', 'right'].indexOf(placement) !== -1;
    var len = isVertical ? 'height' : 'width';
    var sideCapitalized = isVertical ? 'Top' : 'Left';
    var side = sideCapitalized.toLowerCase();
    var altSide = isVertical ? 'left' : 'top';
    var opSide = isVertical ? 'bottom' : 'right';
    var arrowElementSize = getOuterSizes(arrowElement)[len]; //
    // extends keepTogether behavior making sure the popper and its
    // reference have enough pixels in conjunction
    //
    // top/left side

    if (reference[opSide] - arrowElementSize < popper[side]) {
      data.offsets.popper[side] -= popper[side] - (reference[opSide] - arrowElementSize);
    } // bottom/right side


    if (reference[side] + arrowElementSize > popper[opSide]) {
      data.offsets.popper[side] += reference[side] + arrowElementSize - popper[opSide];
    }

    data.offsets.popper = getClientRect(data.offsets.popper); // compute center of the popper

    var center = reference[side] + reference[len] / 2 - arrowElementSize / 2; // Compute the sideValue using the updated popper offsets
    // take popper margin in account because we don't have this info available

    var css = getStyleComputedProperty(data.instance.popper);
    var popperMarginSide = parseFloat(css['margin' + sideCapitalized], 10);
    var popperBorderSide = parseFloat(css['border' + sideCapitalized + 'Width'], 10);
    var sideValue = center - data.offsets.popper[side] - popperMarginSide - popperBorderSide; // prevent arrowElement from being placed not contiguously to its popper

    sideValue = Math.max(Math.min(popper[len] - arrowElementSize, sideValue), 0);
    data.arrowElement = arrowElement;
    data.offsets.arrow = (_data$offsets$arrow = {}, defineProperty(_data$offsets$arrow, side, Math.round(sideValue)), defineProperty(_data$offsets$arrow, altSide, ''), _data$offsets$arrow);
    return data;
  }
  /**
   * Get the opposite placement variation of the given one
   * @method
   * @memberof Popper.Utils
   * @argument {String} placement variation
   * @returns {String} flipped placement variation
   */


  function getOppositeVariation(variation) {
    if (variation === 'end') {
      return 'start';
    } else if (variation === 'start') {
      return 'end';
    }

    return variation;
  }
  /**
   * List of accepted placements to use as values of the `placement` option.<br />
   * Valid placements are:
   * - `auto`
   * - `top`
   * - `right`
   * - `bottom`
   * - `left`
   *
   * Each placement can have a variation from this list:
   * - `-start`
   * - `-end`
   *
   * Variations are interpreted easily if you think of them as the left to right
   * written languages. Horizontally (`top` and `bottom`), `start` is left and `end`
   * is right.<br />
   * Vertically (`left` and `right`), `start` is top and `end` is bottom.
   *
   * Some valid examples are:
   * - `top-end` (on top of reference, right aligned)
   * - `right-start` (on right of reference, top aligned)
   * - `bottom` (on bottom, centered)
   * - `auto-end` (on the side with more space available, alignment depends by placement)
   *
   * @static
   * @type {Array}
   * @enum {String}
   * @readonly
   * @method placements
   * @memberof Popper
   */


  var placements = ['auto-start', 'auto', 'auto-end', 'top-start', 'top', 'top-end', 'right-start', 'right', 'right-end', 'bottom-end', 'bottom', 'bottom-start', 'left-end', 'left', 'left-start']; // Get rid of `auto` `auto-start` and `auto-end`

  var validPlacements = placements.slice(3);
  /**
   * Given an initial placement, returns all the subsequent placements
   * clockwise (or counter-clockwise).
   *
   * @method
   * @memberof Popper.Utils
   * @argument {String} placement - A valid placement (it accepts variations)
   * @argument {Boolean} counter - Set to true to walk the placements counterclockwise
   * @returns {Array} placements including their variations
   */

  function clockwise(placement) {
    var counter = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    var index = validPlacements.indexOf(placement);
    var arr = validPlacements.slice(index + 1).concat(validPlacements.slice(0, index));
    return counter ? arr.reverse() : arr;
  }

  var BEHAVIORS = {
    FLIP: 'flip',
    CLOCKWISE: 'clockwise',
    COUNTERCLOCKWISE: 'counterclockwise'
  };
  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by update method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */

  function flip(data, options) {
    // if `inner` modifier is enabled, we can't use the `flip` modifier
    if (isModifierEnabled(data.instance.modifiers, 'inner')) {
      return data;
    }

    if (data.flipped && data.placement === data.originalPlacement) {
      // seems like flip is trying to loop, probably there's not enough space on any of the flippable sides
      return data;
    }

    var boundaries = getBoundaries(data.instance.popper, data.instance.reference, options.padding, options.boundariesElement, data.positionFixed);
    var placement = data.placement.split('-')[0];
    var placementOpposite = getOppositePlacement(placement);
    var variation = data.placement.split('-')[1] || '';
    var flipOrder = [];

    switch (options.behavior) {
      case BEHAVIORS.FLIP:
        flipOrder = [placement, placementOpposite];
        break;

      case BEHAVIORS.CLOCKWISE:
        flipOrder = clockwise(placement);
        break;

      case BEHAVIORS.COUNTERCLOCKWISE:
        flipOrder = clockwise(placement, true);
        break;

      default:
        flipOrder = options.behavior;
    }

    flipOrder.forEach(function (step, index) {
      if (placement !== step || flipOrder.length === index + 1) {
        return data;
      }

      placement = data.placement.split('-')[0];
      placementOpposite = getOppositePlacement(placement);
      var popperOffsets = data.offsets.popper;
      var refOffsets = data.offsets.reference; // using floor because the reference offsets may contain decimals we are not going to consider here

      var floor = Math.floor;
      var overlapsRef = placement === 'left' && floor(popperOffsets.right) > floor(refOffsets.left) || placement === 'right' && floor(popperOffsets.left) < floor(refOffsets.right) || placement === 'top' && floor(popperOffsets.bottom) > floor(refOffsets.top) || placement === 'bottom' && floor(popperOffsets.top) < floor(refOffsets.bottom);
      var overflowsLeft = floor(popperOffsets.left) < floor(boundaries.left);
      var overflowsRight = floor(popperOffsets.right) > floor(boundaries.right);
      var overflowsTop = floor(popperOffsets.top) < floor(boundaries.top);
      var overflowsBottom = floor(popperOffsets.bottom) > floor(boundaries.bottom);
      var overflowsBoundaries = placement === 'left' && overflowsLeft || placement === 'right' && overflowsRight || placement === 'top' && overflowsTop || placement === 'bottom' && overflowsBottom; // flip the variation if required

      var isVertical = ['top', 'bottom'].indexOf(placement) !== -1; // flips variation if reference element overflows boundaries

      var flippedVariationByRef = !!options.flipVariations && (isVertical && variation === 'start' && overflowsLeft || isVertical && variation === 'end' && overflowsRight || !isVertical && variation === 'start' && overflowsTop || !isVertical && variation === 'end' && overflowsBottom); // flips variation if popper content overflows boundaries

      var flippedVariationByContent = !!options.flipVariationsByContent && (isVertical && variation === 'start' && overflowsRight || isVertical && variation === 'end' && overflowsLeft || !isVertical && variation === 'start' && overflowsBottom || !isVertical && variation === 'end' && overflowsTop);
      var flippedVariation = flippedVariationByRef || flippedVariationByContent;

      if (overlapsRef || overflowsBoundaries || flippedVariation) {
        // this boolean to detect any flip loop
        data.flipped = true;

        if (overlapsRef || overflowsBoundaries) {
          placement = flipOrder[index + 1];
        }

        if (flippedVariation) {
          variation = getOppositeVariation(variation);
        }

        data.placement = placement + (variation ? '-' + variation : ''); // this object contains `position`, we want to preserve it along with
        // any additional property we may add in the future

        data.offsets.popper = _extends$1({}, data.offsets.popper, getPopperOffsets(data.instance.popper, data.offsets.reference, data.placement));
        data = runModifiers(data.instance.modifiers, data, 'flip');
      }
    });
    return data;
  }
  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by update method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */


  function keepTogether(data) {
    var _data$offsets = data.offsets,
        popper = _data$offsets.popper,
        reference = _data$offsets.reference;
    var placement = data.placement.split('-')[0];
    var floor = Math.floor;
    var isVertical = ['top', 'bottom'].indexOf(placement) !== -1;
    var side = isVertical ? 'right' : 'bottom';
    var opSide = isVertical ? 'left' : 'top';
    var measurement = isVertical ? 'width' : 'height';

    if (popper[side] < floor(reference[opSide])) {
      data.offsets.popper[opSide] = floor(reference[opSide]) - popper[measurement];
    }

    if (popper[opSide] > floor(reference[side])) {
      data.offsets.popper[opSide] = floor(reference[side]);
    }

    return data;
  }
  /**
   * Converts a string containing value + unit into a px value number
   * @function
   * @memberof {modifiers~offset}
   * @private
   * @argument {String} str - Value + unit string
   * @argument {String} measurement - `height` or `width`
   * @argument {Object} popperOffsets
   * @argument {Object} referenceOffsets
   * @returns {Number|String}
   * Value in pixels, or original string if no values were extracted
   */


  function toValue(str, measurement, popperOffsets, referenceOffsets) {
    // separate value from unit
    var split = str.match(/((?:\-|\+)?\d*\.?\d*)(.*)/);
    var value = +split[1];
    var unit = split[2]; // If it's not a number it's an operator, I guess

    if (!value) {
      return str;
    }

    if (unit.indexOf('%') === 0) {
      var element = void 0;

      switch (unit) {
        case '%p':
          element = popperOffsets;
          break;

        case '%':
        case '%r':
        default:
          element = referenceOffsets;
      }

      var rect = getClientRect(element);
      return rect[measurement] / 100 * value;
    } else if (unit === 'vh' || unit === 'vw') {
      // if is a vh or vw, we calculate the size based on the viewport
      var size = void 0;

      if (unit === 'vh') {
        size = Math.max(document.documentElement.clientHeight, window.innerHeight || 0);
      } else {
        size = Math.max(document.documentElement.clientWidth, window.innerWidth || 0);
      }

      return size / 100 * value;
    } else {
      // if is an explicit pixel unit, we get rid of the unit and keep the value
      // if is an implicit unit, it's px, and we return just the value
      return value;
    }
  }
  /**
   * Parse an `offset` string to extrapolate `x` and `y` numeric offsets.
   * @function
   * @memberof {modifiers~offset}
   * @private
   * @argument {String} offset
   * @argument {Object} popperOffsets
   * @argument {Object} referenceOffsets
   * @argument {String} basePlacement
   * @returns {Array} a two cells array with x and y offsets in numbers
   */


  function parseOffset(offset, popperOffsets, referenceOffsets, basePlacement) {
    var offsets = [0, 0]; // Use height if placement is left or right and index is 0 otherwise use width
    // in this way the first offset will use an axis and the second one
    // will use the other one

    var useHeight = ['right', 'left'].indexOf(basePlacement) !== -1; // Split the offset string to obtain a list of values and operands
    // The regex addresses values with the plus or minus sign in front (+10, -20, etc)

    var fragments = offset.split(/(\+|\-)/).map(function (frag) {
      return frag.trim();
    }); // Detect if the offset string contains a pair of values or a single one
    // they could be separated by comma or space

    var divider = fragments.indexOf(find(fragments, function (frag) {
      return frag.search(/,|\s/) !== -1;
    }));

    if (fragments[divider] && fragments[divider].indexOf(',') === -1) {
      console.warn('Offsets separated by white space(s) are deprecated, use a comma (,) instead.');
    } // If divider is found, we divide the list of values and operands to divide
    // them by ofset X and Y.


    var splitRegex = /\s*,\s*|\s+/;
    var ops = divider !== -1 ? [fragments.slice(0, divider).concat([fragments[divider].split(splitRegex)[0]]), [fragments[divider].split(splitRegex)[1]].concat(fragments.slice(divider + 1))] : [fragments]; // Convert the values with units to absolute pixels to allow our computations

    ops = ops.map(function (op, index) {
      // Most of the units rely on the orientation of the popper
      var measurement = (index === 1 ? !useHeight : useHeight) ? 'height' : 'width';
      var mergeWithPrevious = false;
      return op // This aggregates any `+` or `-` sign that aren't considered operators
      // e.g.: 10 + +5 => [10, +, +5]
      .reduce(function (a, b) {
        if (a[a.length - 1] === '' && ['+', '-'].indexOf(b) !== -1) {
          a[a.length - 1] = b;
          mergeWithPrevious = true;
          return a;
        } else if (mergeWithPrevious) {
          a[a.length - 1] += b;
          mergeWithPrevious = false;
          return a;
        } else {
          return a.concat(b);
        }
      }, []) // Here we convert the string values into number values (in px)
      .map(function (str) {
        return toValue(str, measurement, popperOffsets, referenceOffsets);
      });
    }); // Loop trough the offsets arrays and execute the operations

    ops.forEach(function (op, index) {
      op.forEach(function (frag, index2) {
        if (isNumeric(frag)) {
          offsets[index] += frag * (op[index2 - 1] === '-' ? -1 : 1);
        }
      });
    });
    return offsets;
  }
  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by update method
   * @argument {Object} options - Modifiers configuration and options
   * @argument {Number|String} options.offset=0
   * The offset value as described in the modifier description
   * @returns {Object} The data object, properly modified
   */


  function offset(data, _ref) {
    var offset = _ref.offset;
    var placement = data.placement,
        _data$offsets = data.offsets,
        popper = _data$offsets.popper,
        reference = _data$offsets.reference;
    var basePlacement = placement.split('-')[0];
    var offsets = void 0;

    if (isNumeric(+offset)) {
      offsets = [+offset, 0];
    } else {
      offsets = parseOffset(offset, popper, reference, basePlacement);
    }

    if (basePlacement === 'left') {
      popper.top += offsets[0];
      popper.left -= offsets[1];
    } else if (basePlacement === 'right') {
      popper.top += offsets[0];
      popper.left += offsets[1];
    } else if (basePlacement === 'top') {
      popper.left += offsets[0];
      popper.top -= offsets[1];
    } else if (basePlacement === 'bottom') {
      popper.left += offsets[0];
      popper.top += offsets[1];
    }

    data.popper = popper;
    return data;
  }
  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by `update` method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */


  function preventOverflow(data, options) {
    var boundariesElement = options.boundariesElement || getOffsetParent(data.instance.popper); // If offsetParent is the reference element, we really want to
    // go one step up and use the next offsetParent as reference to
    // avoid to make this modifier completely useless and look like broken

    if (data.instance.reference === boundariesElement) {
      boundariesElement = getOffsetParent(boundariesElement);
    } // NOTE: DOM access here
    // resets the popper's position so that the document size can be calculated excluding
    // the size of the popper element itself


    var transformProp = getSupportedPropertyName('transform');
    var popperStyles = data.instance.popper.style; // assignment to help minification

    var top = popperStyles.top,
        left = popperStyles.left,
        transform = popperStyles[transformProp];
    popperStyles.top = '';
    popperStyles.left = '';
    popperStyles[transformProp] = '';
    var boundaries = getBoundaries(data.instance.popper, data.instance.reference, options.padding, boundariesElement, data.positionFixed); // NOTE: DOM access here
    // restores the original style properties after the offsets have been computed

    popperStyles.top = top;
    popperStyles.left = left;
    popperStyles[transformProp] = transform;
    options.boundaries = boundaries;
    var order = options.priority;
    var popper = data.offsets.popper;
    var check = {
      primary: function primary(placement) {
        var value = popper[placement];

        if (popper[placement] < boundaries[placement] && !options.escapeWithReference) {
          value = Math.max(popper[placement], boundaries[placement]);
        }

        return defineProperty({}, placement, value);
      },
      secondary: function secondary(placement) {
        var mainSide = placement === 'right' ? 'left' : 'top';
        var value = popper[mainSide];

        if (popper[placement] > boundaries[placement] && !options.escapeWithReference) {
          value = Math.min(popper[mainSide], boundaries[placement] - (placement === 'right' ? popper.width : popper.height));
        }

        return defineProperty({}, mainSide, value);
      }
    };
    order.forEach(function (placement) {
      var side = ['left', 'top'].indexOf(placement) !== -1 ? 'primary' : 'secondary';
      popper = _extends$1({}, popper, check[side](placement));
    });
    data.offsets.popper = popper;
    return data;
  }
  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by `update` method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */


  function shift(data) {
    var placement = data.placement;
    var basePlacement = placement.split('-')[0];
    var shiftvariation = placement.split('-')[1]; // if shift shiftvariation is specified, run the modifier

    if (shiftvariation) {
      var _data$offsets = data.offsets,
          reference = _data$offsets.reference,
          popper = _data$offsets.popper;
      var isVertical = ['bottom', 'top'].indexOf(basePlacement) !== -1;
      var side = isVertical ? 'left' : 'top';
      var measurement = isVertical ? 'width' : 'height';
      var shiftOffsets = {
        start: defineProperty({}, side, reference[side]),
        end: defineProperty({}, side, reference[side] + reference[measurement] - popper[measurement])
      };
      data.offsets.popper = _extends$1({}, popper, shiftOffsets[shiftvariation]);
    }

    return data;
  }
  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by update method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */


  function hide(data) {
    if (!isModifierRequired(data.instance.modifiers, 'hide', 'preventOverflow')) {
      return data;
    }

    var refRect = data.offsets.reference;
    var bound = find(data.instance.modifiers, function (modifier) {
      return modifier.name === 'preventOverflow';
    }).boundaries;

    if (refRect.bottom < bound.top || refRect.left > bound.right || refRect.top > bound.bottom || refRect.right < bound.left) {
      // Avoid unnecessary DOM access if visibility hasn't changed
      if (data.hide === true) {
        return data;
      }

      data.hide = true;
      data.attributes['x-out-of-boundaries'] = '';
    } else {
      // Avoid unnecessary DOM access if visibility hasn't changed
      if (data.hide === false) {
        return data;
      }

      data.hide = false;
      data.attributes['x-out-of-boundaries'] = false;
    }

    return data;
  }
  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by `update` method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */


  function inner(data) {
    var placement = data.placement;
    var basePlacement = placement.split('-')[0];
    var _data$offsets = data.offsets,
        popper = _data$offsets.popper,
        reference = _data$offsets.reference;
    var isHoriz = ['left', 'right'].indexOf(basePlacement) !== -1;
    var subtractLength = ['top', 'left'].indexOf(basePlacement) === -1;
    popper[isHoriz ? 'left' : 'top'] = reference[basePlacement] - (subtractLength ? popper[isHoriz ? 'width' : 'height'] : 0);
    data.placement = getOppositePlacement(placement);
    data.offsets.popper = getClientRect(popper);
    return data;
  }
  /**
   * Modifier function, each modifier can have a function of this type assigned
   * to its `fn` property.<br />
   * These functions will be called on each update, this means that you must
   * make sure they are performant enough to avoid performance bottlenecks.
   *
   * @function ModifierFn
   * @argument {dataObject} data - The data object generated by `update` method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {dataObject} The data object, properly modified
   */

  /**
   * Modifiers are plugins used to alter the behavior of your poppers.<br />
   * Popper.js uses a set of 9 modifiers to provide all the basic functionalities
   * needed by the library.
   *
   * Usually you don't want to override the `order`, `fn` and `onLoad` props.
   * All the other properties are configurations that could be tweaked.
   * @namespace modifiers
   */


  var modifiers = {
    /**
     * Modifier used to shift the popper on the start or end of its reference
     * element.<br />
     * It will read the variation of the `placement` property.<br />
     * It can be one either `-end` or `-start`.
     * @memberof modifiers
     * @inner
     */
    shift: {
      /** @prop {number} order=100 - Index used to define the order of execution */
      order: 100,

      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,

      /** @prop {ModifierFn} */
      fn: shift
    },

    /**
     * The `offset` modifier can shift your popper on both its axis.
     *
     * It accepts the following units:
     * - `px` or unit-less, interpreted as pixels
     * - `%` or `%r`, percentage relative to the length of the reference element
     * - `%p`, percentage relative to the length of the popper element
     * - `vw`, CSS viewport width unit
     * - `vh`, CSS viewport height unit
     *
     * For length is intended the main axis relative to the placement of the popper.<br />
     * This means that if the placement is `top` or `bottom`, the length will be the
     * `width`. In case of `left` or `right`, it will be the `height`.
     *
     * You can provide a single value (as `Number` or `String`), or a pair of values
     * as `String` divided by a comma or one (or more) white spaces.<br />
     * The latter is a deprecated method because it leads to confusion and will be
     * removed in v2.<br />
     * Additionally, it accepts additions and subtractions between different units.
     * Note that multiplications and divisions aren't supported.
     *
     * Valid examples are:
     * ```
     * 10
     * '10%'
     * '10, 10'
     * '10%, 10'
     * '10 + 10%'
     * '10 - 5vh + 3%'
     * '-10px + 5vh, 5px - 6%'
     * ```
     * > **NB**: If you desire to apply offsets to your poppers in a way that may make them overlap
     * > with their reference element, unfortunately, you will have to disable the `flip` modifier.
     * > You can read more on this at this [issue](https://github.com/FezVrasta/popper.js/issues/373).
     *
     * @memberof modifiers
     * @inner
     */
    offset: {
      /** @prop {number} order=200 - Index used to define the order of execution */
      order: 200,

      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,

      /** @prop {ModifierFn} */
      fn: offset,

      /** @prop {Number|String} offset=0
       * The offset value as described in the modifier description
       */
      offset: 0
    },

    /**
     * Modifier used to prevent the popper from being positioned outside the boundary.
     *
     * A scenario exists where the reference itself is not within the boundaries.<br />
     * We can say it has "escaped the boundaries" — or just "escaped".<br />
     * In this case we need to decide whether the popper should either:
     *
     * - detach from the reference and remain "trapped" in the boundaries, or
     * - if it should ignore the boundary and "escape with its reference"
     *
     * When `escapeWithReference` is set to`true` and reference is completely
     * outside its boundaries, the popper will overflow (or completely leave)
     * the boundaries in order to remain attached to the edge of the reference.
     *
     * @memberof modifiers
     * @inner
     */
    preventOverflow: {
      /** @prop {number} order=300 - Index used to define the order of execution */
      order: 300,

      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,

      /** @prop {ModifierFn} */
      fn: preventOverflow,

      /**
       * @prop {Array} [priority=['left','right','top','bottom']]
       * Popper will try to prevent overflow following these priorities by default,
       * then, it could overflow on the left and on top of the `boundariesElement`
       */
      priority: ['left', 'right', 'top', 'bottom'],

      /**
       * @prop {number} padding=5
       * Amount of pixel used to define a minimum distance between the boundaries
       * and the popper. This makes sure the popper always has a little padding
       * between the edges of its container
       */
      padding: 5,

      /**
       * @prop {String|HTMLElement} boundariesElement='scrollParent'
       * Boundaries used by the modifier. Can be `scrollParent`, `window`,
       * `viewport` or any DOM element.
       */
      boundariesElement: 'scrollParent'
    },

    /**
     * Modifier used to make sure the reference and its popper stay near each other
     * without leaving any gap between the two. Especially useful when the arrow is
     * enabled and you want to ensure that it points to its reference element.
     * It cares only about the first axis. You can still have poppers with margin
     * between the popper and its reference element.
     * @memberof modifiers
     * @inner
     */
    keepTogether: {
      /** @prop {number} order=400 - Index used to define the order of execution */
      order: 400,

      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,

      /** @prop {ModifierFn} */
      fn: keepTogether
    },

    /**
     * This modifier is used to move the `arrowElement` of the popper to make
     * sure it is positioned between the reference element and its popper element.
     * It will read the outer size of the `arrowElement` node to detect how many
     * pixels of conjunction are needed.
     *
     * It has no effect if no `arrowElement` is provided.
     * @memberof modifiers
     * @inner
     */
    arrow: {
      /** @prop {number} order=500 - Index used to define the order of execution */
      order: 500,

      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,

      /** @prop {ModifierFn} */
      fn: arrow,

      /** @prop {String|HTMLElement} element='[x-arrow]' - Selector or node used as arrow */
      element: '[x-arrow]'
    },

    /**
     * Modifier used to flip the popper's placement when it starts to overlap its
     * reference element.
     *
     * Requires the `preventOverflow` modifier before it in order to work.
     *
     * **NOTE:** this modifier will interrupt the current update cycle and will
     * restart it if it detects the need to flip the placement.
     * @memberof modifiers
     * @inner
     */
    flip: {
      /** @prop {number} order=600 - Index used to define the order of execution */
      order: 600,

      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,

      /** @prop {ModifierFn} */
      fn: flip,

      /**
       * @prop {String|Array} behavior='flip'
       * The behavior used to change the popper's placement. It can be one of
       * `flip`, `clockwise`, `counterclockwise` or an array with a list of valid
       * placements (with optional variations)
       */
      behavior: 'flip',

      /**
       * @prop {number} padding=5
       * The popper will flip if it hits the edges of the `boundariesElement`
       */
      padding: 5,

      /**
       * @prop {String|HTMLElement} boundariesElement='viewport'
       * The element which will define the boundaries of the popper position.
       * The popper will never be placed outside of the defined boundaries
       * (except if `keepTogether` is enabled)
       */
      boundariesElement: 'viewport',

      /**
       * @prop {Boolean} flipVariations=false
       * The popper will switch placement variation between `-start` and `-end` when
       * the reference element overlaps its boundaries.
       *
       * The original placement should have a set variation.
       */
      flipVariations: false,

      /**
       * @prop {Boolean} flipVariationsByContent=false
       * The popper will switch placement variation between `-start` and `-end` when
       * the popper element overlaps its reference boundaries.
       *
       * The original placement should have a set variation.
       */
      flipVariationsByContent: false
    },

    /**
     * Modifier used to make the popper flow toward the inner of the reference element.
     * By default, when this modifier is disabled, the popper will be placed outside
     * the reference element.
     * @memberof modifiers
     * @inner
     */
    inner: {
      /** @prop {number} order=700 - Index used to define the order of execution */
      order: 700,

      /** @prop {Boolean} enabled=false - Whether the modifier is enabled or not */
      enabled: false,

      /** @prop {ModifierFn} */
      fn: inner
    },

    /**
     * Modifier used to hide the popper when its reference element is outside of the
     * popper boundaries. It will set a `x-out-of-boundaries` attribute which can
     * be used to hide with a CSS selector the popper when its reference is
     * out of boundaries.
     *
     * Requires the `preventOverflow` modifier before it in order to work.
     * @memberof modifiers
     * @inner
     */
    hide: {
      /** @prop {number} order=800 - Index used to define the order of execution */
      order: 800,

      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,

      /** @prop {ModifierFn} */
      fn: hide
    },

    /**
     * Computes the style that will be applied to the popper element to gets
     * properly positioned.
     *
     * Note that this modifier will not touch the DOM, it just prepares the styles
     * so that `applyStyle` modifier can apply it. This separation is useful
     * in case you need to replace `applyStyle` with a custom implementation.
     *
     * This modifier has `850` as `order` value to maintain backward compatibility
     * with previous versions of Popper.js. Expect the modifiers ordering method
     * to change in future major versions of the library.
     *
     * @memberof modifiers
     * @inner
     */
    computeStyle: {
      /** @prop {number} order=850 - Index used to define the order of execution */
      order: 850,

      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,

      /** @prop {ModifierFn} */
      fn: computeStyle,

      /**
       * @prop {Boolean} gpuAcceleration=true
       * If true, it uses the CSS 3D transformation to position the popper.
       * Otherwise, it will use the `top` and `left` properties
       */
      gpuAcceleration: true,

      /**
       * @prop {string} [x='bottom']
       * Where to anchor the X axis (`bottom` or `top`). AKA X offset origin.
       * Change this if your popper should grow in a direction different from `bottom`
       */
      x: 'bottom',

      /**
       * @prop {string} [x='left']
       * Where to anchor the Y axis (`left` or `right`). AKA Y offset origin.
       * Change this if your popper should grow in a direction different from `right`
       */
      y: 'right'
    },

    /**
     * Applies the computed styles to the popper element.
     *
     * All the DOM manipulations are limited to this modifier. This is useful in case
     * you want to integrate Popper.js inside a framework or view library and you
     * want to delegate all the DOM manipulations to it.
     *
     * Note that if you disable this modifier, you must make sure the popper element
     * has its position set to `absolute` before Popper.js can do its work!
     *
     * Just disable this modifier and define your own to achieve the desired effect.
     *
     * @memberof modifiers
     * @inner
     */
    applyStyle: {
      /** @prop {number} order=900 - Index used to define the order of execution */
      order: 900,

      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,

      /** @prop {ModifierFn} */
      fn: applyStyle,

      /** @prop {Function} */
      onLoad: applyStyleOnLoad,

      /**
       * @deprecated since version 1.10.0, the property moved to `computeStyle` modifier
       * @prop {Boolean} gpuAcceleration=true
       * If true, it uses the CSS 3D transformation to position the popper.
       * Otherwise, it will use the `top` and `left` properties
       */
      gpuAcceleration: undefined
    }
  };
  /**
   * The `dataObject` is an object containing all the information used by Popper.js.
   * This object is passed to modifiers and to the `onCreate` and `onUpdate` callbacks.
   * @name dataObject
   * @property {Object} data.instance The Popper.js instance
   * @property {String} data.placement Placement applied to popper
   * @property {String} data.originalPlacement Placement originally defined on init
   * @property {Boolean} data.flipped True if popper has been flipped by flip modifier
   * @property {Boolean} data.hide True if the reference element is out of boundaries, useful to know when to hide the popper
   * @property {HTMLElement} data.arrowElement Node used as arrow by arrow modifier
   * @property {Object} data.styles Any CSS property defined here will be applied to the popper. It expects the JavaScript nomenclature (eg. `marginBottom`)
   * @property {Object} data.arrowStyles Any CSS property defined here will be applied to the popper arrow. It expects the JavaScript nomenclature (eg. `marginBottom`)
   * @property {Object} data.boundaries Offsets of the popper boundaries
   * @property {Object} data.offsets The measurements of popper, reference and arrow elements
   * @property {Object} data.offsets.popper `top`, `left`, `width`, `height` values
   * @property {Object} data.offsets.reference `top`, `left`, `width`, `height` values
   * @property {Object} data.offsets.arrow] `top` and `left` offsets, only one of them will be different from 0
   */

  /**
   * Default options provided to Popper.js constructor.<br />
   * These can be overridden using the `options` argument of Popper.js.<br />
   * To override an option, simply pass an object with the same
   * structure of the `options` object, as the 3rd argument. For example:
   * ```
   * new Popper(ref, pop, {
   *   modifiers: {
   *     preventOverflow: { enabled: false }
   *   }
   * })
   * ```
   * @type {Object}
   * @static
   * @memberof Popper
   */

  var Defaults = {
    /**
     * Popper's placement.
     * @prop {Popper.placements} placement='bottom'
     */
    placement: 'bottom',

    /**
     * Set this to true if you want popper to position it self in 'fixed' mode
     * @prop {Boolean} positionFixed=false
     */
    positionFixed: false,

    /**
     * Whether events (resize, scroll) are initially enabled.
     * @prop {Boolean} eventsEnabled=true
     */
    eventsEnabled: true,

    /**
     * Set to true if you want to automatically remove the popper when
     * you call the `destroy` method.
     * @prop {Boolean} removeOnDestroy=false
     */
    removeOnDestroy: false,

    /**
     * Callback called when the popper is created.<br />
     * By default, it is set to no-op.<br />
     * Access Popper.js instance with `data.instance`.
     * @prop {onCreate}
     */
    onCreate: function onCreate() {},

    /**
     * Callback called when the popper is updated. This callback is not called
     * on the initialization/creation of the popper, but only on subsequent
     * updates.<br />
     * By default, it is set to no-op.<br />
     * Access Popper.js instance with `data.instance`.
     * @prop {onUpdate}
     */
    onUpdate: function onUpdate() {},

    /**
     * List of modifiers used to modify the offsets before they are applied to the popper.
     * They provide most of the functionalities of Popper.js.
     * @prop {modifiers}
     */
    modifiers: modifiers
  };
  /**
   * @callback onCreate
   * @param {dataObject} data
   */

  /**
   * @callback onUpdate
   * @param {dataObject} data
   */
  // Utils
  // Methods

  var Popper = function () {
    /**
     * Creates a new Popper.js instance.
     * @class Popper
     * @param {Element|referenceObject} reference - The reference element used to position the popper
     * @param {Element} popper - The HTML / XML element used as the popper
     * @param {Object} options - Your custom options to override the ones defined in [Defaults](#defaults)
     * @return {Object} instance - The generated Popper.js instance
     */
    function Popper(reference, popper) {
      var _this = this;

      var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      classCallCheck(this, Popper);

      this.scheduleUpdate = function () {
        return requestAnimationFrame(_this.update);
      }; // make update() debounced, so that it only runs at most once-per-tick


      this.update = debounce(this.update.bind(this)); // with {} we create a new object with the options inside it

      this.options = _extends$1({}, Popper.Defaults, options); // init state

      this.state = {
        isDestroyed: false,
        isCreated: false,
        scrollParents: []
      }; // get reference and popper elements (allow jQuery wrappers)

      this.reference = reference && reference.jquery ? reference[0] : reference;
      this.popper = popper && popper.jquery ? popper[0] : popper; // Deep merge modifiers options

      this.options.modifiers = {};
      Object.keys(_extends$1({}, Popper.Defaults.modifiers, options.modifiers)).forEach(function (name) {
        _this.options.modifiers[name] = _extends$1({}, Popper.Defaults.modifiers[name] || {}, options.modifiers ? options.modifiers[name] : {});
      }); // Refactoring modifiers' list (Object => Array)

      this.modifiers = Object.keys(this.options.modifiers).map(function (name) {
        return _extends$1({
          name: name
        }, _this.options.modifiers[name]);
      }) // sort the modifiers by order
      .sort(function (a, b) {
        return a.order - b.order;
      }); // modifiers have the ability to execute arbitrary code when Popper.js get inited
      // such code is executed in the same order of its modifier
      // they could add new properties to their options configuration
      // BE AWARE: don't add options to `options.modifiers.name` but to `modifierOptions`!

      this.modifiers.forEach(function (modifierOptions) {
        if (modifierOptions.enabled && isFunction(modifierOptions.onLoad)) {
          modifierOptions.onLoad(_this.reference, _this.popper, _this.options, modifierOptions, _this.state);
        }
      }); // fire the first update to position the popper in the right place

      this.update();
      var eventsEnabled = this.options.eventsEnabled;

      if (eventsEnabled) {
        // setup event listeners, they will take care of update the position in specific situations
        this.enableEventListeners();
      }

      this.state.eventsEnabled = eventsEnabled;
    } // We can't use class properties because they don't get listed in the
    // class prototype and break stuff like Sinon stubs


    createClass(Popper, [{
      key: 'update',
      value: function update$$1() {
        return update.call(this);
      }
    }, {
      key: 'destroy',
      value: function destroy$$1() {
        return destroy.call(this);
      }
    }, {
      key: 'enableEventListeners',
      value: function enableEventListeners$$1() {
        return enableEventListeners.call(this);
      }
    }, {
      key: 'disableEventListeners',
      value: function disableEventListeners$$1() {
        return disableEventListeners.call(this);
      }
      /**
       * Schedules an update. It will run on the next UI update available.
       * @method scheduleUpdate
       * @memberof Popper
       */

      /**
       * Collection of utilities useful when writing custom modifiers.
       * Starting from version 1.7, this method is available only if you
       * include `popper-utils.js` before `popper.js`.
       *
       * **DEPRECATION**: This way to access PopperUtils is deprecated
       * and will be removed in v2! Use the PopperUtils module directly instead.
       * Due to the high instability of the methods contained in Utils, we can't
       * guarantee them to follow semver. Use them at your own risk!
       * @static
       * @private
       * @type {Object}
       * @deprecated since version 1.8
       * @member Utils
       * @memberof Popper
       */

    }]);
    return Popper;
  }();
  /**
   * The `referenceObject` is an object that provides an interface compatible with Popper.js
   * and lets you use it as replacement of a real DOM node.<br />
   * You can use this method to position a popper relatively to a set of coordinates
   * in case you don't have a DOM node to use as reference.
   *
   * ```
   * new Popper(referenceObject, popperNode);
   * ```
   *
   * NB: This feature isn't supported in Internet Explorer 10.
   * @name referenceObject
   * @property {Function} data.getBoundingClientRect
   * A function that returns a set of coordinates compatible with the native `getBoundingClientRect` method.
   * @property {number} data.clientWidth
   * An ES6 getter that will return the width of the virtual reference element.
   * @property {number} data.clientHeight
   * An ES6 getter that will return the height of the virtual reference element.
   */


  Popper.Utils = (typeof window !== 'undefined' ? window : global).PopperUtils;
  Popper.placements = placements;
  Popper.Defaults = Defaults;

  var popper = /*#__PURE__*/Object.freeze({
    __proto__: null,
    'default': Popper
  });

  var require$$0 = getCjsExportFromNamespace(popper);

  var vuePopper_min = createCommonjsModule$1(function (module, exports) {
    !function (e, t) {
       module.exports = t(require$$0) ;
    }(commonjsGlobal$1, function (e) {

      function t(e, t, o) {
        e && t && o && (document.addEventListener ? e.addEventListener(t, o, !1) : e.attachEvent("on" + t, o));
      }

      function o(e, t, o) {
        e && t && (document.removeEventListener ? e.removeEventListener(t, o, !1) : e.detachEvent("on" + t, o));
      }

      e = e && e.hasOwnProperty("default") ? e.default : e;
      var n = {
        props: {
          tagName: {
            type: String,
            default: "span"
          },
          trigger: {
            type: String,
            default: "hover",
            validator: function validator(e) {
              return ["clickToOpen", "click", "clickToToggle", "hover", "focus"].indexOf(e) > -1;
            }
          },
          delayOnMouseOver: {
            type: Number,
            default: 10
          },
          delayOnMouseOut: {
            type: Number,
            default: 10
          },
          disabled: {
            type: Boolean,
            default: !1
          },
          content: String,
          enterActiveClass: String,
          leaveActiveClass: String,
          boundariesSelector: String,
          reference: {},
          forceShow: {
            type: Boolean,
            default: !1
          },
          dataValue: {
            default: null
          },
          appendToBody: {
            type: Boolean,
            default: !1
          },
          visibleArrow: {
            type: Boolean,
            default: !0
          },
          transition: {
            type: String,
            default: ""
          },
          stopPropagation: {
            type: Boolean,
            default: !1
          },
          preventDefault: {
            type: Boolean,
            default: !1
          },
          options: {
            type: Object,
            default: function _default() {
              return {};
            }
          }
        },
        data: function data() {
          return {
            referenceElm: null,
            popperJS: null,
            showPopper: !1,
            currentPlacement: "",
            popperOptions: {
              placement: "bottom",
              computeStyle: {
                gpuAcceleration: !1
              }
            }
          };
        },
        watch: {
          showPopper: function showPopper(e) {
            e ? (this.$emit("show", this), this.popperJS && this.popperJS.enableEventListeners(), this.updatePopper()) : (this.popperJS && this.popperJS.disableEventListeners(), this.$emit("hide", this));
          },
          forceShow: {
            handler: function handler(e) {
              this[e ? "doShow" : "doClose"]();
            },
            immediate: !0
          },
          disabled: function disabled(e) {
            e && (this.showPopper = !1);
          }
        },
        created: function created() {
          this.appendedArrow = !1, this.appendedToBody = !1, this.popperOptions = _extends(this.popperOptions, this.options);
        },
        mounted: function mounted() {
          switch (this.referenceElm = this.reference || this.$slots.reference[0].elm, this.popper = this.$slots.default[0].elm, this.trigger) {
            case "clickToOpen":
              t(this.referenceElm, "click", this.doShow), t(document, "click", this.handleDocumentClick);
              break;

            case "click":
            case "clickToToggle":
              t(this.referenceElm, "click", this.doToggle), t(document, "click", this.handleDocumentClick);
              break;

            case "hover":
              t(this.referenceElm, "mouseover", this.onMouseOver), t(this.popper, "mouseover", this.onMouseOver), t(this.referenceElm, "mouseout", this.onMouseOut), t(this.popper, "mouseout", this.onMouseOut);
              break;

            case "focus":
              t(this.referenceElm, "focus", this.onMouseOver), t(this.popper, "focus", this.onMouseOver), t(this.referenceElm, "blur", this.onMouseOut), t(this.popper, "blur", this.onMouseOut);
          }
        },
        methods: {
          doToggle: function doToggle(e) {
            this.stopPropagation && e.stopPropagation(), this.preventDefault && e.preventDefault(), this.forceShow || (this.showPopper = !this.showPopper);
          },
          doShow: function doShow() {
            this.showPopper = !0;
          },
          doClose: function doClose() {
            this.showPopper = !1;
          },
          doDestroy: function doDestroy() {
            this.showPopper || (this.popperJS && (this.popperJS.destroy(), this.popperJS = null), this.appendedToBody && (this.appendedToBody = !1, document.body.removeChild(this.popper.parentElement)));
          },
          createPopper: function createPopper() {
            var t = this;
            this.$nextTick(function () {
              if (t.visibleArrow && t.appendArrow(t.popper), t.appendToBody && !t.appendedToBody && (t.appendedToBody = !0, document.body.appendChild(t.popper.parentElement)), t.popperJS && t.popperJS.destroy && t.popperJS.destroy(), t.boundariesSelector) {
                var o = document.querySelector(t.boundariesSelector);
                o && (t.popperOptions.modifiers = _extends({}, t.popperOptions.modifiers), t.popperOptions.modifiers.preventOverflow = _extends({}, t.popperOptions.modifiers.preventOverflow), t.popperOptions.modifiers.preventOverflow.boundariesElement = o);
              }

              t.popperOptions.onCreate = function () {
                t.$emit("created", t), t.$nextTick(t.updatePopper);
              }, t.popperJS = new e(t.referenceElm, t.popper, t.popperOptions);
            });
          },
          destroyPopper: function destroyPopper() {
            o(this.referenceElm, "click", this.doToggle), o(this.referenceElm, "mouseup", this.doClose), o(this.referenceElm, "mousedown", this.doShow), o(this.referenceElm, "focus", this.doShow), o(this.referenceElm, "blur", this.doClose), o(this.referenceElm, "mouseout", this.onMouseOut), o(this.referenceElm, "mouseover", this.onMouseOver), o(document, "click", this.handleDocumentClick), this.showPopper = !1, this.doDestroy();
          },
          appendArrow: function appendArrow(e) {
            if (!this.appendedArrow) {
              this.appendedArrow = !0;
              var t = document.createElement("div");
              t.setAttribute("x-arrow", ""), t.className = "popper__arrow", e.appendChild(t);
            }
          },
          updatePopper: function updatePopper() {
            this.popperJS ? this.popperJS.scheduleUpdate() : this.createPopper();
          },
          onMouseOver: function onMouseOver() {
            var e = this;
            clearTimeout(this._timer), this._timer = setTimeout(function () {
              e.showPopper = !0;
            }, this.delayOnMouseOver);
          },
          onMouseOut: function onMouseOut() {
            var e = this;
            clearTimeout(this._timer), this._timer = setTimeout(function () {
              e.showPopper = !1;
            }, this.delayOnMouseOut);
          },
          handleDocumentClick: function handleDocumentClick(e) {
            this.$el && this.referenceElm && !this.elementContains(this.$el, e.target) && !this.elementContains(this.referenceElm, e.target) && this.popper && !this.elementContains(this.popper, e.target) && (this.$emit("documentClick", this), this.forceShow || (this.showPopper = !1));
          },
          elementContains: function elementContains(e, t) {
            return "function" == typeof e.contains && e.contains(t);
          }
        },
        destroyed: function destroyed() {
          this.destroyPopper();
        }
      };
      var r = n;
      n.__file = "popper.js.vue";
      return function (e, t, o, n, r, i, s, p, c, a) {
        "function" == typeof s && (c = p, p = s, s = !1);
        var d = "function" == typeof o ? o.options : o;
        var l;
        if (e && e.render && (d.render = e.render, d.staticRenderFns = e.staticRenderFns, d._compiled = !0, r && (d.functional = !0)), n && (d._scopeId = n), i ? (l = function l(e) {
          (e = e || this.$vnode && this.$vnode.ssrContext || this.parent && this.parent.$vnode && this.parent.$vnode.ssrContext) || "undefined" == typeof __VUE_SSR_CONTEXT__ || (e = __VUE_SSR_CONTEXT__), t && t.call(this, c(e)), e && e._registeredComponents && e._registeredComponents.add(i);
        }, d._ssrRegister = l) : t && (l = s ? function () {
          t.call(this, a(this.$root.$options.shadowRoot));
        } : function (e) {
          t.call(this, p(e));
        }), l) if (d.functional) {
          var _e = d.render;

          d.render = function (t, o) {
            return l.call(o), _e(t, o);
          };
        } else {
          var _e2 = d.beforeCreate;
          d.beforeCreate = _e2 ? [].concat(_e2, l) : [l];
        }
        return o;
      }({
        render: function render() {
          var e = this,
              t = e.$createElement,
              o = e._self._c || t;
          return o(e.tagName, {
            tag: "component"
          }, [o("transition", {
            attrs: {
              name: e.transition,
              "enter-active-class": e.enterActiveClass,
              "leave-active-class": e.leaveActiveClass
            },
            on: {
              "after-leave": e.doDestroy
            }
          }, [o("span", {
            directives: [{
              name: "show",
              rawName: "v-show",
              value: !e.disabled && e.showPopper,
              expression: "!disabled && showPopper"
            }],
            ref: "popper"
          }, [e._t("default", [e._v(e._s(e.content))])], 2)]), e._v(" "), e._t("reference")], 2);
        },
        staticRenderFns: []
      }, void 0, r, void 0, !1, void 0, void 0, void 0);
    });
  });

  var formatDistanceLocale = {
    lessThanXSeconds: {
      one: 'less than a second',
      other: 'less than {{count}} seconds'
    },
    xSeconds: {
      one: '1 second',
      other: '{{count}} seconds'
    },
    halfAMinute: 'half a minute',
    lessThanXMinutes: {
      one: 'less than a minute',
      other: 'less than {{count}} minutes'
    },
    xMinutes: {
      one: '1 minute',
      other: '{{count}} minutes'
    },
    aboutXHours: {
      one: 'about 1 hour',
      other: 'about {{count}} hours'
    },
    xHours: {
      one: '1 hour',
      other: '{{count}} hours'
    },
    xDays: {
      one: '1 day',
      other: '{{count}} days'
    },
    aboutXMonths: {
      one: 'about 1 month',
      other: 'about {{count}} months'
    },
    xMonths: {
      one: '1 month',
      other: '{{count}} months'
    },
    aboutXYears: {
      one: 'about 1 year',
      other: 'about {{count}} years'
    },
    xYears: {
      one: '1 year',
      other: '{{count}} years'
    },
    overXYears: {
      one: 'over 1 year',
      other: 'over {{count}} years'
    },
    almostXYears: {
      one: 'almost 1 year',
      other: 'almost {{count}} years'
    }
  };
  function formatDistance(token, count, options) {
    options = options || {};
    var result;

    if (typeof formatDistanceLocale[token] === 'string') {
      result = formatDistanceLocale[token];
    } else if (count === 1) {
      result = formatDistanceLocale[token].one;
    } else {
      result = formatDistanceLocale[token].other.replace('{{count}}', count);
    }

    if (options.addSuffix) {
      if (options.comparison > 0) {
        return 'in ' + result;
      } else {
        return result + ' ago';
      }
    }

    return result;
  }

  function buildFormatLongFn(args) {
    return function (dirtyOptions) {
      var options = dirtyOptions || {};
      var width = options.width ? String(options.width) : args.defaultWidth;
      var format = args.formats[width] || args.formats[args.defaultWidth];
      return format;
    };
  }

  var dateFormats = {
    full: 'EEEE, MMMM do, y',
    long: 'MMMM do, y',
    medium: 'MMM d, y',
    short: 'MM/dd/yyyy'
  };
  var timeFormats = {
    full: 'h:mm:ss a zzzz',
    long: 'h:mm:ss a z',
    medium: 'h:mm:ss a',
    short: 'h:mm a'
  };
  var dateTimeFormats = {
    full: "{{date}} 'at' {{time}}",
    long: "{{date}} 'at' {{time}}",
    medium: '{{date}}, {{time}}',
    short: '{{date}}, {{time}}'
  };
  var formatLong = {
    date: buildFormatLongFn({
      formats: dateFormats,
      defaultWidth: 'full'
    }),
    time: buildFormatLongFn({
      formats: timeFormats,
      defaultWidth: 'full'
    }),
    dateTime: buildFormatLongFn({
      formats: dateTimeFormats,
      defaultWidth: 'full'
    })
  };

  var formatRelativeLocale = {
    lastWeek: "'last' eeee 'at' p",
    yesterday: "'yesterday at' p",
    today: "'today at' p",
    tomorrow: "'tomorrow at' p",
    nextWeek: "eeee 'at' p",
    other: 'P'
  };
  function formatRelative(token, _date, _baseDate, _options) {
    return formatRelativeLocale[token];
  }

  function buildLocalizeFn(args) {
    return function (dirtyIndex, dirtyOptions) {
      var options = dirtyOptions || {};
      var context = options.context ? String(options.context) : 'standalone';
      var valuesArray;

      if (context === 'formatting' && args.formattingValues) {
        var defaultWidth = args.defaultFormattingWidth || args.defaultWidth;
        var width = options.width ? String(options.width) : defaultWidth;
        valuesArray = args.formattingValues[width] || args.formattingValues[defaultWidth];
      } else {
        var _defaultWidth = args.defaultWidth;

        var _width = options.width ? String(options.width) : args.defaultWidth;

        valuesArray = args.values[_width] || args.values[_defaultWidth];
      }

      var index = args.argumentCallback ? args.argumentCallback(dirtyIndex) : dirtyIndex;
      return valuesArray[index];
    };
  }

  var eraValues = {
    narrow: ['B', 'A'],
    abbreviated: ['BC', 'AD'],
    wide: ['Before Christ', 'Anno Domini']
  };
  var quarterValues = {
    narrow: ['1', '2', '3', '4'],
    abbreviated: ['Q1', 'Q2', 'Q3', 'Q4'],
    wide: ['1st quarter', '2nd quarter', '3rd quarter', '4th quarter'] // Note: in English, the names of days of the week and months are capitalized.
    // If you are making a new locale based on this one, check if the same is true for the language you're working on.
    // Generally, formatted dates should look like they are in the middle of a sentence,
    // e.g. in Spanish language the weekdays and months should be in the lowercase.

  };
  var monthValues = {
    narrow: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
    abbreviated: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
    wide: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December']
  };
  var dayValues = {
    narrow: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
    short: ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa'],
    abbreviated: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
    wide: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday']
  };
  var dayPeriodValues = {
    narrow: {
      am: 'a',
      pm: 'p',
      midnight: 'mi',
      noon: 'n',
      morning: 'morning',
      afternoon: 'afternoon',
      evening: 'evening',
      night: 'night'
    },
    abbreviated: {
      am: 'AM',
      pm: 'PM',
      midnight: 'midnight',
      noon: 'noon',
      morning: 'morning',
      afternoon: 'afternoon',
      evening: 'evening',
      night: 'night'
    },
    wide: {
      am: 'a.m.',
      pm: 'p.m.',
      midnight: 'midnight',
      noon: 'noon',
      morning: 'morning',
      afternoon: 'afternoon',
      evening: 'evening',
      night: 'night'
    }
  };
  var formattingDayPeriodValues = {
    narrow: {
      am: 'a',
      pm: 'p',
      midnight: 'mi',
      noon: 'n',
      morning: 'in the morning',
      afternoon: 'in the afternoon',
      evening: 'in the evening',
      night: 'at night'
    },
    abbreviated: {
      am: 'AM',
      pm: 'PM',
      midnight: 'midnight',
      noon: 'noon',
      morning: 'in the morning',
      afternoon: 'in the afternoon',
      evening: 'in the evening',
      night: 'at night'
    },
    wide: {
      am: 'a.m.',
      pm: 'p.m.',
      midnight: 'midnight',
      noon: 'noon',
      morning: 'in the morning',
      afternoon: 'in the afternoon',
      evening: 'in the evening',
      night: 'at night'
    }
  };

  function ordinalNumber(dirtyNumber, _dirtyOptions) {
    var number = Number(dirtyNumber); // If ordinal numbers depend on context, for example,
    // if they are different for different grammatical genders,
    // use `options.unit`:
    //
    //   var options = dirtyOptions || {}
    //   var unit = String(options.unit)
    //
    // where `unit` can be 'year', 'quarter', 'month', 'week', 'date', 'dayOfYear',
    // 'day', 'hour', 'minute', 'second'

    var rem100 = number % 100;

    if (rem100 > 20 || rem100 < 10) {
      switch (rem100 % 10) {
        case 1:
          return number + 'st';

        case 2:
          return number + 'nd';

        case 3:
          return number + 'rd';
      }
    }

    return number + 'th';
  }

  var localize = {
    ordinalNumber: ordinalNumber,
    era: buildLocalizeFn({
      values: eraValues,
      defaultWidth: 'wide'
    }),
    quarter: buildLocalizeFn({
      values: quarterValues,
      defaultWidth: 'wide',
      argumentCallback: function (quarter) {
        return Number(quarter) - 1;
      }
    }),
    month: buildLocalizeFn({
      values: monthValues,
      defaultWidth: 'wide'
    }),
    day: buildLocalizeFn({
      values: dayValues,
      defaultWidth: 'wide'
    }),
    dayPeriod: buildLocalizeFn({
      values: dayPeriodValues,
      defaultWidth: 'wide',
      formattingValues: formattingDayPeriodValues,
      defaultFormattingWidth: 'wide'
    })
  };

  function buildMatchPatternFn(args) {
    return function (dirtyString, dirtyOptions) {
      var string = String(dirtyString);
      var options = dirtyOptions || {};
      var matchResult = string.match(args.matchPattern);

      if (!matchResult) {
        return null;
      }

      var matchedString = matchResult[0];
      var parseResult = string.match(args.parsePattern);

      if (!parseResult) {
        return null;
      }

      var value = args.valueCallback ? args.valueCallback(parseResult[0]) : parseResult[0];
      value = options.valueCallback ? options.valueCallback(value) : value;
      return {
        value: value,
        rest: string.slice(matchedString.length)
      };
    };
  }

  function buildMatchFn(args) {
    return function (dirtyString, dirtyOptions) {
      var string = String(dirtyString);
      var options = dirtyOptions || {};
      var width = options.width;
      var matchPattern = width && args.matchPatterns[width] || args.matchPatterns[args.defaultMatchWidth];
      var matchResult = string.match(matchPattern);

      if (!matchResult) {
        return null;
      }

      var matchedString = matchResult[0];
      var parsePatterns = width && args.parsePatterns[width] || args.parsePatterns[args.defaultParseWidth];
      var value;

      if (Object.prototype.toString.call(parsePatterns) === '[object Array]') {
        value = findIndex$1(parsePatterns, function (pattern) {
          return pattern.test(string);
        });
      } else {
        value = findKey(parsePatterns, function (pattern) {
          return pattern.test(string);
        });
      }

      value = args.valueCallback ? args.valueCallback(value) : value;
      value = options.valueCallback ? options.valueCallback(value) : value;
      return {
        value: value,
        rest: string.slice(matchedString.length)
      };
    };
  }

  function findKey(object, predicate) {
    for (var key in object) {
      if (object.hasOwnProperty(key) && predicate(object[key])) {
        return key;
      }
    }
  }

  function findIndex$1(array, predicate) {
    for (var key = 0; key < array.length; key++) {
      if (predicate(array[key])) {
        return key;
      }
    }
  }

  var matchOrdinalNumberPattern = /^(\d+)(th|st|nd|rd)?/i;
  var parseOrdinalNumberPattern = /\d+/i;
  var matchEraPatterns = {
    narrow: /^(b|a)/i,
    abbreviated: /^(b\.?\s?c\.?|b\.?\s?c\.?\s?e\.?|a\.?\s?d\.?|c\.?\s?e\.?)/i,
    wide: /^(before christ|before common era|anno domini|common era)/i
  };
  var parseEraPatterns = {
    any: [/^b/i, /^(a|c)/i]
  };
  var matchQuarterPatterns = {
    narrow: /^[1234]/i,
    abbreviated: /^q[1234]/i,
    wide: /^[1234](th|st|nd|rd)? quarter/i
  };
  var parseQuarterPatterns = {
    any: [/1/i, /2/i, /3/i, /4/i]
  };
  var matchMonthPatterns = {
    narrow: /^[jfmasond]/i,
    abbreviated: /^(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/i,
    wide: /^(january|february|march|april|may|june|july|august|september|october|november|december)/i
  };
  var parseMonthPatterns = {
    narrow: [/^j/i, /^f/i, /^m/i, /^a/i, /^m/i, /^j/i, /^j/i, /^a/i, /^s/i, /^o/i, /^n/i, /^d/i],
    any: [/^ja/i, /^f/i, /^mar/i, /^ap/i, /^may/i, /^jun/i, /^jul/i, /^au/i, /^s/i, /^o/i, /^n/i, /^d/i]
  };
  var matchDayPatterns = {
    narrow: /^[smtwf]/i,
    short: /^(su|mo|tu|we|th|fr|sa)/i,
    abbreviated: /^(sun|mon|tue|wed|thu|fri|sat)/i,
    wide: /^(sunday|monday|tuesday|wednesday|thursday|friday|saturday)/i
  };
  var parseDayPatterns = {
    narrow: [/^s/i, /^m/i, /^t/i, /^w/i, /^t/i, /^f/i, /^s/i],
    any: [/^su/i, /^m/i, /^tu/i, /^w/i, /^th/i, /^f/i, /^sa/i]
  };
  var matchDayPeriodPatterns = {
    narrow: /^(a|p|mi|n|(in the|at) (morning|afternoon|evening|night))/i,
    any: /^([ap]\.?\s?m\.?|midnight|noon|(in the|at) (morning|afternoon|evening|night))/i
  };
  var parseDayPeriodPatterns = {
    any: {
      am: /^a/i,
      pm: /^p/i,
      midnight: /^mi/i,
      noon: /^no/i,
      morning: /morning/i,
      afternoon: /afternoon/i,
      evening: /evening/i,
      night: /night/i
    }
  };
  var match = {
    ordinalNumber: buildMatchPatternFn({
      matchPattern: matchOrdinalNumberPattern,
      parsePattern: parseOrdinalNumberPattern,
      valueCallback: function (value) {
        return parseInt(value, 10);
      }
    }),
    era: buildMatchFn({
      matchPatterns: matchEraPatterns,
      defaultMatchWidth: 'wide',
      parsePatterns: parseEraPatterns,
      defaultParseWidth: 'any'
    }),
    quarter: buildMatchFn({
      matchPatterns: matchQuarterPatterns,
      defaultMatchWidth: 'wide',
      parsePatterns: parseQuarterPatterns,
      defaultParseWidth: 'any',
      valueCallback: function (index) {
        return index + 1;
      }
    }),
    month: buildMatchFn({
      matchPatterns: matchMonthPatterns,
      defaultMatchWidth: 'wide',
      parsePatterns: parseMonthPatterns,
      defaultParseWidth: 'any'
    }),
    day: buildMatchFn({
      matchPatterns: matchDayPatterns,
      defaultMatchWidth: 'wide',
      parsePatterns: parseDayPatterns,
      defaultParseWidth: 'any'
    }),
    dayPeriod: buildMatchFn({
      matchPatterns: matchDayPeriodPatterns,
      defaultMatchWidth: 'any',
      parsePatterns: parseDayPeriodPatterns,
      defaultParseWidth: 'any'
    })
  };

  /**
   * @type {Locale}
   * @category Locales
   * @summary English locale (United States).
   * @language English
   * @iso-639-2 eng
   * @author Sasha Koss [@kossnocorp]{@link https://github.com/kossnocorp}
   * @author Lesha Koss [@leshakoss]{@link https://github.com/leshakoss}
   */

  var locale = {
    code: 'en-US',
    formatDistance: formatDistance,
    formatLong: formatLong,
    formatRelative: formatRelative,
    localize: localize,
    match: match,
    options: {
      weekStartsOn: 0
      /* Sunday */
      ,
      firstWeekContainsDate: 1
    }
  };

  function toInteger(dirtyNumber) {
    if (dirtyNumber === null || dirtyNumber === true || dirtyNumber === false) {
      return NaN;
    }

    var number = Number(dirtyNumber);

    if (isNaN(number)) {
      return number;
    }

    return number < 0 ? Math.ceil(number) : Math.floor(number);
  }

  function requiredArgs(required, args) {
    if (args.length < required) {
      throw new TypeError(required + ' argument' + required > 1 ? 's' : '' + ' required, but only ' + args.length + ' present');
    }
  }

  /**
   * @name toDate
   * @category Common Helpers
   * @summary Convert the given argument to an instance of Date.
   *
   * @description
   * Convert the given argument to an instance of Date.
   *
   * If the argument is an instance of Date, the function returns its clone.
   *
   * If the argument is a number, it is treated as a timestamp.
   *
   * If the argument is none of the above, the function returns Invalid Date.
   *
   * **Note**: *all* Date arguments passed to any *date-fns* function is processed by `toDate`.
   *
   * @param {Date|Number} argument - the value to convert
   * @returns {Date} the parsed date in the local time zone
   * @throws {TypeError} 1 argument required
   *
   * @example
   * // Clone the date:
   * const result = toDate(new Date(2014, 1, 11, 11, 30, 30))
   * //=> Tue Feb 11 2014 11:30:30
   *
   * @example
   * // Convert the timestamp to date:
   * const result = toDate(1392098430000)
   * //=> Tue Feb 11 2014 11:30:30
   */

  function toDate(argument) {
    requiredArgs(1, arguments);
    var argStr = Object.prototype.toString.call(argument); // Clone the date

    if (argument instanceof Date || typeof argument === 'object' && argStr === '[object Date]') {
      // Prevent the date to lose the milliseconds when passed to new Date() in IE10
      return new Date(argument.getTime());
    } else if (typeof argument === 'number' || argStr === '[object Number]') {
      return new Date(argument);
    } else {
      if ((typeof argument === 'string' || argStr === '[object String]') && typeof console !== 'undefined') {
        // eslint-disable-next-line no-console
        console.warn("Starting with v2.0.0-beta.1 date-fns doesn't accept strings as arguments. Please use `parseISO` to parse strings. See: https://git.io/fjule"); // eslint-disable-next-line no-console

        console.warn(new Error().stack);
      }

      return new Date(NaN);
    }
  }

  /**
   * @name addMilliseconds
   * @category Millisecond Helpers
   * @summary Add the specified number of milliseconds to the given date.
   *
   * @description
   * Add the specified number of milliseconds to the given date.
   *
   * ### v2.0.0 breaking changes:
   *
   * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
   *
   * @param {Date|Number} date - the date to be changed
   * @param {Number} amount - the amount of milliseconds to be added
   * @returns {Date} the new date with the milliseconds added
   * @throws {TypeError} 2 arguments required
   *
   * @example
   * // Add 750 milliseconds to 10 July 2014 12:45:30.000:
   * var result = addMilliseconds(new Date(2014, 6, 10, 12, 45, 30, 0), 750)
   * //=> Thu Jul 10 2014 12:45:30.750
   */

  function addMilliseconds(dirtyDate, dirtyAmount) {
    requiredArgs(2, arguments);
    var timestamp = toDate(dirtyDate).getTime();
    var amount = toInteger(dirtyAmount);
    return new Date(timestamp + amount);
  }

  /**
   * @name subMilliseconds
   * @category Millisecond Helpers
   * @summary Subtract the specified number of milliseconds from the given date.
   *
   * @description
   * Subtract the specified number of milliseconds from the given date.
   *
   * ### v2.0.0 breaking changes:
   *
   * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
   *
   * @param {Date|Number} date - the date to be changed
   * @param {Number} amount - the amount of milliseconds to be subtracted
   * @returns {Date} the new date with the milliseconds subtracted
   * @throws {TypeError} 2 arguments required
   *
   * @example
   * // Subtract 750 milliseconds from 10 July 2014 12:45:30.000:
   * var result = subMilliseconds(new Date(2014, 6, 10, 12, 45, 30, 0), 750)
   * //=> Thu Jul 10 2014 12:45:29.250
   */

  function subMilliseconds(dirtyDate, dirtyAmount) {
    requiredArgs(2, arguments);
    var amount = toInteger(dirtyAmount);
    return addMilliseconds(dirtyDate, -amount);
  }

  function assign(target, dirtyObject) {
    if (target == null) {
      throw new TypeError('assign requires that input parameter not be null or undefined');
    }

    dirtyObject = dirtyObject || {};

    for (var property in dirtyObject) {
      if (dirtyObject.hasOwnProperty(property)) {
        target[property] = dirtyObject[property];
      }
    }

    return target;
  }

  function dateLongFormatter(pattern, formatLong) {
    switch (pattern) {
      case 'P':
        return formatLong.date({
          width: 'short'
        });

      case 'PP':
        return formatLong.date({
          width: 'medium'
        });

      case 'PPP':
        return formatLong.date({
          width: 'long'
        });

      case 'PPPP':
      default:
        return formatLong.date({
          width: 'full'
        });
    }
  }

  function timeLongFormatter(pattern, formatLong) {
    switch (pattern) {
      case 'p':
        return formatLong.time({
          width: 'short'
        });

      case 'pp':
        return formatLong.time({
          width: 'medium'
        });

      case 'ppp':
        return formatLong.time({
          width: 'long'
        });

      case 'pppp':
      default:
        return formatLong.time({
          width: 'full'
        });
    }
  }

  function dateTimeLongFormatter(pattern, formatLong) {
    var matchResult = pattern.match(/(P+)(p+)?/);
    var datePattern = matchResult[1];
    var timePattern = matchResult[2];

    if (!timePattern) {
      return dateLongFormatter(pattern, formatLong);
    }

    var dateTimeFormat;

    switch (datePattern) {
      case 'P':
        dateTimeFormat = formatLong.dateTime({
          width: 'short'
        });
        break;

      case 'PP':
        dateTimeFormat = formatLong.dateTime({
          width: 'medium'
        });
        break;

      case 'PPP':
        dateTimeFormat = formatLong.dateTime({
          width: 'long'
        });
        break;

      case 'PPPP':
      default:
        dateTimeFormat = formatLong.dateTime({
          width: 'full'
        });
        break;
    }

    return dateTimeFormat.replace('{{date}}', dateLongFormatter(datePattern, formatLong)).replace('{{time}}', timeLongFormatter(timePattern, formatLong));
  }

  var longFormatters = {
    p: timeLongFormatter,
    P: dateTimeLongFormatter
  };

  var MILLISECONDS_IN_MINUTE = 60000;
  /**
   * Google Chrome as of 67.0.3396.87 introduced timezones with offset that includes seconds.
   * They usually appear for dates that denote time before the timezones were introduced
   * (e.g. for 'Europe/Prague' timezone the offset is GMT+00:57:44 before 1 October 1891
   * and GMT+01:00:00 after that date)
   *
   * Date#getTimezoneOffset returns the offset in minutes and would return 57 for the example above,
   * which would lead to incorrect calculations.
   *
   * This function returns the timezone offset in milliseconds that takes seconds in account.
   */

  function getTimezoneOffsetInMilliseconds(dirtyDate) {
    var date = new Date(dirtyDate.getTime());
    var baseTimezoneOffset = Math.ceil(date.getTimezoneOffset());
    date.setSeconds(0, 0);
    var millisecondsPartOfTimezoneOffset = date.getTime() % MILLISECONDS_IN_MINUTE;
    return baseTimezoneOffset * MILLISECONDS_IN_MINUTE + millisecondsPartOfTimezoneOffset;
  }

  var protectedDayOfYearTokens = ['D', 'DD'];
  var protectedWeekYearTokens = ['YY', 'YYYY'];
  function isProtectedDayOfYearToken(token) {
    return protectedDayOfYearTokens.indexOf(token) !== -1;
  }
  function isProtectedWeekYearToken(token) {
    return protectedWeekYearTokens.indexOf(token) !== -1;
  }
  function throwProtectedError(token) {
    if (token === 'YYYY') {
      throw new RangeError('Use `yyyy` instead of `YYYY` for formatting years; see: https://git.io/fxCyr');
    } else if (token === 'YY') {
      throw new RangeError('Use `yy` instead of `YY` for formatting years; see: https://git.io/fxCyr');
    } else if (token === 'D') {
      throw new RangeError('Use `d` instead of `D` for formatting days of the month; see: https://git.io/fxCyr');
    } else if (token === 'DD') {
      throw new RangeError('Use `dd` instead of `DD` for formatting days of the month; see: https://git.io/fxCyr');
    }
  }

  // See issue: https://github.com/date-fns/date-fns/issues/376

  function startOfUTCWeek(dirtyDate, dirtyOptions) {
    requiredArgs(1, arguments);
    var options = dirtyOptions || {};
    var locale = options.locale;
    var localeWeekStartsOn = locale && locale.options && locale.options.weekStartsOn;
    var defaultWeekStartsOn = localeWeekStartsOn == null ? 0 : toInteger(localeWeekStartsOn);
    var weekStartsOn = options.weekStartsOn == null ? defaultWeekStartsOn : toInteger(options.weekStartsOn); // Test if weekStartsOn is between 0 and 6 _and_ is not NaN

    if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
      throw new RangeError('weekStartsOn must be between 0 and 6 inclusively');
    }

    var date = toDate(dirtyDate);
    var day = date.getUTCDay();
    var diff = (day < weekStartsOn ? 7 : 0) + day - weekStartsOn;
    date.setUTCDate(date.getUTCDate() - diff);
    date.setUTCHours(0, 0, 0, 0);
    return date;
  }

  // See issue: https://github.com/date-fns/date-fns/issues/376

  function getUTCWeekYear(dirtyDate, dirtyOptions) {
    requiredArgs(1, arguments);
    var date = toDate(dirtyDate, dirtyOptions);
    var year = date.getUTCFullYear();
    var options = dirtyOptions || {};
    var locale = options.locale;
    var localeFirstWeekContainsDate = locale && locale.options && locale.options.firstWeekContainsDate;
    var defaultFirstWeekContainsDate = localeFirstWeekContainsDate == null ? 1 : toInteger(localeFirstWeekContainsDate);
    var firstWeekContainsDate = options.firstWeekContainsDate == null ? defaultFirstWeekContainsDate : toInteger(options.firstWeekContainsDate); // Test if weekStartsOn is between 1 and 7 _and_ is not NaN

    if (!(firstWeekContainsDate >= 1 && firstWeekContainsDate <= 7)) {
      throw new RangeError('firstWeekContainsDate must be between 1 and 7 inclusively');
    }

    var firstWeekOfNextYear = new Date(0);
    firstWeekOfNextYear.setUTCFullYear(year + 1, 0, firstWeekContainsDate);
    firstWeekOfNextYear.setUTCHours(0, 0, 0, 0);
    var startOfNextYear = startOfUTCWeek(firstWeekOfNextYear, dirtyOptions);
    var firstWeekOfThisYear = new Date(0);
    firstWeekOfThisYear.setUTCFullYear(year, 0, firstWeekContainsDate);
    firstWeekOfThisYear.setUTCHours(0, 0, 0, 0);
    var startOfThisYear = startOfUTCWeek(firstWeekOfThisYear, dirtyOptions);

    if (date.getTime() >= startOfNextYear.getTime()) {
      return year + 1;
    } else if (date.getTime() >= startOfThisYear.getTime()) {
      return year;
    } else {
      return year - 1;
    }
  }

  // See issue: https://github.com/date-fns/date-fns/issues/376

  function setUTCDay(dirtyDate, dirtyDay, dirtyOptions) {
    requiredArgs(2, arguments);
    var options = dirtyOptions || {};
    var locale = options.locale;
    var localeWeekStartsOn = locale && locale.options && locale.options.weekStartsOn;
    var defaultWeekStartsOn = localeWeekStartsOn == null ? 0 : toInteger(localeWeekStartsOn);
    var weekStartsOn = options.weekStartsOn == null ? defaultWeekStartsOn : toInteger(options.weekStartsOn); // Test if weekStartsOn is between 0 and 6 _and_ is not NaN

    if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
      throw new RangeError('weekStartsOn must be between 0 and 6 inclusively');
    }

    var date = toDate(dirtyDate);
    var day = toInteger(dirtyDay);
    var currentDay = date.getUTCDay();
    var remainder = day % 7;
    var dayIndex = (remainder + 7) % 7;
    var diff = (dayIndex < weekStartsOn ? 7 : 0) + day - currentDay;
    date.setUTCDate(date.getUTCDate() + diff);
    return date;
  }

  // See issue: https://github.com/date-fns/date-fns/issues/376

  function setUTCISODay(dirtyDate, dirtyDay) {
    requiredArgs(2, arguments);
    var day = toInteger(dirtyDay);

    if (day % 7 === 0) {
      day = day - 7;
    }

    var weekStartsOn = 1;
    var date = toDate(dirtyDate);
    var currentDay = date.getUTCDay();
    var remainder = day % 7;
    var dayIndex = (remainder + 7) % 7;
    var diff = (dayIndex < weekStartsOn ? 7 : 0) + day - currentDay;
    date.setUTCDate(date.getUTCDate() + diff);
    return date;
  }

  // See issue: https://github.com/date-fns/date-fns/issues/376

  function startOfUTCISOWeek(dirtyDate) {
    requiredArgs(1, arguments);
    var weekStartsOn = 1;
    var date = toDate(dirtyDate);
    var day = date.getUTCDay();
    var diff = (day < weekStartsOn ? 7 : 0) + day - weekStartsOn;
    date.setUTCDate(date.getUTCDate() - diff);
    date.setUTCHours(0, 0, 0, 0);
    return date;
  }

  // See issue: https://github.com/date-fns/date-fns/issues/376

  function getUTCISOWeekYear(dirtyDate) {
    requiredArgs(1, arguments);
    var date = toDate(dirtyDate);
    var year = date.getUTCFullYear();
    var fourthOfJanuaryOfNextYear = new Date(0);
    fourthOfJanuaryOfNextYear.setUTCFullYear(year + 1, 0, 4);
    fourthOfJanuaryOfNextYear.setUTCHours(0, 0, 0, 0);
    var startOfNextYear = startOfUTCISOWeek(fourthOfJanuaryOfNextYear);
    var fourthOfJanuaryOfThisYear = new Date(0);
    fourthOfJanuaryOfThisYear.setUTCFullYear(year, 0, 4);
    fourthOfJanuaryOfThisYear.setUTCHours(0, 0, 0, 0);
    var startOfThisYear = startOfUTCISOWeek(fourthOfJanuaryOfThisYear);

    if (date.getTime() >= startOfNextYear.getTime()) {
      return year + 1;
    } else if (date.getTime() >= startOfThisYear.getTime()) {
      return year;
    } else {
      return year - 1;
    }
  }

  // See issue: https://github.com/date-fns/date-fns/issues/376

  function startOfUTCISOWeekYear(dirtyDate) {
    requiredArgs(1, arguments);
    var year = getUTCISOWeekYear(dirtyDate);
    var fourthOfJanuary = new Date(0);
    fourthOfJanuary.setUTCFullYear(year, 0, 4);
    fourthOfJanuary.setUTCHours(0, 0, 0, 0);
    var date = startOfUTCISOWeek(fourthOfJanuary);
    return date;
  }

  var MILLISECONDS_IN_WEEK = 604800000; // This function will be a part of public API when UTC function will be implemented.
  // See issue: https://github.com/date-fns/date-fns/issues/376

  function getUTCISOWeek(dirtyDate) {
    requiredArgs(1, arguments);
    var date = toDate(dirtyDate);
    var diff = startOfUTCISOWeek(date).getTime() - startOfUTCISOWeekYear(date).getTime(); // Round the number of days to the nearest integer
    // because the number of milliseconds in a week is not constant
    // (e.g. it's different in the week of the daylight saving time clock shift)

    return Math.round(diff / MILLISECONDS_IN_WEEK) + 1;
  }

  // See issue: https://github.com/date-fns/date-fns/issues/376

  function setUTCISOWeek(dirtyDate, dirtyISOWeek) {
    requiredArgs(2, arguments);
    var date = toDate(dirtyDate);
    var isoWeek = toInteger(dirtyISOWeek);
    var diff = getUTCISOWeek(date) - isoWeek;
    date.setUTCDate(date.getUTCDate() - diff * 7);
    return date;
  }

  // See issue: https://github.com/date-fns/date-fns/issues/376

  function startOfUTCWeekYear(dirtyDate, dirtyOptions) {
    requiredArgs(1, arguments);
    var options = dirtyOptions || {};
    var locale = options.locale;
    var localeFirstWeekContainsDate = locale && locale.options && locale.options.firstWeekContainsDate;
    var defaultFirstWeekContainsDate = localeFirstWeekContainsDate == null ? 1 : toInteger(localeFirstWeekContainsDate);
    var firstWeekContainsDate = options.firstWeekContainsDate == null ? defaultFirstWeekContainsDate : toInteger(options.firstWeekContainsDate);
    var year = getUTCWeekYear(dirtyDate, dirtyOptions);
    var firstWeek = new Date(0);
    firstWeek.setUTCFullYear(year, 0, firstWeekContainsDate);
    firstWeek.setUTCHours(0, 0, 0, 0);
    var date = startOfUTCWeek(firstWeek, dirtyOptions);
    return date;
  }

  var MILLISECONDS_IN_WEEK$1 = 604800000; // This function will be a part of public API when UTC function will be implemented.
  // See issue: https://github.com/date-fns/date-fns/issues/376

  function getUTCWeek(dirtyDate, options) {
    requiredArgs(1, arguments);
    var date = toDate(dirtyDate);
    var diff = startOfUTCWeek(date, options).getTime() - startOfUTCWeekYear(date, options).getTime(); // Round the number of days to the nearest integer
    // because the number of milliseconds in a week is not constant
    // (e.g. it's different in the week of the daylight saving time clock shift)

    return Math.round(diff / MILLISECONDS_IN_WEEK$1) + 1;
  }

  // See issue: https://github.com/date-fns/date-fns/issues/376

  function setUTCWeek(dirtyDate, dirtyWeek, options) {
    requiredArgs(2, arguments);
    var date = toDate(dirtyDate);
    var week = toInteger(dirtyWeek);
    var diff = getUTCWeek(date, options) - week;
    date.setUTCDate(date.getUTCDate() - diff * 7);
    return date;
  }

  var MILLISECONDS_IN_HOUR = 3600000;
  var MILLISECONDS_IN_MINUTE$1 = 60000;
  var MILLISECONDS_IN_SECOND = 1000;
  var numericPatterns = {
    month: /^(1[0-2]|0?\d)/,
    // 0 to 12
    date: /^(3[0-1]|[0-2]?\d)/,
    // 0 to 31
    dayOfYear: /^(36[0-6]|3[0-5]\d|[0-2]?\d?\d)/,
    // 0 to 366
    week: /^(5[0-3]|[0-4]?\d)/,
    // 0 to 53
    hour23h: /^(2[0-3]|[0-1]?\d)/,
    // 0 to 23
    hour24h: /^(2[0-4]|[0-1]?\d)/,
    // 0 to 24
    hour11h: /^(1[0-1]|0?\d)/,
    // 0 to 11
    hour12h: /^(1[0-2]|0?\d)/,
    // 0 to 12
    minute: /^[0-5]?\d/,
    // 0 to 59
    second: /^[0-5]?\d/,
    // 0 to 59
    singleDigit: /^\d/,
    // 0 to 9
    twoDigits: /^\d{1,2}/,
    // 0 to 99
    threeDigits: /^\d{1,3}/,
    // 0 to 999
    fourDigits: /^\d{1,4}/,
    // 0 to 9999
    anyDigitsSigned: /^-?\d+/,
    singleDigitSigned: /^-?\d/,
    // 0 to 9, -0 to -9
    twoDigitsSigned: /^-?\d{1,2}/,
    // 0 to 99, -0 to -99
    threeDigitsSigned: /^-?\d{1,3}/,
    // 0 to 999, -0 to -999
    fourDigitsSigned: /^-?\d{1,4}/ // 0 to 9999, -0 to -9999

  };
  var timezonePatterns = {
    basicOptionalMinutes: /^([+-])(\d{2})(\d{2})?|Z/,
    basic: /^([+-])(\d{2})(\d{2})|Z/,
    basicOptionalSeconds: /^([+-])(\d{2})(\d{2})((\d{2}))?|Z/,
    extended: /^([+-])(\d{2}):(\d{2})|Z/,
    extendedOptionalSeconds: /^([+-])(\d{2}):(\d{2})(:(\d{2}))?|Z/
  };

  function parseNumericPattern(pattern, string, valueCallback) {
    var matchResult = string.match(pattern);

    if (!matchResult) {
      return null;
    }

    var value = parseInt(matchResult[0], 10);
    return {
      value: valueCallback ? valueCallback(value) : value,
      rest: string.slice(matchResult[0].length)
    };
  }

  function parseTimezonePattern(pattern, string) {
    var matchResult = string.match(pattern);

    if (!matchResult) {
      return null;
    } // Input is 'Z'


    if (matchResult[0] === 'Z') {
      return {
        value: 0,
        rest: string.slice(1)
      };
    }

    var sign = matchResult[1] === '+' ? 1 : -1;
    var hours = matchResult[2] ? parseInt(matchResult[2], 10) : 0;
    var minutes = matchResult[3] ? parseInt(matchResult[3], 10) : 0;
    var seconds = matchResult[5] ? parseInt(matchResult[5], 10) : 0;
    return {
      value: sign * (hours * MILLISECONDS_IN_HOUR + minutes * MILLISECONDS_IN_MINUTE$1 + seconds * MILLISECONDS_IN_SECOND),
      rest: string.slice(matchResult[0].length)
    };
  }

  function parseAnyDigitsSigned(string, valueCallback) {
    return parseNumericPattern(numericPatterns.anyDigitsSigned, string, valueCallback);
  }

  function parseNDigits(n, string, valueCallback) {
    switch (n) {
      case 1:
        return parseNumericPattern(numericPatterns.singleDigit, string, valueCallback);

      case 2:
        return parseNumericPattern(numericPatterns.twoDigits, string, valueCallback);

      case 3:
        return parseNumericPattern(numericPatterns.threeDigits, string, valueCallback);

      case 4:
        return parseNumericPattern(numericPatterns.fourDigits, string, valueCallback);

      default:
        return parseNumericPattern(new RegExp('^\\d{1,' + n + '}'), string, valueCallback);
    }
  }

  function parseNDigitsSigned(n, string, valueCallback) {
    switch (n) {
      case 1:
        return parseNumericPattern(numericPatterns.singleDigitSigned, string, valueCallback);

      case 2:
        return parseNumericPattern(numericPatterns.twoDigitsSigned, string, valueCallback);

      case 3:
        return parseNumericPattern(numericPatterns.threeDigitsSigned, string, valueCallback);

      case 4:
        return parseNumericPattern(numericPatterns.fourDigitsSigned, string, valueCallback);

      default:
        return parseNumericPattern(new RegExp('^-?\\d{1,' + n + '}'), string, valueCallback);
    }
  }

  function dayPeriodEnumToHours(enumValue) {
    switch (enumValue) {
      case 'morning':
        return 4;

      case 'evening':
        return 17;

      case 'pm':
      case 'noon':
      case 'afternoon':
        return 12;

      case 'am':
      case 'midnight':
      case 'night':
      default:
        return 0;
    }
  }

  function normalizeTwoDigitYear(twoDigitYear, currentYear) {
    var isCommonEra = currentYear > 0; // Absolute number of the current year:
    // 1 -> 1 AC
    // 0 -> 1 BC
    // -1 -> 2 BC

    var absCurrentYear = isCommonEra ? currentYear : 1 - currentYear;
    var result;

    if (absCurrentYear <= 50) {
      result = twoDigitYear || 100;
    } else {
      var rangeEnd = absCurrentYear + 50;
      var rangeEndCentury = Math.floor(rangeEnd / 100) * 100;
      var isPreviousCentury = twoDigitYear >= rangeEnd % 100;
      result = twoDigitYear + rangeEndCentury - (isPreviousCentury ? 100 : 0);
    }

    return isCommonEra ? result : 1 - result;
  }

  var DAYS_IN_MONTH = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
  var DAYS_IN_MONTH_LEAP_YEAR = [31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31]; // User for validation

  function isLeapYearIndex(year) {
    return year % 400 === 0 || year % 4 === 0 && year % 100 !== 0;
  }
  /*
   * |     | Unit                           |     | Unit                           |
   * |-----|--------------------------------|-----|--------------------------------|
   * |  a  | AM, PM                         |  A* | Milliseconds in day            |
   * |  b  | AM, PM, noon, midnight         |  B  | Flexible day period            |
   * |  c  | Stand-alone local day of week  |  C* | Localized hour w/ day period   |
   * |  d  | Day of month                   |  D  | Day of year                    |
   * |  e  | Local day of week              |  E  | Day of week                    |
   * |  f  |                                |  F* | Day of week in month           |
   * |  g* | Modified Julian day            |  G  | Era                            |
   * |  h  | Hour [1-12]                    |  H  | Hour [0-23]                    |
   * |  i! | ISO day of week                |  I! | ISO week of year               |
   * |  j* | Localized hour w/ day period   |  J* | Localized hour w/o day period  |
   * |  k  | Hour [1-24]                    |  K  | Hour [0-11]                    |
   * |  l* | (deprecated)                   |  L  | Stand-alone month              |
   * |  m  | Minute                         |  M  | Month                          |
   * |  n  |                                |  N  |                                |
   * |  o! | Ordinal number modifier        |  O* | Timezone (GMT)                 |
   * |  p  |                                |  P  |                                |
   * |  q  | Stand-alone quarter            |  Q  | Quarter                        |
   * |  r* | Related Gregorian year         |  R! | ISO week-numbering year        |
   * |  s  | Second                         |  S  | Fraction of second             |
   * |  t! | Seconds timestamp              |  T! | Milliseconds timestamp         |
   * |  u  | Extended year                  |  U* | Cyclic year                    |
   * |  v* | Timezone (generic non-locat.)  |  V* | Timezone (location)            |
   * |  w  | Local week of year             |  W* | Week of month                  |
   * |  x  | Timezone (ISO-8601 w/o Z)      |  X  | Timezone (ISO-8601)            |
   * |  y  | Year (abs)                     |  Y  | Local week-numbering year      |
   * |  z* | Timezone (specific non-locat.) |  Z* | Timezone (aliases)             |
   *
   * Letters marked by * are not implemented but reserved by Unicode standard.
   *
   * Letters marked by ! are non-standard, but implemented by date-fns:
   * - `o` modifies the previous token to turn it into an ordinal (see `parse` docs)
   * - `i` is ISO day of week. For `i` and `ii` is returns numeric ISO week days,
   *   i.e. 7 for Sunday, 1 for Monday, etc.
   * - `I` is ISO week of year, as opposed to `w` which is local week of year.
   * - `R` is ISO week-numbering year, as opposed to `Y` which is local week-numbering year.
   *   `R` is supposed to be used in conjunction with `I` and `i`
   *   for universal ISO week-numbering date, whereas
   *   `Y` is supposed to be used in conjunction with `w` and `e`
   *   for week-numbering date specific to the locale.
   */


  var parsers = {
    // Era
    G: {
      priority: 140,
      parse: function (string, token, match, _options) {
        switch (token) {
          // AD, BC
          case 'G':
          case 'GG':
          case 'GGG':
            return match.era(string, {
              width: 'abbreviated'
            }) || match.era(string, {
              width: 'narrow'
            });
          // A, B

          case 'GGGGG':
            return match.era(string, {
              width: 'narrow'
            });
          // Anno Domini, Before Christ

          case 'GGGG':
          default:
            return match.era(string, {
              width: 'wide'
            }) || match.era(string, {
              width: 'abbreviated'
            }) || match.era(string, {
              width: 'narrow'
            });
        }
      },
      set: function (date, flags, value, _options) {
        flags.era = value;
        date.setUTCFullYear(value, 0, 1);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ['R', 'u', 't', 'T']
    },
    // Year
    y: {
      // From http://www.unicode.org/reports/tr35/tr35-31/tr35-dates.html#Date_Format_Patterns
      // | Year     |     y | yy |   yyy |  yyyy | yyyyy |
      // |----------|-------|----|-------|-------|-------|
      // | AD 1     |     1 | 01 |   001 |  0001 | 00001 |
      // | AD 12    |    12 | 12 |   012 |  0012 | 00012 |
      // | AD 123   |   123 | 23 |   123 |  0123 | 00123 |
      // | AD 1234  |  1234 | 34 |  1234 |  1234 | 01234 |
      // | AD 12345 | 12345 | 45 | 12345 | 12345 | 12345 |
      priority: 130,
      parse: function (string, token, match, _options) {
        var valueCallback = function (year) {
          return {
            year: year,
            isTwoDigitYear: token === 'yy'
          };
        };

        switch (token) {
          case 'y':
            return parseNDigits(4, string, valueCallback);

          case 'yo':
            return match.ordinalNumber(string, {
              unit: 'year',
              valueCallback: valueCallback
            });

          default:
            return parseNDigits(token.length, string, valueCallback);
        }
      },
      validate: function (_date, value, _options) {
        return value.isTwoDigitYear || value.year > 0;
      },
      set: function (date, flags, value, _options) {
        var currentYear = date.getUTCFullYear();

        if (value.isTwoDigitYear) {
          var normalizedTwoDigitYear = normalizeTwoDigitYear(value.year, currentYear);
          date.setUTCFullYear(normalizedTwoDigitYear, 0, 1);
          date.setUTCHours(0, 0, 0, 0);
          return date;
        }

        var year = !('era' in flags) || flags.era === 1 ? value.year : 1 - value.year;
        date.setUTCFullYear(year, 0, 1);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ['Y', 'R', 'u', 'w', 'I', 'i', 'e', 'c', 't', 'T']
    },
    // Local week-numbering year
    Y: {
      priority: 130,
      parse: function (string, token, match, _options) {
        var valueCallback = function (year) {
          return {
            year: year,
            isTwoDigitYear: token === 'YY'
          };
        };

        switch (token) {
          case 'Y':
            return parseNDigits(4, string, valueCallback);

          case 'Yo':
            return match.ordinalNumber(string, {
              unit: 'year',
              valueCallback: valueCallback
            });

          default:
            return parseNDigits(token.length, string, valueCallback);
        }
      },
      validate: function (_date, value, _options) {
        return value.isTwoDigitYear || value.year > 0;
      },
      set: function (date, flags, value, options) {
        var currentYear = getUTCWeekYear(date, options);

        if (value.isTwoDigitYear) {
          var normalizedTwoDigitYear = normalizeTwoDigitYear(value.year, currentYear);
          date.setUTCFullYear(normalizedTwoDigitYear, 0, options.firstWeekContainsDate);
          date.setUTCHours(0, 0, 0, 0);
          return startOfUTCWeek(date, options);
        }

        var year = !('era' in flags) || flags.era === 1 ? value.year : 1 - value.year;
        date.setUTCFullYear(year, 0, options.firstWeekContainsDate);
        date.setUTCHours(0, 0, 0, 0);
        return startOfUTCWeek(date, options);
      },
      incompatibleTokens: ['y', 'R', 'u', 'Q', 'q', 'M', 'L', 'I', 'd', 'D', 'i', 't', 'T']
    },
    // ISO week-numbering year
    R: {
      priority: 130,
      parse: function (string, token, _match, _options) {
        if (token === 'R') {
          return parseNDigitsSigned(4, string);
        }

        return parseNDigitsSigned(token.length, string);
      },
      set: function (_date, _flags, value, _options) {
        var firstWeekOfYear = new Date(0);
        firstWeekOfYear.setUTCFullYear(value, 0, 4);
        firstWeekOfYear.setUTCHours(0, 0, 0, 0);
        return startOfUTCISOWeek(firstWeekOfYear);
      },
      incompatibleTokens: ['G', 'y', 'Y', 'u', 'Q', 'q', 'M', 'L', 'w', 'd', 'D', 'e', 'c', 't', 'T']
    },
    // Extended year
    u: {
      priority: 130,
      parse: function (string, token, _match, _options) {
        if (token === 'u') {
          return parseNDigitsSigned(4, string);
        }

        return parseNDigitsSigned(token.length, string);
      },
      set: function (date, _flags, value, _options) {
        date.setUTCFullYear(value, 0, 1);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ['G', 'y', 'Y', 'R', 'w', 'I', 'i', 'e', 'c', 't', 'T']
    },
    // Quarter
    Q: {
      priority: 120,
      parse: function (string, token, match, _options) {
        switch (token) {
          // 1, 2, 3, 4
          case 'Q':
          case 'QQ':
            // 01, 02, 03, 04
            return parseNDigits(token.length, string);
          // 1st, 2nd, 3rd, 4th

          case 'Qo':
            return match.ordinalNumber(string, {
              unit: 'quarter'
            });
          // Q1, Q2, Q3, Q4

          case 'QQQ':
            return match.quarter(string, {
              width: 'abbreviated',
              context: 'formatting'
            }) || match.quarter(string, {
              width: 'narrow',
              context: 'formatting'
            });
          // 1, 2, 3, 4 (narrow quarter; could be not numerical)

          case 'QQQQQ':
            return match.quarter(string, {
              width: 'narrow',
              context: 'formatting'
            });
          // 1st quarter, 2nd quarter, ...

          case 'QQQQ':
          default:
            return match.quarter(string, {
              width: 'wide',
              context: 'formatting'
            }) || match.quarter(string, {
              width: 'abbreviated',
              context: 'formatting'
            }) || match.quarter(string, {
              width: 'narrow',
              context: 'formatting'
            });
        }
      },
      validate: function (_date, value, _options) {
        return value >= 1 && value <= 4;
      },
      set: function (date, _flags, value, _options) {
        date.setUTCMonth((value - 1) * 3, 1);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ['Y', 'R', 'q', 'M', 'L', 'w', 'I', 'd', 'D', 'i', 'e', 'c', 't', 'T']
    },
    // Stand-alone quarter
    q: {
      priority: 120,
      parse: function (string, token, match, _options) {
        switch (token) {
          // 1, 2, 3, 4
          case 'q':
          case 'qq':
            // 01, 02, 03, 04
            return parseNDigits(token.length, string);
          // 1st, 2nd, 3rd, 4th

          case 'qo':
            return match.ordinalNumber(string, {
              unit: 'quarter'
            });
          // Q1, Q2, Q3, Q4

          case 'qqq':
            return match.quarter(string, {
              width: 'abbreviated',
              context: 'standalone'
            }) || match.quarter(string, {
              width: 'narrow',
              context: 'standalone'
            });
          // 1, 2, 3, 4 (narrow quarter; could be not numerical)

          case 'qqqqq':
            return match.quarter(string, {
              width: 'narrow',
              context: 'standalone'
            });
          // 1st quarter, 2nd quarter, ...

          case 'qqqq':
          default:
            return match.quarter(string, {
              width: 'wide',
              context: 'standalone'
            }) || match.quarter(string, {
              width: 'abbreviated',
              context: 'standalone'
            }) || match.quarter(string, {
              width: 'narrow',
              context: 'standalone'
            });
        }
      },
      validate: function (_date, value, _options) {
        return value >= 1 && value <= 4;
      },
      set: function (date, _flags, value, _options) {
        date.setUTCMonth((value - 1) * 3, 1);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ['Y', 'R', 'Q', 'M', 'L', 'w', 'I', 'd', 'D', 'i', 'e', 'c', 't', 'T']
    },
    // Month
    M: {
      priority: 110,
      parse: function (string, token, match, _options) {
        var valueCallback = function (value) {
          return value - 1;
        };

        switch (token) {
          // 1, 2, ..., 12
          case 'M':
            return parseNumericPattern(numericPatterns.month, string, valueCallback);
          // 01, 02, ..., 12

          case 'MM':
            return parseNDigits(2, string, valueCallback);
          // 1st, 2nd, ..., 12th

          case 'Mo':
            return match.ordinalNumber(string, {
              unit: 'month',
              valueCallback: valueCallback
            });
          // Jan, Feb, ..., Dec

          case 'MMM':
            return match.month(string, {
              width: 'abbreviated',
              context: 'formatting'
            }) || match.month(string, {
              width: 'narrow',
              context: 'formatting'
            });
          // J, F, ..., D

          case 'MMMMM':
            return match.month(string, {
              width: 'narrow',
              context: 'formatting'
            });
          // January, February, ..., December

          case 'MMMM':
          default:
            return match.month(string, {
              width: 'wide',
              context: 'formatting'
            }) || match.month(string, {
              width: 'abbreviated',
              context: 'formatting'
            }) || match.month(string, {
              width: 'narrow',
              context: 'formatting'
            });
        }
      },
      validate: function (_date, value, _options) {
        return value >= 0 && value <= 11;
      },
      set: function (date, _flags, value, _options) {
        date.setUTCMonth(value, 1);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ['Y', 'R', 'q', 'Q', 'L', 'w', 'I', 'D', 'i', 'e', 'c', 't', 'T']
    },
    // Stand-alone month
    L: {
      priority: 110,
      parse: function (string, token, match, _options) {
        var valueCallback = function (value) {
          return value - 1;
        };

        switch (token) {
          // 1, 2, ..., 12
          case 'L':
            return parseNumericPattern(numericPatterns.month, string, valueCallback);
          // 01, 02, ..., 12

          case 'LL':
            return parseNDigits(2, string, valueCallback);
          // 1st, 2nd, ..., 12th

          case 'Lo':
            return match.ordinalNumber(string, {
              unit: 'month',
              valueCallback: valueCallback
            });
          // Jan, Feb, ..., Dec

          case 'LLL':
            return match.month(string, {
              width: 'abbreviated',
              context: 'standalone'
            }) || match.month(string, {
              width: 'narrow',
              context: 'standalone'
            });
          // J, F, ..., D

          case 'LLLLL':
            return match.month(string, {
              width: 'narrow',
              context: 'standalone'
            });
          // January, February, ..., December

          case 'LLLL':
          default:
            return match.month(string, {
              width: 'wide',
              context: 'standalone'
            }) || match.month(string, {
              width: 'abbreviated',
              context: 'standalone'
            }) || match.month(string, {
              width: 'narrow',
              context: 'standalone'
            });
        }
      },
      validate: function (_date, value, _options) {
        return value >= 0 && value <= 11;
      },
      set: function (date, _flags, value, _options) {
        date.setUTCMonth(value, 1);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ['Y', 'R', 'q', 'Q', 'M', 'w', 'I', 'D', 'i', 'e', 'c', 't', 'T']
    },
    // Local week of year
    w: {
      priority: 100,
      parse: function (string, token, match, _options) {
        switch (token) {
          case 'w':
            return parseNumericPattern(numericPatterns.week, string);

          case 'wo':
            return match.ordinalNumber(string, {
              unit: 'week'
            });

          default:
            return parseNDigits(token.length, string);
        }
      },
      validate: function (_date, value, _options) {
        return value >= 1 && value <= 53;
      },
      set: function (date, _flags, value, options) {
        return startOfUTCWeek(setUTCWeek(date, value, options), options);
      },
      incompatibleTokens: ['y', 'R', 'u', 'q', 'Q', 'M', 'L', 'I', 'd', 'D', 'i', 't', 'T']
    },
    // ISO week of year
    I: {
      priority: 100,
      parse: function (string, token, match, _options) {
        switch (token) {
          case 'I':
            return parseNumericPattern(numericPatterns.week, string);

          case 'Io':
            return match.ordinalNumber(string, {
              unit: 'week'
            });

          default:
            return parseNDigits(token.length, string);
        }
      },
      validate: function (_date, value, _options) {
        return value >= 1 && value <= 53;
      },
      set: function (date, _flags, value, options) {
        return startOfUTCISOWeek(setUTCISOWeek(date, value, options), options);
      },
      incompatibleTokens: ['y', 'Y', 'u', 'q', 'Q', 'M', 'L', 'w', 'd', 'D', 'e', 'c', 't', 'T']
    },
    // Day of the month
    d: {
      priority: 90,
      parse: function (string, token, match, _options) {
        switch (token) {
          case 'd':
            return parseNumericPattern(numericPatterns.date, string);

          case 'do':
            return match.ordinalNumber(string, {
              unit: 'date'
            });

          default:
            return parseNDigits(token.length, string);
        }
      },
      validate: function (date, value, _options) {
        var year = date.getUTCFullYear();
        var isLeapYear = isLeapYearIndex(year);
        var month = date.getUTCMonth();

        if (isLeapYear) {
          return value >= 1 && value <= DAYS_IN_MONTH_LEAP_YEAR[month];
        } else {
          return value >= 1 && value <= DAYS_IN_MONTH[month];
        }
      },
      set: function (date, _flags, value, _options) {
        date.setUTCDate(value);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ['Y', 'R', 'q', 'Q', 'w', 'I', 'D', 'i', 'e', 'c', 't', 'T']
    },
    // Day of year
    D: {
      priority: 90,
      parse: function (string, token, match, _options) {
        switch (token) {
          case 'D':
          case 'DD':
            return parseNumericPattern(numericPatterns.dayOfYear, string);

          case 'Do':
            return match.ordinalNumber(string, {
              unit: 'date'
            });

          default:
            return parseNDigits(token.length, string);
        }
      },
      validate: function (date, value, _options) {
        var year = date.getUTCFullYear();
        var isLeapYear = isLeapYearIndex(year);

        if (isLeapYear) {
          return value >= 1 && value <= 366;
        } else {
          return value >= 1 && value <= 365;
        }
      },
      set: function (date, _flags, value, _options) {
        date.setUTCMonth(0, value);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ['Y', 'R', 'q', 'Q', 'M', 'L', 'w', 'I', 'd', 'E', 'i', 'e', 'c', 't', 'T']
    },
    // Day of week
    E: {
      priority: 90,
      parse: function (string, token, match, _options) {
        switch (token) {
          // Tue
          case 'E':
          case 'EE':
          case 'EEE':
            return match.day(string, {
              width: 'abbreviated',
              context: 'formatting'
            }) || match.day(string, {
              width: 'short',
              context: 'formatting'
            }) || match.day(string, {
              width: 'narrow',
              context: 'formatting'
            });
          // T

          case 'EEEEE':
            return match.day(string, {
              width: 'narrow',
              context: 'formatting'
            });
          // Tu

          case 'EEEEEE':
            return match.day(string, {
              width: 'short',
              context: 'formatting'
            }) || match.day(string, {
              width: 'narrow',
              context: 'formatting'
            });
          // Tuesday

          case 'EEEE':
          default:
            return match.day(string, {
              width: 'wide',
              context: 'formatting'
            }) || match.day(string, {
              width: 'abbreviated',
              context: 'formatting'
            }) || match.day(string, {
              width: 'short',
              context: 'formatting'
            }) || match.day(string, {
              width: 'narrow',
              context: 'formatting'
            });
        }
      },
      validate: function (_date, value, _options) {
        return value >= 0 && value <= 6;
      },
      set: function (date, _flags, value, options) {
        date = setUTCDay(date, value, options);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ['D', 'i', 'e', 'c', 't', 'T']
    },
    // Local day of week
    e: {
      priority: 90,
      parse: function (string, token, match, options) {
        var valueCallback = function (value) {
          var wholeWeekDays = Math.floor((value - 1) / 7) * 7;
          return (value + options.weekStartsOn + 6) % 7 + wholeWeekDays;
        };

        switch (token) {
          // 3
          case 'e':
          case 'ee':
            // 03
            return parseNDigits(token.length, string, valueCallback);
          // 3rd

          case 'eo':
            return match.ordinalNumber(string, {
              unit: 'day',
              valueCallback: valueCallback
            });
          // Tue

          case 'eee':
            return match.day(string, {
              width: 'abbreviated',
              context: 'formatting'
            }) || match.day(string, {
              width: 'short',
              context: 'formatting'
            }) || match.day(string, {
              width: 'narrow',
              context: 'formatting'
            });
          // T

          case 'eeeee':
            return match.day(string, {
              width: 'narrow',
              context: 'formatting'
            });
          // Tu

          case 'eeeeee':
            return match.day(string, {
              width: 'short',
              context: 'formatting'
            }) || match.day(string, {
              width: 'narrow',
              context: 'formatting'
            });
          // Tuesday

          case 'eeee':
          default:
            return match.day(string, {
              width: 'wide',
              context: 'formatting'
            }) || match.day(string, {
              width: 'abbreviated',
              context: 'formatting'
            }) || match.day(string, {
              width: 'short',
              context: 'formatting'
            }) || match.day(string, {
              width: 'narrow',
              context: 'formatting'
            });
        }
      },
      validate: function (_date, value, _options) {
        return value >= 0 && value <= 6;
      },
      set: function (date, _flags, value, options) {
        date = setUTCDay(date, value, options);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ['y', 'R', 'u', 'q', 'Q', 'M', 'L', 'I', 'd', 'D', 'E', 'i', 'c', 't', 'T']
    },
    // Stand-alone local day of week
    c: {
      priority: 90,
      parse: function (string, token, match, options) {
        var valueCallback = function (value) {
          var wholeWeekDays = Math.floor((value - 1) / 7) * 7;
          return (value + options.weekStartsOn + 6) % 7 + wholeWeekDays;
        };

        switch (token) {
          // 3
          case 'c':
          case 'cc':
            // 03
            return parseNDigits(token.length, string, valueCallback);
          // 3rd

          case 'co':
            return match.ordinalNumber(string, {
              unit: 'day',
              valueCallback: valueCallback
            });
          // Tue

          case 'ccc':
            return match.day(string, {
              width: 'abbreviated',
              context: 'standalone'
            }) || match.day(string, {
              width: 'short',
              context: 'standalone'
            }) || match.day(string, {
              width: 'narrow',
              context: 'standalone'
            });
          // T

          case 'ccccc':
            return match.day(string, {
              width: 'narrow',
              context: 'standalone'
            });
          // Tu

          case 'cccccc':
            return match.day(string, {
              width: 'short',
              context: 'standalone'
            }) || match.day(string, {
              width: 'narrow',
              context: 'standalone'
            });
          // Tuesday

          case 'cccc':
          default:
            return match.day(string, {
              width: 'wide',
              context: 'standalone'
            }) || match.day(string, {
              width: 'abbreviated',
              context: 'standalone'
            }) || match.day(string, {
              width: 'short',
              context: 'standalone'
            }) || match.day(string, {
              width: 'narrow',
              context: 'standalone'
            });
        }
      },
      validate: function (_date, value, _options) {
        return value >= 0 && value <= 6;
      },
      set: function (date, _flags, value, options) {
        date = setUTCDay(date, value, options);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ['y', 'R', 'u', 'q', 'Q', 'M', 'L', 'I', 'd', 'D', 'E', 'i', 'e', 't', 'T']
    },
    // ISO day of week
    i: {
      priority: 90,
      parse: function (string, token, match, _options) {
        var valueCallback = function (value) {
          if (value === 0) {
            return 7;
          }

          return value;
        };

        switch (token) {
          // 2
          case 'i':
          case 'ii':
            // 02
            return parseNDigits(token.length, string);
          // 2nd

          case 'io':
            return match.ordinalNumber(string, {
              unit: 'day'
            });
          // Tue

          case 'iii':
            return match.day(string, {
              width: 'abbreviated',
              context: 'formatting',
              valueCallback: valueCallback
            }) || match.day(string, {
              width: 'short',
              context: 'formatting',
              valueCallback: valueCallback
            }) || match.day(string, {
              width: 'narrow',
              context: 'formatting',
              valueCallback: valueCallback
            });
          // T

          case 'iiiii':
            return match.day(string, {
              width: 'narrow',
              context: 'formatting',
              valueCallback: valueCallback
            });
          // Tu

          case 'iiiiii':
            return match.day(string, {
              width: 'short',
              context: 'formatting',
              valueCallback: valueCallback
            }) || match.day(string, {
              width: 'narrow',
              context: 'formatting',
              valueCallback: valueCallback
            });
          // Tuesday

          case 'iiii':
          default:
            return match.day(string, {
              width: 'wide',
              context: 'formatting',
              valueCallback: valueCallback
            }) || match.day(string, {
              width: 'abbreviated',
              context: 'formatting',
              valueCallback: valueCallback
            }) || match.day(string, {
              width: 'short',
              context: 'formatting',
              valueCallback: valueCallback
            }) || match.day(string, {
              width: 'narrow',
              context: 'formatting',
              valueCallback: valueCallback
            });
        }
      },
      validate: function (_date, value, _options) {
        return value >= 1 && value <= 7;
      },
      set: function (date, _flags, value, options) {
        date = setUTCISODay(date, value, options);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ['y', 'Y', 'u', 'q', 'Q', 'M', 'L', 'w', 'd', 'D', 'E', 'e', 'c', 't', 'T']
    },
    // AM or PM
    a: {
      priority: 80,
      parse: function (string, token, match, _options) {
        switch (token) {
          case 'a':
          case 'aa':
          case 'aaa':
            return match.dayPeriod(string, {
              width: 'abbreviated',
              context: 'formatting'
            }) || match.dayPeriod(string, {
              width: 'narrow',
              context: 'formatting'
            });

          case 'aaaaa':
            return match.dayPeriod(string, {
              width: 'narrow',
              context: 'formatting'
            });

          case 'aaaa':
          default:
            return match.dayPeriod(string, {
              width: 'wide',
              context: 'formatting'
            }) || match.dayPeriod(string, {
              width: 'abbreviated',
              context: 'formatting'
            }) || match.dayPeriod(string, {
              width: 'narrow',
              context: 'formatting'
            });
        }
      },
      set: function (date, _flags, value, _options) {
        date.setUTCHours(dayPeriodEnumToHours(value), 0, 0, 0);
        return date;
      },
      incompatibleTokens: ['b', 'B', 'H', 'K', 'k', 't', 'T']
    },
    // AM, PM, midnight
    b: {
      priority: 80,
      parse: function (string, token, match, _options) {
        switch (token) {
          case 'b':
          case 'bb':
          case 'bbb':
            return match.dayPeriod(string, {
              width: 'abbreviated',
              context: 'formatting'
            }) || match.dayPeriod(string, {
              width: 'narrow',
              context: 'formatting'
            });

          case 'bbbbb':
            return match.dayPeriod(string, {
              width: 'narrow',
              context: 'formatting'
            });

          case 'bbbb':
          default:
            return match.dayPeriod(string, {
              width: 'wide',
              context: 'formatting'
            }) || match.dayPeriod(string, {
              width: 'abbreviated',
              context: 'formatting'
            }) || match.dayPeriod(string, {
              width: 'narrow',
              context: 'formatting'
            });
        }
      },
      set: function (date, _flags, value, _options) {
        date.setUTCHours(dayPeriodEnumToHours(value), 0, 0, 0);
        return date;
      },
      incompatibleTokens: ['a', 'B', 'H', 'K', 'k', 't', 'T']
    },
    // in the morning, in the afternoon, in the evening, at night
    B: {
      priority: 80,
      parse: function (string, token, match, _options) {
        switch (token) {
          case 'B':
          case 'BB':
          case 'BBB':
            return match.dayPeriod(string, {
              width: 'abbreviated',
              context: 'formatting'
            }) || match.dayPeriod(string, {
              width: 'narrow',
              context: 'formatting'
            });

          case 'BBBBB':
            return match.dayPeriod(string, {
              width: 'narrow',
              context: 'formatting'
            });

          case 'BBBB':
          default:
            return match.dayPeriod(string, {
              width: 'wide',
              context: 'formatting'
            }) || match.dayPeriod(string, {
              width: 'abbreviated',
              context: 'formatting'
            }) || match.dayPeriod(string, {
              width: 'narrow',
              context: 'formatting'
            });
        }
      },
      set: function (date, _flags, value, _options) {
        date.setUTCHours(dayPeriodEnumToHours(value), 0, 0, 0);
        return date;
      },
      incompatibleTokens: ['a', 'b', 't', 'T']
    },
    // Hour [1-12]
    h: {
      priority: 70,
      parse: function (string, token, match, _options) {
        switch (token) {
          case 'h':
            return parseNumericPattern(numericPatterns.hour12h, string);

          case 'ho':
            return match.ordinalNumber(string, {
              unit: 'hour'
            });

          default:
            return parseNDigits(token.length, string);
        }
      },
      validate: function (_date, value, _options) {
        return value >= 1 && value <= 12;
      },
      set: function (date, _flags, value, _options) {
        var isPM = date.getUTCHours() >= 12;

        if (isPM && value < 12) {
          date.setUTCHours(value + 12, 0, 0, 0);
        } else if (!isPM && value === 12) {
          date.setUTCHours(0, 0, 0, 0);
        } else {
          date.setUTCHours(value, 0, 0, 0);
        }

        return date;
      },
      incompatibleTokens: ['H', 'K', 'k', 't', 'T']
    },
    // Hour [0-23]
    H: {
      priority: 70,
      parse: function (string, token, match, _options) {
        switch (token) {
          case 'H':
            return parseNumericPattern(numericPatterns.hour23h, string);

          case 'Ho':
            return match.ordinalNumber(string, {
              unit: 'hour'
            });

          default:
            return parseNDigits(token.length, string);
        }
      },
      validate: function (_date, value, _options) {
        return value >= 0 && value <= 23;
      },
      set: function (date, _flags, value, _options) {
        date.setUTCHours(value, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ['a', 'b', 'h', 'K', 'k', 't', 'T']
    },
    // Hour [0-11]
    K: {
      priority: 70,
      parse: function (string, token, match, _options) {
        switch (token) {
          case 'K':
            return parseNumericPattern(numericPatterns.hour11h, string);

          case 'Ko':
            return match.ordinalNumber(string, {
              unit: 'hour'
            });

          default:
            return parseNDigits(token.length, string);
        }
      },
      validate: function (_date, value, _options) {
        return value >= 0 && value <= 11;
      },
      set: function (date, _flags, value, _options) {
        var isPM = date.getUTCHours() >= 12;

        if (isPM && value < 12) {
          date.setUTCHours(value + 12, 0, 0, 0);
        } else {
          date.setUTCHours(value, 0, 0, 0);
        }

        return date;
      },
      incompatibleTokens: ['a', 'b', 'h', 'H', 'k', 't', 'T']
    },
    // Hour [1-24]
    k: {
      priority: 70,
      parse: function (string, token, match, _options) {
        switch (token) {
          case 'k':
            return parseNumericPattern(numericPatterns.hour24h, string);

          case 'ko':
            return match.ordinalNumber(string, {
              unit: 'hour'
            });

          default:
            return parseNDigits(token.length, string);
        }
      },
      validate: function (_date, value, _options) {
        return value >= 1 && value <= 24;
      },
      set: function (date, _flags, value, _options) {
        var hours = value <= 24 ? value % 24 : value;
        date.setUTCHours(hours, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ['a', 'b', 'h', 'H', 'K', 't', 'T']
    },
    // Minute
    m: {
      priority: 60,
      parse: function (string, token, match, _options) {
        switch (token) {
          case 'm':
            return parseNumericPattern(numericPatterns.minute, string);

          case 'mo':
            return match.ordinalNumber(string, {
              unit: 'minute'
            });

          default:
            return parseNDigits(token.length, string);
        }
      },
      validate: function (_date, value, _options) {
        return value >= 0 && value <= 59;
      },
      set: function (date, _flags, value, _options) {
        date.setUTCMinutes(value, 0, 0);
        return date;
      },
      incompatibleTokens: ['t', 'T']
    },
    // Second
    s: {
      priority: 50,
      parse: function (string, token, match, _options) {
        switch (token) {
          case 's':
            return parseNumericPattern(numericPatterns.second, string);

          case 'so':
            return match.ordinalNumber(string, {
              unit: 'second'
            });

          default:
            return parseNDigits(token.length, string);
        }
      },
      validate: function (_date, value, _options) {
        return value >= 0 && value <= 59;
      },
      set: function (date, _flags, value, _options) {
        date.setUTCSeconds(value, 0);
        return date;
      },
      incompatibleTokens: ['t', 'T']
    },
    // Fraction of second
    S: {
      priority: 30,
      parse: function (string, token, _match, _options) {
        var valueCallback = function (value) {
          return Math.floor(value * Math.pow(10, -token.length + 3));
        };

        return parseNDigits(token.length, string, valueCallback);
      },
      set: function (date, _flags, value, _options) {
        date.setUTCMilliseconds(value);
        return date;
      },
      incompatibleTokens: ['t', 'T']
    },
    // Timezone (ISO-8601. +00:00 is `'Z'`)
    X: {
      priority: 10,
      parse: function (string, token, _match, _options) {
        switch (token) {
          case 'X':
            return parseTimezonePattern(timezonePatterns.basicOptionalMinutes, string);

          case 'XX':
            return parseTimezonePattern(timezonePatterns.basic, string);

          case 'XXXX':
            return parseTimezonePattern(timezonePatterns.basicOptionalSeconds, string);

          case 'XXXXX':
            return parseTimezonePattern(timezonePatterns.extendedOptionalSeconds, string);

          case 'XXX':
          default:
            return parseTimezonePattern(timezonePatterns.extended, string);
        }
      },
      set: function (date, flags, value, _options) {
        if (flags.timestampIsSet) {
          return date;
        }

        return new Date(date.getTime() - value);
      },
      incompatibleTokens: ['t', 'T', 'x']
    },
    // Timezone (ISO-8601)
    x: {
      priority: 10,
      parse: function (string, token, _match, _options) {
        switch (token) {
          case 'x':
            return parseTimezonePattern(timezonePatterns.basicOptionalMinutes, string);

          case 'xx':
            return parseTimezonePattern(timezonePatterns.basic, string);

          case 'xxxx':
            return parseTimezonePattern(timezonePatterns.basicOptionalSeconds, string);

          case 'xxxxx':
            return parseTimezonePattern(timezonePatterns.extendedOptionalSeconds, string);

          case 'xxx':
          default:
            return parseTimezonePattern(timezonePatterns.extended, string);
        }
      },
      set: function (date, flags, value, _options) {
        if (flags.timestampIsSet) {
          return date;
        }

        return new Date(date.getTime() - value);
      },
      incompatibleTokens: ['t', 'T', 'X']
    },
    // Seconds timestamp
    t: {
      priority: 40,
      parse: function (string, _token, _match, _options) {
        return parseAnyDigitsSigned(string);
      },
      set: function (_date, _flags, value, _options) {
        return [new Date(value * 1000), {
          timestampIsSet: true
        }];
      },
      incompatibleTokens: '*'
    },
    // Milliseconds timestamp
    T: {
      priority: 20,
      parse: function (string, _token, _match, _options) {
        return parseAnyDigitsSigned(string);
      },
      set: function (_date, _flags, value, _options) {
        return [new Date(value), {
          timestampIsSet: true
        }];
      },
      incompatibleTokens: '*'
    }
  };

  var TIMEZONE_UNIT_PRIORITY = 10; // This RegExp consists of three parts separated by `|`:
  // - [yYQqMLwIdDecihHKkms]o matches any available ordinal number token
  //   (one of the certain letters followed by `o`)
  // - (\w)\1* matches any sequences of the same letter
  // - '' matches two quote characters in a row
  // - '(''|[^'])+('|$) matches anything surrounded by two quote characters ('),
  //   except a single quote symbol, which ends the sequence.
  //   Two quote characters do not end the sequence.
  //   If there is no matching single quote
  //   then the sequence will continue until the end of the string.
  // - . matches any single character unmatched by previous parts of the RegExps

  var formattingTokensRegExp = /[yYQqMLwIdDecihHKkms]o|(\w)\1*|''|'(''|[^'])+('|$)|./g; // This RegExp catches symbols escaped by quotes, and also
  // sequences of symbols P, p, and the combinations like `PPPPPPPppppp`

  var longFormattingTokensRegExp = /P+p+|P+|p+|''|'(''|[^'])+('|$)|./g;
  var escapedStringRegExp = /^'([^]*?)'?$/;
  var doubleQuoteRegExp = /''/g;
  var notWhitespaceRegExp = /\S/;
  var unescapedLatinCharacterRegExp = /[a-zA-Z]/;
  /**
   * @name parse
   * @category Common Helpers
   * @summary Parse the date.
   *
   * @description
   * Return the date parsed from string using the given format string.
   *
   * > ⚠️ Please note that the `format` tokens differ from Moment.js and other libraries.
   * > See: https://git.io/fxCyr
   *
   * The characters in the format string wrapped between two single quotes characters (') are escaped.
   * Two single quotes in a row, whether inside or outside a quoted sequence, represent a 'real' single quote.
   *
   * Format of the format string is based on Unicode Technical Standard #35:
   * https://www.unicode.org/reports/tr35/tr35-dates.html#Date_Field_Symbol_Table
   * with a few additions (see note 5 below the table).
   *
   * Not all tokens are compatible. Combinations that don't make sense or could lead to bugs are prohibited
   * and will throw `RangeError`. For example usage of 24-hour format token with AM/PM token will throw an exception:
   *
   * ```javascript
   * parse('23 AM', 'HH a', new Date())
   * //=> RangeError: The format string mustn't contain `HH` and `a` at the same time
   * ```
   *
   * See the compatibility table: https://docs.google.com/spreadsheets/d/e/2PACX-1vQOPU3xUhplll6dyoMmVUXHKl_8CRDs6_ueLmex3SoqwhuolkuN3O05l4rqx5h1dKX8eb46Ul-CCSrq/pubhtml?gid=0&single=true
   *
   * Accepted format string patterns:
   * | Unit                            |Prior| Pattern | Result examples                   | Notes |
   * |---------------------------------|-----|---------|-----------------------------------|-------|
   * | Era                             | 140 | G..GGG  | AD, BC                            |       |
   * |                                 |     | GGGG    | Anno Domini, Before Christ        | 2     |
   * |                                 |     | GGGGG   | A, B                              |       |
   * | Calendar year                   | 130 | y       | 44, 1, 1900, 2017, 9999           | 4     |
   * |                                 |     | yo      | 44th, 1st, 1900th, 9999999th      | 4,5   |
   * |                                 |     | yy      | 44, 01, 00, 17                    | 4     |
   * |                                 |     | yyy     | 044, 001, 123, 999                | 4     |
   * |                                 |     | yyyy    | 0044, 0001, 1900, 2017            | 4     |
   * |                                 |     | yyyyy   | ...                               | 2,4   |
   * | Local week-numbering year       | 130 | Y       | 44, 1, 1900, 2017, 9000           | 4     |
   * |                                 |     | Yo      | 44th, 1st, 1900th, 9999999th      | 4,5   |
   * |                                 |     | YY      | 44, 01, 00, 17                    | 4,6   |
   * |                                 |     | YYY     | 044, 001, 123, 999                | 4     |
   * |                                 |     | YYYY    | 0044, 0001, 1900, 2017            | 4,6   |
   * |                                 |     | YYYYY   | ...                               | 2,4   |
   * | ISO week-numbering year         | 130 | R       | -43, 1, 1900, 2017, 9999, -9999   | 4,5   |
   * |                                 |     | RR      | -43, 01, 00, 17                   | 4,5   |
   * |                                 |     | RRR     | -043, 001, 123, 999, -999         | 4,5   |
   * |                                 |     | RRRR    | -0043, 0001, 2017, 9999, -9999    | 4,5   |
   * |                                 |     | RRRRR   | ...                               | 2,4,5 |
   * | Extended year                   | 130 | u       | -43, 1, 1900, 2017, 9999, -999    | 4     |
   * |                                 |     | uu      | -43, 01, 99, -99                  | 4     |
   * |                                 |     | uuu     | -043, 001, 123, 999, -999         | 4     |
   * |                                 |     | uuuu    | -0043, 0001, 2017, 9999, -9999    | 4     |
   * |                                 |     | uuuuu   | ...                               | 2,4   |
   * | Quarter (formatting)            | 120 | Q       | 1, 2, 3, 4                        |       |
   * |                                 |     | Qo      | 1st, 2nd, 3rd, 4th                | 5     |
   * |                                 |     | QQ      | 01, 02, 03, 04                    |       |
   * |                                 |     | QQQ     | Q1, Q2, Q3, Q4                    |       |
   * |                                 |     | QQQQ    | 1st quarter, 2nd quarter, ...     | 2     |
   * |                                 |     | QQQQQ   | 1, 2, 3, 4                        | 4     |
   * | Quarter (stand-alone)           | 120 | q       | 1, 2, 3, 4                        |       |
   * |                                 |     | qo      | 1st, 2nd, 3rd, 4th                | 5     |
   * |                                 |     | qq      | 01, 02, 03, 04                    |       |
   * |                                 |     | qqq     | Q1, Q2, Q3, Q4                    |       |
   * |                                 |     | qqqq    | 1st quarter, 2nd quarter, ...     | 2     |
   * |                                 |     | qqqqq   | 1, 2, 3, 4                        | 3     |
   * | Month (formatting)              | 110 | M       | 1, 2, ..., 12                     |       |
   * |                                 |     | Mo      | 1st, 2nd, ..., 12th               | 5     |
   * |                                 |     | MM      | 01, 02, ..., 12                   |       |
   * |                                 |     | MMM     | Jan, Feb, ..., Dec                |       |
   * |                                 |     | MMMM    | January, February, ..., December  | 2     |
   * |                                 |     | MMMMM   | J, F, ..., D                      |       |
   * | Month (stand-alone)             | 110 | L       | 1, 2, ..., 12                     |       |
   * |                                 |     | Lo      | 1st, 2nd, ..., 12th               | 5     |
   * |                                 |     | LL      | 01, 02, ..., 12                   |       |
   * |                                 |     | LLL     | Jan, Feb, ..., Dec                |       |
   * |                                 |     | LLLL    | January, February, ..., December  | 2     |
   * |                                 |     | LLLLL   | J, F, ..., D                      |       |
   * | Local week of year              | 100 | w       | 1, 2, ..., 53                     |       |
   * |                                 |     | wo      | 1st, 2nd, ..., 53th               | 5     |
   * |                                 |     | ww      | 01, 02, ..., 53                   |       |
   * | ISO week of year                | 100 | I       | 1, 2, ..., 53                     | 5     |
   * |                                 |     | Io      | 1st, 2nd, ..., 53th               | 5     |
   * |                                 |     | II      | 01, 02, ..., 53                   | 5     |
   * | Day of month                    |  90 | d       | 1, 2, ..., 31                     |       |
   * |                                 |     | do      | 1st, 2nd, ..., 31st               | 5     |
   * |                                 |     | dd      | 01, 02, ..., 31                   |       |
   * | Day of year                     |  90 | D       | 1, 2, ..., 365, 366               | 7     |
   * |                                 |     | Do      | 1st, 2nd, ..., 365th, 366th       | 5     |
   * |                                 |     | DD      | 01, 02, ..., 365, 366             | 7     |
   * |                                 |     | DDD     | 001, 002, ..., 365, 366           |       |
   * |                                 |     | DDDD    | ...                               | 2     |
   * | Day of week (formatting)        |  90 | E..EEE  | Mon, Tue, Wed, ..., Su            |       |
   * |                                 |     | EEEE    | Monday, Tuesday, ..., Sunday      | 2     |
   * |                                 |     | EEEEE   | M, T, W, T, F, S, S               |       |
   * |                                 |     | EEEEEE  | Mo, Tu, We, Th, Fr, Su, Sa        |       |
   * | ISO day of week (formatting)    |  90 | i       | 1, 2, 3, ..., 7                   | 5     |
   * |                                 |     | io      | 1st, 2nd, ..., 7th                | 5     |
   * |                                 |     | ii      | 01, 02, ..., 07                   | 5     |
   * |                                 |     | iii     | Mon, Tue, Wed, ..., Su            | 5     |
   * |                                 |     | iiii    | Monday, Tuesday, ..., Sunday      | 2,5   |
   * |                                 |     | iiiii   | M, T, W, T, F, S, S               | 5     |
   * |                                 |     | iiiiii  | Mo, Tu, We, Th, Fr, Su, Sa        | 5     |
   * | Local day of week (formatting)  |  90 | e       | 2, 3, 4, ..., 1                   |       |
   * |                                 |     | eo      | 2nd, 3rd, ..., 1st                | 5     |
   * |                                 |     | ee      | 02, 03, ..., 01                   |       |
   * |                                 |     | eee     | Mon, Tue, Wed, ..., Su            |       |
   * |                                 |     | eeee    | Monday, Tuesday, ..., Sunday      | 2     |
   * |                                 |     | eeeee   | M, T, W, T, F, S, S               |       |
   * |                                 |     | eeeeee  | Mo, Tu, We, Th, Fr, Su, Sa        |       |
   * | Local day of week (stand-alone) |  90 | c       | 2, 3, 4, ..., 1                   |       |
   * |                                 |     | co      | 2nd, 3rd, ..., 1st                | 5     |
   * |                                 |     | cc      | 02, 03, ..., 01                   |       |
   * |                                 |     | ccc     | Mon, Tue, Wed, ..., Su            |       |
   * |                                 |     | cccc    | Monday, Tuesday, ..., Sunday      | 2     |
   * |                                 |     | ccccc   | M, T, W, T, F, S, S               |       |
   * |                                 |     | cccccc  | Mo, Tu, We, Th, Fr, Su, Sa        |       |
   * | AM, PM                          |  80 | a..aaa  | AM, PM                            |       |
   * |                                 |     | aaaa    | a.m., p.m.                        | 2     |
   * |                                 |     | aaaaa   | a, p                              |       |
   * | AM, PM, noon, midnight          |  80 | b..bbb  | AM, PM, noon, midnight            |       |
   * |                                 |     | bbbb    | a.m., p.m., noon, midnight        | 2     |
   * |                                 |     | bbbbb   | a, p, n, mi                       |       |
   * | Flexible day period             |  80 | B..BBB  | at night, in the morning, ...     |       |
   * |                                 |     | BBBB    | at night, in the morning, ...     | 2     |
   * |                                 |     | BBBBB   | at night, in the morning, ...     |       |
   * | Hour [1-12]                     |  70 | h       | 1, 2, ..., 11, 12                 |       |
   * |                                 |     | ho      | 1st, 2nd, ..., 11th, 12th         | 5     |
   * |                                 |     | hh      | 01, 02, ..., 11, 12               |       |
   * | Hour [0-23]                     |  70 | H       | 0, 1, 2, ..., 23                  |       |
   * |                                 |     | Ho      | 0th, 1st, 2nd, ..., 23rd          | 5     |
   * |                                 |     | HH      | 00, 01, 02, ..., 23               |       |
   * | Hour [0-11]                     |  70 | K       | 1, 2, ..., 11, 0                  |       |
   * |                                 |     | Ko      | 1st, 2nd, ..., 11th, 0th          | 5     |
   * |                                 |     | KK      | 1, 2, ..., 11, 0                  |       |
   * | Hour [1-24]                     |  70 | k       | 24, 1, 2, ..., 23                 |       |
   * |                                 |     | ko      | 24th, 1st, 2nd, ..., 23rd         | 5     |
   * |                                 |     | kk      | 24, 01, 02, ..., 23               |       |
   * | Minute                          |  60 | m       | 0, 1, ..., 59                     |       |
   * |                                 |     | mo      | 0th, 1st, ..., 59th               | 5     |
   * |                                 |     | mm      | 00, 01, ..., 59                   |       |
   * | Second                          |  50 | s       | 0, 1, ..., 59                     |       |
   * |                                 |     | so      | 0th, 1st, ..., 59th               | 5     |
   * |                                 |     | ss      | 00, 01, ..., 59                   |       |
   * | Seconds timestamp               |  40 | t       | 512969520                         |       |
   * |                                 |     | tt      | ...                               | 2     |
   * | Fraction of second              |  30 | S       | 0, 1, ..., 9                      |       |
   * |                                 |     | SS      | 00, 01, ..., 99                   |       |
   * |                                 |     | SSS     | 000, 0001, ..., 999               |       |
   * |                                 |     | SSSS    | ...                               | 2     |
   * | Milliseconds timestamp          |  20 | T       | 512969520900                      |       |
   * |                                 |     | TT      | ...                               | 2     |
   * | Timezone (ISO-8601 w/ Z)        |  10 | X       | -08, +0530, Z                     |       |
   * |                                 |     | XX      | -0800, +0530, Z                   |       |
   * |                                 |     | XXX     | -08:00, +05:30, Z                 |       |
   * |                                 |     | XXXX    | -0800, +0530, Z, +123456          | 2     |
   * |                                 |     | XXXXX   | -08:00, +05:30, Z, +12:34:56      |       |
   * | Timezone (ISO-8601 w/o Z)       |  10 | x       | -08, +0530, +00                   |       |
   * |                                 |     | xx      | -0800, +0530, +0000               |       |
   * |                                 |     | xxx     | -08:00, +05:30, +00:00            | 2     |
   * |                                 |     | xxxx    | -0800, +0530, +0000, +123456      |       |
   * |                                 |     | xxxxx   | -08:00, +05:30, +00:00, +12:34:56 |       |
   * | Long localized date             |  NA | P       | 05/29/1453                        | 5,8   |
   * |                                 |     | PP      | May 29, 1453                      |       |
   * |                                 |     | PPP     | May 29th, 1453                    |       |
   * |                                 |     | PPPP    | Sunday, May 29th, 1453            | 2,5,8 |
   * | Long localized time             |  NA | p       | 12:00 AM                          | 5,8   |
   * |                                 |     | pp      | 12:00:00 AM                       |       |
   * | Combination of date and time    |  NA | Pp      | 05/29/1453, 12:00 AM              |       |
   * |                                 |     | PPpp    | May 29, 1453, 12:00:00 AM         |       |
   * |                                 |     | PPPpp   | May 29th, 1453 at ...             |       |
   * |                                 |     | PPPPpp  | Sunday, May 29th, 1453 at ...     | 2,5,8 |
   * Notes:
   * 1. "Formatting" units (e.g. formatting quarter) in the default en-US locale
   *    are the same as "stand-alone" units, but are different in some languages.
   *    "Formatting" units are declined according to the rules of the language
   *    in the context of a date. "Stand-alone" units are always nominative singular.
   *    In `format` function, they will produce different result:
   *
   *    `format(new Date(2017, 10, 6), 'do LLLL', {locale: cs}) //=> '6. listopad'`
   *
   *    `format(new Date(2017, 10, 6), 'do MMMM', {locale: cs}) //=> '6. listopadu'`
   *
   *    `parse` will try to match both formatting and stand-alone units interchangably.
   *
   * 2. Any sequence of the identical letters is a pattern, unless it is escaped by
   *    the single quote characters (see below).
   *    If the sequence is longer than listed in table:
   *    - for numerical units (`yyyyyyyy`) `parse` will try to match a number
   *      as wide as the sequence
   *    - for text units (`MMMMMMMM`) `parse` will try to match the widest variation of the unit.
   *      These variations are marked with "2" in the last column of the table.
   *
   * 3. `QQQQQ` and `qqqqq` could be not strictly numerical in some locales.
   *    These tokens represent the shortest form of the quarter.
   *
   * 4. The main difference between `y` and `u` patterns are B.C. years:
   *
   *    | Year | `y` | `u` |
   *    |------|-----|-----|
   *    | AC 1 |   1 |   1 |
   *    | BC 1 |   1 |   0 |
   *    | BC 2 |   2 |  -1 |
   *
   *    Also `yy` will try to guess the century of two digit year by proximity with `backupDate`:
   *
   *    `parse('50', 'yy', new Date(2018, 0, 1)) //=> Sat Jan 01 2050 00:00:00`
   *
   *    `parse('75', 'yy', new Date(2018, 0, 1)) //=> Wed Jan 01 1975 00:00:00`
   *
   *    while `uu` will just assign the year as is:
   *
   *    `parse('50', 'uu', new Date(2018, 0, 1)) //=> Sat Jan 01 0050 00:00:00`
   *
   *    `parse('75', 'uu', new Date(2018, 0, 1)) //=> Tue Jan 01 0075 00:00:00`
   *
   *    The same difference is true for local and ISO week-numbering years (`Y` and `R`),
   *    except local week-numbering years are dependent on `options.weekStartsOn`
   *    and `options.firstWeekContainsDate` (compare [setISOWeekYear]{@link https://date-fns.org/docs/setISOWeekYear}
   *    and [setWeekYear]{@link https://date-fns.org/docs/setWeekYear}).
   *
   * 5. These patterns are not in the Unicode Technical Standard #35:
   *    - `i`: ISO day of week
   *    - `I`: ISO week of year
   *    - `R`: ISO week-numbering year
   *    - `o`: ordinal number modifier
   *    - `P`: long localized date
   *    - `p`: long localized time
   *
   * 6. `YY` and `YYYY` tokens represent week-numbering years but they are often confused with years.
   *    You should enable `options.useAdditionalWeekYearTokens` to use them. See: https://git.io/fxCyr
   *
   * 7. `D` and `DD` tokens represent days of the year but they are ofthen confused with days of the month.
   *    You should enable `options.useAdditionalDayOfYearTokens` to use them. See: https://git.io/fxCyr
   *
   * 8. `P+` tokens do not have a defined priority since they are merely aliases to other tokens based
   *    on the given locale.
   *
   *    using `en-US` locale: `P` => `MM/dd/yyyy`
   *    using `en-US` locale: `p` => `hh:mm a`
   *    using `pt-BR` locale: `P` => `dd/MM/yyyy`
   *    using `pt-BR` locale: `p` => `HH:mm`
   *
   * Values will be assigned to the date in the descending order of its unit's priority.
   * Units of an equal priority overwrite each other in the order of appearance.
   *
   * If no values of higher priority are parsed (e.g. when parsing string 'January 1st' without a year),
   * the values will be taken from 3rd argument `backupDate` which works as a context of parsing.
   *
   * `backupDate` must be passed for correct work of the function.
   * If you're not sure which `backupDate` to supply, create a new instance of Date:
   * `parse('02/11/2014', 'MM/dd/yyyy', new Date())`
   * In this case parsing will be done in the context of the current date.
   * If `backupDate` is `Invalid Date` or a value not convertible to valid `Date`,
   * then `Invalid Date` will be returned.
   *
   * The result may vary by locale.
   *
   * If `formatString` matches with `dateString` but does not provides tokens, `backupDate` will be returned.
   *
   * If parsing failed, `Invalid Date` will be returned.
   * Invalid Date is a Date, whose time value is NaN.
   * Time value of Date: http://es5.github.io/#x15.9.1.1
   *
   * ### v2.0.0 breaking changes:
   *
   * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
   *
   * - Old `parse` was renamed to `toDate`.
   *   Now `parse` is a new function which parses a string using a provided format.
   *
   *   ```javascript
   *   // Before v2.0.0
   *   parse('2016-01-01')
   *
   *   // v2.0.0 onward
   *   toDate('2016-01-01')
   *   parse('2016-01-01', 'yyyy-MM-dd', new Date())
   *   ```
   *
   * @param {String} dateString - the string to parse
   * @param {String} formatString - the string of tokens
   * @param {Date|Number} backupDate - defines values missing from the parsed dateString
   * @param {Object} [options] - an object with options.
   * @param {Locale} [options.locale=defaultLocale] - the locale object. See [Locale]{@link https://date-fns.org/docs/Locale}
   * @param {0|1|2|3|4|5|6} [options.weekStartsOn=0] - the index of the first day of the week (0 - Sunday)
   * @param {1|2|3|4|5|6|7} [options.firstWeekContainsDate=1] - the day of January, which is always in the first week of the year
   * @param {Boolean} [options.useAdditionalWeekYearTokens=false] - if true, allows usage of the week-numbering year tokens `YY` and `YYYY`;
   *   see: https://git.io/fxCyr
   * @param {Boolean} [options.useAdditionalDayOfYearTokens=false] - if true, allows usage of the day of year tokens `D` and `DD`;
   *   see: https://git.io/fxCyr
   * @returns {Date} the parsed date
   * @throws {TypeError} 3 arguments required
   * @throws {RangeError} `options.weekStartsOn` must be between 0 and 6
   * @throws {RangeError} `options.firstWeekContainsDate` must be between 1 and 7
   * @throws {RangeError} `options.locale` must contain `match` property
   * @throws {RangeError} use `yyyy` instead of `YYYY` for formatting years; see: https://git.io/fxCyr
   * @throws {RangeError} use `yy` instead of `YY` for formatting years; see: https://git.io/fxCyr
   * @throws {RangeError} use `d` instead of `D` for formatting days of the month; see: https://git.io/fxCyr
   * @throws {RangeError} use `dd` instead of `DD` for formatting days of the month; see: https://git.io/fxCyr
   * @throws {RangeError} format string contains an unescaped latin alphabet character
   *
   * @example
   * // Parse 11 February 2014 from middle-endian format:
   * var result = parse('02/11/2014', 'MM/dd/yyyy', new Date())
   * //=> Tue Feb 11 2014 00:00:00
   *
   * @example
   * // Parse 28th of February in Esperanto locale in the context of 2010 year:
   * import eo from 'date-fns/locale/eo'
   * var result = parse('28-a de februaro', "do 'de' MMMM", new Date(2010, 0, 1), {
   *   locale: eo
   * })
   * //=> Sun Feb 28 2010 00:00:00
   */

  function parse(dirtyDateString, dirtyFormatString, dirtyBackupDate, dirtyOptions) {
    requiredArgs(3, arguments);
    var dateString = String(dirtyDateString);
    var formatString = String(dirtyFormatString);
    var options = dirtyOptions || {};
    var locale$1 = options.locale || locale;

    if (!locale$1.match) {
      throw new RangeError('locale must contain match property');
    }

    var localeFirstWeekContainsDate = locale$1.options && locale$1.options.firstWeekContainsDate;
    var defaultFirstWeekContainsDate = localeFirstWeekContainsDate == null ? 1 : toInteger(localeFirstWeekContainsDate);
    var firstWeekContainsDate = options.firstWeekContainsDate == null ? defaultFirstWeekContainsDate : toInteger(options.firstWeekContainsDate); // Test if weekStartsOn is between 1 and 7 _and_ is not NaN

    if (!(firstWeekContainsDate >= 1 && firstWeekContainsDate <= 7)) {
      throw new RangeError('firstWeekContainsDate must be between 1 and 7 inclusively');
    }

    var localeWeekStartsOn = locale$1.options && locale$1.options.weekStartsOn;
    var defaultWeekStartsOn = localeWeekStartsOn == null ? 0 : toInteger(localeWeekStartsOn);
    var weekStartsOn = options.weekStartsOn == null ? defaultWeekStartsOn : toInteger(options.weekStartsOn); // Test if weekStartsOn is between 0 and 6 _and_ is not NaN

    if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
      throw new RangeError('weekStartsOn must be between 0 and 6 inclusively');
    }

    if (formatString === '') {
      if (dateString === '') {
        return toDate(dirtyBackupDate);
      } else {
        return new Date(NaN);
      }
    }

    var subFnOptions = {
      firstWeekContainsDate: firstWeekContainsDate,
      weekStartsOn: weekStartsOn,
      locale: locale$1 // If timezone isn't specified, it will be set to the system timezone

    };
    var setters = [{
      priority: TIMEZONE_UNIT_PRIORITY,
      set: dateToSystemTimezone,
      index: 0
    }];
    var i;
    var tokens = formatString.match(longFormattingTokensRegExp).map(function (substring) {
      var firstCharacter = substring[0];

      if (firstCharacter === 'p' || firstCharacter === 'P') {
        var longFormatter = longFormatters[firstCharacter];
        return longFormatter(substring, locale$1.formatLong, subFnOptions);
      }

      return substring;
    }).join('').match(formattingTokensRegExp);
    var usedTokens = [];

    for (i = 0; i < tokens.length; i++) {
      var token = tokens[i];

      if (!options.useAdditionalWeekYearTokens && isProtectedWeekYearToken(token)) {
        throwProtectedError(token);
      }

      if (!options.useAdditionalDayOfYearTokens && isProtectedDayOfYearToken(token)) {
        throwProtectedError(token);
      }

      var firstCharacter = token[0];
      var parser = parsers[firstCharacter];

      if (parser) {
        var incompatibleTokens = parser.incompatibleTokens;

        if (Array.isArray(incompatibleTokens)) {
          var incompatibleToken = void 0;

          for (var _i = 0; _i < usedTokens.length; _i++) {
            var usedToken = usedTokens[_i].token;

            if (incompatibleTokens.indexOf(usedToken) !== -1 || usedToken === firstCharacter) {
              incompatibleToken = usedTokens[_i];
              break;
            }
          }

          if (incompatibleToken) {
            throw new RangeError("The format string mustn't contain `".concat(incompatibleToken.fullToken, "` and `").concat(token, "` at the same time"));
          }
        } else if (parser.incompatibleTokens === '*' && usedTokens.length) {
          throw new RangeError("The format string mustn't contain `".concat(token, "` and any other token at the same time"));
        }

        usedTokens.push({
          token: firstCharacter,
          fullToken: token
        });
        var parseResult = parser.parse(dateString, token, locale$1.match, subFnOptions);

        if (!parseResult) {
          return new Date(NaN);
        }

        setters.push({
          priority: parser.priority,
          set: parser.set,
          validate: parser.validate,
          value: parseResult.value,
          index: setters.length
        });
        dateString = parseResult.rest;
      } else {
        if (firstCharacter.match(unescapedLatinCharacterRegExp)) {
          throw new RangeError('Format string contains an unescaped latin alphabet character `' + firstCharacter + '`');
        } // Replace two single quote characters with one single quote character


        if (token === "''") {
          token = "'";
        } else if (firstCharacter === "'") {
          token = cleanEscapedString(token);
        } // Cut token from string, or, if string doesn't match the token, return Invalid Date


        if (dateString.indexOf(token) === 0) {
          dateString = dateString.slice(token.length);
        } else {
          return new Date(NaN);
        }
      }
    } // Check if the remaining input contains something other than whitespace


    if (dateString.length > 0 && notWhitespaceRegExp.test(dateString)) {
      return new Date(NaN);
    }

    var uniquePrioritySetters = setters.map(function (setter) {
      return setter.priority;
    }).sort(function (a, b) {
      return b - a;
    }).filter(function (priority, index, array) {
      return array.indexOf(priority) === index;
    }).map(function (priority) {
      return setters.filter(function (setter) {
        return setter.priority === priority;
      }).reverse();
    }).map(function (setterArray) {
      return setterArray[0];
    });
    var date = toDate(dirtyBackupDate);

    if (isNaN(date)) {
      return new Date(NaN);
    } // Convert the date in system timezone to the same date in UTC+00:00 timezone.
    // This ensures that when UTC functions will be implemented, locales will be compatible with them.
    // See an issue about UTC functions: https://github.com/date-fns/date-fns/issues/37


    var utcDate = subMilliseconds(date, getTimezoneOffsetInMilliseconds(date));
    var flags = {};

    for (i = 0; i < uniquePrioritySetters.length; i++) {
      var setter = uniquePrioritySetters[i];

      if (setter.validate && !setter.validate(utcDate, setter.value, subFnOptions)) {
        return new Date(NaN);
      }

      var result = setter.set(utcDate, flags, setter.value, subFnOptions); // Result is tuple (date, flags)

      if (result[0]) {
        utcDate = result[0];
        assign(flags, result[1]); // Result is date
      } else {
        utcDate = result;
      }
    }

    return utcDate;
  }

  function dateToSystemTimezone(date, flags) {
    if (flags.timestampIsSet) {
      return date;
    }

    var convertedDate = new Date(0);
    convertedDate.setFullYear(date.getUTCFullYear(), date.getUTCMonth(), date.getUTCDate());
    convertedDate.setHours(date.getUTCHours(), date.getUTCMinutes(), date.getUTCSeconds(), date.getUTCMilliseconds());
    return convertedDate;
  }

  function cleanEscapedString(input) {
    return input.match(escapedStringRegExp)[1].replace(doubleQuoteRegExp, "'");
  }

  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  var dateUtils = {
    compareDates: function compareDates(date1, date2) {
      var d1 = new Date(date1.getTime());
      var d2 = new Date(date2.getTime());
      d1.setHours(0, 0, 0, 0);
      d2.setHours(0, 0, 0, 0);
      return d1.getTime() === d2.getTime();
    },
    daysInMonth: function daysInMonth(year, month) {
      return /8|3|5|10/.test(month) ? 30 : month === 1 ? !(year % 4) && year % 100 || !(year % 400) ? 29 : 28 : 31;
    },
    formatDate: function formatDate(date, localeObj) {
      var year = date.getFullYear();
      var month = date.getMonth() + 1;
      var day = date.getDate();
      var str = localeObj.format.replace(/dd/, ('0' + day).slice(-2)).replace(/d/, day).replace(/yyyy/, year).replace(/yy/, String(year).slice(2)).replace(/MMMM/, localeObj.months[date.getMonth()]).replace(/MMMM/, localeObj.short[date.getMonth()]).replace(/MM/, ('0' + month).slice(-2)).replace(/M(?!a|ä|e)/, month); // .replace(/su/, this.getNthSuffix(this.getDate(date)))
      // .replace(/D(?!e|é|i)/, this.getDayNameAbbr(date, translation.days))

      return str;
    }
  };
  var locale$1 = {
    "da": {
      goToToday: "Gå til idag",
      format: "dd/MM/yyyy",
      firstDay: 1,
      days: ["M", "T", "O", "T", "F", "L", "S"],
      months: ['Januar', 'Februar', 'Marts', 'April', 'Maj', 'Juni', 'Juli', 'August', 'September', 'Oktober', 'November', 'December'],
      short: ['Jan', 'Feb', 'Mar', 'Apr', 'Maj', 'Jun', 'Jul', 'Aug', 'Sep', 'Okt', 'Nov', 'Dec']
    },
    "de": {
      goToToday: "gehe heute hin",
      format: "dd.MM.yyyy",
      firstDay: 1,
      days: ["M", "D", "M", "D", "F", "S", "S"],
      months: ['Januar', 'Februar', 'März', 'April', 'Mai', 'Juni', 'Juli', 'August', 'September', 'Oktober', 'November', 'Dezember'],
      short: ['Jan', 'Febr', 'Mrz', 'Apr', 'Mai', 'Jun', 'Jul', 'Aug', 'Sept', 'Okt', 'Nov', 'Dez']
    },
    "es": {
      goToToday: "ir a hoy",
      format: "dd/MM/yyyy",
      firstDay: 1,
      days: ["L", "M", "M", "J", "V", "S", "D"],
      months: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
      short: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic']
    },
    "en-uk": {
      goToToday: "Go to today",
      format: "dd/MM/yyyy",
      firstDay: 1,
      days: ["M", "T", "W", "T", "F", "S", "S"],
      months: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
      short: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
    },
    "en-gb": {
      goToToday: "Go to today",
      format: "dd/MM/yyyy",
      firstDay: 1,
      days: ["M", "T", "W", "T", "F", "S", "S"],
      months: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
      short: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
    },
    "en-us": {
      goToToday: "Go to today",
      format: "M/d/yyyy",
      firstDay: 0,
      days: ["S", "M", "T", "W", "T", "F", "S"],
      months: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
      short: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
    },
    "fi": {
      goToToday: "mene tänään",
      format: "M/d/yyyy",
      firstDay: 1,
      days: ["M", "T", "K", "T", "P", "L", "S"],
      months: ["Tammikuu", "helmikuu", "maaliskuu", "huhtikuu", "toukokuu", "kesäkuu", "heinäkuu", "elokuu", "syyskuu", "lokakuu", "marraskuu", "joulukuu"],
      short: ["Tam", "Hel", "Maa", "Huh", "Tou", "Kes", "Hei", "Elo", "Syy", "Lok", "Mar", "Jou"]
    },
    "fr": {
      goToToday: "Aller à aujourd'hui",
      format: "dd/MM/yyyy",
      firstDay: 1,
      days: ["L", "M", "M", "J", "V", "S", "D"],
      months: ['janvier', 'février', 'mars', 'avril', 'mai', 'juin', 'juillet', 'août', 'septembre', 'octobre', 'novembre', 'décembre'],
      short: ['janv.', 'févr.', 'mars', 'avr.', 'mai', 'juin', 'juil.', 'août', 'sept.', 'oct.', 'nov.', 'déc.']
    },
    "it": {
      goToToday: "Vai a oggi",
      format: "dd/MM/yyyy",
      firstDay: 1,
      days: ["L", "M", "M", "G", "V", "S", "D"],
      months: ['gennaio', 'febbraio', 'marzo', 'aprile', 'maggio', 'giugno', 'luglio', 'agosto', 'settembre', 'ottobre', 'novembre', 'dicembre'],
      short: ['gen', 'feb', 'mar', 'apr', 'mag', 'giu', 'lug', 'ago', 'set', 'ott', 'nov', 'dic']
    },
    "nl": {
      goToToday: "Ga naar vandaag",
      format: "dd-MM-yyyy",
      firstDay: 1,
      days: ["M", "D", "W", "D", "V", "Z", "Z"],
      months: ['januari', 'februari', 'maart', 'april', 'mei', 'juni', 'juli', 'augustus', 'september', 'oktober', 'november', 'december'],
      short: ['jan', 'feb', 'mrt', 'apr', 'mei', 'jun', 'jul', 'aug', 'sep', 'okt', 'nov', 'dec']
    },
    "pl": {
      goToToday: "Idź do dzisiaj",
      format: "dd.MM.yyyy",
      firstDay: 1,
      days: ["P", "W", "Ś", "C", "P", "S", "N"],
      months: ['styczeń', 'luty', 'marzec', 'kwiecień', 'maj', 'czerwiec', 'lipiec', 'sierpień', 'wrzesień', 'październik', 'listopad', 'grudzień'],
      short: ['sty', 'lut', 'mar', 'kwi', 'maj', 'cze', 'lip', 'sie', 'wrz', 'paź', 'lis', 'gru']
    }
  };
  var script$$ = {
    loadStyles: loadThemedStyles.loadStyles,
    components: {
      uiIconUp: uiIconUp,
      uiIconDown: uiIconDown,
      uiIconCalendar: uiIconCalendar,
      Popper: vuePopper_min
    },
    props: {
      value: {
        type: Date
      },
      locale: {
        type: String,
        default: "en-us"
      },
      placement: {
        type: String,
        default: "top-end"
      }
    },
    watch: {
      value: {
        handler: function handler(newVal) {
          // console.log("value watch", newVal);
          if (newVal) {
            this.inputVal = dateUtils.formatDate(newVal, this.localeObj);
            this.pickerDate = newVal;
          } else {
            this.inputVal = "";
            this.pickerDate = new Date();
          }
        },
        immediate: true
      }
    },
    computed: {
      popperOptions: function popperOptions() {
        return {
          placement: "bottom-start",
          modifiers: {
            preventOverflow: {
              enabled: false
            },
            offset: {
              enabled: false
            },
            keepTogether: {
              enabled: false
            },
            arrow: {
              enabled: false
            },
            flip: {
              enabled: false
            },
            hide: {
              enabled: false
            },
            computeStyle: {
              enabled: false
            },
            applyStyle: {
              enabled: true,
              fn: function fn(data, options) {
                var input = data.instance.reference.getClientRects()[0];
                var popper = data.instance.popper.getClientRects()[0];
                var windowWidth = document.documentElement.clientWidth;
                var windowHeight = document.documentElement.clientHeight; // below of above the input

                var top = 0;
                if (input.height + input.y + popper.height < windowHeight) top = input.height; // yay room to place it beneath
                else top = 0 - popper.height; //crap, place it above
                // left or rightside of the input

                var right = 0;
                if (popper.x + popper.width + input.width >= windowWidth) right = 0 - popper.width + input.width; // apply style

                data.instance.popper.style.transform = "translate(" + right + "px, " + top + "px)";
              }
            }
          }
        };
      },
      localeObj: function localeObj() {
        if (locale$1[this.locale.toLowerCase()]) return locale$1[this.locale.toLowerCase()];
        if (locale$1[this.locale.split("-")[0].toLowerCase()]) return locale$1[this.locale.split("-")[0].toLowerCase()];
        return locale$1["en-us"];
      },
      years: function years() {
        var rtn = [];

        for (var i = this.yearStart; i < this.yearEnd; i++) {
          rtn.push(i);
        }

        return rtn;
      },
      yearStart: {
        get: function get() {
          return this.yearEnd - 12;
        },
        set: function set(val) {
          this.yearEnd = val + 12;
        }
      },
      currentMonth: function currentMonth() {
        return this.localeObj.months[this.pickerDate.getMonth()] + " " + this.pickerDate.getFullYear(); // return ['Januar', 'Februar', 'Marts', 'April', 'Maj', 'Juni', 'Juli', 'August', 'September', 'Oktober', 'November', 'December'][this.pickerDate.getMonth()]
        // + " " + this.pickerDate.getFullYear();// TODO
      },
      months: function months() {
        return this.localeObj.short; // return ['Jan', 'Feb', 'Mar', 'Apr', 'Maj', 'Jun', 'Jul', 'Aug', 'Sep', 'Okt', 'Nov', 'Dec'];
      },
      daysOfWeek: function daysOfWeek() {
        return this.localeObj.days; // ["M","T","O","T","F","L","S"]
      },
      blankDaysStart: function blankDaysStart() {
        var dObj = new Date(this.pickerDate.getFullYear(), this.pickerDate.getMonth(), 1, this.pickerDate.getHours(), this.pickerDate.getMinutes()); // if (this.mondayFirst) {

        if (this.localeObj.firstDay == 1) {
          return dObj.getDay() > 0 ? dObj.getDay() - 1 : 6;
        }

        return dObj.getDay();
      },
      blankDaysEnd: function blankDaysEnd() {
        return 7 - (this.blankDaysStart + this.days.length) % 7;
      },
      days: function days() {
        var d = this.pickerDate;
        var days = [];
        var dObj = new Date(this.pickerDate.getFullYear(), this.pickerDate.getMonth(), 1, this.pickerDate.getHours(), this.pickerDate.getMinutes());
        var daysInMonth = dateUtils.daysInMonth(dObj.getFullYear(), dObj.getMonth());

        for (var i = 0; i < daysInMonth; i++) {
          days.push({
            date: dObj.getDate(),
            timestamp: dObj.getTime(),
            isSelected: this.value && dateUtils.compareDates(dObj, this.value),
            // isDisabled: this.isDisabledDate(dObj),
            // isHighlighted: this.isHighlightedDate(dObj),
            // isHighlightStart: this.isHighlightStart(dObj),
            // isHighlightEnd: this.isHighlightEnd(dObj),
            isToday: dateUtils.compareDates(dObj, new Date()),
            isWeekend: dObj.getDay() === 0 || dObj.getDay() === 6,
            isSaturday: dObj.getDay() === 6,
            isSunday: dObj.getDay() === 0
          });
          dObj.setDate(dObj.getDate() + 1);
        }

        return days;
      }
    },
    methods: {
      parseTypedDate: function parseTypedDate() {
        if (!this.inputVal || this.inputVal == "") {
          this.$emit("input", "");
          return;
        }

        try {
          var parsed = parse(this.inputVal, this.localeObj.format); // this.pickerDate = parsed;

          if (parsed != "Invalid Date" && !dateUtils.compareDates(parsed, this.value)) this.$emit("input", parsed);
        } catch (ex) {} // var parsed = Moment(this.inputVal, this.localeObj.format.toUpperCase());
        // if(parsed.isValid()){
        //     // this.pickerDate = parsed.toDate();
        //     if(!dateUtils.compareDates(parsed.toDate(), this.value))
        //         this.$emit("input", parsed.toDate());
        // }
        // console.log("parsed", parsed);

      },
      selectDate: function selectDate(val) {
        var _this = this;

        this.$emit("input", new Date(val.timestamp));
        this.inputVal = dateUtils.formatDate(new Date(val.timestamp), this.localeObj); // this.showPicker = false;

        this.$refs.popper.doClose();
        this.$nextTick(function () {
          _this.$refs.popper.doClose();
        }); // console.log("inputval", this.inputVal);
      },
      selectYear: function selectYear(year) {
        this.year = year;
        this.showYear = false;
      },
      selectMonth: function selectMonth(index) {
        this.pickerDate.setMonth(index);
        this.pickerDate.setFullYear(this.year);
        this.pickerDate = new Date(this.pickerDate); // fire off change detection
      },
      getDayClasses: function getDayClasses(day) {
        return {
          'selectable': true,
          'selected': day.isSelected,
          // 'disabled': day.isDisabled,
          // 'highlighted': day.isHighlighted,
          'today': day.isToday,
          'weekend': day.isWeekend,
          'sat': day.isSaturday,
          'sun': day.isSunday // 'highlight-start': day.isHighlightStart,
          // 'highlight-end': day.isHighlightEnd

        };
      },
      // inputBlurred(){
      //     setTimeout(()=>{
      //         if(!this.cancelBlur)
      //             this.showPicker = false;
      //         this.cancelBlur = false;
      //     },500);            
      // },
      monthUp: function monthUp() {
        this.pickerDate.setMonth(this.pickerDate.getMonth() + 1);
        this.pickerDate = new Date(this.pickerDate); // fire off change detection
      },
      monthDown: function monthDown() {
        this.pickerDate.setMonth(this.pickerDate.getMonth() - 1);
        this.pickerDate = new Date(this.pickerDate); // fire off change detection
      },
      goToToday: function goToToday() {
        this.year = new Date().getFullYear();
        this.pickerDate = new Date();
      }
    },
    data: function data() {
      return {
        // showPicker : true, // TODO
        // cancelBlur : false,
        inputVal: "",
        showYear: false,
        pickerDate: this.value || new Date(),
        year: (this.value || new Date()).getFullYear(),
        yearEnd: new Date().getFullYear() - new Date().getFullYear() % 12 + 12
      };
    }
  };

  /* script */
  const __vue_script__$$ = script$$;

  /* template */
  var __vue_render__$B = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"uiDatePicker"},[_c('popper',{ref:"popper",attrs:{"trigger":"click","options":_vm.popperOptions}},[_c('div',{staticClass:"popper foldout"},[_c('div',{staticClass:"dayPicker"},[_c('div',{staticClass:"header"},[_c('span',{staticClass:"current"},[_vm._v(_vm._s(_vm.currentMonth))]),_vm._v(" "),_c('span',{staticClass:"navigate"},[_c('span',{staticClass:"up",on:{"click":function($event){return _vm.monthUp()}}},[_c('uiIconUp')],1),_vm._v(" "),_c('span',{staticClass:"down",on:{"click":function($event){return _vm.monthDown()}}},[_c('uiIconDown')],1)])]),_vm._v(" "),_c('div',{staticClass:"days"},_vm._l((_vm.daysOfWeek),function(day,index){return _c('span',{key:index},[_vm._v(_vm._s(day))])}),0),_vm._v(" "),_c('div',{staticClass:"days"},[(_vm.blankDaysStart > 0)?_vm._l((_vm.blankDaysStart),function(d){return _c('span',{key:d.timestamp})}):_vm._e(),_vm._v(" "),_vm._l((_vm.days),function(day){return _c('span',{key:day.timestamp,class:_vm.getDayClasses(day),on:{"click":function($event){return _vm.selectDate(day)}}},[_vm._v(_vm._s(day.date))])}),_vm._v(" "),(_vm.blankDaysEnd > 0)?_vm._l((_vm.blankDaysEnd),function(d){return _c('span',{key:d.timestamp})}):_vm._e()],2)]),_vm._v(" "),(!_vm.showYear)?_c('div',{staticClass:"monthPicker"},[_c('div',{staticClass:"header"},[_c('span',{staticClass:"current pointer",on:{"click":function($event){_vm.showYear=true;}}},[_vm._v(_vm._s(_vm.year))]),_vm._v(" "),_c('span',{staticClass:"navigate"},[_c('span',{staticClass:"up",on:{"click":function($event){_vm.year++;}}},[_c('uiIconUp')],1),_vm._v(" "),_c('span',{staticClass:"down",on:{"click":function($event){_vm.year--;}}},[_c('uiIconDown')],1)])]),_vm._v(" "),_c('div',{staticClass:"months"},_vm._l((_vm.months),function(month,index){return _c('span',{key:index,on:{"click":function($event){return _vm.selectMonth(index)}}},[_vm._v("\n                        "+_vm._s(month)+"\n                    ")])}),0),_vm._v(" "),_c('div',{staticClass:"goToToday"},[_c('span',{on:{"click":function($event){return _vm.goToToday()}}},[_vm._v(_vm._s(_vm.localeObj.goToToday))])])]):_vm._e(),_vm._v(" "),(_vm.showYear)?_c('div',{staticClass:"yearPicker"},[_c('div',{staticClass:"header"},[_c('span',{staticClass:"current pointer",on:{"click":function($event){_vm.showYear=false;}}},[_vm._v(_vm._s(_vm.yearStart)+" - "+_vm._s(_vm.yearEnd-1))]),_vm._v(" "),_c('span',{staticClass:"navigate"},[_c('span',{staticClass:"up",on:{"click":function($event){_vm.yearStart+=12;}}},[_c('uiIconUp')],1),_vm._v(" "),_c('span',{staticClass:"down",on:{"click":function($event){_vm.yearStart-=12;}}},[_c('uiIconDown')],1)])]),_vm._v(" "),_c('div',{staticClass:"years"},_vm._l((_vm.years),function(year){return _c('span',{key:year,on:{"click":function($event){return _vm.selectYear(year)}}},[_vm._v("\n                        "+_vm._s(year)+"\n                    ")])}),0),_vm._v(" "),_c('div',{staticClass:"goToToday"},[_c('span',{on:{"click":function($event){return _vm.goToToday()}}},[_vm._v(_vm._s(_vm.localeObj.goToToday))])])]):_vm._e()]),_vm._v(" "),_c('div',{staticClass:"inputGroup",attrs:{"slot":"reference"},slot:"reference"},[_c('div',{staticClass:"inputContainer"},[_c('input',{directives:[{name:"model",rawName:"v-model",value:(_vm.inputVal),expression:"inputVal"}],attrs:{"type":"text"},domProps:{"value":(_vm.inputVal)},on:{"blur":_vm.parseTypedDate,"input":function($event){if($event.target.composing){ return; }_vm.inputVal=$event.target.value;}}})]),_vm._v(" "),_c('div',{staticClass:"iconContainer"},[_c('uiIconCalendar')],1)])])],1)};
  var __vue_staticRenderFns__$B = [];

    /* style */
    const __vue_inject_styles__$$ = function (inject) {
      if (!inject) return
      inject("data-v-5077fc00_0", { source: ".popper[data-v-5077fc00]{width:auto;background-color:#fafafa;color:#212121;text-align:center;padding:2px;display:inline-block;border-radius:3px;position:absolute;font-size:14px;font-weight:400;border:1px #ebebeb solid;z-index:200000;-moz-box-shadow:#3a3a3a 0 0 6px 0;-webkit-box-shadow:#3a3a3a 0 0 6px 0;box-shadow:#3a3a3a 0 0 6px 0}.popper .popper__arrow[data-v-5077fc00]{width:0;height:0;border-style:solid;position:absolute;margin:5px}.popper[x-placement^=top][data-v-5077fc00]{margin-bottom:5px}.popper[x-placement^=top] .popper__arrow[data-v-5077fc00]{border-width:5px 5px 0 5px;border-color:#fafafa transparent transparent transparent;bottom:-5px;left:calc(50% - 5px);margin-top:0;margin-bottom:0}.popper[x-placement^=bottom][data-v-5077fc00]{margin-top:5px}.popper[x-placement^=bottom] .popper__arrow[data-v-5077fc00]{border-width:0 5px 5px 5px;border-color:transparent transparent #fafafa transparent;top:-5px;left:calc(50% - 5px);margin-top:0;margin-bottom:0}.popper[x-placement^=right][data-v-5077fc00]{margin-left:5px}.popper[x-placement^=right] .popper__arrow[data-v-5077fc00]{border-width:5px 5px 5px 0;border-color:transparent #fafafa transparent transparent;left:-5px;top:calc(50% - 5px);margin-left:0;margin-right:0}.popper[x-placement^=left][data-v-5077fc00]{margin-right:5px}.popper[x-placement^=left] .popper__arrow[data-v-5077fc00]{border-width:5px 0 5px 5px;border-color:transparent transparent transparent #fafafa;right:-5px;top:calc(50% - 5px);margin-left:0;margin-right:0}.uiDatePicker[data-v-5077fc00]{position:relative;font-family:\"Segoe UI WestEuropean\",\"Segoe UI\",-apple-system,BlinkMacSystemFont,Roboto,\"Helvetica Neue\",sans-serif;-webkit-font-smoothing:antialiased;box-sizing:border-box;margin:0;padding:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;color:\"[theme:neutralPrimary, default: #333333]\";font-size:12px;font-weight:400}.foldout[data-v-5077fc00]{background-color:#fff;width:420px;box-shadow:1px 1px 5px 0 rgba(0,0,0,.75);user-select:none}.foldout>div[data-v-5077fc00]{display:table-cell;vertical-align:top}.header[data-v-5077fc00]{padding:7px;display:flex;justify-content:space-between}.header .current[data-v-5077fc00]{font-weight:700}.header .navigate[data-v-5077fc00]{cursor:pointer}.header .navigate .up[data-v-5077fc00]{padding:6px 8px}.header .navigate .up[data-v-5077fc00]:hover{background-color:#d3d3d3}.header .navigate .down[data-v-5077fc00]{padding:6px 8px}.header .navigate .down[data-v-5077fc00]:hover{background-color:#d3d3d3}.monthPicker[data-v-5077fc00],.yearPicker[data-v-5077fc00]{width:210px;padding:5px}.monthPicker .months[data-v-5077fc00],.monthPicker .years[data-v-5077fc00],.yearPicker .months[data-v-5077fc00],.yearPicker .years[data-v-5077fc00]{width:200px;display:flex;flex-wrap:wrap;justify-content:space-between}.monthPicker .months span[data-v-5077fc00],.monthPicker .years span[data-v-5077fc00],.yearPicker .months span[data-v-5077fc00],.yearPicker .years span[data-v-5077fc00]{flex-basis:40px;padding:12px 2px;text-align:center;margin-bottom:12px;cursor:pointer}.monthPicker .months span[data-v-5077fc00]:hover,.monthPicker .years span[data-v-5077fc00]:hover,.yearPicker .months span[data-v-5077fc00]:hover,.yearPicker .years span[data-v-5077fc00]:hover{background-color:#d3d3d3}.monthPicker .goToToday[data-v-5077fc00],.yearPicker .goToToday[data-v-5077fc00]{text-align:right;padding:5px}.monthPicker .goToToday span[data-v-5077fc00],.yearPicker .goToToday span[data-v-5077fc00]{cursor:pointer}.dayPicker[data-v-5077fc00]{width:210px;padding:5px;border-right:solid 1px #edebe9}.dayPicker .days[data-v-5077fc00]{width:200px;display:flex;flex-wrap:wrap;justify-content:space-between}.dayPicker .days span[data-v-5077fc00]{flex-basis:20px;padding:4px;text-align:center}.dayPicker .days span.selectable[data-v-5077fc00]{cursor:pointer}.dayPicker .days span.selectable[data-v-5077fc00]:hover{background-color:#d3d3d3}.dayPicker .days span.today[data-v-5077fc00]{background-color:\"[theme:themePrimary, default: #0078d7]\";color:\"[theme:white, default: #ffffff]\"}.dayPicker .days span.selected[data-v-5077fc00]{background-color:\"[theme:themeLight, default: #c7e0f4]\"}.pointer[data-v-5077fc00]{cursor:pointer}.inputGroup[data-v-5077fc00]{display:inline-block;padding-right:8px;border:1px solid \"[theme:neutralTertiaryAlt, default: #c8c8c8]\";border-radius:2px}.inputGroup .inputContainer[data-v-5077fc00]{display:table-cell;width:100%}.inputGroup .inputContainer input[data-v-5077fc00]{height:30px;width:100%;box-sizing:border-box;padding:0 8px;border:none;font-weight:300;font-size:14px;color:\"[theme:neutralPrimary, default: #333333]\"}.inputGroup .inputContainer input[data-v-5077fc00]:focus{outline:0}.inputGroup .iconContainer[data-v-5077fc00]{display:table-cell}.inputGroup .iconContainer .ms-Icon[data-v-5077fc00]{vertical-align:-4px;font-size:18px}@media screen and (max-width:450px){.monthPicker[data-v-5077fc00],.yearPicker[data-v-5077fc00]{display:none!important}.dayPicker[data-v-5077fc00]{border-right:none!important}.foldout[data-v-5077fc00]{width:210px}}", map: undefined, media: undefined });

    };
    /* scoped */
    const __vue_scope_id__$$ = "data-v-5077fc00";
    /* module identifier */
    const __vue_module_identifier__$$ = undefined;
    /* functional template */
    const __vue_is_functional_template__$$ = false;
    /* style inject */
    const __vue_create_injector__$q = function(context){ 
                  return function(scopeId, data)
                  {
                      if(window['wizstyle-'+scopeId])
                          return;
                      if(__vue_script__$$.loadStyles)
                          __vue_script__$$.loadStyles(data.source);
                      window['wizstyle-'+scopeId]=true;
                  }
              };
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var uiDatePicker = normalizeComponent(
      { render: __vue_render__$B, staticRenderFns: __vue_staticRenderFns__$B },
      __vue_inject_styles__$$,
      __vue_script__$$,
      __vue_scope_id__$$,
      __vue_is_functional_template__$$,
      __vue_module_identifier__$$,
      false,
      __vue_create_injector__$q,
      undefined,
      undefined
    );

  /**
   * lodash (Custom Build) <https://lodash.com/>
   * Build: `lodash modularize exports="npm" -o ./`
   * Copyright jQuery Foundation and other contributors <https://jquery.org/>
   * Released under MIT license <https://lodash.com/license>
   * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
   * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
   */

  /** Used as the `TypeError` message for "Functions" methods. */
  var FUNC_ERROR_TEXT = 'Expected a function';

  /** Used as references for various `Number` constants. */
  var NAN = 0 / 0;

  /** `Object#toString` result references. */
  var symbolTag = '[object Symbol]';

  /** Used to match leading and trailing whitespace. */
  var reTrim = /^\s+|\s+$/g;

  /** Used to detect bad signed hexadecimal string values. */
  var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;

  /** Used to detect binary string values. */
  var reIsBinary = /^0b[01]+$/i;

  /** Used to detect octal string values. */
  var reIsOctal = /^0o[0-7]+$/i;

  /** Built-in method references without a dependency on `root`. */
  var freeParseInt = parseInt;

  /** Detect free variable `global` from Node.js. */
  var freeGlobal = typeof commonjsGlobal == 'object' && commonjsGlobal && commonjsGlobal.Object === Object && commonjsGlobal;

  /** Detect free variable `self`. */
  var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

  /** Used as a reference to the global object. */
  var root = freeGlobal || freeSelf || Function('return this')();

  /** Used for built-in method references. */
  var objectProto = Object.prototype;

  /**
   * Used to resolve the
   * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
   * of values.
   */
  var objectToString = objectProto.toString;

  /* Built-in method references for those with the same name as other `lodash` methods. */
  var nativeMax = Math.max,
      nativeMin = Math.min;

  /**
   * Gets the timestamp of the number of milliseconds that have elapsed since
   * the Unix epoch (1 January 1970 00:00:00 UTC).
   *
   * @static
   * @memberOf _
   * @since 2.4.0
   * @category Date
   * @returns {number} Returns the timestamp.
   * @example
   *
   * _.defer(function(stamp) {
   *   console.log(_.now() - stamp);
   * }, _.now());
   * // => Logs the number of milliseconds it took for the deferred invocation.
   */
  var now = function() {
    return root.Date.now();
  };

  /**
   * Creates a debounced function that delays invoking `func` until after `wait`
   * milliseconds have elapsed since the last time the debounced function was
   * invoked. The debounced function comes with a `cancel` method to cancel
   * delayed `func` invocations and a `flush` method to immediately invoke them.
   * Provide `options` to indicate whether `func` should be invoked on the
   * leading and/or trailing edge of the `wait` timeout. The `func` is invoked
   * with the last arguments provided to the debounced function. Subsequent
   * calls to the debounced function return the result of the last `func`
   * invocation.
   *
   * **Note:** If `leading` and `trailing` options are `true`, `func` is
   * invoked on the trailing edge of the timeout only if the debounced function
   * is invoked more than once during the `wait` timeout.
   *
   * If `wait` is `0` and `leading` is `false`, `func` invocation is deferred
   * until to the next tick, similar to `setTimeout` with a timeout of `0`.
   *
   * See [David Corbacho's article](https://css-tricks.com/debouncing-throttling-explained-examples/)
   * for details over the differences between `_.debounce` and `_.throttle`.
   *
   * @static
   * @memberOf _
   * @since 0.1.0
   * @category Function
   * @param {Function} func The function to debounce.
   * @param {number} [wait=0] The number of milliseconds to delay.
   * @param {Object} [options={}] The options object.
   * @param {boolean} [options.leading=false]
   *  Specify invoking on the leading edge of the timeout.
   * @param {number} [options.maxWait]
   *  The maximum time `func` is allowed to be delayed before it's invoked.
   * @param {boolean} [options.trailing=true]
   *  Specify invoking on the trailing edge of the timeout.
   * @returns {Function} Returns the new debounced function.
   * @example
   *
   * // Avoid costly calculations while the window size is in flux.
   * jQuery(window).on('resize', _.debounce(calculateLayout, 150));
   *
   * // Invoke `sendMail` when clicked, debouncing subsequent calls.
   * jQuery(element).on('click', _.debounce(sendMail, 300, {
   *   'leading': true,
   *   'trailing': false
   * }));
   *
   * // Ensure `batchLog` is invoked once after 1 second of debounced calls.
   * var debounced = _.debounce(batchLog, 250, { 'maxWait': 1000 });
   * var source = new EventSource('/stream');
   * jQuery(source).on('message', debounced);
   *
   * // Cancel the trailing debounced invocation.
   * jQuery(window).on('popstate', debounced.cancel);
   */
  function debounce$1(func, wait, options) {
    var lastArgs,
        lastThis,
        maxWait,
        result,
        timerId,
        lastCallTime,
        lastInvokeTime = 0,
        leading = false,
        maxing = false,
        trailing = true;

    if (typeof func != 'function') {
      throw new TypeError(FUNC_ERROR_TEXT);
    }
    wait = toNumber(wait) || 0;
    if (isObject(options)) {
      leading = !!options.leading;
      maxing = 'maxWait' in options;
      maxWait = maxing ? nativeMax(toNumber(options.maxWait) || 0, wait) : maxWait;
      trailing = 'trailing' in options ? !!options.trailing : trailing;
    }

    function invokeFunc(time) {
      var args = lastArgs,
          thisArg = lastThis;

      lastArgs = lastThis = undefined;
      lastInvokeTime = time;
      result = func.apply(thisArg, args);
      return result;
    }

    function leadingEdge(time) {
      // Reset any `maxWait` timer.
      lastInvokeTime = time;
      // Start the timer for the trailing edge.
      timerId = setTimeout(timerExpired, wait);
      // Invoke the leading edge.
      return leading ? invokeFunc(time) : result;
    }

    function remainingWait(time) {
      var timeSinceLastCall = time - lastCallTime,
          timeSinceLastInvoke = time - lastInvokeTime,
          result = wait - timeSinceLastCall;

      return maxing ? nativeMin(result, maxWait - timeSinceLastInvoke) : result;
    }

    function shouldInvoke(time) {
      var timeSinceLastCall = time - lastCallTime,
          timeSinceLastInvoke = time - lastInvokeTime;

      // Either this is the first call, activity has stopped and we're at the
      // trailing edge, the system time has gone backwards and we're treating
      // it as the trailing edge, or we've hit the `maxWait` limit.
      return (lastCallTime === undefined || (timeSinceLastCall >= wait) ||
        (timeSinceLastCall < 0) || (maxing && timeSinceLastInvoke >= maxWait));
    }

    function timerExpired() {
      var time = now();
      if (shouldInvoke(time)) {
        return trailingEdge(time);
      }
      // Restart the timer.
      timerId = setTimeout(timerExpired, remainingWait(time));
    }

    function trailingEdge(time) {
      timerId = undefined;

      // Only invoke if we have `lastArgs` which means `func` has been
      // debounced at least once.
      if (trailing && lastArgs) {
        return invokeFunc(time);
      }
      lastArgs = lastThis = undefined;
      return result;
    }

    function cancel() {
      if (timerId !== undefined) {
        clearTimeout(timerId);
      }
      lastInvokeTime = 0;
      lastArgs = lastCallTime = lastThis = timerId = undefined;
    }

    function flush() {
      return timerId === undefined ? result : trailingEdge(now());
    }

    function debounced() {
      var time = now(),
          isInvoking = shouldInvoke(time);

      lastArgs = arguments;
      lastThis = this;
      lastCallTime = time;

      if (isInvoking) {
        if (timerId === undefined) {
          return leadingEdge(lastCallTime);
        }
        if (maxing) {
          // Handle invocations in a tight loop.
          timerId = setTimeout(timerExpired, wait);
          return invokeFunc(lastCallTime);
        }
      }
      if (timerId === undefined) {
        timerId = setTimeout(timerExpired, wait);
      }
      return result;
    }
    debounced.cancel = cancel;
    debounced.flush = flush;
    return debounced;
  }

  /**
   * Checks if `value` is the
   * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
   * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
   *
   * @static
   * @memberOf _
   * @since 0.1.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is an object, else `false`.
   * @example
   *
   * _.isObject({});
   * // => true
   *
   * _.isObject([1, 2, 3]);
   * // => true
   *
   * _.isObject(_.noop);
   * // => true
   *
   * _.isObject(null);
   * // => false
   */
  function isObject(value) {
    var type = typeof value;
    return !!value && (type == 'object' || type == 'function');
  }

  /**
   * Checks if `value` is object-like. A value is object-like if it's not `null`
   * and has a `typeof` result of "object".
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
   * @example
   *
   * _.isObjectLike({});
   * // => true
   *
   * _.isObjectLike([1, 2, 3]);
   * // => true
   *
   * _.isObjectLike(_.noop);
   * // => false
   *
   * _.isObjectLike(null);
   * // => false
   */
  function isObjectLike(value) {
    return !!value && typeof value == 'object';
  }

  /**
   * Checks if `value` is classified as a `Symbol` primitive or object.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
   * @example
   *
   * _.isSymbol(Symbol.iterator);
   * // => true
   *
   * _.isSymbol('abc');
   * // => false
   */
  function isSymbol(value) {
    return typeof value == 'symbol' ||
      (isObjectLike(value) && objectToString.call(value) == symbolTag);
  }

  /**
   * Converts `value` to a number.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to process.
   * @returns {number} Returns the number.
   * @example
   *
   * _.toNumber(3.2);
   * // => 3.2
   *
   * _.toNumber(Number.MIN_VALUE);
   * // => 5e-324
   *
   * _.toNumber(Infinity);
   * // => Infinity
   *
   * _.toNumber('3.2');
   * // => 3.2
   */
  function toNumber(value) {
    if (typeof value == 'number') {
      return value;
    }
    if (isSymbol(value)) {
      return NAN;
    }
    if (isObject(value)) {
      var other = typeof value.valueOf == 'function' ? value.valueOf() : value;
      value = isObject(other) ? (other + '') : other;
    }
    if (typeof value != 'string') {
      return value === 0 ? value : +value;
    }
    value = value.replace(reTrim, '');
    var isBinary = reIsBinary.test(value);
    return (isBinary || reIsOctal.test(value))
      ? freeParseInt(value.slice(2), isBinary ? 2 : 8)
      : (reIsBadHex.test(value) ? NAN : +value);
  }

  var lodash_debounce = debounce$1;

  //
  var script$10 = {
    loadStyles: loadThemedStyles.loadStyles,
    components: {
      uiTextfield: uiTextfield,
      uiIconChevronDownMed: uiIconChevronDownMed,
      Popper: vuePopper_min
    },
    props: ['options', //Array of available options to display in dropdown
    'display', //String that decides what attribute on the options is used for display and typeahead
    'placeholderText', //String to use as placeholder text
    'label', //Label
    'autoselectOff'],
    data: function data() {
      return {
        selected: null,
        userInput: ''
      };
    },
    methods: {
      selectOption: function selectOption(option) {
        this.selected = option;
        this.userInput = option[this.display];
      },
      //Autoselects an option if userinput matches display attribute
      autoselectMatch: lodash_debounce(function () {
        var _this = this;

        if (this.autoselectOff == true) {
          return;
        }

        this.options.forEach(function (option) {
          //Regex for exact match but case insensitive
          var regex = new RegExp('^' + _this.userInput + '$', 'i');

          if (regex.test(option[_this.display])) {
            _this.selectOption(option);
          }
        });
      }, 500),
      setUserInput: function setUserInput(newInput) {
        this.userInput = newInput;
      },
      inputBlurred: function inputBlurred() {
        this.$refs.popper.doClose();
      }
    },
    computed: {
      popperOptions: function popperOptions() {
        return {
          placement: "bottom-end",
          positionFixed: true,
          modifiers: {
            preventOverflow: {
              enabled: true
            },
            flip: {
              enabled: true
            },
            autoSizing: {
              enabled: true,
              fn: function autoSizing(data) {
                data.styles.width = data.offsets.reference.width - 2;
                return data;
              },
              order: 840
            }
          }
        };
      }
    },
    watch: {
      "userInput": lodash_debounce(function (newVal) {
        if (this.selected == null || this.selected[this.display] != newVal) {
          this.$refs.popper.doShow();
        }
        this.autoselectMatch();
        this.$emit('inputChanged', newVal);
      }, 500),
      "selected": function selected(newVal) {
        this.$refs.popper.doClose();
        this.$emit('optionSelected', newVal);
      }
    }
  };

  /* script */
  const __vue_script__$10 = script$10;

  /* template */
  var __vue_render__$C = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"uiTypeAhead"},[_c('popper',{ref:"popper",attrs:{"trigger":"click","options":_vm.popperOptions}},[_c('div',{staticClass:"popper foldout"},[_c('div',{staticClass:"optionlist"},_vm._l((_vm.options),function(option){return _c('div',{key:option.id,staticClass:"option",class:{ 'selectedOption' : _vm.selected != null && option.id == _vm.selected.id },on:{"click":function($event){return _vm.selectOption(option)},"mousedown":function($event){$event.preventDefault();}}},[_vm._v("\n                    "+_vm._s(option[_vm.display])+"\n                ")])}),0)]),_vm._v(" "),_c('div',{staticClass:"inputGroup",attrs:{"slot":"reference"},slot:"reference"},[_c('div',{staticClass:"inputContainer"},[_c('uiTextfield',{attrs:{"label":_vm.label,"placeholder":_vm.placeholderText},on:{"blur":function($event){return _vm.inputBlurred()}},model:{value:(_vm.userInput),callback:function ($$v) {_vm.userInput=$$v;},expression:"userInput"}}),_vm._v(" "),_c('uiIconChevronDownMed',{staticClass:"chevronIcon"})],1)])])],1)};
  var __vue_staticRenderFns__$C = [];

    /* style */
    const __vue_inject_styles__$10 = function (inject) {
      if (!inject) return
      inject("data-v-59d1ae7c_0", { source: ".popper[data-v-59d1ae7c]{width:auto;background-color:#fafafa;color:#212121;text-align:center;padding:2px;display:inline-block;border-radius:3px;position:absolute;font-size:14px;font-weight:400;border:1px #ebebeb solid;z-index:200000;-moz-box-shadow:#3a3a3a 0 0 6px 0;-webkit-box-shadow:#3a3a3a 0 0 6px 0;box-shadow:#3a3a3a 0 0 6px 0}.popper .popper__arrow[data-v-59d1ae7c]{width:0;height:0;border-style:solid;position:absolute;margin:5px}.popper[x-placement^=top][data-v-59d1ae7c]{margin-bottom:5px}.popper[x-placement^=top] .popper__arrow[data-v-59d1ae7c]{border-width:5px 5px 0 5px;border-color:#fafafa transparent transparent transparent;bottom:-5px;left:calc(50% - 5px);margin-top:0;margin-bottom:0}.popper[x-placement^=bottom][data-v-59d1ae7c]{margin-top:5px}.popper[x-placement^=bottom] .popper__arrow[data-v-59d1ae7c]{border-width:0 5px 5px 5px;border-color:transparent transparent #fafafa transparent;top:-5px;left:calc(50% - 5px);margin-top:0;margin-bottom:0}.popper[x-placement^=right][data-v-59d1ae7c]{margin-left:5px}.popper[x-placement^=right] .popper__arrow[data-v-59d1ae7c]{border-width:5px 5px 5px 0;border-color:transparent #fafafa transparent transparent;left:-5px;top:calc(50% - 5px);margin-left:0;margin-right:0}.popper[x-placement^=left][data-v-59d1ae7c]{margin-right:5px}.popper[x-placement^=left] .popper__arrow[data-v-59d1ae7c]{border-width:5px 0 5px 5px;border-color:transparent transparent transparent #fafafa;right:-5px;top:calc(50% - 5px);margin-left:0;margin-right:0}.inputGroup[data-v-59d1ae7c]{position:relative}.inputGroup .chevronIcon[data-v-59d1ae7c]{color:\"[theme:neutralDark, default: #212121]\";font-size:12px;position:absolute;right:13px;bottom:7px;pointer-events:none}.inputGroup[data-v-59d1ae7c]  .ms-TextField-field{padding-right:32px}.foldout[data-v-59d1ae7c]{background-color:#fff;margin:0!important;padding:0;box-shadow:1px 1px 5px 0 \"[theme:neutralQuaternaryAlt, default: #dadada]\";border-radius:2px}.optionlist[data-v-59d1ae7c]{max-height:200px;overflow:auto}.option[data-v-59d1ae7c]{height:19px;font-weight:400;padding:7px 10px 7px 10px;text-align:left;white-space:nowrap;cursor:pointer;color:\"[theme:neutralPrimary, default: #333333]\"}.option[data-v-59d1ae7c]:hover{color:\"[theme:black, default: #000000]\";background-color:\"[theme:neutralLight, default: #eaeaea]\"}.selectedOption[data-v-59d1ae7c]{color:\"[theme:black, default: #000000]\";background-color:\"[theme:themeLight, default: #c7e0f4]\"}.selectedOption[data-v-59d1ae7c]:hover{background-color:\"[theme:themeLight, default: #c7e0f4]\"}", map: undefined, media: undefined });

    };
    /* scoped */
    const __vue_scope_id__$10 = "data-v-59d1ae7c";
    /* module identifier */
    const __vue_module_identifier__$10 = undefined;
    /* functional template */
    const __vue_is_functional_template__$10 = false;
    /* style inject */
    const __vue_create_injector__$r = function(context){ 
                  return function(scopeId, data)
                  {
                      if(window['wizstyle-'+scopeId])
                          return;
                      if(__vue_script__$10.loadStyles)
                          __vue_script__$10.loadStyles(data.source);
                      window['wizstyle-'+scopeId]=true;
                  }
              };
    /* style inject SSR */
    
    /* style inject shadow dom */
    

    
    var uiTypeAhead = normalizeComponent(
      { render: __vue_render__$C, staticRenderFns: __vue_staticRenderFns__$C },
      __vue_inject_styles__$10,
      __vue_script__$10,
      __vue_scope_id__$10,
      __vue_is_functional_template__$10,
      __vue_module_identifier__$10,
      false,
      __vue_create_injector__$r,
      undefined,
      undefined
    );

  var component = {
      props: ['contentTypeId', 'breaking'],
      components: {
          uiIconNews,
          uiIconVideo,
          uiIconMegaphone,
          uiIconStreaming
      }
  };

  component.originalTemplate = "contentTypeIcon";
  component.template = `
<div>
    <uiIconMegaphone :title="'News' | translate" v-if="contentTypeId === 1"/>
    <uiIconVideo :title="'Media' | translate" v-else-if="contentTypeId === 2"/>
    <uiIconStreaming :title="'Streaming' | translate" v-else-if="contentTypeId === 3"/>
    <uiIconVideo :title="'Media' | translate" v-else-if="contentTypeId === 4" />
    <uiIconNews :title="'Corporate news' | translate" v-else-if="contentTypeId === 5 && !breaking"/>
    <div :title="'Breaking' | translate" v-else-if="contentTypeId === 5 && breaking" class="ms-Icon">{{"Breaking" | translate}}</div>
</div>
`;

  function stripHtml(html, maxLength) {
      // this logic is taken from wizdom365. I've modified it abit to removed the dependency on jquery
      if (html === undefined)
          return;
      var minLastLineLength = 25;
      html = html.replace(/\&/g, "&amp;"); // ensure that already encoded html doesn't lose the encoding below
      // replace prepend <br /> and </p> with |br|, which will be used for line split
      var strippedHtml = html
          .replace(/\<br/gi, "|br|<br")
          .replace(/\<\/p\>/gi, "|br||br|</p>");
      var tmp = document.createElement("DIV");
      tmp.innerHTML = strippedHtml;
      tmp.innerHTML = tmp.innerHTML.replace(/<table(.*?)table>/g, '[TABLE]|br|');
      tmp.innerHTML = tmp.innerHTML.replace(/((<ul)|(<ol))(.*?)((ul>)|(ol>))/g, '[LIST]|br|');
      tmp.innerHTML = tmp.innerHTML.replace(/<img.[^>]*?alt="(.*?)".*?>|<img(.*?)>/g, "[IMG]" + '$1' + "|br|"); //With alt text|Without alt text
      strippedHtml = tmp.textContent;
      var lines = strippedHtml.split("|br|");
      var rtnVal = [];
      var currentLength = 0;
      var dots = false;
      for (var i = 0; i < lines.length; i++) {
          if (maxLength - currentLength >= minLastLineLength || i == 0) {
              if (lines[i].length + currentLength > maxLength) {
                  rtnVal.push(lines[i].substr(0, maxLength - currentLength - 4).trim() + " ...");
                  dots = true;
              }
              else
                  rtnVal.push(lines[i].trim());
              currentLength += lines[i].length;
          }
          else
              break;
      }
      if (lines.length > rtnVal.length && !dots)
          rtnVal[rtnVal.length - 1] = rtnVal[rtnVal.length - 1].trim() + " ...";
      var rtnStr = rtnVal.join("<br />");
      while (rtnStr.indexOf("<br /><br /><br />") >= 0)
          rtnStr = rtnStr.replace("<br /><br /><br />", "<br /><br />");
      //Replace [IMG] after maxlength has been calculated. 
      //The icon length has then been counted as the "[IMG]" (5 chars) string and not '<i class="ms-Icon ms-Icon--Picture" aria-hidden="true"></i>  ' (61 chars). 
      rtnStr = rtnStr.replace(/\[IMG\]/gi, '<i class="ms-Icon ms-Icon--Picture" aria-hidden="true"></i>  ');
      rtnStr = rtnStr.replace(/\[TABLE\]/gi, '<i class="ms-Icon ms-Icon--Table" aria-hidden="true"></i>  ');
      rtnStr = rtnStr.replace(/\[LIST\]/gi, '<i class="ms-Icon ms-Icon--BulletedList" aria-hidden="true"></i>  ');
      // remove all <br /> at the end
      rtnStr = rtnStr.replace(/^(<br \/>)+|(<br \/>)+$/g, "");
      //   console.log("stripHtml result: " + rtnStr);
      return rtnStr;
  }

  var timeago = function (resolve) { return require.ensure([], function () { return resolve(require("./../../shared/timeago/timeago.vue")); }); };
  var component$1 = {
      props: ["item", "webpartProperties", "imageHandler", "getLikesTooltip", "readToggle", "likeToggle", "showItem"],
      components: {
          uiIconLikeSolid,
          uiIconLike,
          uiIconComment,
          timeago,
          contentTypeIcon: component,
          uiIconCircleRing,
          uiIconCompleted,
          uiIconLocationDot,
          uiIconStreaming
      },
      methods: {
          readToggleLocal: function () {
              this.$emit("readToggle", this.item);
          },
          goToLink: function (goToCommentSection) {
              if (!this.item.readByCurrentUser) {
                  this.readToggleLocal();
              }
              if (this.item.contentType.id == 5) {
                  window.open(this.item.extendedProperties.ItemUrl, "_blank");
              }
              else {
                  if (goToCommentSection) {
                      this.$emit("showItem", this.item, true);
                  }
                  else {
                      this.$emit("showItem", this.item);
                  }
              }
          },
          summary: function (input, maxLength) {
              return stripHtml(input, maxLength);
          }
      }
  };

  component$1.originalTemplate = "listBaseItem";
  component$1.template = `
<div data-v-f7d06fa4 class="list-base-item" :class="[webpartProperties.enableTwoColumn ? 'twoColumnSocial' : '', 'contentTypeId_' + item.contentType.id]">
    <div data-v-f7d06fa4 class="item__imageArea" @click="goToLink(false)">
        <img data-v-f7d06fa4 v-if="item.extendedProperties.picture" :src="[imageHandler(item, 300, false)]" />
        <img data-v-f7d06fa4 v-else-if="item.extendedProperties.videoImage" :src="[imageHandler(item, 300, true)]" />
    </div>
    <contentTypeIcon data-v-f7d06fa4 class="contentTypeIcon" :contentTypeId="item.contentType.id" :breaking="item.extendedProperties.breaking" />
    <div data-v-f7d06fa4 class="item__content" >

        <div data-v-f7d06fa4 class="channels">
            <div data-v-f7d06fa4 v-for="(channel) in item.channels" :key="channel.id" class="channel">
                <uiIconStreaming data-v-f7d06fa4 v-if="item.contentType.id == 3" class="streamingIcon" :title="'Streaming' | translate" />
                <uiIconLocationDot data-v-f7d06fa4 class="channelDevider" />
                <span data-v-f7d06fa4 class="channelName">{{channel.name}}</span>
            </div>
        </div>

        <div data-v-f7d06fa4 class="content__headline" @click="goToLink(false)">
            {{item.heading}}
        </div>
        <div data-v-f7d06fa4 class="content__summary" @click="goToLink(false)">
            <div data-v-f7d06fa4 v-html="item.summary ? item.summary.substring(0, 400) : summary(item.content, 400)"></div>
        </div>
        <div data-v-f7d06fa4 class="content__details">
            <div data-v-f7d06fa4 class="details__author">
               <div data-v-f7d06fa4 v-if="item.contentType.metaData.useAlternativeAuthor && item.alternateAuthor" class="authorName">{{item.alternateAuthor.displayName}}</div>
                <div data-v-f7d06fa4 v-else class="authorName">
                    <span data-v-f7d06fa4 v-if="item.contentType.id == 3">{{item.extendedProperties.AuthorName}}</span>
                    <span data-v-f7d06fa4 v-else>{{item.author.displayName}}</span>
                </div>
            </div>
            <div data-v-f7d06fa4 class="details__date">
                <timeago data-v-f7d06fa4 v-model="item.start" class="time-ago-time"/>
            </div>
        </div>
    </div>
    <div data-v-f7d06fa4 class="item__actions">
        <div data-v-f7d06fa4 v-if="item.contentType.id != 5" class="actions__like" @click="$emit('likeToggle', item);">
            <uiIconLikeSolid data-v-f7d06fa4 v-if="item.likedByCurrentUser" :title="getLikesTooltip(item)" class="icon"/>
            <uiIconLike data-v-f7d06fa4 v-if="!item.likedByCurrentUser" :title="getLikesTooltip(item)" class="icon"/>
            <div data-v-f7d06fa4 class="counter">{{item.likes.totalCount}}</div>
        </div>
        <div data-v-f7d06fa4 v-if="item.contentType.id != 5" class="actions__comment">
            <uiIconComment data-v-f7d06fa4 class="icon" :title="'Comments' | translate" @click="goToLink(true)" />
            <div data-v-f7d06fa4 class="counter">{{item.comments.totalCount}}</div>
        </div>
         <div data-v-f7d06fa4 @click="$emit('readToggle', item)" class="is-read pointer">
            <uiIconCircleRing data-v-f7d06fa4 class="icon" v-if="!item.readByCurrentUser" :title="'Click here to mark as read' | translate"/>
            <uiIconCompleted data-v-f7d06fa4 class="icon" v-if="item.readByCurrentUser" :title="'Click here to mark as unread' | translate"/>
        </div>

    </div>
    
</div>
`;
  component$1.styles = `
.list-base-item[data-v-f7d06fa4] {
  display: flex;
  flex-direction: row;
  flex-wrap: nowrap;
  margin-top: 16px;
  width: 100%;
  position: relative;
  border: 1px solid "[theme:neutralLight, default: #eaeaea]";
  color: "[theme:neutralTertiary, default: #eaeaea]";
  font-weight: 400;
  transition: border 0.5s ease-in-out;
}
.list-base-item[data-v-f7d06fa4]:hover {
  border: 1px solid "[theme: themePrimary, default: #0078d4]";
}
.item__imageArea[data-v-f7d06fa4] {
  background-color: "[theme:neutralLight, default:#d7d7d7]";
  cursor: pointer;
  display: flex;
  height: 138px;
  width: 162px;
}
.webpart-size-medium .item__imageArea[data-v-f7d06fa4],
  .webpart-size-large .item__imageArea[data-v-f7d06fa4],
  .webpart-size-xlarge .item__imageArea[data-v-f7d06fa4] {
    height: 168px;
    width: 208px;
}
.item__imageArea img[data-v-f7d06fa4] {
    max-height: 100%;
    max-width: 100%;
    height: 100%;
    width: 100%;
    object-fit: cover;
    -ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=80)";
    filter: alpha(opacity=80);
    -moz-opacity: 0.8;
    -khtml-opacity: 0.8;
    opacity: 0.8;
}
.contentTypeIcon[data-v-f7d06fa4] {
  position: absolute;
  top: 0;
  left: 0;
  color: "[theme:bodyBackground, default:#ffffff]";
  background-color: "[theme:themeTertiary, default: #eaeaea]";
  padding-top: 7px;
  padding-bottom: 6px;
  padding-left: 10px;
  padding-right: 10px;
  z-index: 3;
  text-transform: uppercase;
}
.contentTypeIcon[data-v-f7d06fa4] .ms-Icon {
    font-size: 20px;
}
.channels[data-v-f7d06fa4] {
  margin-bottom: 12px;
  height: 20px;
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
}
.channels .channel[data-v-f7d06fa4] {
    display: inline-block;
    font-size: 14px;
    line-height: 17px;
    color: "[theme:themeTertiary, default: #eaeaea]";
}
.channels .channel .channelName[data-v-f7d06fa4] {
      margin-right: 6px;
      font-weight: bold;
}
.channels .channel .channelDevider[data-v-f7d06fa4] {
      font-size: 10px;
      margin-right: 1px;
}
.channels .channel:first-child .channelDevider[data-v-f7d06fa4] {
    display: none;
}
.streamingIcon[data-v-f7d06fa4] {
  position: relative;
  top: 4px;
  margin-right: 4px;
  font-size: 18px;
}
.item__content[data-v-f7d06fa4] {
  flex: 1;
  margin-top: 11px;
  margin-bottom: 10px;
  margin-left: 16px;
  margin-right: 16px;
  min-width: 0;
  /* needed for text-overflow: ellipsis */
  position: relative;
}
.item__content .content__headline[data-v-f7d06fa4] {
    color: "[theme:neutralTertiary, default: #eaeaea]";
    cursor: pointer;
    font-size: 21px;
    line-height: 1.3;
    font-weight: 400;
    max-height: 60px;
    overflow: hidden;
    overflow-wrap: break-word;
    word-wrap: break-word;
    -ms-word-break: break-all;
    word-break: break-word;
    -ms-hyphens: auto;
    -moz-hyphens: auto;
    -webkit-hyphens: auto;
    hyphens: auto;
}
.webpart-size-small .item__content .content__headline[data-v-f7d06fa4],
    .webpart-size-medium .item__content .content__headline[data-v-f7d06fa4] {
      font-size: 19px;
      max-height: 50px;
}
.item__content .content__summary[data-v-f7d06fa4] {
    cursor: pointer;
    font-size: 14px;
    max-height: 20px;
    margin-top: 5px;
    overflow: hidden;
    overflow-wrap: break-word;
    word-wrap: break-word;
    word-break: break-word;
    -ms-hyphens: auto;
    -moz-hyphens: auto;
    -webkit-hyphens: auto;
    hyphens: auto;
}
.webpart-size-small .item__content .content__summary[data-v-f7d06fa4] {
      display: none;
}
.item__content .content__details[data-v-f7d06fa4] {
    color: "[theme:neutralTertiary, default: #eaeaea]";
    font-size: 14px;
    display: flex;
    flex-direction: row;
}
.item__content .content__details .details__author[data-v-f7d06fa4] {
      position: absolute;
      bottom: 0;
      font-weight: 500;
      margin-bottom: 5px;
      font-weight: 600;
}
.webpart-size-small .item__content .content__details .details__author[data-v-f7d06fa4] {
        display: none;
}
.item__content .content__details .details__date[data-v-f7d06fa4] {
      position: absolute;
      right: 0;
      bottom: 0;
      margin-bottom: 5px;
}
.item__actions[data-v-f7d06fa4] {
  display: flex;
  border-left: 1px solid "[theme:neutralLight, default:#d7d7d7]";
  flex-direction: column;
  font-size: 16px;
  line-height: 19px;
  overflow-wrap: break-word;
  text-align: center;
  width: 47px;
}
.item__actions .ms-Icon[data-v-f7d06fa4] {
    font-size: 20px;
}
.webpart-size-small .item__actions[data-v-f7d06fa4] {
    display: none;
}
.item__actions .actions__like[data-v-f7d06fa4] {
    margin-top: 15px;
}
.item__actions .actions__comment[data-v-f7d06fa4] {
    margin-top: 15px;
}
.item__actions .is-read[data-v-f7d06fa4] {
    margin-top: 23px;
}
.contentTypeId_5 .is-read[data-v-f7d06fa4] {
  margin-top: 135px;
}
@media only screen and (max-width: 1200px) {
.twoColumnSocial .details__author[data-v-f7d06fa4], .twoColumnSocial .content__summary[data-v-f7d06fa4], .twoColumnSocial .content__details[data-v-f7d06fa4] {
    display: none;
}
}
.not-read.list-base-item[data-v-f7d06fa4] {
  color: "[theme:neutralSecondary, default:#333]";
}
.not-read.list-base-item .channel[data-v-f7d06fa4] {
    color: "[theme:themePrimary, default: #eaeaea]";
}
.not-read.list-base-item .content__headline[data-v-f7d06fa4] {
    color: "[theme:neutralPrimary, default:#333]";
}
.not-read.list-base-item .item__imageArea img[data-v-f7d06fa4] {
    -ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=100)";
    filter: alpha(opacity=100);
    -moz-opacity: 1;
    -khtml-opacity: 1;
    opacity: 1;
}
.not-read.list-base-item .content__details[data-v-f7d06fa4] {
    color: "[theme:neutralSecondary, default:#333]";
}
.not-read.list-base-item .contentTypeIcon[data-v-f7d06fa4] {
    background-color: "[theme:themePrimary, default: #eaeaea]";
}
.not-read.list-base-item .item__actions .ms-Icon--LikeSolid[data-v-f7d06fa4] {
    color: "[theme:themePrimary, default: #eaeaea]";
}


`;

  var component$2 = {
      props: ['webpartProperties', 'searchMode', 'searchTermSearched', 'showSelectChannels'],
      inject: ["webpartInstanceId"],
      components: {
          uiContextualMenu,
          uiContextualMenuItem,
          uiIconAdd,
          uiIconMore,
          uiIconLike,
          uiIconRefresh,
          uiIconSearch,
          uiSearchBox: uiSearchbox,
          uiLink,
          uiSpinner
      },
      methods: {
          setSearchMode: function (option) {
              if (!option)
                  this.searchTerm = null;
              this.searchMode = option;
              this.$emit('setSearchMode', option);
          },
          searchBoxKeyUp: function (e) {
              if (e.key == "Enter")
                  this.$emit('search', this.searchTerm);
          }
      }
  };

  component$2.originalTemplate = "toolbar";
  component$2.template = `
<div data-v-66a341c7 class="toolbarRoot">
    <div data-v-66a341c7 class="webpart-header" v-if="!webpartProperties.hideToolbar">
        <div data-v-66a341c7 class="header-icons" >
            <span data-v-66a341c7 @click="$emit('createEditItem')" class="toolbarCreate">
                <uiIconAdd data-v-66a341c7 class="header-icons-icon" data-automation-id='create'/>
                <span data-v-66a341c7 v-if="!webpartProperties.ToolbarUseIconsOnly">{{'Add' | translate}}</span>
            </span>
            <span data-v-66a341c7 @click="setSearchMode(true)" class="toolbarSearch">
                <uiIconSearch data-v-66a341c7 class="header-icons-icon" />
                <span data-v-66a341c7 v-if="!webpartProperties.ToolbarUseIconsOnly">{{'Search' | translate}}</span>
            </span>                    
            <uiContextualMenu data-v-66a341c7 class="uiContextualMenu toolbarMore">
                <span data-v-66a341c7 :title="'Settings' | translate">
                    <uiIconMore data-v-66a341c7 class="header-icons-icon" />
                    <span data-v-66a341c7 v-if="!webpartProperties.ToolbarUseIconsOnly">{{'More' | translate}}</span>
                </span> 
                <div data-v-66a341c7 slot='list'>
                    <uiContextualMenuItem data-v-66a341c7 :name="'Show unread' | translate" @click="$emit('setTab','unread')" :class="['noticeboardContextualMenuItem',  tab=='unread' ? 'selectedMenu' : '']" />
                    <uiContextualMenuItem data-v-66a341c7 :name="'Show all' | translate" @click="$emit('setTab','all')" :class="['noticeboardContextualMenuItem',  tab=='all' ? 'selectedMenu' : '']" />
                    <uiContextualMenuItem data-v-66a341c7 :name="'Show my' | translate" @click="$emit('setTab','mine')" :class="['noticeboardContextualMenuItem',  tab=='mine' ? 'selectedMenu' : '']" />
                    <uiContextualMenuItem data-v-66a341c7 type="divider" />
                    <uiContextualMenuItem data-v-66a341c7 :name="'Choose channels' | translate" @click="$emit('selectChannels')" class="noticeboardContextualMenuItem noHighlight" />
                    <uiContextualMenuItem data-v-66a341c7 :name="'Mark all as read' | translate" @click="$emit('markAllRead')" class="noticeboardContextualMenuItem noHighlight" />
                </div>
            </uiContextualMenu>
            <span data-v-66a341c7 @click="items = null; $emit('refreshItems')" class="toolbarRefresh">
                <uiIconRefresh data-v-66a341c7 class="header-icons-icon" />
                <span data-v-66a341c7 v-if="!webpartProperties.ToolbarUseIconsOnly">{{'Refresh' | translate}}</span>
            </span>
        </div>
    </div>

     <div data-v-66a341c7 v-if="searchMode" class="search-area">
          <div data-v-66a341c7 class="searchbox">
            <div data-v-66a341c7 @keyup="searchBoxKeyUp"><uiSearchBox data-v-66a341c7 @keyup="searchBoxKeyUp" :placeholder="'Search news' | translate" v-model='searchTerm'/></div>
          </div>
          <div data-v-66a341c7 class="searchboxExit">
            <uiLink data-v-66a341c7 :title="'Exit search mode' | translate" @click="setSearchMode(false)">{{'Exit search mode' | translate}}</uiLink>
          </div>
        <div data-v-66a341c7>
          <uiSpinner data-v-66a341c7 class="spinner" v-if="loading" />
          <div data-v-66a341c7 v-if="items && numberOfItems > 0" class="searchTextInfo">{{'Search results for' | translate}} "{{searchTermSearched}}"</div>
          <div data-v-66a341c7 v-if="searchTermSearched.length >= 1 && !loading && items && numberOfItems < 1" class="searchTextInfoNoResults">{{'No results found' | translate}}</div>
        </div>
      </div>
</div>
`;
  component$2.styles = `
.pointer[data-v-66a341c7] {
  cursor: pointer;
}
.ms-Icon[data-v-66a341c7] {
  color: "[theme:themePrimary, default:#333]";
}
.webpart-header[data-v-66a341c7] {
  color: "[theme:bodyText, default:#333]";
  position: relative;
  padding-bottom: 5px;
  border-bottom: 1px solid "[theme:neutralTertiary, default: #eaeaea]";
}
.spinner[data-v-66a341c7] {
  margin-top: 10px;
}
.search-area[data-v-66a341c7] {
  color: "[theme:bodyText, default:#333]";
}
.search-area .searchTextInfo[data-v-66a341c7] {
    margin-top: 15px;
    padding-bottom: 15px;
    border-bottom: 1px solid "[theme:neutralTertiary, default: #eaeaea]";
    font-size: 16px;
    font-weight: 100;
}
.search-area .searchTextInfoNoResults[data-v-66a341c7] {
    margin-top: 15px;
    font-size: 16px;
    font-weight: 100;
}
.toolbarRoot[data-v-66a341c7] .ms-SearchBox {
  margin-top: 15px;
  margin-bottom: 5px;
}
.toolbarRoot[data-v-66a341c7] .ms-SearchBox .ms-SearchBox-label .ms-SearchBox-icon {
    content: "" !important;
}
.toolbarRoot[data-v-66a341c7] .ms-SearchBox .ms-SearchBox-field {
    padding: 6px 3px 7px 10px;
    border: 1px solid "[theme:neutralLight, default:#d7d7d7]" !important;
    padding-left: 10px !important;
}
.toolbarRoot[data-v-66a341c7] .ms-SearchBox .ms-CommandButton {
    display: none !important;
}
.header-icons[data-v-66a341c7] {
  width: 100%;
}
.header-icons > span[data-v-66a341c7] {
    margin-right: 10px;
    line-height: 18px;
    cursor: pointer;
}
.header-icons > div[data-v-66a341c7] {
    margin-right: 10px;
}
.header-icons .header-icons-icon[data-v-66a341c7] {
    cursor: pointer;
    margin-right: 2px;
    position: relative;
    top: 2px;
}
.header-icons .ms-Icon--Search[data-v-66a341c7] {
    font-size: 13px;
}
.header-icons .ms-Icon--Add[data-v-66a341c7] {
    font-size: 13px;
    top: 1px;
}
.header-icons .ms-Icon--Refresh[data-v-66a341c7] {
    font-size: 13px;
    top: 2px;
}
.newslist-container[data-v-66a341c7] {
  display: table;
  table-layout: fixed;
  /* Set to fixed to ensure word-wrap on title */
  width: 100%;
}
.newslist-container .news-container[data-v-66a341c7] {
    padding-bottom: 10px;
    color: "[theme:neutralSecondary, default:#858585]";
    display: table-row;
}
.newslist-container .news-container > div[data-v-66a341c7] {
      display: table-cell;
      border-bottom: 1px solid "[theme:neutralLight, default: #eaeaea]";
      padding-top: 10px;
      padding-bottom: 15px;
}
.newslist-container .news-container .time-ago-time[data-v-66a341c7] {
      font-size: 12px;
      margin-left: 1px;
}
.newslist-container .not-read[data-v-66a341c7] {
    color: "[theme:bodyText, default:#333]";
}
.newslist-container .not-read .read-indicator .ms-Icon[data-v-66a341c7] {
      color: "[theme:themePrimary, default: #0078d4]";
}
.newslist-container a[data-v-66a341c7] {
    cursor: pointer;
}
.newslist-container .webpart-height[data-v-66a341c7] {
    height: 648px;
}
.newslist-container .font-size[data-v-66a341c7] {
    font-size: 10px;
}
.pagination[data-v-66a341c7] {
  margin: 16px 0;
}
.uiContextualMenu[data-v-66a341c7] {
  display: inline-block;
  cursor: pointer;
}
.image-container[data-v-66a341c7] {
  padding: 0;
}
.my-news-header[data-v-66a341c7] {
  display: inline-block;
  font-size: 20px;
  font-weight: 400;
  padding: 5px 10px 5px 15px;
}


/*  modals noticeboard */
.module-root .ms-Overlay {
  z-index: 1000003 !important;
}
.ms-Dialog {
  z-index: 1000004 !important;
}
.ms-ContextualHost.is-open {
  z-index: 1000004 !important;
}

/* Styles used for ContextualMenu - needs to be non scoped */
.noticeboardContextualMenuItem .ms-ContextualMenu-link {
  padding-left: 25px;
  padding-right: 16px;
  height: 36px;
  line-height: 34px;
  cursor: pointer;
}
.noticeboardContextualMenuItem .ms-ContextualMenu-link:hover {
  background-color: "[theme:neutralLighterAlt, default:#f4f4f4]" !important;
}
.noticeboardContextualMenuItem .ms-ContextualMenu-link.is-selected {
  background-color: "[theme:neutralLight, default:#dadada]" !important;
}
.noticeboardContextualMenuItem .ms-ContextualMenu-link.is-selected:hover {
  background-color: "[theme:neutralLight, default:#dadada]" !important;
}
.noticeboardContextualMenuItem a.ms-ContextualMenu-link.is-selected {
  font-weight: normal;
}
.noticeboardContextualMenuItem a.ms-ContextualMenu-link.is-selected:hover {
    background-color: "[theme:neutralLighter, default:#f4f4f4]";
}
.noticeboardContextualMenuItem.selectedMenu {
  background-color: "[theme:neutralLight, default:#dadada]" !important;
}
.noticeboardContextualMenuItem.selectedMenu a.ms-ContextualMenu-link {
    color: "[theme:bodyText, default:#333]";
}
.noticeboardContextualMenuItem.selectedMenu:hover {
  background-color: "[theme:neutralLight, default:#dadada]" !important;
}
.noticeboardContextualMenuItem a.ms-ContextualMenu-link.is-selected::after {
  content: "" !important;
}
.noticeboardContextualMenuItem.noHighlight .ms-ContextualMenu-link {
  background-color: "[theme:bodyBackground, default:#f4f4f4]" !important;
}
.noticeboardContextualMenuItem.noHighlight .ms-ContextualMenu-link:hover {
  background-color: "[theme:neutralLighter, default:#dadada]" !important;
}
.fixed-height {
  min-height: 475px;
}
.toolbarMore,
.toolbarRefresh,
.toolbarCreate,
.toolbarSearch {
  display: inline-block;
  padding-bottom: 5px;
}
.webpart-fallback .toolbarMore > span, .webpart-fallback
  .toolbarRefresh > span, .webpart-fallback
  .toolbarCreate > span, .webpart-fallback
  .toolbarSearch > span {
    display: none;
}
.webpart-fallback .toolbarMore > span > span > span {
  display: none;
}


`;

  var component$3 = {
      inject: ["webpartInstanceId", "configuration"],
      props: ["item", "webpartProperties"],
      components: {
          uiContextualMenu,
          uiContextualMenuItem,
          uiIconAdd,
          uiIconMore,
          uiIconClock,
          uiIconLikeSolid,
          uiIconLike,
          uiIconCompleted,
          uiIconCircleRing,
          uiIconSearch,
          uiIconComment,
          uiIconRefresh,
          listBaseItem: component$1,
          toolbar: component$2
      },
      data: function () {
          return {
              configSocialEnabled: false
          };
      },
      mounted: function () {
          this.configSocialEnabled = this.configuration.Noticeboard.SocialFeature.Enabled == "true";
      }
  };

  component$3.originalTemplate = "overviewList";
  component$3.template = `
<wizdomWebpart data-v-5d88c65d :environmentInfo="environmentInfo" :chromeProperties="webpartProperties.chromeProperties" :webpartPadding="true"  :title="'Noticeboard' | translate" chromeType="title" :dynamicData="numberOfItems" :id="this.webpartInstanceId" @webpart-resize="webpartResize">
    <div data-v-5d88c65d class="module-root" data-automation-id="noticeboard" :class="{'fixed-height': showContentPlaceholder && !webpartProperties.hideToolbar}">
        
        <toolbar data-v-5d88c65d 
          :webpartProperties="webpartProperties"
          :searchMode="searchMode"
          :searchTermSearched="searchTermSearched"
          @createEditItem="createEditItem"
          @refreshItems="refreshItems"
          @selectChannels="selectChannels"
          @setTab="setTab"
          @markAllRead="markAllRead"
          @search="search"
          @setSearchMode="setSearchMode"
        />

       <div data-v-5d88c65d v-if="webpartProperties.enableTwoColumn" class="list-base-container">
          <div data-v-5d88c65d class="inner-list-base-container">
              <listBaseItem data-v-5d88c65d class="column"
                v-for="item in items"
                :key="item.id"
                :item="item"
                :class="{'not-read' : !item.readByCurrentUser}"
                data-automation-id="noticeboardListItem"
                :webpartProperties="webpartProperties"
                @readToggle="readToggle"
                @showItem="showItem"
                @likeToggle="likeToggle"
                :getLikesTooltip="getLikesTooltip"
                :imageHandler="imageHandler"
              ></listBaseItem>
          </div>
        </div>
        <div data-v-5d88c65d v-else class="list-base-container"> 
          <listBaseItem data-v-5d88c65d
            v-for="item in items"
            :key="item.id"
            :item="item"
            :class="{'not-read' : !item.readByCurrentUser}"
            data-automation-id="noticeboardListItem"
            :webpartProperties="webpartProperties"
            @readToggle="readToggle"
            @showItem="showItem"
            @likeToggle="likeToggle"
            :getLikesTooltip="getLikesTooltip"
            :imageHandler="imageHandler"
            ></listBaseItem>
        </div>

        <noItem data-v-5d88c65d v-show="showContentPlaceholder"
          :title="contentPlaceholderMessage.text"
          @activated="contentPlaceholderMessage.event()"
          :button="contentPlaceholderMessage.buttonText">
        </noItem>

        <showItem data-v-5d88c65d v-if="currentItem" v-model="currentItem" :item="currentItem" :showNext="showNextBtn" :showPrev="showPrevBtn" @edit="editItem" @next="showNext" @prev="showPrev" @refresh="refreshItems" @readToggle="readToggle" @likeToggle="likeToggle"/>

        <selectPersonalChannels data-v-5d88c65d v-if="showSelectChannels" v-model="showSelectChannels" @channelSelectionsUpdated="refreshItems" />
        <newItem data-v-5d88c65d  v-if="newEditItem" v-model="newEditItem" @itemCreated="refreshItems" @itemUpdate="refreshItems" />
        <pagination data-v-5d88c65d class="pagination"
                    v-if="items && numberOfItems > webpartProperties.itemsPerPage"
                    :pageSize="webpartProperties.itemsPerPage" 
                    :length="numberOfItems" 
                    :align="'center'"
                    :webpartSize="webpartSize"
                    @onPageChanged="pageChanged"
                    v-model="currentPage"></pagination>
    </div>
</wizdomWebpart>
`;
  component$3.styles = `
.list-base-container[data-v-5d88c65d] {
  display: flex;
  flex-direction: column;
  flex-wrap: nowrap;
}
@media only screen and (min-width: 992px) {
.inner-list-base-container[data-v-5d88c65d] {
    display: flex;
    flex-direction: row;
    flex-wrap: wrap;
    justify-content: space-between;
    margin: auto;
}
.column[data-v-5d88c65d] {
    width: calc(1/2*100% - (1 - 1/2)*20px);
}
}
.pagination[data-v-5d88c65d] {
  margin: 16px 0;
}


`;

  return component$3;

});
